<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Extras extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_extras','extras');
	}

	public function addCart_post()
	{
	    $token       = $this->security->xss_clean($this->input->post('device_token'));
	    $extra_id    = $this->security->xss_clean($this->input->post('extra_id'));
		$quantity    = $this->security->xss_clean($this->input->post('quantity'));
		$branch_id   = $this->security->xss_clean($this->input->post('branch_id'));
        
	    $header = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
                $product = $this->Common->get_details('extras',array('extra_id'=>$extra_id))->row();
        	    $price   = $product->price;
        	    $total   = $price*$quantity;
    
        		$item        = [
                			     'user_id'     => $user_id,
                			     'product_id'  => $extra_id,
                			     'type'        => 'e'
                		       ];
        	    $restaurant_id = $this->Common->get_details('extras',array('extra_id'=>$extra_id))->row()->r_id;
        	    $cart_check    = $this->extras->cartCheck($restaurant_id,$user_id);
        	    if($cart_check==0)
        	    {      
            		    $check   = $this->Common->get_details('cart',$item);
                		if ($check->num_rows() > 0) 
                		{   
                			$cart_id = $check->row()->cart_id;
                			if($quantity=='0')
                			{
                			    $this->Common->delete('cart',array('cart_id' => $cart_id));
                			}
                			else
                			{
                				$this->Common->update('cart_id',$cart_id,'cart',array('quantity' => $quantity));
                			}
                		}
                		else 
                		{
                			$item['quantity']   = $quantity;
                			$item['date']       = date('Y-m-d');
                    		$item['time']       = date('h:i A');
                    		$item['branch_id']  = $branch_id;
                    		$item['r_id']       = $restaurant_id; 
                			$this->Common->insert('cart',$item);
                		} 
                		
                	   $this->response(array(
                        		              "status"  => true,
                        		              "message" => "Success"
                        		            ), REST_Controller::HTTP_OK);	
        	     }
        	     else
        	     {
        	        $this->response(array(
                        		              "status"  => false,
                        		              "message" => "Failed to add product to cart"
                        		            ), REST_Controller::HTTP_OK);	
        	     }
    		}
    		else
    		{
    			$this->response(array(
                        			    "status"  => false,
                        			    "message" => "Your session has expired, please login again"
                        			  ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	        $check_guest= $this->Common->get_details('guest',array('token'=>$token));
            if($check_guest->num_rows()>0)
            {
                $product     = $this->Common->get_details('extras',array('extra_id'=>$extra_id))->row();
        	    $price       = $product->price;
        	    $total       = $price*$quantity;
    
        		$item        = [
                			     'guest_id'     => $check_guest->row()->guest_id,
                			     'product_id'   => $extra_id,
                			     'type'         => 'e'
                		       ];
        	    $restaurant_id = $this->Common->get_details('extras',array('extra_id'=>$extra_id))->row()->r_id;
        	    $cart_check    = $this->extras->cartCheckExtra($restaurant_id,$check_guest->row()->guest_id);
        	    if($cart_check==0)
        	    {      
            		    $check   = $this->Common->get_details('guest_cart',$item);
                		if ($check->num_rows() > 0) 
                		{   
                			$cart_id = $check->row()->gcart_id;
                			if($quantity=='0')
                			{
                			    $this->Common->delete('guest_cart',array('gcart_id' => $cart_id));
                			}
                			else
                			{
                				$this->Common->update('gcart_id',$cart_id,'guest_cart',array('quantity' => $quantity));
                			}
                		}
                		else 
                		{
                			$item['quantity']   = $quantity;
                			$item['date']       = date('Y-m-d');
                    		$item['time']       = date('h:i A');
                    		$item['branch_id']  = $branch_id;
                    		$item['r_id']       = $restaurant_id; 
                			$this->Common->insert('guest_cart',$item);
                		} 
                		
                	   $this->response(array(
                        		              "status"  => true,
                        		              "message" => "Success"
                        		            ), REST_Controller::HTTP_OK);	
        	     }
        	     else
        	     {
        	        $this->response(array(
                        		              "status"  => false,
                        		              "message" => "Failed to add product to cart"
                        		            ), REST_Controller::HTTP_OK);	
        	     }
            }
            else
            {
                 $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
            }
	       
	    }
	}
	
	
	public function decodeToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h7';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}
	
	
}
?>
