<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Delivery extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_delivery','delivery');
	}
	
	public function check_post()
	{
	    $block_no      = $this->security->xss_clean($this->input->post('block_no'));
	    $restaurant_id = $this->security->xss_clean($this->input->post('restaurant_id'));
	    $branch_id     = $this->security->xss_clean($this->input->post('branch_id'));
	    
	    $check_block   = $this->Common->get_details('blocks',array('block_name'=>$block_no));
        if($check_block->num_rows()>0)
	    {
	        $block_id  = $check_block->row()->block_id;
    	    $radius    = $this->Common->get_details('delivery_area',array())->row()->area_distance;
    	    if($restaurant_id!='')
    	    {    
    	          $shops = $this->delivery->getShopsBranchDelivery($branch_id,$block_id);
    	    }
    	    else
    	    {
    	          $shops = $this->delivery->getShops();
    	    }
    	    
    	    if($shops>0)
    	    {
    	        $this->response(array(
                		              "status"  => true,
                		              "message" => "Success"
                		              ), REST_Controller::HTTP_OK);
    	    }
    		else
    		{
    		    $this->response(array(
                		              "status"  => false,
                		              "message" => "Failed"
                		            ), REST_Controller::HTTP_OK);
    		}
	    }
	    else
	    {
	        $this->response(array(
                		              "status"  => false,
                		              "message" => "Failed"
                		            ), REST_Controller::HTTP_OK);
	    }
	}
	
	public function check_old_post()
	{
	    $latitude      = $this->security->xss_clean($this->input->post('latitude'));
	    $longitude     = $this->security->xss_clean($this->input->post('longitude'));
	    $restaurant_id = $this->security->xss_clean($this->input->post('restaurant_id'));
	    $branch_id     = $this->security->xss_clean($this->input->post('branch_id'));
	    
	    $radius    = $this->Common->get_details('delivery_area',array())->row()->area_distance;

	    if($restaurant_id!='')
	    {    
	        if($branch_id=='' || $branch_id=='0')
	        {
	             $shops     = $this->delivery->getShopsDelivery($latitude,$longitude,$radius,$restaurant_id);
	        }
	        else
	        {
	             $shops     = $this->delivery->getShopsBranchDelivery($latitude,$longitude,$radius,$branch_id);
	        }
	    }
	    else
	    {
	        $shops     = $this->delivery->getShops($latitude,$longitude,$radius);
	    }
	    
	    if($shops>0)
	    {
	        $this->response(array(
            		              "status"  => true,
            		              "message" => "Success"
            		              ), REST_Controller::HTTP_OK);
	    }
		else
		{
		    $this->response(array(
            		              "status"  => false,
            		              "message" => "Failed"
            		            ), REST_Controller::HTTP_OK);
		}
	}

	public function checkAddress_post()
	{
	    $block_no      = $this->security->xss_clean($this->input->post('block_no'));
	    $restaurant_id = $this->security->xss_clean($this->input->post('restaurant_id'));
	    $branch_id     = $this->security->xss_clean($this->input->post('branch_id'));
	    $address_id     = $this->security->xss_clean($this->input->post('address_id'));
	    $uid      = $this->security->xss_clean($this->input->post('uid'));
	    $token    = $this->security->xss_clean($this->input->post('device_token'));
	    $header   = $this->input->get_request_header('Authorization');

	    $address = null;
	    if (count(explode(' ', $header)) > 1)   {

			$user_id = $this->decodeToken($header);

			if ($user_id) {
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0) {

			    	$address_check = $this->Common->get_details('address',array('address_id'=>$address_id,'user_id'=>$user_id));
    				if($address_check->num_rows() > 0) {
    					$address = $address_check->row();
    				} else {
	    				$this->response(array(
                    			"status" => false,
                    			"message" => "Address not found"
                    	), REST_Controller::HTTP_NOT_FOUND);
	    			}   

	    		} else   {
			        $this->response(array(
                    		"status" => false,
                    		"message" => "Your session has expired, please login again"
                    ), REST_Controller::HTTP_UNAUTHORIZED);
			    }
			}
			else 
			{
				$this->response(array(
                    	"status" => false,
                    	"message" => "Your session has expired, please login again"
                ), REST_Controller::HTTP_UNAUTHORIZED);
			}
		}
		else 
		{
			$check_guest= $this->Common->get_details('guest',array('token'=>$token));
            if($check_guest->num_rows()>0) {
            	$guest_id = $check_guest->row()->guest_id;
                $address_check = $this->Common->get_details('guest_address',array('ga_id'=>$address_id,'guest_id'=>$guest_id));

    			if($address_check->num_rows() > 0) {
    				$address = $address_check->row();

    			} else {
    				$this->response(array(
                    			"status" => false,
                    			"message" => "Address not found"
                    	), REST_Controller::HTTP_NOT_FOUND);
    			}

            }  else  {
                $this->response(array(
                        "status"  => false,
                        "message" => "Your session has expired, please login again"
                ), REST_Controller::HTTP_UNAUTHORIZED);
            }
		}

		if($address) {
			$check_block   = $this->Common->get_details('blocks',array('block_name'=>$block_no));
	        if($check_block->num_rows()>0)
		    {
		        $block_id  = $check_block->row()->block_id;
	    	    $radius    = $this->Common->get_details('delivery_area',array())->row()->area_distance;

	    	    
		    	    if($restaurant_id!='')
		    	    {   

		    	          $shops = $this->delivery->getShopsBranchDelivery1($address->latitude, $address->longitude, $radius, $branch_id, $block_id);
		    	    }
		    	    else
		    	    {
		    	          $shops = $this->delivery->getShops1($address->latitude, $address->longitude, $radius);
		    	    }

	    	    
		    	    if($shops>0)
		    	    {
		    	        $this->response(array(
		                		              "status"  => true,
		                		              "message" => "Deliverable"
		                		              ), REST_Controller::HTTP_OK);
		    	    }
		    		else
		    		{
		    		    $this->response(array(
		                		              "status"  => false,
		                		              "message" => "Not deliverable"
		                		            ), REST_Controller::HTTP_OK);
		    		}
		    }
		    else
		    {
		        $this->response(array(
	                	"status"  => false,
	                	"message" => "Failed"
	            ), REST_Controller::HTTP_OK);
		    }
		} else {
			$this->response(array(
	                "status"  => false,
	                "message" => "Address not found"
	        ), REST_Controller::HTTP_OK);
		}
	}
	public function decodeToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h7';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}
}
?>
