<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';

class About extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_about','about');
	}

	public function about_get()
	{
	    $about = $this->Common->get_details('about',array())->row();
	    $this->response(array(
        		              "status"  => true,
        		              "message" => "Success",
        		              "data"    => $about,
        		            ), REST_Controller::HTTP_OK); 
	}

	public function terms_get()
	{
	    $terms = $this->Common->get_details('terms',array())->row();
	    $this->response(array(
        		              "status"  => true,
        		              "message" => "Success",
        		              "data"    => $terms,
        		            ), REST_Controller::HTTP_OK); 
	}
	
	public function privacy_get()
	{
	    $privacy = $this->Common->get_details('privacy',array())->row();
	    $this->response(array(
        		              "status"  => true,
        		              "message" => "Success",
        		              "data"    => $privacy,
        		            ), REST_Controller::HTTP_OK);  
		
	}
	
	public function faq_get()
	{
	    $faq = $this->Common->get_details('faq',array())->result();
	    $this->response(array(
        		              "status"  => true,
        		              "message" => "Success",
        		              "data"    => $faq,
        		            ), REST_Controller::HTTP_OK);  
		
	}
	
	public function help_get()
	{
	    $help      = $this->Common->get_details('help',array())->result();
	    
	    $this->response(array(
        		              "status"  => true,
        		              "message" => "Success",
        		              "data"    => $help,
        		            ), REST_Controller::HTTP_OK);    			  
	}
	
	public function contactus_get()
	{
	    $contact      = $this->Common->get_details('contact',array())->result();
	    
	    $this->response(array(
        		              "status"  => true,
        		              "message" => "Success",
        		              "data"    => $contact,
        		            ), REST_Controller::HTTP_OK);    			  
	}
	
	
}
?>
