<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Promotions extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('Common');
			$this->load->model('branch/M_promotions','promotions');
			if (!branch()) {
				redirect('users/branch');
			}
	}

	public function index()
	{   
		$branch    = $this->session->userdata['branch'];
		$branch_id = $branch['branch_id'];

		$promotions  = $this->promotions->getPromotions($branch_id);

		$data['promotions'] = $promotions;
		$this->load->view('branch/promotions/view',$data);
	}

    public function disable()
	{
	    $product_id = $this->input->post('promo_id');
		$array      =  [
    			          'status' => '0'
    		           ];
	
		if ($this->Common->update('bp_id',$product_id,'branch_promotions',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Promotion blocked successfully..!');
			redirect('branch/promotions');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block promotion..!');
			redirect('branch/promotions');
		}
	}

	public function enable()
	{
	    $product_id = $this->input->post('promo_id');
		$array      = [
			            'status' => '1'
		              ];
	
		if ($this->Common->update('bp_id',$product_id,'branch_promotions',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Promotion activated successfully..');
			redirect('branch/promotions');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate promotion..!');
			redirect('branch/promotions');
	    }		
	}
	
	public function details($id)
	{
		$promotion          = $this->Common->get_details('promotions',array('pr_id'=>$id))->row();
		$promotion_category= $this->Common->get_details('promotion_selection_list',array('promo_id'=>$id))->result();
		foreach($promotion_category as $cat)
		{   
		    $cat_details    = $this->Common->get_details('promotion_category',array('pcat_id'=>$cat->cat_id))->row();
		    if($cat_details) {
		        $cat->name      = $cat_details->cat_name;
		    } else {
		        $cat->name      = '';
		    }
		    $cat->products  = $this->Common->get_details('promotion_products',array('cat_id'=>$cat->cat_id,'promo_id'=>$id))->result();
		    foreach($cat->products as $product)
		    {
		        $product_details  = $this->Common->get_details('products',array('p_id'=>$product->product_id))->row();
		        $product->item_code= $product_details->item_code;
		        $price            = $this->Common->get_details('product_price',array('price_id'=>$product->price_id))->row();
		        if($price->unit!=='')
		        {
		            $product->name    = $product_details->name.' - '.$price->unit;
		        }
		        else
		        {
		            $product->name    = $product_details->name;
		        }
		        $product->code        = $product_details->item_code;
		    }
		}
		$data['promotion']  = $promotion;
		$data['promotion_category'] = $promotion_category;
	   $this->load->view('branch/promotions/details',$data);
	}

}
?>
