<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Profile extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('Common');
			if (!branch()) {
				redirect('users/branch');
			}
	}

	public function index()
	{   
		$branch    = $this->session->userdata['branch'];
		$branch_id = $branch['branch_id'];

		$restaurant_id  = $this->Common->get_details('branches',array('b_id'=>$branch_id))->row()->r_id;
		$data['branch'] = $this->Common->get_details('branches',array('b_id'=>$branch_id))->row();
		$data['rest']   = $this->Common->get_details('restaurants',array('r_id'=>$restaurant_id))->row();
		$types          = $this->Common->get_details('restaurant_cuisines',array('r_id'=>$restaurant_id))->result();
		foreach($types as $type)
		{
			$type->name = $this->Common->get_details('cuisines',array('c_id'=>$type->c_id))->row()->name;
		}
		$data['types'] = $types;
		$this->load->view('branch/profile/view',$data);
	}

	public function getProfileById()
    {
    	$branch_id    = $this->input->post('id');
    	$data         = $this->Common->get_details('branches',array('b_id'=>$branch_id))->row();
    	print_r(json_encode($data));
    }
    
    public function edit()
    {
        $branch    = $this->session->userdata['branch'];
		$branch_id = $branch['branch_id'];
		
		$data['places']  = $this->Common->get_details('places',array('status'=>'1'))->result();
		$branch          = $this->Common->get_details('branches',array('b_id'=>$branch_id))->row();
		$data['branch']  = $branch;
		$data['rest']   = $this->Common->get_details('restaurants',array('r_id'=>$branch->r_id))->row();
		$types           = $this->Common->get_details('restaurant_cuisines',array('r_id'=>$branch->r_id))->result();
		foreach($types as $type)
		{
			$type->name = $this->Common->get_details('cuisines',array('c_id'=>$type->c_id))->row()->name;
		}
		$data['types'] = $types;
		$this->load->view('branch/profile/edit',$data);
    }
	
	public function editData()
	{
		$branch_id = $this->input->post('branch_id');
		$branch_name     = $this->security->xss_clean($this->input->post('branch_name'));
		$email     = $this->security->xss_clean($this->input->post('email'));
		$code      = $this->security->xss_clean($this->input->post('code'));
		$phone     = $this->security->xss_clean($this->input->post('phone'));
		$address_1 = $this->security->xss_clean($this->input->post('address_1'));
		$country   = $this->security->xss_clean($this->input->post('country'));
		$city      = $this->security->xss_clean($this->input->post('city'));
		$landmark  = $this->security->xss_clean($this->input->post('landmark'));
		$latitude  = $this->security->xss_clean($this->input->post('latitude'));
		$longitude = $this->security->xss_clean($this->input->post('longitude'));
		$open_time = $this->security->xss_clean($this->input->post('open_time'));
		$close_time= $this->security->xss_clean($this->input->post('close_time'));
		
        $city_check= $this->Common->get_details('places',array('name' =>$city));
		if($city_check->num_rows()>0)
		{
		    $city_id = $city_check->row()->place_id;
		}
		else
		{
		    $city_id= '';
		}
		
		$check       = $this->Common->get_details('branches',array('email' => $email,'phone'=>$phone, 'b_id!=' => $branch_id))->num_rows();
		$check_phone = $this->Common->get_details('branches',array('phone'=>$phone, 'b_id!=' => $branch_id))->num_rows();
		$check_mail  = $this->Common->get_details('branches',array('email'=>$email, 'b_id!=' => $branch_id))->num_rows();
		
		$branch_details= $this->Common->get_details('branches',array('b_id' =>$branch_id));
		$branch_type = $branch_details->row()->branch_type;
		$rest_id = $branch_details->row()->r_id;
		if($branch_type == '2'){
			$check_email= $this->Common->get_details('restaurants',array('rest_email' => $email ,'r_id!=' => $rest_id))->num_rows();
		}else{
			$check_email= $this->Common->get_details('restaurants',array('rest_email' => $email))->num_rows();

		}

		$check_code  = $this->Common->get_details('branches',array('branch_code'=>$code, 'b_id!=' => $branch_id))->num_rows();
		if($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Mobile number and email already exists..!');
			redirect('branch/profile');
		}
		elseif($check_phone > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Mobile number already exists..!');
			redirect('branch/profile');
		}
		elseif($check_mail > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Email already exists..!');
			redirect('branch/profile/edit',$branch_id);
		}
		else if ($check_email > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Email address already registered for a store..!');
			redirect('branch/profile/edit',$branch_id);
		}
		elseif($check_code > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Code already exists..!');
			redirect('branch/profile/edit',$branch_id);
		}
		else 
		{		
			$array = [  
						'branch_name'=> $branch_name,
						'phone'      => $phone,
						'email'      => $email,
						'city'       => $city,
						'city_id'    => $city_id,
						'address'    => $address_1,
						'location'   => $landmark,
						'latitude'   => $latitude,
						'longitude'  => $longitude,
				// 		'pincode'    => $pincode,
						'country'    => $country,
						'branch_code'=> $code,
						'open_time'  => $open_time,
						'close_time' => $close_time,
					  ];
			if ($this->Common->update('b_id',$branch_id,'branches',$array)) 
			{
				$branch_details= $this->Common->get_details('branches',array('b_id' =>$branch_id));
				$branch_type = $branch_details->row()->branch_type;
				$rest_id = $branch_details->row()->r_id;
				if($branch_type == '2')
				{
					$res_array = [
						// 'rest_name'  => $name,
						'rest_code'  => $code,
						'rest_phone' => $phone,
						'rest_email' => $email,
						// 'rest_image' => $path,
						'open_time'  => $open_time,
						'close_time' => $close_time,
						'address1'   => $address_1,
				// 		'address2'   => $address_2,
				// 		'address3'   => $address_3,
				// 		'state'      => $state,
						'latitude'   => $latitude,
						'longitude'   => $longitude,
						'city'       => $city,
						'landmark'   => $landmark,
				// 		'pincode'    => $pincode,
						'country'    => $country,
						
					 ];
					 $this->Common->update('r_id',$rest_id,'restaurants',$res_array);
				}
				

				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Changes made successfully..!');
				redirect('branch/profile');
			}
			else
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to update branch..!');
				redirect('branch/profile');
			}
		}
	}

}
?>
