<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Products extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('Common');
			$this->load->model('branch/M_products','products');
			if (!branch()) {
				redirect('users/branch');
			}
	}

	public function index()
	{   
		$branch    = $this->session->userdata['branch'];
		$branch_id = $branch['branch_id'];

		$products  = $this->products->getProducts($branch_id);
		foreach($products as $prod)
		{
		    $prod->prices = $this->Common->get_details('product_price',array('product_id'=>$prod->product_id))->result();
		}
		$data['products'] = $products;
		$this->load->view('branch/products/view',$data);
	}

    public function disable()
	{
	    $product_id = $this->input->post('product_id');
		$array      =  [
    			          'status' => '0'
    		           ];
	
		if ($this->Common->update('bp_id',$product_id,'branch_products',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Product blocked successfully..!');
			redirect('branch/products');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block product..!');
			redirect('branch/products');
		}
	}

	public function enable()
	{
	    $product_id = $this->input->post('product_id');
		$array      = [
			            'status' => '1'
		              ];
	
		if ($this->Common->update('bp_id',$product_id,'branch_products',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Product activated successfully..');
			redirect('branch/products');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate product..!');
			redirect('branch/products');
	    }		
	}
	
    public function details($id)
	{   
		$restaurant    = $this->session->userdata['restaurant'];
		$restaurant_id = $restaurant['restaurant_id'];

		$check = $this->Common->get_details('products',array('p_id' => $id));
		if ($check->num_rows() > 0) 
		{
			$data['pro'] = $check->row();
			
			$menu = $this->Common->get_details('menu',array('menu_id'=>$check->row()->cat_id));
             if($menu->num_rows()>0)
             {
             	$data['menu'] = $menu->row()->name;
             }
             else
             {
             	$data['menu'] = 'None';
             }

            $categories         = $this->Common->get_details('product_choice_categories',array('product_id'=>$id,'status'=>'1'))->result();
			foreach($categories as $cat)
			{
			    $cat->choices   = $this->Common->get_details('product_choices',array('pcat_id'=>$cat->pcat_id,'status'=>'1'))->result();
			}
            $data['categories'] = $categories;
            
            $prices        = $this->Common->get_details('product_price',array('product_id'=>$id,'status'=>'1'))->result();
			$data['prices']= $prices;
            
			$this->load->view('branch/products/details',$data);
		}
		else 
		{
			redirect('branch/products');
		}
	}

}
?>
