<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('branch/M_dashboard','dash');
			$this->load->model('Common');
			if (!branch()) {
				redirect('users/branch');
			}
	}
	
	public function index()
	{   
		$branch    = $this->session->userdata['branch'];
		$branch_id = $branch['branch_id'];
        
        $restaurant_id       = $this->Common->get_details('branches',array('b_id'=>$branch_id))->row()->r_id;
        // $data['products']    = $this->dash->getProducts($restaurant_id);
		$products      = $this->dash->getProducts($restaurant_id);
        foreach($products as $product)
        {
            $product->prices = $this->Common->get_details('product_price',array('product_id'=>$product->p_id,'status'=>'1'))->result();
        }
		$data['products']    = $products;

		$orders  = $this->dash->getOrders($branch_id);
		foreach($orders as $order)
		{
			$address_check    = $this->Common->get_details('ordered_address',array('order_id'=>$order->order_id));
    	    if($order->type=="guest")
    	    {
    	        if($address_check->num_rows()>0)
    		    {
    	           $order->username   = $address_check->row()->name;
    		    }
    		    else
    		    {
    		    	$order->username  = '';
    		    }
    	    }
    	    else
    	    {
    	        // $user             = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
    	        $order->username  = $order->firstname.' '.$order->lastname;
    	    }
		}
        $data['orders']  = $orders;
        $data['categories']  = $this->dash->getCategories($restaurant_id);

        $data['product']     = $this->Common->get_details('products',array('r_id'=>$restaurant_id,'status'=>'active'))->num_rows();
        $data['category']   = $this->Common->get_details('menu',array('r_id'=>$restaurant_id,'status'=>'1'))->num_rows();
        $data['cuisine']     = $this->Common->get_details('restaurant_cuisines',array('r_id'=>$restaurant_id))->num_rows();
        $data['order']       = $this->dash->getOrderCount($branch_id );
        $data['cancelled_today'] = $this->dash->getTodaysCancelledOrderCount($branch_id);

		$this->load->view('branch/dashboard/dashboard',$data);
	}
	
    public function password()
    {
    	$branch    = $this->session->userdata['branch'];
		$branch_id = $branch['branch_id'];
        
        $pass     = $this->security->xss_clean($this->input->post('password'));
		$password = md5($pass); 
		$array    = [
			            'password' => $password,
			            'pass'     => $pass
		            ];
	
		if ($this->Common->update('b_id',$branch_id,'branches',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Password changed successfully..!');
			redirect('branch/dashboard');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to change password..!');
			redirect('branch/dashboard');
		}
    }
}
?>
