<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Blocks extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('branch/M_blocks','blocks');
			$this->load->model('Common');
			if (!branch()) {
				redirect('users/branch');
			}
	}

/*Get Branch selected blocks*/	
	public function index()
	{   
		$branch    = $this->session->userdata['branch'];
		$branch_id = $branch['branch_id'];

        $blocks         = $this->blocks->getBlocks($branch_id);
        $data['blocks'] = $blocks;
		$this->load->view('branch/blocks/view',$data);
	}
	
	public function manage()
	{
	    $branch    = $this->session->userdata['branch'];
		$branch_id = $branch['branch_id'];
       
        $blocks     = $this->blocks->getAllBlocks();
        foreach($blocks as $block)
		{   
			$stat_check  = $this->blocks->getBranchBlockStat($block->block_id,$branch_id);
			if($stat_check>0)
			{
				$block->stat  = '1';
			}
			else
			{
				$block->stat  = '0';
			}
		}
        $data['blocks'] = $blocks;
        $this->load->view('branch/blocks/manage',$data);
	}
	
	public function addData()
	{   
		$branch    = $this->session->userdata['branch'];
		$branch_id = $branch['branch_id'];
        
		$blocks     = $this->input->post('blocks');
		$this->Common->delete('branch_delivery_blocks',array('branch_id'=>$branch_id));
        foreach($blocks as $block)
		{ 
		    	$array  = [
    			             'branch_id'  => $branch_id,
    			             'block_id'   => $block
    		              ];
		        $this->Common->insert('branch_delivery_blocks',$array);
		}
		$this->session->set_flashdata('alert_type', 'success');
		$this->session->set_flashdata('alert_title', 'Success');
		$this->session->set_flashdata('alert_message', 'Block added..!');
		redirect('branch/blocks');
	}
	
	public function delete()
	{  
	    $id        = $this->input->post('block_id');
		$branch    = $this->session->userdata['branch'];
		$branch_id = $branch['branch_id'];

		if($this->Common->delete('branch_delivery_blocks',array('bdb_id'=>$id)))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Block removed successfully..');
			redirect('branch/blocks');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to remove block..!');
			redirect('branch/blocks');
	    }		
	}
}
?>
