<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Status extends REST_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('android/driver/M_status','status');
			$this->load->model('android/driver/M_order','orders');
			$this->load->model('Common');
	}

	public function index_post()
	{   
	    $header = $this->input->get_request_header('Authorization');
	    if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{ 
        	    $status    = $this->security->xss_clean($this->input->post('status'));
        	    if($status=='today')
        	    {
        		   $total_sale    = $this->status->getTodaysTotalSale($user_id);
        		   $payment_list  = $this->status->getTodaysTotalPaymentList($user_id);
        		   foreach($payment_list as $list)
        		   {
        		       $list->products = $this->orders->getOrderedProducts($list->order_id);
            	       foreach($list->products as $product)
            	       {
                            $product->extras           = $this->Common->get_details('ordered_extras',array('order_id'=>$list->order_id,'product_id'=>$product->product_id))->result();
            	       }
            	       $list->address  = $this->Common->get_details('address',array('address_id'=>$list->address_id))->row();
        		   }
        	    }
        	    elseif($status=='week')
        	    {
        	        $total_sale    = $this->status->getWeeksTotalSale($user_id);
        	        $payment_list  = $this->status->getWeeksTotalPaymentList($user_id);
        	        foreach($payment_list as $list)
        		    {
        		       $list->products = $this->orders->getOrderedProducts($list->order_id);
            	       foreach($list->products as $product)
            	       {
            	             $product->extras           = $this->Common->get_details('ordered_extras',array('order_id'=>$list->order_id,'product_id'=>$product->product_id))->result();
            	       }
            	       $list->address  = $this->Common->get_details('address',array('address_id'=>$list->address_id))->row();
        		    }
        	    }
        	    elseif($status=='month')
        	    {
        	        $total_sale    = $this->status->getMonthTotalSale($user_id);
        	        $payment_list  = $this->status->getMonthTotalPaymentList($user_id);
        	        foreach($payment_list as $list)
        		    {
        		       $list->products = $this->orders->getOrderedProducts($list->order_id);
            	       foreach($list->products as $product)
            	       {
            	            $product->extras           = $this->Common->get_details('ordered_extras',array('order_id'=>$list->order_id,'product_id'=>$product->product_id))->result();
            	       }
            	       $list->address  = $this->Common->get_details('address',array('address_id'=>$list->address_id))->row();
        		    }
        	    }
        	    elseif($status=='lifetime')
        	    {
        	        $total_sale    = $this->status->getTotalSale($user_id);
        	        $payment_list  = $this->status->getTotalPaymentList($user_id);
        	        foreach($payment_list as $list)
        		    {
        		       $list->products = $this->orders->getOrderedProducts($list->order_id);
            	       foreach($list->products as $product)
            	       {
            	           $product->extras           = $this->Common->get_details('ordered_extras',array('order_id'=>$list->order_id,'product_id'=>$product->product_id))->result();
            	       }
            	       $list->address  = $this->Common->get_details('address',array('address_id'=>$list->address_id))->row();
        		    }
        	    }
        	    
        	   	$this->response(array(
                        		              "status"  => 1,
                        		              "message" => "Success",
                        		              "data"    => [
                    	                                      'payments'  => $total_sale,
                    	                                      'orders'    => $payment_list
                    	                                    ]  
                        		            ), REST_Controller::HTTP_OK);             
    		}	
            else 
    		{
    			   $this->response(array(
                    			          "status"  => 0,
                    			          "message" => "Your session has expired, please login again"
                    			        ), REST_Controller::HTTP_UNAUTHORIZED);
    		}              
	    }
	    else
	    {
	        $this->response(array(
                    			    "status"  => 0,
                    			    "message" => "Your session has expired, please login again"
                    			 ), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}
	
	public function decodeToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h6';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}
	
}
?>
