<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Restaurant extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_restaurant','restaurant');
		$this->load->model('android/M_home','home');
		$this->load->model('android/M_products','products');
	}
//*********************************** GET *****************************************************************************************************************************************//	
	public function index_post()
	{   
	    date_default_timezone_set('Asia/Bahrain');
	    $current    = date('Y-m-d H:i:s');
	    $date       = date('Y-m-d');
	    $time       = date('h:i:s');
	    
	    $latitude    = $this->security->xss_clean($this->input->post('latitude'));
	    $longitude   = $this->security->xss_clean($this->input->post('longitude'));
	    
	    $radius      = $this->Common->get_details('delivery_area',array())->row()->area_distance;
	   // $radius      = $radius/1.609;
	     
	    $cuisine_id  = $this->security->xss_clean($this->input->post('cuisine_id'));
	    if($cuisine_id=='0')
	    {
	        $check           = $this->Common->get_details('restaurants',array('status'=>'1'));
    		if($check->num_rows()>0)
    		{
    		  //  $restaurants  = $this->rest->getRestaurants();
    		    $rest         = $this->restaurant->getRestaurants($latitude,$longitude,$radius);
    		    foreach($rest as $re)
    		    {
    		        $re->branch_id = '0';
    		    }
    		    $branches      = $this->restaurant->getBranches($latitude,$longitude,$radius);
    		    $array1        = array_merge($rest, $branches);
                $array2        = array_unique(array_column($array1, 'r_id'));
                $array         = array_intersect_key($array1, $array2);
                function array_multi_subsort($array, $subkey)
                    {
                        $b = array(); $c = array();
                    
                        foreach ($array as $k => $v)
                        {
                            $b[$k] = strtolower($v->$subkey);
                        }
                    
                        asort($b);
                        foreach ($b as $key => $val)
                        {
                            $c[] = $array[$key];
                        }
                    
                        return $c;
                    }

                $restaurants = array_multi_subsort($array, 'distance');

    		    foreach($restaurants as $restaurant)
    		    {
    		         if($restaurant->latitude!='' || $restaurant->longitude!='')
			         {
			             $distance              = $this->GetDrivingDistance($latitude, $restaurant->latitude, $longitude, $restaurant->longitude);
                         $town_distance         = $distance['distance'];
                         $town_time_taken       = $distance['time'];
                         $restaurant->travel_time      = $town_time_taken;
                         $restaurant->travel_distance  = $town_distance;
			         }
			         else
			         {
			              $restaurant->travel_time       = 0;
			              $restaurant->travel_distance  = 0;
			         }
    		         $restaurant->types  = $this->restaurant->getTypes($restaurant->r_id);
    		         $rating_check              = $this->Common->get_details('restaurant_reviews',array('r_id'=>$restaurant->r_id));
				     if($rating_check->num_rows()>0)
				     {
				        $rate_count          = $rating_check->num_rows();
				        $rating              = $this->restaurant->getRatingSum($restaurant->r_id);
				        $restaurant-> ratings  = number_format($rating/$rate_count,'1');
				     }
				     else
				     {
				        $restaurant-> ratings  = '0'; 
				     }
    		         $restaurant->sale_value = '0';
    		         $restaurant->coupons   = $this->home->getCoupons($restaurant->r_id);
    		         foreach($restaurant->coupons as $coup)
        		     {
        		        if($coup->start_time!='00:00:00')
            	        {   
            	            $c_start  = $coup->start_date.' '.$coup->start_time;
            	            if($current>=$c_start)
                	        {
                	            $start_date = true;
                	        }
                	        else
                	        {
                	            $start_date = false;
                	        }
            	        }
            	        else
            	        {
            	            if($date>=$coup->start_date)
                	        {
                	            $start_date  = true;
                	        }
                	        else
                	        {
                	            $start_date  = false;
                	        }
            	        }
            	        
            	        
            	        if($coup->end_time!='00:00:00')
            	        {  
            	            $c_end  = $coup->end_date.' '.$coup->end_time;
                	        if($current<=$c_end)
                	        {
                	            $end_date  = true;
                	        }
                	        else
                	        {
                	            $end_date  = false;
                	        }
            	        }
            	        else
            	        {
            	            if($date<=$coup->end_date)
                	        {
                	            $end_date  = true;
                	        }
                	        else
                	        {
                	            $end_date  = false;
                	        }
            	        }
            	        
            	        if($start_date && $end_date)
            	        {  
            	            $coup->valid_status = true;
            	        }
            	        else
            	        {
            	           $coup->valid_status = false;              
            	        }
        		     }
			         $restaurant->promotions= $this->home->getPromotions($restaurant->r_id);
			         foreach($restaurant->promotions as $pro)
			         {
			            if($date>=$pro->start_date)
            	        {
            	            $start_date  = true;
            	        }
            	        else
            	        {
            	            $start_date  = false;
            	        }
            	        
            	        if($date<=$pro->end_date)
            	        {
            	            $end_date  = true;
            	        }
            	        else
            	        {
            	            $end_date  = false;
            	        }
            	        
            	        if($start_date && $end_date)
            	        {  
            	            $pro->valid_status = true;
            	        }
            	        else
            	        {
            	           $pro->valid_status = false;              
            	        }
			         }
    		    }       
    		}
    		else
    		{
    		    $restaurants  = array();
    		}
	    }
	    else
	    {
	        $check           = $this->restaurant->getCuisineRestaurantsCount($cuisine_id,$latitude,$longitude,$radius);
	       // $check           = $this->rest->getCuisineRestaurants($cuisine_id);
    		if($check>0)
    		{
    		    $rest        = $this->restaurant->getCuisineRestaurants($cuisine_id,$latitude,$longitude,$radius);
    		    foreach($rest as $re)
    		    {
    		        $re->branch_id = '0';
    		    }
    		    $branches     = $this->restaurant->getCuisineBranches($cuisine_id,$latitude,$longitude,$radius);
    		    $array1        = array_merge($rest, $branches);
                $array2        = array_unique(array_column($array1, 'r_id'));
                $array         = array_intersect_key($array1, $array2);
    		     
    		    function array_multi_subsort($array, $subkey)
                    {
                        $b = array(); $c = array();
                    
                        foreach ($array as $k => $v)
                        {
                            $b[$k] = strtolower($v->$subkey);
                        }
                    
                        asort($b);
                        foreach ($b as $key => $val)
                        {
                            $c[] = $array[$key];
                        }
                    
                        return $c;
                    }

                $restaurants = array_multi_subsort($array, 'distance');
    		    
    		    foreach($restaurants as $restaurant)
    		    {
    		         if($restaurant->latitude!='' || $restaurant->longitude!='')
			         {
			             $distance              = $this->GetDrivingDistance($latitude, $restaurant->latitude, $longitude, $restaurant->longitude);
                         $town_distance         = $distance['distance'];
                         $town_time_taken       = $distance['time'];
                         $restaurant->travel_time      = $town_time_taken;
                         $restaurant->travel_distance  = $town_distance;
			         }
			         else
			         {
			              $restaurant->travel_time       = 0;
			              $restaurant->travel_distance  = 0;
			         }
    		         $restaurant->types = $this->restaurant->getTypes($restaurant->r_id);
    		         $rating_check    = $this->Common->get_details('restaurant_reviews',array('r_id'=>$restaurant->r_id));
				     if($rating_check->num_rows()>0)
				     {
				        $rate_count            = $rating_check->num_rows();
				        $rating                = $this->restaurant->getRatingSum($restaurant->r_id);
				        $restaurant-> ratings  = number_format($rating/$rate_count,'1');
				     }
				     else
				     {
				        $restaurant-> ratings  = '0'; 
				     }
    		         $restaurant->sale_value   = '0'; 
    		         $restaurant->coupons      = $this->home->getCoupons($restaurant->r_id);
    		         foreach($restaurant->coupons as $coup)
        		     {
        		        if($coup->start_time!='00:00:00')
            	        {   
            	            $c_start  = $coup->start_date.' '.$coup->start_time;
            	            if($current>=$c_start)
                	        {
                	            $start_date = true;
                	        }
                	        else
                	        {
                	            $start_date = false;
                	        }
            	        }
            	        else
            	        {
            	            if($date>=$coup->start_date)
                	        {
                	            $start_date  = true;
                	        }
                	        else
                	        {
                	            $start_date  = false;
                	        }
            	        }
            	        
            	        
            	        if($coup->end_time!='00:00:00')
            	        {  
            	            $c_end  = $coup->end_date.' '.$coup->end_time;
                	        if($current<=$c_end)
                	        {
                	            $end_date  = true;
                	        }
                	        else
                	        {
                	            $end_date  = false;
                	        }
            	        }
            	        else
            	        {
            	            if($date<=$coup->end_date)
                	        {
                	            $end_date  = true;
                	        }
                	        else
                	        {
                	            $end_date  = false;
                	        }
            	        }
            	        
            	        if($start_date && $end_date)
            	        {  
            	            $coup->valid_status = true;
            	        }
            	        else
            	        {
            	           $coup->valid_status = false;              
            	        }
        		     }
			         $restaurant->promotions   = $this->home->getPromotions($restaurant->r_id);
			         foreach($restaurant->promotions as $pro)
			         {
			            if($date>=$pro->start_date)
            	        {
            	            $start_date  = true;
            	        }
            	        else
            	        {
            	            $start_date  = false;
            	        }
            	        
            	        if($date<=$pro->end_date)
            	        {
            	            $end_date  = true;
            	        }
            	        else
            	        {
            	            $end_date  = false;
            	        }
            	        
            	        if($start_date && $end_date)
            	        {  
            	            $pro->valid_status = true;
            	        }
            	        else
            	        {
            	           $pro->valid_status = false;              
            	        }
			         }
    		    }       
    		}
    		else
    		{
    		    $restaurants  = array();
    		}
	    }
	   
		$this->response(array(
            		              "status"  => true,
            		              "message" => "Success",
            					  'data'    => $restaurants
            		            ), REST_Controller::HTTP_OK);        
	}

//**************************************** SEARCH *********************************************************************************************************************************//	
	public function search_post()
	{
	    date_default_timezone_set('Asia/Bahrain');
	    $current    = date('Y-m-d H:i:s');
	    $date       = date('Y-m-d');
	    $time       = date('h:i:s');
	    
	    $key         = $this->security->xss_clean($this->input->post('key'));
	    $latitude    = $this->security->xss_clean($this->input->post('latitude'));
	    $longitude   = $this->security->xss_clean($this->input->post('longitude'));
	    
	    $radius      = $this->Common->get_details('delivery_area',array())->row()->area_distance;
	   // $radius      = $radius/1.609;
	    
		$keyword     = str_replace(" ", "%", $key);
		if($keyword=='')
		{     
		      $rest        = $this->restaurant->getRestaurants($latitude,$longitude,$radius);
		      foreach($rest as $re)
		      {
		          $re->branch_id = '0';
		      }
		      $branches      = $this->restaurant->getBranches($latitude,$longitude,$radius);
		      $array1        = array_merge($rest, $branches);
              $array2        = array_unique(array_column($array1, 'r_id'));
              $array         = array_intersect_key($array1, $array2);
    		     
		    function array_multi_subsort($array, $subkey)
            {
                $b = array(); $c = array();
            
                foreach ($array as $k => $v)
                {
                    $b[$k] = strtolower($v->$subkey);
                }
            
                asort($b);
                foreach ($b as $key => $val)
                {
                    $c[] = $array[$key];
                }
            
                return $c;
            }

             $restaurants = array_multi_subsort($array, 'distance');
             foreach($restaurants as $restaurant)
		     {
		         $restaurant->types  = $this->restaurant->getTypes($restaurant->r_id);
		         $rating_check              = $this->Common->get_details('restaurant_reviews',array('r_id'=>$restaurant->r_id));
			     if($rating_check->num_rows()>0)
			     {
			        $rate_count            = $rating_check->num_rows();
			        $rating                = $this->restaurant->getRatingSum($restaurant->r_id);
			        $restaurant-> ratings  = number_format($rating/$rate_count,'1');
			     }
			     else
			     {
			        $restaurant-> ratings  = '0'; 
			     }
		         $restaurant->sale_value = '0';
		         
		         if($restaurant->latitude!='' || $restaurant->longitude!='')
		         {
		             $distance              = $this->GetDrivingDistance($latitude, $restaurant->latitude, $longitude, $restaurant->longitude);
                     $town_distance         = $distance['distance'];
                     $town_time_taken       = $distance['time'];
                     $restaurant->travel_time      = $town_time_taken;
                     $restaurant->travel_distance  = $town_distance;
		         }
		         else
		         {
		              $restaurant->travel_time       = 0;
		              $restaurant->travel_distance  = 0;
		         }
		         
		         $restaurant->coupons   = $this->home->getCoupons($restaurant->r_id);
		         foreach($restaurant->coupons as $coup)
    		     {
    		        if($coup->start_time!='00:00:00')
        	        {   
        	            $c_start  = $coup->start_date.' '.$coup->start_time;
        	            if($current>=$c_start)
            	        {
            	            $start_date = true;
            	        }
            	        else
            	        {
            	            $start_date = false;
            	        }
        	        }
        	        else
        	        {
        	            if($date>=$coup->start_date)
            	        {
            	            $start_date  = true;
            	        }
            	        else
            	        {
            	            $start_date  = false;
            	        }
        	        }
        	        
        	        
        	        if($coup->end_time!='00:00:00')
        	        {  
        	            $c_end  = $coup->end_date.' '.$coup->end_time;
            	        if($current<=$c_end)
            	        {
            	            $end_date  = true;
            	        }
            	        else
            	        {
            	            $end_date  = false;
            	        }
        	        }
        	        else
        	        {
        	            if($date<=$coup->end_date)
            	        {
            	            $end_date  = true;
            	        }
            	        else
            	        {
            	            $end_date  = false;
            	        }
        	        }
        	        
        	        if($start_date && $end_date)
        	        {  
        	            $coup->valid_status = true;
        	        }
        	        else
        	        {
        	           $coup->valid_status = false;              
        	        }
    		     }
		         $restaurant->promotions= $this->home->getPromotions($restaurant->r_id);
		         foreach($restaurant->promotions as $pro)
		         {
		            if($date>=$pro->start_date)
        	        {
        	            $start_date  = true;
        	        }
        	        else
        	        {
        	            $start_date  = false;
        	        }
        	        
        	        if($date<=$pro->end_date)
        	        {
        	            $end_date  = true;
        	        }
        	        else
        	        {
        	            $end_date  = false;
        	        }
        	        
        	        if($start_date && $end_date)
        	        {  
        	            $pro->valid_status = true;
        	        }
        	        else
        	        {
        	           $pro->valid_status = false;              
        	        }
		         }
		    }
		}
		else
		{    
		     $rest        = $this->restaurant->searchRestaurant($keyword,$latitude,$longitude,$radius);
		     foreach($rest as $re)
		      {
		          $re->branch_id = '0';
		      }
		   	 $branches     = $this->restaurant->searchBranches($keyword,$latitude,$longitude,$radius);
		   	 $array1        = array_merge($rest, $branches);
             $array2        = array_unique(array_column($array1, 'r_id'));
             $array         = array_intersect_key($array1, $array2);
    		     
    		    function array_multi_subsort($array, $subkey)
                    {
                        $b = array(); $c = array();
                    
                        foreach ($array as $k => $v)
                        {
                            $b[$k] = strtolower($v->$subkey);
                        }
                    
                        asort($b);
                        foreach ($b as $key => $val)
                        {
                            $c[] = $array[$key];
                        }
                    
                        return $c;
                    }

             $restaurants = array_multi_subsort($array, 'distance');
             foreach($restaurants as $restaurant)
		     {
		         $restaurant->types  = $this->restaurant->getTypes($restaurant->r_id);
		         $rating_check              = $this->Common->get_details('restaurant_reviews',array('r_id'=>$restaurant->r_id));
			     if($rating_check->num_rows()>0)
			     {
			        $rate_count          = $rating_check->num_rows();
			        $rating              = $this->restaurant->getRatingSum($restaurant->r_id);
			        $restaurant-> ratings  = number_format($rating/$rate_count,'1');
			     }
			     else
			     {
			        $restaurant-> ratings  = '0'; 
			     }
		         $restaurant->sale_value = '0';
		         
		         if($restaurant->latitude!='' || $restaurant->longitude!='')
		         {
		             $distance              = $this->GetDrivingDistance($latitude, $restaurant->latitude, $longitude, $restaurant->longitude);
                     $town_distance         = $distance['distance'];
                     $town_time_taken       = $distance['time'];
                     $restaurant->travel_time      = $town_time_taken;
                     $restaurant->travel_distance  = $town_distance;
		         }
		         else
		         {
		              $restaurant->travel_time       = 0;
		              $restaurant->travel_distance  = 0;
		         }
		         
		         $restaurant->coupons   = $this->home->getCoupons($restaurant->r_id);
		         foreach($restaurant->coupons as $coup)
    		     {
    		        if($coup->start_time!='00:00:00')
        	        {   
        	            $c_start  = $coup->start_date.' '.$coup->start_time;
        	            if($current>=$c_start)
            	        {
            	            $start_date = true;
            	        }
            	        else
            	        {
            	            $start_date = false;
            	        }
        	        }
        	        else
        	        {
        	            if($date>=$coup->start_date)
            	        {
            	            $start_date  = true;
            	        }
            	        else
            	        {
            	            $start_date  = false;
            	        }
        	        }
        	        
        	        
        	        if($coup->end_time!='00:00:00')
        	        {  
        	            $c_end  = $coup->end_date.' '.$coup->end_time;
            	        if($current<=$c_end)
            	        {
            	            $end_date  = true;
            	        }
            	        else
            	        {
            	            $end_date  = false;
            	        }
        	        }
        	        else
        	        {
        	            if($date<=$coup->end_date)
            	        {
            	            $end_date  = true;
            	        }
            	        else
            	        {
            	            $end_date  = false;
            	        }
        	        }
        	        
        	        if($start_date && $end_date)
        	        {  
        	            $coup->valid_status = true;
        	        }
        	        else
        	        {
        	           $coup->valid_status = false;              
        	        }
    		     }
		         $restaurant->promotions= $this->home->getPromotions($restaurant->r_id);
		         foreach($restaurant->promotions as $pro)
		         {
		            if($date>=$pro->start_date)
        	        {
        	            $start_date  = true;
        	        }
        	        else
        	        {
        	            $start_date  = false;
        	        }
        	        
        	        if($date<=$pro->end_date)
        	        {
        	            $end_date  = true;
        	        }
        	        else
        	        {
        	            $end_date  = false;
        	        }
        	        
        	        if($start_date && $end_date)
        	        {  
        	            $pro->valid_status = true;
        	        }
        	        else
        	        {
        	           $pro->valid_status = false;              
        	        }
		         }
		    }
 
		}
		 $this->response(array(
            		              "status"  => true,
            		              "message" => "Success",
            		              'data'    => $restaurants
            		            ), REST_Controller::HTTP_OK);        
	}

//********************************************** DETAILS *************************************************************************************************************************//	
	public function details_post()
	{   
	    date_default_timezone_set('Asia/Bahrain');
		$date       = date('Y-m-d');
	    $time       = date('H:i:s');
	    $current    = date('Y-m-d H:i:s');
	    
	    $restaurant_id   = $this->security->xss_clean($this->input->post('restaurant_id'));
	    $branch_id       = $this->security->xss_clean($this->input->post('branch_id'));
		$check           = $this->Common->get_details('restaurants',array('r_id'=>$restaurant_id));
		if($check->num_rows()>0)
		{
		    if($branch_id=='0')
		    {
		        $restaurant                = $check->row();
		        $restaurant->open_time     = date('h:i A',strtotime($restaurant->open_time));
		        $restaurant->close_time    = date('h:i A',strtotime($restaurant->close_time));
		      
		        $restaurant->branch_id     = '0';
		        $restaurant->delivery_time = '30';
		        $restaurant->reviews       = $this->Common->get_details('restaurant_reviews',array('r_id'=>$restaurant_id))->num_rows();
    		    $rating_check              = $this->Common->get_details('restaurant_reviews',array('r_id'=>$restaurant_id));
			    if($rating_check->num_rows()>0)
			    {
			        $rate_count            = $rating_check->num_rows();
			        $rating                = $this->restaurant->getRatingSum($restaurant_id);
			        $restaurant-> ratings  = number_format($rating/$rate_count,'1');
			    }
			    else
			    {
			        $restaurant-> ratings   = '0'; 
			    }
    		    $restaurant->min_order      = $restaurant->min_order;
    		    $restaurant->delivery_fee   = '0';
    		    $restaurant->sales_tax      = '0';
    		    $restaurant->service_charge = $restaurant->service_charge;
    		    $restaurant->types          = $this->restaurant->getTypes($restaurant_id);
    		    $restaurant->coupons        = $this->home->getCoupons($restaurant_id);
    		    foreach($restaurant->coupons as $coup)
    		    {
    		        if($coup->start_time!='00:00:00')
        	        {   
        	            $c_start  = $coup->start_date.' '.$coup->start_time;
        	            if($current>=$c_start)
            	        {
            	            $start_date = true;
            	        }
            	        else
            	        {
            	            $start_date = false;
            	        }
        	        }
        	        else
        	        {
        	            if($date>=$coup->start_date)
            	        {
            	            $start_date  = true;
            	        }
            	        else
            	        {
            	            $start_date  = false;
            	        }
        	        }
        	        
        	        
        	        if($coup->end_time!='00:00:00')
        	        {  
        	            $c_end  = $coup->end_date.' '.$coup->end_time;
            	        if($current<=$c_end)
            	        {
            	            $end_date  = true;
            	        }
            	        else
            	        {
            	            $end_date  = false;
            	        }
        	        }
        	        else
        	        {
        	            if($date<=$coup->end_date)
            	        {
            	            $end_date  = true;
            	        }
            	        else
            	        {
            	            $end_date  = false;
            	        }
        	        }
        	        
        	        if($start_date && $end_date)
        	        {  
        	            $coup->valid_status = true;
        	        }
        	        else
        	        {
        	           $coup->valid_status = false;              
        	        }
    		    }
    			$restaurant->promotions     = $this->home->getPromotions($restaurant_id);
    			foreach($restaurant->promotions as $pro)
		         {
		            if($date>=$pro->start_date)
        	        {
        	            $start_date  = true;
        	        }
        	        else
        	        {
        	            $start_date  = false;
        	        }
        	        
        	        if($date<=$pro->end_date)
        	        {
        	            $end_date  = true;
        	        }
        	        else
        	        {
        	            $end_date  = false;
        	        }
        	        
        	        if($start_date && $end_date)
        	        {  
        	            $pro->valid_status = true;
        	        }
        	        else
        	        {
        	           $pro->valid_status = false;              
        	        }
		         }
    			
    			$header = $this->input->get_request_header('Authorization');
        	    if (count(explode(' ', $header)) > 1)
        	    {
        			$user_id  = $this->decodeToken($header);
        			$c_check  = $this->restaurant->getRestCategories($restaurant_id);
            		if($c_check->num_rows()>0)
            		{
            		    $categories  = $c_check->result();
            		    foreach($categories as $cat)
            		    {
            		       $p_check  = $this->restaurant->getRestProductsByMenu($cat->menu_id);
            		       if($p_check->num_rows()>0)
            		       {
            		           $cat->products = $p_check->result();
            		           foreach($cat->products as $product)
                    		    {
                    		      $product->price          = $this->products->get_smallest_price($product->p_id);  
                    		      $product->available_days = $this->restaurant->getDays($product->p_id);
                    		      $fav_check               = $this->Common->get_details('favourites',array('product_id'=>$product->p_id,'user_id'=>$user_id));
                    		      if($fav_check->num_rows()>0)
                    		      {
                    		          $product->fav_status = true;
                    		          $product->fav_id     = $fav_check->row()->fav_id;
                    		      }
                    		      else
                    		      {
                    		          $product->fav_status = false;
                    		          $product->fav_id     = '0';
                    		      }
                    		      $offerCheck = $this->restaurant->checkProductOffer($product->p_id,$date);
                    		      if($offerCheck->num_rows()>0)
                    		      {
                    		          $offer                     = $offerCheck->row();
                    		          $percentage                = $offer->percentage;
                    		          $price                     = $product->price*$percentage/100;
                    		          $product->offer_price      = number_format($product->price-$price,'2');
                    		          $product->offer_percentage = $percentage;
                    		      }
                    		      else
                    		      {
                    		           $product->offer_price      = '';
                    		           $product->offer_percentage = '';
                    		      }
                    		    }    
            		       }
            		       else
            		       {
            		           $cat->products = array();
            		       }
            		    }
            		}
            		else
            		{
            		    $categories  = array();
            		}
            		
            		
            		 $bestSellingProducts   = $this->restaurant->getBestSellingProducts($restaurant_id);
            		 foreach($bestSellingProducts as $best)
            		 {     
            		      $best->price          = $this->products->get_smallest_price($best->p_id);   
            		      $mostfav_check  = $this->Common->get_details('favourites',array('product_id'=>$best->p_id,'user_id'=>$user_id));
            		      if($mostfav_check->num_rows()>0)
            		      {
            		          $best->fav_status    = true;
            		          $best->fav_id        = $mostfav_check->row()->fav_id;
            		      }
            		      else
            		      {
            		          $best->fav_status    = false;
            		          $best->fav_id        = '0';
            		      }
            		      
            		      $offerCheck = $this->restaurant->checkProductOffer($best->p_id,$date);
            		      if($offerCheck->num_rows()>0)
            		      {
            		          $offer                  = $offerCheck->row();
            		          $percentage             = $offer->percentage;
            		          $price                  = $best->price*$percentage/100;
            		          $best->offer_price      = number_format($best->price-$price,'2');
            		          $best->offer_percentage = $percentage;
            		      }
            		      else
            		      {
            		           $best->offer_price      = '';
            		           $best->offer_percentage = '';
            		      }
            		 }
        	    }
        	    else
        	    {
    	            $c_check  = $this->restaurant->getRestCategories($restaurant_id);
            		if($c_check->num_rows()>0)
            		{
            		    $categories  = $c_check->result();
            		    foreach($categories as $cat)
            		    {
            		       $p_check  = $this->restaurant->getRestProductsByMenu($cat->menu_id);
            		       if($p_check->num_rows()>0)
            		       {
            		           $cat->products = $p_check->result();
            		           foreach($cat->products as $product)
                    		   {
                    		      $product->price          = $this->products->get_smallest_price($product->p_id);  
                    		      $product->available_days = $this->restaurant->getDays($product->p_id);
                    		      $product->fav_status     = false;
                    		      $product->fav_id         = '0';
                    		      $offerCheck = $this->restaurant->checkProductOffer($product->p_id,$date);
                    		      if($offerCheck->num_rows()>0)
                    		      {
                    		          $offer      = $offerCheck->row();
                    		          $percentage = $offer->percentage;
                    		          $price      = $product->price*$percentage/100;
                    		          $product->offer_price      = number_format($product->price-$price,'2');
                    		          $product->offer_percentage = $percentage;
                    		      }
                    		      else
                    		      {
                    		           $product->offer_price     = '';
                    		           $product->offer_percentage= '';
                    		      }
                    		    }    
            		       }
            		       else
            		       {
            		           $cat->products = array();
            		       }
            		    }
            		}
            		else
            		{
            		    $categories  = array();
            		}
            		
            		 $bestSellingProducts   = $this->restaurant->getBestSellingProducts($restaurant_id);
            		 foreach($bestSellingProducts as $best)
            		 {    
            		      $best->price         = $this->products->get_smallest_price($best->p_id); 
            		      $best->fav_status    = false;
            		      $best->fav_id        = '0';
            		      $offerCheck = $this->restaurant->checkProductOffer($best->p_id,$date);
            		      if($offerCheck->num_rows()>0)
            		      {
            		          $offer      = $offerCheck->row();
            		          $percentage = $offer->percentage;
            		          $price      = $best->price*$percentage/100;
            		          $best->offer_price      = number_format($best->price-$price,'2');
            		          $best->offer_percentage = $percentage;
            		      }
            		      else
            		      {
            		           $best->offer_price     = '';
            		           $best->offer_percentage= '';
            		      }
            		 }
        	    }
		    }
		    else
		    {
		        $details          = $check->row();
		        $branch           = $this->Common->get_details('branches',array('b_id'=>$branch_id))->row();
		        $restaurant       = [
		                                'r_id'         => $details->r_id,
		                                'branch_id'    => $branch_id,
		                                'rest_name'    => $details->rest_name,
		                                'rest_email'   => $branch->email,
		                                'rest_phone'   => $branch->phone,
		                                'rest_image'   => $details->rest_image,
		                                'cover_image'  => $details->cover_image,
		                                'latitude'     => $branch->latitude,
		                                'longitude'    => $branch->longitude,
		                                'address1'     => $branch->address,
		                                'landmark'     => $branch->location,
		                                'open_time'    => date('h:i A',strtotime($details->open_time)),
		                                'close_time'   => date('h:i A',strtotime($details->close_time)),
		                                'delivery_time'   => '30',
		                                'min_order'       => $details->min_order,
		                                'service_charge'  =>$details->service_charge,
		                                'delivery_charge' => $details->delivery_charge,
		                                'city'            => $details->city
		                            ];
	            $restaurant['reviews']      = $this->Common->get_details('restaurant_reviews',array('r_id'=>$restaurant_id))->num_rows();
    		    $rating_check               = $this->Common->get_details('restaurant_reviews',array('r_id'=>$restaurant_id));
			    if($rating_check->num_rows()>0)
			    {
			        $rate_count             = $rating_check->num_rows();
			        $rating                 = $this->restaurant->getRatingSum($restaurant_id);
			        $restaurant['ratings']  = number_format($rating/$rate_count,'1');
			    }
			    else
			    {
			        $restaurant['ratings']  = '0'; 
			    }
    		    $restaurant['delivery_fee'] = '0';
    		    $restaurant['sales_tax']    = '0';
    		    $restaurant['types']        = $this->restaurant->getTypes($restaurant_id);
    		    
    		    $coupons                    = $this->home->getCoupons($restaurant_id);
    		    foreach($coupons as $coup)
    		    {
    		        if($coup->start_time!='00:00:00')
        	        {   
        	            $c_start  = $coup->start_date.' '.$coup->start_time;
        	            if($current>=$c_start)
            	        {
            	            $start_date = true;
            	        }
            	        else
            	        {
            	            $start_date = false;
            	        }
        	        }
        	        else
        	        {
        	            if($date>=$coup->start_date)
            	        {
            	            $start_date  = true;
            	        }
            	        else
            	        {
            	            $start_date  = false;
            	        }
        	        }
        	        
        	        
        	        if($coup->end_time!='00:00:00')
        	        {  
        	            $c_end  = $coup->end_date.' '.$coup->end_time;
            	        if($current<=$c_end)
            	        {
            	            $end_date  = true;
            	        }
            	        else
            	        {
            	            $end_date  = false;
            	        }
        	        }
        	        else
        	        {
        	            if($date<=$coup->end_date)
            	        {
            	            $end_date  = true;
            	        }
            	        else
            	        {
            	            $end_date  = false;
            	        }
        	        }
        	        
        	        if($start_date && $end_date)
        	        {  
        	            $coup->valid_status = true;
        	        }
        	        else
        	        {
        	           $coup->valid_status = false;              
        	        }
    		    }
    		    
    		    $promotions                 = $this->home->getPromotions($restaurant_id);
    		    foreach($promotions as $pro)
		         {
		            if($date>=$pro->start_date)
        	        {
        	            $start_date  = true;
        	        }
        	        else
        	        {
        	            $start_date  = false;
        	        }
        	        
        	        if($date<=$pro->end_date)
        	        {
        	            $end_date  = true;
        	        }
        	        else
        	        {
        	            $end_date  = false;
        	        }
        	        
        	        if($start_date && $end_date)
        	        {  
        	            $pro->valid_status = true;
        	        }
        	        else
        	        {
        	           $pro->valid_status = false;              
        	        }
		         }
    		    
    		    $restaurant['coupons']      = $coupons;
    			$restaurant['promotions']   = $promotions;
    			
    			$header = $this->input->get_request_header('Authorization');
        	    if (count(explode(' ', $header)) > 1)
        	    {
        			$user_id  = $this->decodeToken($header);
        			$c_check  = $this->restaurant->getRestCategories($restaurant_id);
            		if($c_check->num_rows()>0)
            		{
            		    $categories  = $c_check->result();
            		    foreach($categories as $cat)
            		    {
            		      // $p_check  = $this->Common->get_details('products',array('cat_id'=>$cat->menu_id,'status'=>'active'));
            		      $p_check     = $this->restaurant->getBranchProducts($cat->menu_id,$branch_id);
            		       if($p_check->num_rows()>0)
            		       {
            		           $cat->products = $p_check->result();
            		           foreach($cat->products as $product)
                    		    {
                    		      $product->price          = $this->products->get_smallest_price($product->p_id);  
                    		      $product->available_days = $this->restaurant->getDays($product->p_id);
                    		      $fav_check               = $this->Common->get_details('favourites',array('product_id'=>$product->p_id,'user_id'=>$user_id));
                    		      if($fav_check->num_rows()>0)
                    		      {
                    		          $product->fav_status = true;
                    		          $product->fav_id     = $fav_check->row()->fav_id;
                    		      }
                    		      else
                    		      {
                    		          $product->fav_status = false;
                    		          $product->fav_id     = '0';
                    		      }
                    		      $offerCheck = $this->restaurant->checkProductOffer($product->p_id,$date);
                    		      if($offerCheck->num_rows()>0)
                    		      {
                    		          $offer                     = $offerCheck->row();
                    		          $percentage                = $offer->percentage;
                    		          $price                     = $product->price*$percentage/100;
                    		          $product->offer_price      = number_format($product->price-$price,'2');
                    		          $product->offer_percentage = $percentage;
                    		      }
                    		      else
                    		      {
                    		           $product->offer_price      = '';
                    		           $product->offer_percentage = '';
                    		      }
                    		    }    
            		       }
            		       else
            		       {
            		           $cat->products = array();
            		       }
            		    }
            		}
            		else
            		{
            		    $categories  = array();
            		}
            		
            		
            		 $bestSellingProducts   = $this->restaurant->getBestSellingProducts($restaurant_id);
            		 foreach($bestSellingProducts as $best)
            		 {     
            		      $best->price          = $this->products->get_smallest_price($best->p_id);   
            		      $mostfav_check        = $this->Common->get_details('favourites',array('product_id'=>$best->p_id,'user_id'=>$user_id));
            		      if($mostfav_check->num_rows()>0)
            		      {
            		          $best->fav_status    = true;
            		          $best->fav_id        = $mostfav_check->row()->fav_id;
            		      }
            		      else
            		      {
            		          $best->fav_status    = false;
            		          $best->fav_id        = '0';
            		      }
            		      
            		      $offerCheck = $this->restaurant->checkProductOffer($best->p_id,$date);
            		      if($offerCheck->num_rows()>0)
            		      {
            		          $offer                  = $offerCheck->row();
            		          $percentage             = $offer->percentage;
            		          $price                  = $best->price*$percentage/100;
            		          $best->offer_price      = number_format($best->price-$price,'2');
            		          $best->offer_percentage = $percentage;
            		      }
            		      else
            		      {
            		           $best->offer_price      = '';
            		           $best->offer_percentage = '';
            		      }
            		 }
        	    }
        	    else
        	    {
    	            $c_check  = $this->restaurant->getRestCategories($restaurant_id);
            		if($c_check->num_rows()>0)
            		{
            		    $categories  = $c_check->result();
            		    foreach($categories as $cat)
            		    {
            		       $p_check     = $this->restaurant->getBranchProducts($cat->menu_id,$branch_id);
            		       if($p_check->num_rows()>0)
            		       {
            		           $cat->products = $p_check->result();
            		           foreach($cat->products as $product)
                    		    {
                    		      $product->price          = $this->products->get_smallest_price($product->p_id);  
                    		      $product->available_days = $this->restaurant->getDays($product->p_id);
                    		      $product->fav_status     = false;
                    		      $product->fav_id         = '0';
                    		      $offerCheck              = $this->restaurant->checkProductOffer($product->p_id,$date);
                    		      if($offerCheck->num_rows()>0)
                    		      {
                    		          $offer                     = $offerCheck->row();
                    		          $percentage                = $offer->percentage;
                    		          $price                     = $product->price*$percentage/100;
                    		          $product->offer_price      = number_format($product->price-$price,'2');
                    		          $product->offer_percentage = $percentage;
                    		      }
                    		      else
                    		      {
                    		           $product->offer_price     = '';
                    		           $product->offer_percentage= '';
                    		      }
                    		    }    
            		       }
            		       else
            		       {
            		           $cat->products = array();
            		       }
            		    }
            		}
            		else
            		{
            		    $categories  = array();
            		}
            		
            		 $bestSellingProducts   = $this->restaurant->getBestSellingProducts($restaurant_id);
            		 foreach($bestSellingProducts as $best)
            		 {    
            		      $best->price         = $this->products->get_smallest_price($best->p_id); 
            		      $best->fav_status    = false;
            		      $best->fav_id        = '0';
            		      $offerCheck = $this->restaurant->checkProductOffer($best->p_id,$date);
            		      if($offerCheck->num_rows()>0)
            		      {
            		          $offer      = $offerCheck->row();
            		          $percentage = $offer->percentage;
            		          $price      = $best->price*$percentage/100;
            		          $best->offer_price      = number_format($best->price-$price,'2');
            		          $best->offer_percentage = $percentage;
            		      }
            		      else
            		      {
            		           $best->offer_price     = '';
            		           $best->offer_percentage= '';
            		      }
            		 }
        	    }
		    }
		    
    	     $best_selling          = [
    	                                'menu_id'  => '0',
    	                                'r_id'     => $restaurant_id,
    	                                'name'     => 'Most Selling',
    	                                'status'   => '1',
    	                                'products' => $bestSellingProducts
    	                              ];
    	                             
		    $this->response(array(
                		              "status"  => true,
                		              "message" => "Success",
                		              'data'    => [
                                                      'restaurant'   => $restaurant,
                                                      'category'     => $categories,
                                                      'best_selling' => $best_selling
                                                   ]
                		            ), REST_Controller::HTTP_OK);                              
		}
		else
		{
		    $this->response(array(
                    		              "status"  => false,
                    		              "message" => "Failed"
                    		            ), REST_Controller::HTTP_NOT_FOUND);
		}
       
	}

//**************************************** CATEGORIES ****************************************************************************************************************************//	
	public function categories_post()
	{
	    $restaurant_id   = $this->security->xss_clean($this->input->post('restaurant_id'));
		$check           = $this->Common->get_details('menu',array('r_id'=>$restaurant_id));
		if($check->num_rows()>0)
		{
		    $categories  = $check->result();
		}
		else
		{
		    $categories  = array();
		}
       
		$this->response(array(
            		              "status"  => true,
            		              "message" => "Success",
            		              'data'    => $categories
            		            ), REST_Controller::HTTP_OK);        
	}

//*************************************** PRODUCTS ********************************************************************************************************************************//	
	public function products_post()
	{
	    $cat_id          = $this->security->xss_clean($this->input->post('category_id'));
		$check           = $this->Common->get_details('products',array('cat_id'=>$cat_id));
		if($check->num_rows()>0)
		{
		    $products   = $check->result();
		    foreach($products as $product)
		    {
		      $product->images         = '';  
		      $product->available_days = $this->restaurant->getDays($product->p_id);
		    }    
		}
		else
		{
		    $products  = array();
		}
        
		$this->response(array(
            		              "status"  => true,
            		              "message" => "Success",
            		              'data'    => $products
            		            ), REST_Controller::HTTP_OK);        
	}

//********************************************* GET CATEGORIES *******************************************************************************************************************//	
	public function getCategories_post()
	{
	    $restaurant_id   = $this->security->xss_clean($this->input->post('restaurant_id'));
		$check           = $this->Common->get_details('menu',array('r_id'=>$restaurant_id));
		if($check->num_rows()>0)
		{
		    $categories  = $check->result();
		    foreach($categories as $cat)
		    {
		       $p_check  = $this->Common->get_details('products',array('cat_id'=>$cat->menu_id,'status'=>'active'));
		       if($p_check->num_rows()>0)
		       {
		           $cat->products = $p_check->num_rows();
		       }
		       else
		       {
		           $cat->products = '0';
		       }
		    }
		}
		else
		{
		    $categories  = array();
		}
        $this->response(array(
            		              "status"  => true,
            		              "message" => "Success",
            		              'data'    => $categories
            		            ), REST_Controller::HTTP_OK); 
	}

//************************************************* GET CATEGORY PRODUCTS ********************************************************************************************************//    
    public function getCategoryProducts_post()
	{   
	    date_default_timezone_set('Asia/Kolkata');
		$date       = date('Y-m-d');
	    $time       = date('H:i:s');
	    $current    = date('Y-m-d H:i:s');
		
	    $restaurant_id   = $this->security->xss_clean($this->input->post('restaurant_id'));
		$check           = $this->Common->get_details('menu',array('r_id'=>$restaurant_id));
		if($check->num_rows()>0)
		{
		    $categories  = $check->result();
		    foreach($categories as $cat)
		    {
		       $p_check  = $this->Common->get_details('products',array('cat_id'=>$cat->menu_id,'status'=>'active'));
		       if($p_check->num_rows()>0)
		       {
		           $cat->products = $p_check->result();
		           foreach($cat->products as $product)
        		    {
        		      $product->available_days = $this->restaurant->getDays($product->p_id);
        		      $offerCheck = $this->restaurant->checkProductOffer($product->p_id,$date);
        		      if($offerCheck->num_rows()>0)
        		      {
        		          $offer      = $offerCheck->row();
        		          $percentage = $offer->percentage;
        		          $price      = $product->price*$percentage/100;
        		          $product->offer_price      = number_format($product->price-$price,'2');
        		          $product->offer_percentage = $percentage;
        		      }
        		      else
        		      {
        		           $product->offer_price     = '';
        		           $product->offer_percentage= '';
        		      }
        		    }    
		       }
		       else
		       {
		           $cat->products = array();
		       }
		    }
		    
		   
		}
		else
		{
		    $categories  = array();
		}
		
		 $bestSellingProducts   = $this->restaurant->getBestSellingProducts($restaurant_id);
		 foreach($bestSellingProducts as $best)
		 {
		      $offerCheck = $this->restaurant->checkProductOffer($best->p_id,$date);
		      if($offerCheck->num_rows()>0)
		      {
		          $offer      = $offerCheck->row();
		          $percentage = $offer->percentage;
		          $price      = $best->price*$percentage/100;
		          $best->offer_price      = number_format($best->price-$price,'2');
		          $best->offer_percentage = $percentage;
		      }
		      else
		      {
		           $best->offer_price     = '';
		           $best->offer_percentage= '';
		      }
		 }
	     $best_selling          = [
	                                'menu_id'  => '0',
	                                'r_id'     => $restaurant_id,
	                                'name'     => 'Most Selling',
	                                'status'   => '1',
	                                'products' => $bestSellingProducts
	                             ];
		        
	    $this->response(array(
            		              "status"  => true,
            		              "message" => "Success",
            		              'data'    => [
                                                  'category'     => $categories,
                                                  'best_selling' => $best_selling
                                               ]
            		            ), REST_Controller::HTTP_OK); 
	}

//******************************************** DECODE TOKEN **********************************************************************************************************************//	
    public function decodeToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h7';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}

//******************************************************************* GET DRIVING DISTANCE ************************************************************************//	
	function GetDrivingDistance($lat1, $lat2, $long1,$long2)
    {
        $url = "https://maps.googleapis.com/maps/api/distancematrix/json?origins=".$lat1.",".$long1."&destinations=".$lat2."%2C".$long2."&mode=driving&language=pl-PL&key=AIzaSyBCN42iAP4i3_QUcP9HRALRmCuZtA1iLEM";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_PROXYPORT, 3128);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        $response = curl_exec($ch);
        curl_close($ch);
        $response_a = json_decode($response, true);
        $dist = $response_a['rows'][0]['elements'][0]['distance']['text'];
        $time = $response_a['rows'][0]['elements'][0]['duration']['text'];
    
        return array('distance' => $dist, 'time' => $time);
        // return $response_a;
    }	
	
}
?>
