<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Register extends REST_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->model('Common');
	}
	
    public function index_post()
	{   
	    date_default_timezone_set("Asia/Calcutta");
	    $timestamp = date('Y-m-d H:i:s');
	    
		$emailCheck  = true;
		$mobileCheck = true;

		$firstname= $this->security->xss_clean($this->input->post('firstname'));
		$lastname = $this->security->xss_clean($this->input->post('lastname'));
		$email    = $this->security->xss_clean($this->input->post('email'));
		$password = $this->security->xss_clean($this->input->post('password'));
		$mobile   = $this->security->xss_clean($this->input->post('mobile'));
		$fcm      = $this->security->xss_clean($this->input->post('fcm'));
		$uid      = $this->security->xss_clean($this->input->post('uid'));
        $auth     = $this->getKey();
        
        $data     =  [
            			'firstname'        => $firstname,
            			'lastname'         => $lastname,
            			'password'         => md5($password),
            			'mobile'           => $mobile,
            			'email'            => $email,
            			'status'           => '1',
            			'auth'             => $auth,
            			'date'             => date('Y-m-d'),
            			'fcm'              => $fcm,
            			'uid'              => $uid,
            			'timestamp'        => $timestamp
    		         ];

		$checkMobile = $this->Common->get_details('users',array('mobile' => $mobile))->num_rows();
		$checkEmail  = $this->Common->get_details('users',array('email' => $email))->num_rows();
		if ( $checkMobile > 0 ) 
		{
			$mobileCheck = false;
		}
		if ( $checkEmail > 0 ) 
		{
			$emailCheck = false;
		}
		if($mobileCheck && $emailCheck)
		{
		    if ($id = $this->Common->insert('users',$data)) 
		    {
		        	$guest_check     = $this->Common->get_details('guest',array('token'=>$uid));
                    if($guest_check->num_rows()>0)
                    {
                         $guest_id       = $guest_check->row()->guest_id;
        			     $check_guestcart= $this->Common->get_details('guest_cart',array('guest_id'=>$guest_id));
        			     if($check_guestcart->num_rows()>0)
        			     {
        			        $guest_cart = $check_guestcart->result();
        			        foreach($guest_cart as $cart)
        			        {
        			             $cart_array = [
            			                         'user_id'      => $id,
            			                         'r_id'         => $cart->r_id,
            			                         'branch_id'    => $cart->branch_id,
            			                         'type'         => $cart->type,
            			                         'product_id'   => $cart->product_id,
            			                         'price_id'     => $cart->price_id,
            			                         'quantity'     => $cart->quantity,
            			                         'date'         => $cart->date,
            			                         'time'         => $cart->time
            			                      ];
        			             if($cartid=$this->Common->insert('cart',$cart_array))
        			             {
        			                 $subcart_check = $this->Common->get_details('guest_sub_cart',array('gcart_id'=>$cart->gcart_id))->result();
        			                 foreach($subcart_check as $sub)
        			                 {
        			                     $sub_array  =  [
        			                                       'cart_id'     => $cartid,
        			                                       'product_id'  => $sub->product_id,
        			                                       'price_id'    => $sub->price_id,
        			                                       'cat_id'      => $sub->cat_id,
        			                                       'val_id'      => $sub->val_id,
        			                                       'quantity'    => $sub->quantity
        			                                    ];
        			                    $this->Common->insert('sub_cart',$sub_array);                   
        			                 }
        			             }
        			        }
          			     }
        			}

                	 $this->response(array(
                        		              "status" => 1,
                        		              "message" => "Successfully registered",
                        		              'data'    => [
                            				                  'user_id'    => $id,
                            				                  'first_name' => $firstname,
                            				                  'lastname'   => $lastname,
                            				                  'email'      => $email,
                            				                  'phone'      => $mobile,
                            				                  'token'      => $this->generateToken($id)
                            				                ]
                        		            ), REST_Controller::HTTP_OK);			
			}
			else 
			{
				$this->response(array(
		              "status" => 0,
		              "message" => "Failed to register",
		              "data"    => ''
		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
			}
		}
		else 
		{
			    if (!$mobileCheck && !$emailCheck) 
			    {
					$message = 'Mobile number and Email address already registered';
				}
				else 
				{
					if (!$mobileCheck) 
					{
						$message = 'Mobile number already registered';
					}
					else 
					{
						$message = 'Email address already registered';
					}
				}
				$this->response(array(
                        	              "status" => 0,
                        	              "message" => $message,
                        	              "data"  => ''
                        	            ), REST_Controller::HTTP_CONFLICT);
		}
	}
	
	function getKey() 
	{
        while (true) {
            $key = $this->key();
            $cond = ['auth' => $key];
            $check = $this->Common->get_details('users', $cond);
            if ($check->num_rows() == 0) {
                break;
            }
        }
        return $key;
    }
    function key() {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0;$i < 20;$i++) {
            $randomString.= $characters[rand(0, $charactersLength - 1) ];
        }
        return $randomString;
    }
    
//********************************************** GENERATE TOKEN ********************************************************************************************************************//    
    public function generateToken($user_id)
	{
		$key    = 'fA5eKhl2TNiG3vGxXvMScg';
        $secret = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h7';
        $token  = array(
                           "iss" => $key,
				           "id"  => $user_id,
                       );
        $tok = JWT::encode( $token, $secret );
		return $tok;
	}

//*********************************************** DECODE TOKEN ***********************************************************************************************************************//	
	public function decodeGuestToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'umM6RFZZVWxNyKFlVD2EUdxl4Rxn9ym5S6i8';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}

}
