<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Rating extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('android/M_ratings','rating');
        $this->load->model('Common');
	}
	
	public function addRating_post()
	{
	    $token           = $this->security->xss_clean($this->input->post('device_token'));
	    $restaurant_id   = $this->security->xss_clean($this->input->post('restaurant_id'));
// 		$ratings         = $this->security->xss_clean($this->input->post('ratings'));
		$order_packing   = $this->security->xss_clean($this->input->post('order_packing'));
		$quality_of_food = $this->security->xss_clean($this->input->post('quality_of_food'));
		$delivery_time   = $this->security->xss_clean($this->input->post('delivery_time'));
		$value_for_money = $this->security->xss_clean($this->input->post('value_for_money'));
		$comments        = $this->security->xss_clean($this->input->post('comment'));
		$rating          = $order_packing+$quality_of_food+$delivery_time+$value_for_money;
		$total_rating    = $rating/4;
		
		date_default_timezone_set('Asia/Bahrain');
        $timestamp = date('Y-m-d H:i:s');
        
		$header = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
    		   $check      = $this->Common->get_details('orders',array('user_id'=>$user_id,'r_id'=>$restaurant_id,'type'=>'user'));
               if($check->num_rows()>0)
               {
    	            $review_check = $this->Common->get_details('restaurant_reviews',array('r_id'=>$restaurant_id,'user_id'=>$user_id));
    	            if($review_check->num_rows()>0)
    	            {   
    	                $rate_id = $review_check->row()->rr_id;
    	                $array   = [
        	                           'order_packing'  => $order_packing,
        	                           'quality_of_food'=> $quality_of_food,
        	                           'delivery_time'  => $delivery_time,
        	                           'value_for_money'=> $value_for_money,
        							   'rating'         => $total_rating,
        							   'comments'       => $comments,
        							   'type'           => 'user',
        							   'date'           => date('Y-m-d'),
        							   'time'           => date('h:i A'),
        							   'timestamp'      => $timestamp
    							    ];
    				    $this->Common->update('rr_id',$rate_id,'restaurant_reviews',$array);
    				    
    				    $title1     = 'New Rating added!...';
                        $body1      = 'Your have a new rating& review!....';
                        $restaurant = $this->Common->get_details('restaurants',array('r_id'=>$restaurant_id))->row();
                        $rest_fcm   = $restaurant->fcm;
                        $this->sendRestaurantNotification($title1,$body1,$rest_fcm);
                        
    	            	$this->response(array(
                    		                    "status"  => true,
                    		                    "message" => "Review updated successfully",
                    		                  ), REST_Controller::HTTP_OK);   
    	            }
    	            else
    	            {
                        $array  = [
                        	          'user_id'         => $user_id,
                        	          'r_id'            => $restaurant_id,
                        	          'order_packing'   => $order_packing,
    	                              'quality_of_food' => $quality_of_food,
    	                              'delivery_time'   => $delivery_time,
    	                              'value_for_money' => $value_for_money,
                        	          'rating'          => $total_rating,
                        	          'comments'        => $comments,
                        	          'type'            => 'user',
                        	          'date'            => date('Y-m-d'),
                        	          'time'            => date('h:i A'),
                        	          'timestamp'       => $timestamp
                                  ];
                        $this->Common->insert('restaurant_reviews',$array);
                        
                        $title1     = 'New Rating added!...';
                        $body1      = 'Your have a new rating& review!....';
                        $restaurant = $this->Common->get_details('restaurants',array('r_id'=>$restaurant_id))->row();
                        $rest_fcm   = $restaurant->fcm;
                        $this->sendRestaurantNotification($title1,$body1,$rest_fcm);
    
                    	$this->response(array(
                    		              "status"  => true,
                    		              "message" => "Review added successfully",
                    		            ), REST_Controller::HTTP_OK);      
    	            }
               }
    		   else
    		   {
    		      $this->response(array(
                        		              "status" => false,
                        		              "message" => "Sorry! You are not allowed to review this restaurant since you havent't bought anything from here..."
                        		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);	            
    		   }
    		}
    		else 
    		{
    			  $this->response(array(
                        			     "status"  => false,
                        			     "message" => "Your session has expired, please login again"
                        			   ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	        $guest_check      = $this->Common->get_details('guest',array('token'=>$token));
	        if($guest_check->num_rows()>0)
	        {
               $check      = $this->Common->get_details('orders',array('user_id'=>$guest_check->row()->guest_id,'r_id'=>$restaurant_id,'type'=>'guest'));
               if($check->num_rows()>0)
               {
    	            $review_check = $this->Common->get_details('restaurant_reviews',array('r_id'=>$restaurant_id,'user_id'=>$guest_check->row()->guest_id,'type'=>'guest'));
    	            if($review_check->num_rows()>0)
    	            {   
    	                $rate_id = $review_check->row()->rr_id;
    	                $array   = [
        	                           'order_packing'   => $order_packing,
        	                           'quality_of_food' => $quality_of_food,
        	                           'delivery_time'   => $delivery_time,
        	                           'value_for_money' => $value_for_money,
        							   'rating'          => $total_rating,
        							   'comments'        => $comments,
        							   'type'            => 'guest',
        							   'date'            => date('Y-m-d'),
                        	           'time'            => date('h:i A'),
        							   'timestamp'       => $timestamp
    							    ];
    				    $this->Common->update('rr_id',$rate_id,'restaurant_reviews',$array);
    				    
    				    $title1     = 'New Rating added!...';
                        $body1      = 'Your have a new rating& review!....';
                        $restaurant = $this->Common->get_details('restaurants',array('r_id'=>$restaurant_id))->row();
                        $rest_fcm   = $restaurant->fcm;
                        $this->sendRestaurantNotification($title1,$body1,$rest_fcm);
                        
    	            	$this->response(array(
                    		                    "status"  => true,
                    		                    "message" => "Review updated successfully",
                    		                  ), REST_Controller::HTTP_OK);   
    	            }
    	            else
    	            {
                        $array  = [
                        	          'user_id'         => $guest_check->row()->guest_id,
                        	          'r_id'            => $restaurant_id,
                        	          'order_packing'   => $order_packing,
    	                              'quality_of_food' => $quality_of_food,
    	                              'delivery_time'   => $delivery_time,
    	                              'value_for_money' => $value_for_money,
                        	          'rating'          => $total_rating,
                        	          'comments'        => $comments,
                        	          'type'            => 'guest',
                        	          'date'            => date('Y-m-d'),
                        	          'time'            => date('h:i A'),
                        	          'timestamp'       => $timestamp
                                  ];
                        $this->Common->insert('restaurant_reviews',$array);
                        
                        $title1     = 'New Rating added!...';
                        $body1      = 'Your have a new rating& review!....';
                        $restaurant = $this->Common->get_details('restaurants',array('r_id'=>$restaurant_id))->row();
                        $rest_fcm   = $restaurant->fcm;
                        $this->sendRestaurantNotification($title1,$body1,$rest_fcm);
    
                    	$this->response(array(
                    		              "status"  => true,
                    		              "message" => "Review added successfully",
                    		            ), REST_Controller::HTTP_OK);      
    	            }
               }
    		   else
    		   {
    		      $this->response(array(
                        		              "status" => false,
                        		              "message" => "Sorry! You are not allowed to review this restaurant since you havent't bought anything from here..."
                        		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);	            
    		   }
	        }
	        else
	        {
	            $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
	        }
	    }
	}
	
	public function getRatings_post()
	{
		$restaurant_id    = $this->security->xss_clean($this->input->post('restaurant_id'));
		$ratings          = $this->Common->get_details('restaurant_reviews',array('r_id'=>$restaurant_id));
        $ratings_no       = $ratings->num_rows(); 
        $restaurant       = $this->Common->get_details('restaurants',array('r_id'=>$restaurant_id))->row();
        $restaurant_name  = $restaurant->rest_name;
        $restaurant_image = $restaurant->cover_image;
        if($ratings->num_rows()>0)    
        {   
        	$rating                   = $this->rating->getTotalRating($restaurant_id);
        	$reviews                  = $this->rating->getReviews($restaurant_id);
        	$total_ratings            = $rating/$ratings_no;
        	
        	$order_package            = $this->rating->getOrderRating($restaurant_id);
        	$order_rating             = $order_package/$ratings_no;
        	
        	$food_quality             = $this->rating->getFoodRating($restaurant_id);
        	$food_rating              = $food_quality/$ratings_no;
        	
        	$delivery_time            = $this->rating->getDeliveryRating($restaurant_id);
        	$delivery_rating          = $delivery_time/$ratings_no;
        	
        	$value_for_money          = $this->rating->getValueRating($restaurant_id);
        	$value_rating             = $value_for_money/$ratings_no;
        }  
        else
        {
        	$total_ratings            = '0';
        	$order_rating             = '0';
        	$food_rating              = '0';
        	$delivery_rating          = '0';
        	$value_rating             = '0';
        	
            $reviews                  = array();
        }
        
         $this->response(array(
            		              "status"  => true,
            					  "data"    => [
                                                   'restaurant_id'          => $restaurant_id,
                                                   'restaurant_name'        => $restaurant_name,
                                                   'restaurant_image'       => $restaurant_image,
                                                   'total_ratings'          => number_format($total_ratings,'1'),
                                                   'order_pacaking_rating'  => number_format($order_rating,'1'),
                                                   'food_quality_rating'    => number_format($food_rating,'1'),
                                                   'delivery_time_rating'   => number_format($delivery_rating,'1'),
                                                   'value_for_money_rating' => number_format($value_rating,'1'),
                                                   'total_reviews'          => $reviews
                                                 ],
            		              "message" => "Success"
            		            ), REST_Controller::HTTP_OK);
        
	}
	
	public function decodeToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h7';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}
	
	public function sendRestaurantNotification($title,$body,$fcm)
	{
	    $SERVER_API_KEY = "AAAAKjNFP5M:APA91bG4yMG9c0Y6NGPh2gMQT77gTT9cy-ZenigVrh5RZJfBUxZZZYgynM06KTTFrtxyBoFfjqef2VIfVVFPL-cnhgAgJwbzHWsQvmzShzg9lAXFK8emE6EjVILc99TzYA0f3rrXPgkU";
    	$header = [
    		'Authorization: key='. $SERVER_API_KEY,
    		'Content-Type: Application/json'
    	];
    	$msg = [
    		'title' => $title,
    		'body'  => $body
    	];
    	
    	$notification = [
    		'title'             => $title,
    		'body'              => $body,
    		'content_available' => true
    	];
    	
    	$payload = [
    		'data'         => $msg,
    		'notification' => $notification,
    		'to'           => $fcm,
    		'priority'     => 10
    	];
    	$url = 'https://fcm.googleapis.com/fcm/send';
    
    	$curl = curl_init();
    
    	curl_setopt_array($curl, array(
    		 CURLOPT_URL            => "https://fcm.googleapis.com/fcm/send",
    		 CURLOPT_RETURNTRANSFER => true,
    		 CURLOPT_CUSTOMREQUEST  => "POST",
    		 CURLOPT_POSTFIELDS     => json_encode($payload),
    		 CURLOPT_HTTPHEADER     => $header,
    	));
    
    	$response = curl_exec($curl);
    	$err = curl_error($curl);
    
    	curl_close($curl);
        
        return true;
	}

}
?>
