<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Promotions extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_products','products');
		$this->load->model('android/M_restaurant','restaurant');
		$this->load->model('android/M_guest','guest');
	}

//****************************************************** DETAILS ***************************************************************************************************//
	public function details_post()
	{   
	    date_default_timezone_set('Asia/Kolkata');
		$date       = date('Y-m-d');
	    $time       = date('H:i:s');
	    $current    = date('Y-m-d H:i:s');
	    
        $promo_id   = $this->security->xss_clean($this->input->post('promotion_id'));

        $promotion  = $this->Common->get_details('promotions',array('pr_id'=>$promo_id))->row();
        $restaurant = $this->Common->get_details('restaurants',array('r_id'=>$promotion->r_id))->row();
        $promotion->rest_name       = $restaurant->rest_name;
        $promotion->selection_list  = $this->Common->get_details('promotion_selection_list',array('promo_id'=>$promo_id))->result();
        foreach($promotion->selection_list as $list)
        {
            $category_check = $this->Common->get_details('promotion_category',array('pcat_id'=>$list->cat_id));
            if($category_check->num_rows()>0)
            {
                $category       = $category_check->row(); 
                $list->cat_name = $category->cat_name;
            }
            else
            {
                $list->cat_name = '';
            }
            $list->products = $this->Common->get_details('promotion_products',array('promo_id'=>$promo_id,'cat_id'=>$list->cat_id))->result();
            foreach($list->products as $product)
            {
                $product_details  = $this->Common->get_details('products',array('p_id'=>$product->product_id))->row();
                $price_details    = $this->Common->get_details('product_price',array('price_id'=>$product->price_id))->row();
                $product->name    = $product_details->name;
                $product->image   = $product_details->cover_image;
                $product->itemcode= $product_details->item_code;
                $product->price   = $price_details->price;
                $product->unit    = $price_details->unit;
            }
        }
		$this->response(array(
            		              "status"  => true,
            		              "message" => "Success",
            					  'data'    => $promotion
            		            ), REST_Controller::HTTP_OK);          
	}

//*************************************************** CHECKOUT ****************************************************************************************************//	
    public function checkout_post()
	{
	    $token          = $this->security->xss_clean($this->input->post('device_token'));
	    $promotion_id   = $this->security->xss_clean($this->input->post('promotion_id'));
		$adrss_id       = $this->security->xss_clean($this->input->post('address_id'));
        $r_id           = $this->security->xss_clean($this->input->post('r_id'));
    	$payment_method = $this->security->xss_clean($this->input->post('payment_method'));
    	$delivery_notes = $this->security->xss_clean($this->input->post('delivery_notes'));
    	$branch_id      = $this->security->xss_clean($this->input->post('branch_id'));
		$products       = $this->security->xss_clean($this->input->post('products'));
		$total          = $this->security->xss_clean($this->input->post('total'));
		$delivery_type  = $this->security->xss_clean($this->input->post('delivery_type'));
        $json           = json_decode($products, true);
        $delivery_charge= $this->security->xss_clean($this->input->post('delivery_charge'));
    	$service_charge = $this->security->xss_clean($this->input->post('service_charge'));
    	$subtotal       = $this->security->xss_clean($this->input->post('subtotal'));
    	$grandtotal     = $this->security->xss_clean($this->input->post('grandtotal'));
        $block_no       = $this->security->xss_clean($this->input->post('block_no'));
        $promotion      = $this->Common->get_details('promotions',array('pr_id'=>$promotion_id))->row();
        $restaurant     = $this->Common->get_details('restaurants',array('r_id'=>$r_id))->row();
        
        $check_block   = $this->Common->get_details('blocks',array('block_name'=>$block_no));
        if($check_block->num_rows()>0)
        {
            $block_id  = $check_block->row()->block_id;
        }
        else
        {
            $block_id = 0;
        }
        
        $delivery_check  = $this->Common->get_details('branch_delivery_blocks',array('block_id'=>$block_id,'branch_id'=>$branch_id));
    	if($delivery_check->num_rows()>0)
    	{        
    	    $header = $this->input->get_request_header('Authorization');
    	    if (count(explode(' ', $header)) > 1)
    	    {
    			$user_id = $this->decodeToken($header);
    			if ($user_id) 
    			{
    			    $address        = $this->Common->get_details('address',array('address_id'=>$adrss_id))->row();
            		$order_array    = [
                        			     'user_id'       => $user_id,
                        			     'r_id'          => $r_id,
                        			     'rest_name'     => $restaurant->rest_name,
                        			     'branch_id'     => $branch_id,
                        			     'ordered_date'  => date('Y-m-d'),
                        			     'ordered_time'  => date('h:i A'),
                        			     'order_type'    => 'normal',
                        			     'payment_method'=> $payment_method,
                        			     'total'         => $grandtotal,
                        			     'offer_type'    => 'promotion',
                        			     'offer_code'    => $promotion->code,
                        			     'type'          => 'user',
                        			     'delivery_type'  => $delivery_type,
                        			     'delivery_charge'=> $delivery_charge,
                        		    	 'service_charge' => $service_charge,
                        			     'subtotal'       => $subtotal,
                        			     'timestamp'      => date('Y-m-d H:i:s')
                        		       ];
                    if($id = $this->Common->insert('orders',$order_array))
    			    {
        			    $elementCount  = count($json);
                        for ($i=0;$i < $elementCount; $i++) 
                        {
                            $pr_name      =  $json[$i]['product_name_english'];
                            $pr_id        =  $json[$i]['product_id'];
                            $p_id         =  $json[$i]['price_id'];
                            $cat_id       =  $json[$i]['cat_id'];
                            $category     = $this->Common->get_details('promotion_selection_list',array('promo_id'=>$promotion_id,'cat_id'=>$cat_id))->row();
                            $quantity     = $category->quantity;
                            $p_price      = $this->Common->get_details('product_price',array('price_id'=>$p_id))->row(); 
                            
                            $value_array  = [    
                                                 'order_id'     => $id,
                                                 'product_id'   => $pr_id,
                                                 'product_name' => $pr_name,
                                                 'price_id'     => $p_id,
                                                 'quantity'     => $quantity,
                                                 'price'        => $p_price->price,
                                                 'total'        => $p_price->price*$quantity
                                             ];
                            $this->Common->insert('ordered_products',$value_array);                
                        }
                        
                        // $address       = $this->Common->get_details('address',array('address_id'=>$adrss_id))->row();
            		    $address_array = [       
            		                             'order_id'   => $id,
            		                             'user_id'    => $user_id,
                                			     'area'       => $address->area,
                                			     'flat'       => $address->flat,
                                			     'building_no'=> $address->building_no,
                                			     'road_no'    => $address->road_no,
                                			     'landmark'   => $address->landmark,
                                			     'block'      => $address->block,
                                			     'mobile'     => $address->mobile,
                                			     'latitude'   => $address->latitude,
                                			     'longitude'  => $address->longitude,
                                			     'type'       => 'user',
                                			     'timestamp'  => date('Y-m-d H:i:s')
            		                     ];
            		    $this->Common->insert('ordered_address',$address_array);
            		    
            		    $this->response(array(
                        		               "status"  => true,
                        		               "message" => "Success",
                        		               'order_id'    => $id
                        		             ), REST_Controller::HTTP_OK);
    			    }
                	else	
            	    {	
            	        $this->response(array(
                        		               "status"      => false,
                        		               "message"     => "Failed",
                        		               'order_id'    => ''
                        		             ), REST_Controller::HTTP_OK);
            	    }
        		}
        		else
        		{
        			$this->response(array(
                            			    "status"  => false,
                            			    "message" => "Your session has expired, please login again"
                            			  ), REST_Controller::HTTP_UNAUTHORIZED);
        		}
    	    }
    	    else
    	    {
    	         $guest_check   = $this->Common->get_details('guest',array('token'=>$token));
    	         if($guest_check->num_rows()>0)
    	         {
    	            $address        = $this->Common->get_details('guest_address',array('ga_id'=>$adrss_id))->row();
            		$order_array    = [
                        			     'user_id'       => $guest_check->row()->guest_id,
                        			     'r_id'          => $r_id,
                        			     'rest_name'     => $restaurant->rest_name,
                        			     'branch_id'     => $branch_id,
                        			     'ordered_date'  => date('Y-m-d'),
                        			     'ordered_time'  => date('h:i A'),
                        			     'order_type'    => 'normal',
                        			     'payment_method'=> $payment_method,
                        			     'total'         => $grandtotal,
                        			     'offer_type'    => 'promotion',
                        			     'offer_code'    => $promotion->code,
                        			     'type'          => 'guest',
                        			     'delivery_type'  => $delivery_type,
                        			     'delivery_charge'=> $delivery_charge,
                        			     'service_charge' => $service_charge,
                        			     'subtotal'       => $subtotal,
                        			     'timestamp'      => date('Y-m-d H:i:s')
                        		       ];
                    if($id = $this->Common->insert('orders',$order_array))
    			    {
        			    $elementCount  = count($json);
                        for ($i=0;$i < $elementCount; $i++) 
                        {
                            $pr_name      =  $json[$i]['product_name_english'];
                            $pr_id        =  $json[$i]['product_id'];
                            $p_id         =  $json[$i]['price_id'];
                            $cat_id       =  $json[$i]['cat_id'];
                            $category     = $this->Common->get_details('promotion_selection_list',array('promo_id'=>$promotion_id,'cat_id'=>$cat_id))->row();
                            $quantity     = $category->quantity;
                            
                            $value_array  = [    
                                                 'order_id'     => $id,
                                                 'product_id'   => $pr_id,
                                                 'product_name' => $pr_name,
                                                 'price_id'     => $p_id,
                                                 'quantity'     => $quantity,
                                                 'price'        => '0',
                                                 'total'        => '0'
                                             ];
                            $this->Common->insert('ordered_products',$value_array);                
                        }
                        
            		    $address_array = [       
            		                             'order_id'   => $id,
            		                             'user_id'    => $guest_check->row()->guest_id,
            		                             'name'       => $address->name,
                                			     'area'       => $address->area,
                                			     'flat'       => $address->flat,
                                			     'building_no'=> $address->building_no,
                                			     'road_no'    => $address->road_no,
                                			     'landmark'   => $address->landmark,
                                			     'block'      => $address->block,
                                			     'mobile'     => $address->mobile,
                                			     'latitude'   => $address->latitude,
                                			     'longitude'  => $address->longitude,
                                			     'type'       => 'guest',
                                			     'timestamp'  => date('Y-m-d H:i:s')
            		                     ];
            		    $this->Common->insert('ordered_address',$address_array);
            		    
            		    $this->response(array(
                        		               "status"      => true,
                        		               "message"     => "Success",
                        		               'order_id'    => $id
                        		             ), REST_Controller::HTTP_OK);
    			    }
                	else	
            	    {	
            	        $this->response(array(
                        		               "status"      => false,
                        		               "message"     => "Failed",
                        		               'order_id'    => ''
                        		             ), REST_Controller::HTTP_OK);
            	    }
    	         }
    	         else
    	         {
    	             $this->response(array(
                            			  "status"  => false,
                            			  "message" => "Your session has expired, please login again"
                            			), REST_Controller::HTTP_UNAUTHORIZED);
    	         }
    	    }
    	}
    	else
    	{
    	    $this->response(array(
                	              "status" => false,
                	              "message" => "Sorry! We don't deliver here.",
                	              'data'    => array(),
                	              'cuisines'=> array()
                	            ), REST_Controller::HTTP_OK); 
    	}
	}

//********************************************** DECODE TOKEN ****************************************************************************************************//    
	public function decodeToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h7';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}
}
?>
