<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Product_recent_search extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_search','search');
	}
//*********************************** POST **************************************************************************************************************************************//	
	public function recent_get()
	{   
	    $uid         = $this->security->xss_clean($this->input->get('uid'));
	    $token       = $this->security->xss_clean($this->input->get('device_token'));
	    $product_id  = $this->security->xss_clean($this->input->get('product_id'));
	    $header      = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{  
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {    
			         $product = $this->Common->get_details('products',array('p_id'=>$product_id))->row();
			         $check   = $this->Common->get_details('product_recent_search',array('user_id'=>$user_id,'type'=>'user','product_id'=>$product_id));
			         if($check->num_rows()>0)
			         {
			             $prev_id = $check->row()->prs_id; 
			             $this->Common->delete('product_recent_search',array('prs_id'=>$prev_id));
			         }
			         
		             $array    = [
		                              'user_id'        => $user_id,
		                              'type'           => 'user',
		                              'rest_id'        => $product->r_id,
		                              'product_id'     => $product_id,
		                              'timestamp'      => date('Y-m-d H:i:s')
		                         ];
		            if($this->Common->insert('product_recent_search',$array)) 
		            {
		                $this->response(array(
                        		              "status"  => true,
                        		              "message" => "Success"
                        		            ), REST_Controller::HTTP_OK);
		            }
		            else
		            {
		                 $this->response(array(
                        		              "status" => false,
                        		              "message" => "Failed to add"
                        		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
		            }
			    }
			    else
			    {
			        $this->response(array(
                            			   "status"  => false,
                            			   "message" => "Your session has expired, please login again"
                            			  ), REST_Controller::HTTP_UNAUTHORIZED);
			    }
    		}
    		else
    		{
    			$this->response(array(
                        			   "status"  => false,
                        			   "message" => "Your session has expired, please login again"
                        			  ), REST_Controller::HTTP_UNAUTHORIZED);
    		}  
	    }
	    else
	    {
	         $guest_check = $this->Common->get_details('guest',array('token'=>$token));
	         if($guest_check->num_rows()>0)
	         {
                 $guest_id  = $guest_check->row()->guest_id;
                 $product   = $this->Common->get_details('products',array('p_id'=>$product_id))->row();
                 $check     = $this->Common->get_details('product_recent_search',array('user_id'=>$guest_id,'type'=>'guest','product_id'=>$product_id));
		         if($check->num_rows()>0)
		         {
		             $prev_id = $check->row()->prs_id; 
		             $this->Common->delete('product_recent_search',array('prs_id'=>$prev_id));
		         }
		         
	             $array    = [
	                              'user_id'        => $guest_id,
	                              'type'           => 'guest',
	                              'rest_id'        => $product->r_id,
	                              'product_id'     => $product_id,
	                              'timestamp'      => date('Y-m-d H:i:s')
	                         ];
	            if($this->Common->insert('product_recent_search',$array)) 
	            {
	                $this->response(array(
                    		              "status"  => true,
                    		              "message" => "Success"
                    		            ), REST_Controller::HTTP_OK);
	            }
	            else
	            {
	                 $this->response(array(
                    		              "status" => false,
                    		              "message" => "Failed to add"
                    		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
	            }
	         }
	         else
	         {
	             $this->response(array(
                        			 "status"  => false,
                        			 "message" => "Your session has expired, please login again"
                        		   ), REST_Controller::HTTP_UNAUTHORIZED);
	         }
	    }
	}

//************************************************************* GET **********************************************************************************************//
	public function index_get()
	{   
	    $uid          = $this->security->xss_clean($this->input->get('uid'));
	    $token        = $this->security->xss_clean($this->input->get('device_token'));
	    $rest_id      = $this->security->xss_clean($this->input->get('restaurant_id'));
	   
	    $header   = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{  
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
			        $result  = $this->search->getUserProductSearchResult($user_id,$rest_id); 
			        foreach($result as $value)
			        {
		                $product             = $this->Common->get_details('products',array('p_id'=>$value->product_id))->row();
		                $product_restaurant  = $this->Common->get_details('restaurants',array('r_id'=>$product->r_id))->row();
		                $value->name         = $product->name; 
		                $value->id           = $product->p_id;
		                if($product->status=='active')
		                {
		                    if($product_restaurant->status=='1'){
		                        $status  = '1';
		                    }
		                    else{
		                        $status = '0';
		                    }
		                    
		                }
		                else{
		                    $status ='0';
		                }
		                $value->status = $status;
			        }
	                $this->response(array(
                    		              "status"  => true,
                    		              "message" => "Success",
                    		              'data'    => $result
                    		            ), REST_Controller::HTTP_OK);
			            
			    }
			    else
			    {
			        $this->response(array(
                            			   "status"  => false,
                            			   "message" => "Your session has expired, please login again"
                            			  ), REST_Controller::HTTP_UNAUTHORIZED);
			    }
    		}
    		else
    		{
    			$this->response(array(
                        			   "status"  => false,
                        			   "message" => "Your session has expired, please login again"
                        			  ), REST_Controller::HTTP_UNAUTHORIZED);
    		}  
	    }
	    else
	    {
	         $guest_check = $this->Common->get_details('guest',array('token'=>$token));
	         if($guest_check->num_rows()>0)
	         {
	                $guest_id  = $guest_check->row()->guest_id;
	                $result  = $this->search->getGuestProductSearchResult($guest_id,$rest_id);
	                foreach($result as $value)
			        {
		                $product             = $this->Common->get_details('products',array('p_id'=>$value->product_id))->row();
		                $product_restaurant  = $this->Common->get_details('restaurants',array('r_id'=>$product->r_id))->row();
		                $value->name         = $product->name; 
		                $value->id           = $product->p_id;
		                $value->type         = 'product';
		                if($product->status=='active')
		                {
		                    if($product_restaurant->status=='1'){
		                        $status  = '1';
		                    }
		                    else{
		                        $status = '0';
		                    }
		                    
		                }
		                else{
		                    $status ='0';
		                }
		                $value->status = $status;
			        }
	                $this->response(array(
                    		              "status"  => true,
                    		              "message" => "Success",
                    		              'data'    => $result
                    		            ), REST_Controller::HTTP_OK);
	         }
	         else
	         {
	             $this->response(array(
                        			 "status"  => false,
                        			 "message" => "Your session has expired, please login again"
                        		   ), REST_Controller::HTTP_UNAUTHORIZED);
	         }
	    }
	}

//******************************************* DECODE TOKEN ************************************************************************************************************************//	
	public function decodeToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h7';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}
	
	
}
?>
