<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Offers extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_offers','offers');
	}

	public function index_get()
	{   
	    date_default_timezone_set('Asia/Bahrain');
	    $current    = date('Y-m-d H:i:s');
	    $date       = date('Y-m-d');
	    $time       = date('h:i:s');
	    
	    $latitude    = $this->security->xss_clean($this->input->get('latitude'));
	    $longitude   = $this->security->xss_clean($this->input->get('longitude'));
	    $block_no    = $this->security->xss_clean($this->input->get('block_no'));
	    
	    $check_block = $this->Common->get_details('blocks',array('block_name'=>$block_no));
        if($check_block->num_rows()>0)
        {
            $block_id   = $check_block->row()->block_id;
    	    $coupons    = $this->offers->getCoupons($latitude,$longitude,$block_id);
    		foreach($coupons as $coup)
    		{   
    		    $rest             = $this->Common->get_details('restaurants',array('r_id'=>$coup->r_id))->row();
    			$coup->restaurant = $rest->rest_name;
    			$coup->rest_image = $rest->cover_image;
    			$coup->rest_image = $rest->cover_image;
    			$coup->thumbnail  = $rest->thumbnail;
    			
    			if($coup->start_time!='00:00:00')
    	        {   
    	            $c_start  = $coup->start_date.' '.$coup->start_time;
    	            if($current>=$c_start)
        	        {
        	            $start_date = true;
        	        }
        	        else
        	        {
        	            $start_date = false;
        	        }
    	        }
    	        else
    	        {
    	            if($date>=$coup->start_date)
        	        {
        	            $start_date  = true;
        	        }
        	        else
        	        {
        	            $start_date  = false;
        	        }
    	        }
    	        
    	        
    	        if($coup->end_time!='00:00:00')
    	        {  
    	            $c_end  = $coup->end_date.' '.$coup->end_time;
        	        if($current<=$c_end)
        	        {
        	            $end_date  = true;
        	        }
        	        else
        	        {
        	            $end_date  = false;
        	        }
    	        }
    	        else
    	        {
    	            if($date<=$coup->end_date)
        	        {
        	            $end_date  = true;
        	        }
        	        else
        	        {
        	            $end_date  = false;
        	        }
    	        }
    	        
    	        if($start_date && $end_date)
    	        {  
    	            $coup->valid_status = true;
    	        }
    	        else
    	        {
    	           $coup->valid_status = false;              
    	        }
    		}
    		
    		$promotions  = $this->offers->getPromotions($latitude,$longitude,$block_id);
    		foreach($promotions as $pro)
    		{   
    		    $rest             = $this->Common->get_details('restaurants',array('r_id'=>$pro->r_id))->row();
    			$pro->restaurant  = $rest->rest_name;
    			$pro->rest_image  = $rest->cover_image;
    			$pro->thumbnail   = $rest->thumbnail;
    			
    			if($date>=$pro->start_date)
    	        {
    	            $start_date  = true;
    	        }
    	        else
    	        {
    	            $start_date  = false;
    	        }
    	        
    	        if($date<=$pro->end_date)
    	        {
    	            $end_date  = true;
    	        }
    	        else
    	        {
    	            $end_date  = false;
    	        }
    	        
    	        if($start_date && $end_date)
    	        {  
    	            $pro->valid_status = true;
    	        }
    	        else
    	        {
    	           $pro->valid_status = false;              
    	        }
    		}
    		        
    		$this->response(array(
            		               "status"  => true,
            		               'data'    => [
                                                  'coupons'    =>$coupons,
                                                  'promotions' =>$promotions
                                               ]
            		             ), REST_Controller::HTTP_OK);
        }
        else
        {
            $this->response(array(
                	              "status" => true,
                	              "message" => 'No restaurants available!..',
                	              'data'    => array(),
                	              'cuisines'=> array()
                	            ), REST_Controller::HTTP_OK);
        }
	}
}
?>
