<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Home extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_home','home');
		$this->load->model('android/M_restaurant','restarant');
		$this->load->model('android/M_offers','offers');
	}
//**************************************** HOME ***************************************************************************************************//
	public function index_get()
	{
	    $latitude    = $this->security->xss_clean($this->input->get('latitude'));
	    $longitude   = $this->security->xss_clean($this->input->get('longitude'));
	    $block_no    = $this->security->xss_clean($this->input->get('block_no'));
	    
	    $radius      = $this->Common->get_details('delivery_area',array())->row()->area_distance;

        $check_block = $this->Common->get_details('blocks',array('block_name'=>$block_no));
        if($check_block->num_rows()>0)
        {
            $block_id  = $check_block->row()->block_id;
           	$Cuisines  = $this->home->getCuisines();
    		$sections  = $this->home->getDetails();
    		foreach($sections as $section)
    		{   
    		    if($section->type!='0')
    		    {
    		        $section->cuisines = $this->Common->get_details('section_cuisines',array('hs_id'=>$section->hs_id))->result();
    				foreach($section->cuisines as $cu)
    				{
    					$cu->name  = $this->Common->get_details('cuisines',array('c_id'=>$cu->c_id))->row()->name;
    				}
    
    				$branches             = $this->home->getBranches($section->hs_id,$latitude,$longitude,$radius,$block_id);
                    $section->restaurants = $branches;
    				foreach($section->restaurants as $restaurants)
    				{   
    				    $rest                   = $this->Common->get_details('restaurants',array('r_id'=>$restaurants->r_id))->row();
    				    $restaurants->rest_name = $rest->rest_name;
    				    $restaurants->rest_image= $rest->rest_image;
    				    $restaurants->thumbnail = $rest->thumbnail;
    				    $restaurants->delivery_charge = $rest->delivery_charge;
    			        if($restaurants->latitude!='' || $restaurants->longitude!='')
    			        {
    			             $distance                      = GetDrivingDistance($latitude, $restaurants->latitude, $longitude, $restaurants->longitude);
                             $town_distance                 = $distance['distance'];
                             $town_time_taken               = $distance['time'];
                             $restaurants->travel_time      = $town_time_taken;
                             $restaurants->travel_distance  = $town_distance;
    			        }
    			        else
    			        {
    			              $restaurants->travel_time       = 0;
    			              $restaurants->travel_distance  = 0;
    			        }
    				    
    				    $rating_check  = $this->Common->get_details('restaurant_reviews',array('r_id'=>$restaurants->r_id));
    				    if($rating_check->num_rows()>0)
    				    {
    				        $rate_count          = $rating_check->num_rows();
    				        $rating              = $this->home->getRatingSum($restaurants->r_id);
    				        $restaurants-> ratings  = number_format($rating/$rate_count,'1');
    				    }
    				    else
    				    {
    				        $restaurants-> ratings  = '0'; 
    				    }
    				    
    				    $restaurants->min_order = $rest->min_order;
    				    $restaurants->service_charge = $rest->service_charge;
    				    $restaurants->coupons   = $this->home->getCoupons($restaurants->r_id);
    				    $restaurants->promotions= $this->home->getPromotions($restaurants->r_id);
    				    $restaurants->types     = $this->restarant->getTypes($restaurants->r_id);
    				}
    				$section->rest_count = count($section->restaurants);
    		    }
    		    else
    		    {
    		        $section->cuisine     = ''; 
    				$branches             = $this->home->getAllBranches($latitude,$longitude,$radius,$block_id);
                    $section->restaurants = $branches;
    		        foreach($section->restaurants as $restaurants)
    				{   
    				    $rest                   = $this->Common->get_details('restaurants',array('r_id'=>$restaurants->r_id))->row();
    				    $restaurants->rest_name = $rest->rest_name;
    				    $restaurants->rest_image= $rest->rest_image;
    				    $restaurants->thumbnail = $rest->thumbnail;
    				    $restaurants->delivery_charge = $rest->delivery_charge;
    				    
    			        if($restaurants->latitude!='' || $restaurants->longitude!='')
    			        {
    			             $distance              = GetDrivingDistance($latitude, $restaurants->latitude, $longitude, $restaurants->longitude);
                             $town_distance         = $distance['distance'];
                             $town_time_taken       = $distance['time'];
                             $restaurants->travel_time      = $town_time_taken;
                             $restaurants->travel_distance  = $town_distance;
    			        }
    			        else
    			        {
    			              $restaurants->travel_time       = 0;
    			              $restaurants->travel_distance   = 0;
    			        }
    				    
    				    $rating_check                = $this->Common->get_details('restaurant_reviews',array('r_id'=>$restaurants->r_id));
    				    if($rating_check->num_rows()>0)
    				    {
    				        $rate_count             = $rating_check->num_rows();
    				        $rating                 = $this->home->getRatingSum($restaurants->r_id);
    				        $restaurants-> ratings  = number_format($rating/$rate_count,'1');
    				    }
    				    else
    				    {
    				        $restaurants-> ratings  = '0'; 
    				    }
    				    $restaurants->coupons   = $this->home->getCoupons($restaurants->r_id);
    				    $restaurants->promotions= $this->home->getPromotions($restaurants->r_id);
    				    $restaurants->types     = $this->restarant->getTypes($restaurants->r_id);
    				}
    				$section->rest_count = count($section->restaurants);
    		    }
    		}
    		$this->response(array(
                	              "status" => true,
                	              "message" => 'Success',
                	              'data'    => $sections,
                	              'cuisines'=> $Cuisines
                	            ), REST_Controller::HTTP_OK);  
        }
        else
        {
            $this->response(array(
                	              "status" => true,
                	              "message" => 'No restaurants available!..',
                	              'data'    => array(),
                	              'cuisines'=> array()
                	            ), REST_Controller::HTTP_OK);  
        }
	}

//************************************************ GET ORDER STATUS **********************************************************************************************//	
	public function getOrderStatus_get()
	{
	    $header = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{ 
    		    $check  = $this->Common->get_details('orders',array('user_id'=>$user_id));
    		    if($check->num_rows()>0)
    		    {
    		        $order      = $this->home->getOrderStatus($user_id);
    		        $restaurant = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id))->row();
    		        $order->rest_name = $restaurant->rest_name;
    		        $order->rest_image= $restaurant->cover_image;
    		       
                    $this->response(array(
                    		              "status"  => true,
                    		              "message" => "Success",
                    		              "data"    => $order,
                    		            ), REST_Controller::HTTP_OK);    			  
    		    }
    		    else
    		    {
    		        $this->response(array(
                        			  "status"  => 0,
                        			  "message" => "Failed"
                        			), REST_Controller::HTTP_NOT_FOUND);
    		    }
    		}
    		else
    		{
    			$this->response(array(
                        			  "status"  => 0,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
    		}    
	    }
	    else
	    {
	        $this->response(array(
                        			  "status"  => 0,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}

//******************************************* DECODE TOKEN *******************************************************************************************************//
	public function decodeToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h7';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}
//******************************************************************* GET DRIVING DISTANCE ************************************************************************//	
	function GetDrivingDistance($lat1, $lat2, $long1,$long2)
    {
        $url = "https://maps.googleapis.com/maps/api/distancematrix/json?origins=".$lat1.",".$long1."&destinations=".$lat2."%2C".$long2."&mode=driving&language=pl-PL&key=" . GOOGLE_MAP_KEY;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_PROXYPORT, 3128);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        $response = curl_exec($ch);
        curl_close($ch);
        $response_a = json_decode($response, true);
        $dist = $response_a['rows'][0]['elements'][0]['distance']['text'];
        $time = $response_a['rows'][0]['elements'][0]['duration']['text'];
    
        return array('distance' => $dist, 'time' => $time);
        // return $response_a;
    }	
}
?>
