<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Guest extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_guest','guest');
		$this->load->model('android/M_orders','order');
	}
	
	public function index_get()
	{   
	    date_default_timezone_set('Asia/Bahrain');
	    $timestamp = date('Y-m-d H:i:s');
	    
	    $token     = $this->security->xss_clean($this->input->get('device_token'));
	    $check     = $this->Common->get_details('guest',array('token'=>$token));
	    if($check->num_rows()==0)
	    {
	        if($id = $this->Common->insert('guest',array('token'=>$token,'timestamp'=>$timestamp)))
    	    {
    	            $this->response(array(
                        		              "status" => true,
                        		              "message" => "Success",
                        		              'data'    => [
                            				                  'guest_id'    => $id,
                            				                  'token'       => $token
                            				                ]
                        		            ), REST_Controller::HTTP_OK);
    	    }
    		else 
    		{
    				$this->response(array(
    				                            "status"  => false,
    				                            "message" => "Failed"
    				                      ), REST_Controller::HTTP_UNAUTHORIZED);
    		} 
	    }
	    else
	    {
	        $this->response(array(
                		              "status" => true,
                		              "message" => "Success",
                		              'data'    => [
                    				                  'guest_id'    => $check->row()->guest_id,
                    				                  'token'       => $check->row()->token
                    				                ]
                		            ), REST_Controller::HTTP_OK);
	    }
	    
	}
	
	public function addCart_post()
	{
	    $header = $this->input->get_request_header('Authorization');
	    if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
			 //   $type        = $this->security->xss_clean($this->input->post('type'));
			 //   if($type=='product')
			 //   {
            		$product_id  = $this->security->xss_clean($this->input->post('product_id'));
            		$price_id    = $this->security->xss_clean($this->input->post('price_id'));
            		$quantity    = $this->security->xss_clean($this->input->post('quantity'));
            		$branch_id   = $this->security->xss_clean($this->input->post('branch_id'));
            		$choices     = $this->security->xss_clean($this->input->post('choices'));
                    $json        = json_decode($choices, true);
                    
                    $product = $this->Common->get_details('products',array('p_id'=>$product_id))->row();
            	    $price   = $product->price;
            	    $total   = $price*$quantity;
        
            		$item        = [
                    			     'guest_id'     => $user_id,
                    			     'product_id'   => $product_id,
                    			     'price_id'     => $price_id
                    		       ];
            	    $restaurant_id = $this->Common->get_details('products',array('p_id'=>$product_id))->row()->r_id;
            	    $cart_check    = $this->guest->cartCheck($restaurant_id,$user_id);
            	    if($cart_check==0)
            	    {      
            		    $check   = $this->Common->get_details('guest_cart',$item);
                		if ($check->num_rows() > 0) 
                		{
                			$cart_id = $check->row()->gcart_id;
                			if($this->Common->update('gcart_id',$cart_id,'guest_cart',array('quantity' => $quantity)))
                			{
                			    $this->Common->delete('guest_sub_cart',array('gcart_id' => $cart_id));
                			    
                			    $elementCount  = count($json);
                                for ($i=0;$i < $elementCount; $i++) 
                                {
                                    $cat_name      =  $json[$i]['pcat_id'];
                                    $cat_values    =  $json[$i]['choice_values'];
                                    $elementCount1 = count($cat_values);
                                    for ($j=0;$j < $elementCount1; $j++)
                                    {
                                        $value_array   = [    
                                                             'gcart_id'      => $cart_id,
                                                             'cat_id'        => $cat_name,
                                                             'val_id'       => $cat_values[$j]['pchoice_id'],
                                                             'quantity'     => $quantity,
                                                         ];
                                        $this->Common->insert('guest_sub_cart',$value_array);                
                                    }
                                }
                			}
                		}
                		else 
                		{
                			$item['quantity']   = $quantity;
                			$item['date']       = date('Y-m-d');
                    		$item['time']       = date('h:i A');
                    		$item['branch_id']  = $branch_id;
                    		$item['r_id']       = $restaurant_id; 
                    		
                			if($id=$this->Common->insert('guest_cart',$item))
                			{
                			    $elementCount  = count($json);
                                for ($i=0;$i < $elementCount; $i++) 
                                {
                                    $cat_name      =  $json[$i]['pcat_id'];
                                    $cat_values    =  $json[$i]['choice_values'];
                                    $elementCount1 = count($cat_values);
                                    for ($j=0;$j < $elementCount1; $j++)
                                    {
                                        $value_array   = [    
                                                             'gcart_id'      => $id,
                                                             'cat_id'        => $cat_name,
                                                             'val_id'       => $cat_values[$j]['pchoice_id'],
                                                             'quantity'     => $quantity,
                                                         ];
                                        $this->Common->insert('guest_sub_cart',$value_array);                
                                    }
                                }
                			}
                		} 
                		
                	   $this->response(array(
                        		              "status"  => true,
                        		              "message" => "Success"
                        		            ), REST_Controller::HTTP_OK);	
            	     }
            	     else
            	     {
            	        $this->response(array(
                            		              "status"  => false,
                            		              "message" => "Failed to add product to cart"
                            		            ), REST_Controller::HTTP_OK);	
            	     }
			
    		}
    		else
    		{
    			$this->response(array(
                        			    "status"  => false,
                        			    "message" => "Your session has expired, please login again"
                        			  ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	         $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}
	
	public function updateCart_post()
	{
	    $header = $this->input->get_request_header('Authorization');
	    if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{   
			    $type        = $this->security->xss_clean($this->input->post('type'));
        		$cart_id     = $this->security->xss_clean($this->input->post('cart_id'));
        		$quantity    = $this->security->xss_clean($this->input->post('quantity'));
        		
                $cart_data   = $this->Common->get_details('guest_cart',array('gcart_id'=>$cart_id))->row();
                if($type=='product')
                {
                    $product_id  = $cart_data->product_id;
                    $price_id    = $cart_data->price_id;
                    $product_price= $this->Common->get_details('product_price',array('price_id'=>$price_id))->row();
            	    $price       = $product_price->price;
            	    $total       = $price*$quantity; 
            	    
            		$array = [
                    			'quantity' => $quantity
                    	 	 ];
            
            		if ($this->Common->update('gcart_id',$cart_id,'guest_cart',$array)) 
            		{   
            		    
            		    $subcart  = $this->Common->get_details('guest_sub_cart',array('gcart_id'=>$cart_id))->result(); 
            		    foreach($subcart as $sub)
            		    {   
            		        $choice   = $this->Common->get_details('product_choices',array('pchoice_id'=>$sub->val_id))->row(); 
            		        $sub_id   = $sub->gsub_id;
            		        $s_total  = $choice->price*$quantity;
            		        $s_array  =  [
            		                          'quantity'  => $quantity
            		                     ];
            		        $this->Common->update('gsub_id',$sub_id,'guest_sub_cart',$s_array);             
            		    }
    
            		    $cart   = $this->Common->get_details('guest_cart',array('guest_id'=>$user_id))->result();
            		    $total  = 0;
            		    foreach($cart as $c)
            		    {
            		        if($c->type=='p')
            		        {
            		            $product         = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();
            		            $product_price   = $this->Common->get_details('product_price',array('price_id'=>$c->price_id))->row();
                		        $restaurant      = $this->Common->get_details('restaurants',array('r_id'=>$product->r_id))->row();
                		        $c->cart_id      = $c->gcart_id;
                		        $c->restaurant   = $restaurant->rest_name;
                		        $c->product_name = $product->name;
                		        $c->r_id         = $product->r_id;
                		        $c->image        = $product->cover_image;
                		        $c->price        = $product_price->price;
                		        $cart_total      = $product_price->price*$c->quantity;
                		        $grand           = $cart_total;
                		        $extras          = $this->Common->get_details('guest_sub_cart',array('gcart_id'=>$c->gcart_id))->result();
                		        $sub_total       = 0;
                		        $single          = 0;
                		        foreach($extras as $extra)
                		        {   
                		            $choice     = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row();
                		            $extra->total= $choice->price*$extra->quantity;
                		            $sub_total  = $sub_total+$extra->total;
                		            $single     = $single+$choice->price;
                		        }
                		        $c->extras       = $extras;
                		        $c->extra_total  = number_format($sub_total,'2');
                		        $total           = $total+$grand+$sub_total;
                		        $total2          = $grand+$sub_total;
                		        $c->total        =  number_format($total2,'2');
                		        $c->singl_price  =  number_format($c->price+$single,'2');
            		        }
            		        else
                		    {
            		            $extras          = $this->Common->get_details('extras',array('extra_id'=>$c->product_id))->row();
                		        $restaurant      = $this->Common->get_details('restaurants',array('r_id'=>$extras->r_id))->row();
                		        $c->restaurant   = $restaurant->rest_name;
                		        $c->product_name = $extras->name;
                		        $c->r_id         = $extras->r_id;
                		        $c->image        = $extras->image;
                		        $c->price        = $extras->price;
                		        $cart_total      = $extras->price*$c->quantity;
                		        $grand           = $cart_total;
        
                		        $total = $total+$grand;
                		        $c->singl_price=  number_format($c->price,'2');
                		        $c->total      =  number_format($cart_total,'2');
                		   }
        		            
            		    }
            		    
    		         	 $this->response(array(
                    		              "status"  => true,
                    		              "message" => "Success",
                    		              'total'   => number_format($total,'2'),
                    		            ), REST_Controller::HTTP_OK);
            		}
            		else 
            		{
            			$this->response(array(
                            		              "status"  => false,
                            		              "message" => "Failed to update cart"
                            		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
            		}
                }
                else
                {
                    $product_id  = $cart_data->product_id;
                   
            		$array = [
                    			'quantity' => $quantity
                    	 	 ];
            
            		if ($this->Common->update('gcart_id',$cart_id,'guest_cart',$array)) 
            		{   
            		    $cart   = $this->Common->get_details('guest_cart',array('guest_id'=>$user_id))->result();
            		    $total  = 0;
            		    foreach($cart as $c)
            		    {
            		        if($c->type=='p')
            		        {
            		            $product         = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();
            		            $product_price   = $this->Common->get_details('product_price',array('price_id'=>$c->price_id))->row();
                		        $restaurant      = $this->Common->get_details('restaurants',array('r_id'=>$product->r_id))->row();
                		        $c->cart_id      = $c->gcart_id;
                		        $c->restaurant   = $restaurant->rest_name;
                		        $c->product_name = $product->name;
                		        $c->r_id         = $product->r_id;
                		        $c->image        = $product->cover_image;
                		        $c->price        = $product_price->price;
                		        $cart_total      = $product_price->price*$c->quantity;
                		        $grand           = $cart_total;
                		        $extras          = $this->Common->get_details('guest_sub_cart',array('gcart_id'=>$c->gcart_id))->result();
                		        $sub_total       = 0;
                		        $single          = 0;
                		        foreach($extras as $extra)
                		        {   
                		            $choice     = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row();
                		            $extra->total= $choice->price*$extra->quantity;
                		            $sub_total  = $sub_total+$extra->total;
                		            $single     = $single+$choice->price;
                		        }
                		        $c->extras       = $extras;
                		        $c->extra_total  = number_format($sub_total,'2');
                		        $total           = $total+$grand+$sub_total;
                		        $total2          = $grand+$sub_total;
                		        $c->total        =  number_format($total2,'2');
                		        $c->singl_price  =  number_format($c->price+$single,'2');
            		        }
            		        else
                		    {
            		            $extras          = $this->Common->get_details('extras',array('extra_id'=>$c->product_id))->row();
                		        $restaurant      = $this->Common->get_details('restaurants',array('r_id'=>$extras->r_id))->row();
                		        $c->restaurant   = $restaurant->rest_name;
                		        $c->product_name = $extras->name;
                		        $c->r_id         = $extras->r_id;
                		        $c->image        = $extras->image;
                		        $c->price        = $extras->price;
                		        $cart_total      = $extras->price*$c->quantity;
                		        $grand           = $cart_total;
        
                		        $total = $total+$grand;
                		        $c->singl_price=  number_format($c->price,'2');
                		        $c->total      =  number_format($cart_total,'2');
                		   }
        		            
            		    }
            		    
    		         	 $this->response(array(
                    		              "status"  => true,
                    		              "message" => "Success",
                    		              'total'   => number_format($total,'2'),
                    		            ), REST_Controller::HTTP_OK);
            		}
            		else 
            		{
            			$this->response(array(
                            		              "status"  => false,
                            		              "message" => "Failed to update cart"
                            		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
            		}
                }
               
    		}
    		else
    		{
    			$this->response(array(
                        			    "status"  => false,
                        			    "message" => "Your session has expired, please login again"
                        			  ), REST_Controller::HTTP_UNAUTHORIZED);
    		}  
	    }
	    else
	    {
	        $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}
	
	public function deleteCartData_post()
	{   
	    $header = $this->input->get_request_header('Authorization');
	    if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{  
			    $type    = $this->security->xss_clean($this->input->post('type'));
        	    $cart_id = $this->security->xss_clean($this->input->post('cart_id'));
        	    if($type=='product')
        	    {
        	        if($this->Common->delete('guest_cart',array('gcart_id' => $cart_id)))
            	    {
            	        $this->Common->delete('guest_sub_cart',array('gcart_id' => $cart_id));
            	        
            	        $cart   = $this->Common->get_details('guest_cart',array('guest_id'=>$user_id))->result();
            		    $total  = 0;
            		    foreach($cart as $c)
            		    {   
            		        if($c->type=='p')
            		        {
                		        $product         = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();
                		        $product_price   = $this->Common->get_details('product_price',array('price_id'=>$c->price_id))->row();
                		        $c->product_name = $product->name;
                		        $c->r_id         = $product->r_id;
                		        $c->image        = $product->cover_image;
                		        $c->price        = $product_price->price;
                		        $cart_total      = number_format($c->price*$c->quantity,'2');
                		        $grand           = $cart_total;
                		        $c->total        =  number_format($cart_total,'2');
                		        
                		        $extras          = $this->Common->get_details('guest_sub_cart',array('gcart_id'=>$c->gcart_id))->result();
                		        $sub_total       = 0;
                		        $single          = 0;
                		        foreach($extras as $extra)
                		        {   
                		            $choice       = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
                		            $extra->total = $choice->price*$extra->quantity;
                		            $sub_total    = $sub_total+$extra->total;
                		            $single       = $single+$choice->price;
                		        }
                		        $total           = $total+$grand+$sub_total;
                		        $c->singl_price  =  number_format($c->price+$single,'2');
            		        }
            		        else
            		        {
            		            $extras          = $this->Common->get_details('extras',array('extra_id'=>$c->product_id))->row();
                		        $restaurant      = $this->Common->get_details('restaurants',array('r_id'=>$extras->r_id))->row();
                		        $c->restaurant   = $restaurant->rest_name;
                		        $c->product_name = $extras->name;
                		        $c->r_id         = $extras->r_id;
                		        $c->image        = $extras->image;
                		        $c->price        = $extras->price;
                		        $cart_total      = $extras->price*$c->quantity;
                		        $grand           = $cart_total;
        
                		        $total = $total+$grand;
                		        $c->singl_price=  number_format($c->price,'2');
                		        $c->total      =  number_format($cart_total,'2');
            		        }
            		    }
            	        
            	        $this->response(array(
                            		              "status"  => true,
                            		              "message" => "success",
                            		              'total'   => number_format($total,'2'),
                            		            ), REST_Controller::HTTP_OK);
            	    }
            	    else
            	    {
            	       $this->response(array(
                            		              "status" => false,
                            		              "message" => "Failed"
                            		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
            	    }
        	    }
        	    else
        	    {
        	        if($this->Common->delete('guest_cart',array('gcart_id' => $cart_id)))
            	    {
            	        $cart   = $this->Common->get_details('guest_cart',array('guest_id'=>$user_id))->result();
            		    $total  = 0;
            		    foreach($cart as $c)
            		    {   
            		        if($c->type=='p')
            		        {
                		        $product         = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();
                		        $product_price   = $this->Common->get_details('product_price',array('price_id'=>$c->price_id))->row();
                		        $c->product_name = $product->name;
                		        $c->r_id         = $product->r_id;
                		        $c->image        = $product->cover_image;
                		        $c->price        = $product_price->price;
                		        $cart_total      = number_format($c->price*$c->quantity,'2');
                		        $grand           = $cart_total;
                		        $c->total        =  number_format($cart_total,'2');
                		        
                		        $extras          = $this->Common->get_details('guest_sub_cart',array('gcart_id'=>$c->gcart_id))->result();
                		        $sub_total       = 0;
                		        $single          = 0;
                		        foreach($extras as $extra)
                		        {   
                		            $choice       = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
                		            $extra->total = $choice->price*$extra->quantity;
                		            $sub_total    = $sub_total+$extra->total;
                		            $single       = $single+$choice->price;
                		        }
                		        $total           = $total+$grand+$sub_total;
                		        $c->singl_price  =  number_format($c->price+$single,'2');
            		        }
            		        else
            		        {
            		            $extras          = $this->Common->get_details('extras',array('extra_id'=>$c->product_id))->row();
                		        $restaurant      = $this->Common->get_details('restaurants',array('r_id'=>$extras->r_id))->row();
                		        $c->restaurant   = $restaurant->rest_name;
                		        $c->product_name = $extras->name;
                		        $c->r_id         = $extras->r_id;
                		        $c->image        = $extras->image;
                		        $c->price        = $extras->price;
                		        $cart_total      = $extras->price*$c->quantity;
                		        $grand           = $cart_total;
        
                		        $total = $total+$grand;
                		        $c->singl_price=  number_format($c->price,'2');
                		        $c->total      =  number_format($cart_total,'2');
            		        }
            		    }
            	        
            	        $this->response(array(
                            		              "status"  => true,
                            		              "message" => "success",
                            		              'total'   => number_format($total,'2'),
                            		            ), REST_Controller::HTTP_OK);
            	    }
            	    else
            	    {
            	       $this->response(array(
                            		              "status" => false,
                            		              "message" => "Failed"
                            		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
            	    }
        	    }
        	    
    		}
    		else
    		{
    			$this->response(array(
                        			   "status"  => false,
                        			   "message" => "Your session has expired, please login again"
                        			 ), REST_Controller::HTTP_UNAUTHORIZED);
    		}  
	    }
	    else
	    {
	         $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}
	
	public function getCartData_get()
	{
	    $header = $this->input->get_request_header('Authorization');
	    if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
    		    $cart   = $this->Common->get_details('guest_cart',array('guest_id'=>$user_id))->result();
    		    $total  = 0;
    		    foreach($cart as $c)
    		    {   
    		        if($c->type=='p')
    		        {
    		            $product         = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();
    		            $product_price   = $this->Common->get_details('product_price',array('price_id'=>$c->price_id))->row();
        		        $restaurant      = $this->Common->get_details('restaurants',array('r_id'=>$product->r_id))->row();
        		        $c->cart_id      = $c->gcart_id;
        		        $c->restaurant   = $restaurant->rest_name;
        		        $c->product_name = $product->name;
        		        $c->r_id         = $product->r_id;
        		        $c->image        = $product->cover_image;
        		        $c->price        = $product_price->price;
        		        $cart_total      = $product_price->price*$c->quantity;
        		        $grand           = $cart_total;
        		        $extras          = $this->Common->get_details('guest_sub_cart',array('gcart_id'=>$c->gcart_id))->result();
        		        $sub_total       = 0;
        		        $single          = 0;
        		        foreach($extras as $extra)
        		        {   
        		            $choice     = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row();
        		            $choice_cat = $this->Common->get_details('product_choice_categories',array('pcat_id'=>$extra->cat_id))->row();
        		            $extra->cat_name = $choice_cat->cat_name;
        		            $extra->cat_value= $choice->name;
        		            $extra->price= $choice->price;
        		            $extra->total= $choice->price*$extra->quantity;
        		            $sub_total  = $sub_total+$extra->total;
        		            $single     = $single+$choice->price;
        		        }
        		        $c->extras       = $extras;
        		        $c->extra_total  = number_format($sub_total,'2');
        		        $total           = $total+$grand+$sub_total;
        		        $total2          = $grand+$sub_total;
        		        $c->total        =  number_format($total2,'2');
        		        $c->singl_price  =  number_format($c->price+$single,'2');
    		        }
    		        else
        		    {
    		            $extras          = $this->Common->get_details('extras',array('extra_id'=>$c->product_id))->row();
        		        $restaurant      = $this->Common->get_details('restaurants',array('r_id'=>$extras->r_id))->row();
        		        $c->restaurant   = $restaurant->rest_name;
        		        $c->product_name = $extras->name;
        		        $c->r_id         = $extras->r_id;
        		        $c->image        = $extras->image;
        		        $c->price        = $extras->price;
        		        $cart_total      = $extras->price*$c->quantity;
        		        $grand           = $cart_total;

        		        $total = $total+$grand;
        		        $c->singl_price=  number_format($c->price,'2');
        		        $c->total      =  number_format($cart_total,'2');
        		        $c->extras     = array();
        		        $c->extra_total= '';
        		   }
    		    }

                $this->response(array(
                    		              "status"  => true,
                    		              "message" => "Success",
                    					  "data"    => $cart,
                    					  'total'   => number_format($total,'2')
                    		            ), REST_Controller::HTTP_OK);			  
    		}
    		else
    		{
    			$this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	        $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
	    }
		
	}
	
	public function getCartCount_get()
	{
	    $header = $this->input->get_request_header('Authorization');
	    if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
    		    $cart   = $this->Common->get_details('guest_cart',array('guest_id'=>$user_id));
		        $count  = $cart->num_rows();
		       
            	$this->response(array(
                    		              "status"  => true,
                    		              "message" => "Success",
                    		              "data"    => $count,
                    		            ), REST_Controller::HTTP_OK);		 
    		}
    		else
    		{
    			$this->response(array(
                        			   "status"  => false,
                        			   "message" => "Your session has expired, please login again"
                        			  ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	        $this->response(array(
                        			 "status"  => false,
                        			 "message" => "Your session has expired, please login again"
                        		   ), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}
	
	public function checkCart_post()
	{
	    $header = $this->input->get_request_header('Authorization');
	    if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{    
    		     $restaurant_id = $this->input->post('restuarant_id');
    		     $branch_id     = $this->input->post('branch_id');
    		     $cart_check    = $this->guest->restaurantCartCheck($restaurant_id,$user_id,$branch_id);
        	     if($cart_check==0)
        	     {
        	         $this->response(array(
                        		              "status" => false,
                        		              "message" => "Failed"
                        		            ), REST_Controller::HTTP_NOT_FOUND);
        	     }
        	     else
        	     {   
        	        $cart   = $this->Common->get_details('guest_cart',array('guest_id'=>$user_id))->result();
        		    $total  = 0;
        		    foreach($cart as $c)
        		    {
        		        if($c->type=='p')
        		        {
        		            $product         = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();
        		            $product_price   = $this->Common->get_details('product_price',array('price_id'=>$c->price_id))->row();
            		        $c->price        = $product_price->price;
            		        $c->total        = $c->price*$c->quantity;
            		        $grand           = $c->total;
            		        $extras          = $this->Common->get_details('guest_sub_cart',array('gcart_id'=>$c->gcart_id))->result();
            		        $sub_total       = 0;
            		        foreach($extras as $extra)
            		        {   
            		            $choice       = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row();
        		                $extra->total = $choice->price*$extra->quantity;
            		            $sub_total    = $sub_total+$extra->total;
            		        }
            		        $total            = $total+$grand+$sub_total;
        		        }
        		        else
        		        {
        		            $extras          = $this->Common->get_details('extras',array('extra_id'=>$c->product_id))->row();
            		        $restaurant      = $this->Common->get_details('restaurants',array('r_id'=>$extras->r_id))->row();
            		        $c->restaurant   = $restaurant->rest_name;
            		        $c->product_name = $extras->name;
            		        $c->r_id         = $extras->r_id;
            		        $c->image        = $extras->image;
            		        $c->price        = $extras->price;
            		        $cart_total      = $extras->price*$c->quantity;
            		        $grand           = $cart_total;
    
            		        $total = $total+$grand;
            		        $c->singl_price=  number_format($c->price,'2');
            		        $c->total      =  number_format($cart_total,'2');
        		        }
        		    }
        	        
        	        $this->response(array(
                        		              "status"  => true,
                        		              "message" => "Success",
                        		              'count'   => $cart_check,
        	                                  'total'   => number_format($total,'2'),
                        		            ), REST_Controller::HTTP_OK);             
        	     }
    		}
    		else
    		{
    		    $this->response(array(
                        			     "status"  => false,
                        			     "message" => "Your session has expired, please login again"
                        			 ), REST_Controller::HTTP_UNAUTHORIZED);
    		}  
	    }
	    else
	    {
	         $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}
	
	public function getExtras_post()
	{   
	    $header = $this->input->get_request_header('Authorization');
	    if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
        	    $rest_id   = $this->security->xss_clean($this->input->post('restaurant_id'));
        	    $extras    = $this->order->getExtras($rest_id);
        	    foreach($extras as $extra)
        	    {
        	        $cart_check = $this->Common->get_details('guest_cart',array('guest_id'=>$user_id,'product_id'=>$extra->extra_id,'type'=>'e'));
        	        if($cart_check->num_rows()>0)
        	        {
        	            $extra->quantity  = $cart_check->row()->quantity;
        	        }
        	        else
        	        {
        	            $extra->quantity  = '0';
        	        }
        	    }
        	    $this->response(array(
                		              "status"   => true,
                		              "message"  => 'Success',
                		              'data'     => $extras
                		            ), REST_Controller::HTTP_OK); 
			}
    		else
    		{
    			$this->response(array(
                        			    "status"  => false,
                        			    "message" => "Your session has expired, please login again"
                        		     ), REST_Controller::HTTP_UNAUTHORIZED);
    		}    
	    }
	    else
	    {
	         $this->response(array(
                        			 "status"  => false,
                        			 "message" => "Your session has expired, please login again"
                        		   ), REST_Controller::HTTP_UNAUTHORIZED);
	    }    		            
	}
	
	public function addExtraCart_post()
	{
	    $header = $this->input->get_request_header('Authorization');
	    if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
		        $extra_id    = $this->security->xss_clean($this->input->post('extra_id'));
        		$quantity    = $this->security->xss_clean($this->input->post('quantity'));
        		$branch_id   = $this->security->xss_clean($this->input->post('branch_id'));
                
                $product     = $this->Common->get_details('extras',array('extra_id'=>$extra_id))->row();
        	    $price       = $product->price;
        	    $total       = $price*$quantity;
    
        		$item        = [
                			     'guest_id'     => $user_id,
                			     'product_id'   => $extra_id,
                			     'type'         => 'e'
                		       ];
        	    $restaurant_id = $this->Common->get_details('extras',array('extra_id'=>$extra_id))->row()->r_id;
        	    $cart_check    = $this->guest->cartCheckExtra($restaurant_id,$user_id);
        	    if($cart_check==0)
        	    {      
            		    $check   = $this->Common->get_details('guest_cart',$item);
                		if ($check->num_rows() > 0) 
                		{   
                			$cart_id = $check->row()->gcart_id;
                			if($quantity=='0')
                			{
                			    $this->Common->delete('guest_cart',array('gcart_id' => $cart_id));
                			}
                			else
                			{
                				$this->Common->update('gcart_id',$cart_id,'guest_cart',array('quantity' => $quantity));
                			}
                		}
                		else 
                		{
                			$item['quantity']   = $quantity;
                			$item['date']       = date('Y-m-d');
                    		$item['time']       = date('h:i A');
                    		$item['branch_id']  = $branch_id;
                    		$item['r_id']       = $restaurant_id; 
                			$this->Common->insert('guest_cart',$item);
                		} 
                		
                	   $this->response(array(
                        		              "status"  => true,
                        		              "message" => "Success"
                        		            ), REST_Controller::HTTP_OK);	
        	     }
        	     else
        	     {
        	        $this->response(array(
                        		              "status"  => false,
                        		              "message" => "Failed to add product to cart"
                        		            ), REST_Controller::HTTP_OK);	
        	     }
    		}
    		else
    		{
    			$this->response(array(
                        			    "status"  => false,
                        			    "message" => "Your session has expired, please login again"
                        			  ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	         $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}
	
	public function delete_get()
	{   
	    $header = $this->input->get_request_header('Authorization');
	    if ($header != '') 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{  
    		    $cart = $this->Common->get_details('guest_cart',array('guest_id'=>$user_id))->result();
    		    foreach($cart as $c)
    		    {   
    		        $cart_id = $c->gcart_id;
    		        if($this->Common->delete('guest_cart',array('gcart_id' => $cart_id)))
            	    {
            	        $this->Common->delete('guest_sub_cart',array('gcart_id' => $cart_id));
            	    }
    		    }
    		     $this->response(array(
                        		              "status"  => true,
                        		              "message" => "Success"
                        		            ), REST_Controller::HTTP_OK);
    		}
    		else
    		{
    			$this->response(array(
                        			   "status"  => false,
                        			   "message" => "Your session has expired, please login again"
                        			  ), REST_Controller::HTTP_UNAUTHORIZED);
    		}  
	    }
	    else
	    {
	         $this->response(array(
                        			 "status"  => false,
                        			 "message" => "Your session has expired, please login again"
                        		   ), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}
	
	public function decodeToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'umM6RFZZVWxNyKFlVD2EUdxl4Rxn9ym5S6i8';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}
 
	public function generateToken($id)
	{
		$key    = 'gB5eLgL3TMiG3vHxYvMTdh';
        $secret = 'umM6RFZZVWxNyKFlVD2EUdxl4Rxn9ym5S6i8';
        $token  = array(
                           "iss" => $key,
				           "id"  => $id,
                       );
        $tok = JWT::encode( $token, $secret );
		return $tok;
	}
}
?>
