<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Delivery extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_delivery','delivery');
	}
	
	public function check_post()
	{
	    $block_no      = $this->security->xss_clean($this->input->post('block_no'));
	    $restaurant_id = $this->security->xss_clean($this->input->post('restaurant_id'));
	    $branch_id     = $this->security->xss_clean($this->input->post('branch_id'));
	    
	    $check_block   = $this->Common->get_details('blocks',array('block_name'=>$block_no));
        if($check_block->num_rows()>0)
	    {
	        $block_id  = $check_block->row()->block_id;
    	    $radius    = $this->Common->get_details('delivery_area',array())->row()->area_distance;
    	    if($restaurant_id!='')
    	    {    
    	          $shops = $this->delivery->getShopsBranchDelivery($branch_id,$block_id);
    	    }
    	    else
    	    {
    	          $shops = $this->delivery->getShops();
    	    }
    	    
    	    if($shops>0)
    	    {
    	        $this->response(array(
                		              "status"  => true,
                		              "message" => "Success"
                		              ), REST_Controller::HTTP_OK);
    	    }
    		else
    		{
    		    $this->response(array(
                		              "status"  => false,
                		              "message" => "Failed"
                		            ), REST_Controller::HTTP_OK);
    		}
	    }
	    else
	    {
	        $this->response(array(
                		              "status"  => false,
                		              "message" => "Failed"
                		            ), REST_Controller::HTTP_OK);
	    }
	}
	
	public function check_old_post()
	{
	    $latitude      = $this->security->xss_clean($this->input->post('latitude'));
	    $longitude     = $this->security->xss_clean($this->input->post('longitude'));
	    $restaurant_id = $this->security->xss_clean($this->input->post('restaurant_id'));
	    $branch_id     = $this->security->xss_clean($this->input->post('branch_id'));
	    
	    $radius    = $this->Common->get_details('delivery_area',array())->row()->area_distance;

	    if($restaurant_id!='')
	    {    
	        if($branch_id=='' || $branch_id=='0')
	        {
	             $shops     = $this->delivery->getShopsDelivery($latitude,$longitude,$radius,$restaurant_id);
	        }
	        else
	        {
	             $shops     = $this->delivery->getShopsBranchDelivery($latitude,$longitude,$radius,$branch_id);
	        }
	    }
	    else
	    {
	        $shops     = $this->delivery->getShops($latitude,$longitude,$radius);
	    }
	    
	    if($shops>0)
	    {
	        $this->response(array(
            		              "status"  => true,
            		              "message" => "Success"
            		              ), REST_Controller::HTTP_OK);
	    }
		else
		{
		    $this->response(array(
            		              "status"  => false,
            		              "message" => "Failed"
            		            ), REST_Controller::HTTP_OK);
		}
	}


}
?>
