<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Cuisines extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_restaurant','restaurant');
	}
	
	public function index_get()
	{
	    $check           = $this->Common->get_details('cuisines',array('status'=>'1'));
		if($check->num_rows()>0)
		{
		    $cuisines  = $this->restaurant->getCuisines();
		}
		else
		{
		    $cuisines  = '';
		}
		
		$this->response(array(
            		              "status"  => true,
            		              "message" => "Success",
            		              'data'    => $cuisines
            		            ), REST_Controller::HTTP_OK); 
	}
	
	public function restaurants_post()
	{
	    $cuisine_id      = $this->security->xss_clean($this->input->post('cuisine_id'));
		$check           = $this->restaurant->getCuisineRestaurants($cuisine_id);
		if($check->num_rows()>0)
		{
		    $restaurants  = $check->result();
		    
		}
		else
		{
		    $restaurants  = '';
		}
		$this->response(array(
            		              "status"  => true,
            		              "message" => "Success",
            		              'data'    => $restaurants
            		            ), REST_Controller::HTTP_OK); 
       
	}
	

	
}
?>
