<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Checkout extends REST_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->model('Common');
			$this->load->model('android/M_orders','order');
	}
	
    public function index_post()
	{   
	    date_default_timezone_set('Asia/Kolkata');
		$timestamp     = date('Y-m-d H:i:s');
		$date          = date('Y-m-d');
		$time          = date('h:i A');
		
		$token          = $this->security->xss_clean($this->input->post('device_token'));
		$address_id     = $this->security->xss_clean($this->input->post('address_id'));
        $restaurant_id  = $this->security->xss_clean($this->input->post('restaurant_id'));
    	$payment_method = $this->security->xss_clean($this->input->post('payment_method'));
    	$delivery_notes = $this->security->xss_clean($this->input->post('delivery_notes'));
    	$offer_code     = $this->security->xss_clean($this->input->post('offer_code'));
    	$branch_id      = $this->security->xss_clean($this->input->post('branch_id'));
    	$cutlery        = $this->security->xss_clean($this->input->post('no_Cutlery'));
    	$delivery_date  = $this->security->xss_clean($this->input->post('delivery_date'));
    	$delivery_time  = $this->security->xss_clean($this->input->post('delivery_time'));
    	$delivery_type  = $this->security->xss_clean($this->input->post('delivery_type'));
    	$delivery_charge= $this->security->xss_clean($this->input->post('delivery_charge'));
    	$service_charge = $this->security->xss_clean($this->input->post('service_charge'));
    	$subtotal       = $this->security->xss_clean($this->input->post('subtotal'));
    	$grandtotal     = $this->security->xss_clean($this->input->post('grandtotal'));
    	$block_no       = $this->security->xss_clean($this->input->post('block_no'));
    	
    	$check_block = $this->Common->get_details('blocks',array('block_name'=>$block_no));
        if($check_block->num_rows()>0)
        {
            $block_id  = $check_block->row()->block_id;
        }
        else
        {
            $block_id = 0;
        }
    	
    	$delivery_check  = $this->Common->get_details('branch_delivery_blocks',array('block_id'=>$block_id,'branch_id'=>$branch_id));
    	if($delivery_check->num_rows()>0)
    	{
    	    if($offer_code!='')
        	{
        	    $offer_type = 'offer';
        	}
        	else
        	{
        	    $offer_type = '';
        	}
        	if($cutlery=='1')
        	{
        	    $cutlery_status ='0';
        	}
        	else
        	{
        	    $cutlery_status ='1';
        	}
        	
        	if($delivery_type=='SelfPickup')
        	{
        	    $delivery_charge1 ='0';
        	}
        	else
        	{
        	    $delivery_charge1 = $delivery_charge;
        	}
        	
        	if($delivery_date!='')
        	{
        	    $order_type = 'scheduled';
        	}
        	else
        	{
        	    $order_type = 'normal';
        	}
        	$restaurant     = $this->Common->get_details('restaurants',array('r_id'=>$restaurant_id))->row();
        	
    		$header = $this->input->get_request_header('Authorization');
    	    if (count(explode(' ', $header)) > 1)
    	    {
    			$user_id = $this->decodeToken($header);
    			if ($user_id) 
    			{ 
                	$user_details   = $this->Common->get_details('users',array('user_id'=>$user_id))->row();
                	$fcm            = $user_details->fcm;
                	
            		$details        = $this->order->getCartData($user_id);
            		
            		if(count($details) != 0)
            		{
            		    $cart   = $this->Common->get_details('cart',array('user_id'=>$user_id))->result();
            		    $total  = 0;
            		    foreach($cart as $c)
            		    {
            		        if($c->type=='p')
            		        {
            		            $product_id      = $c->product_id;
            		            $price_id        = $c->price_id;
                		        $product         = $this->Common->get_details('products',array('p_id'=>$product_id))->row();
                		        $p_price         = $this->Common->get_details('product_price',array('price_id'=>$price_id))->row();
                		        $price           = $p_price->price;
                		        $quantity        = $c->quantity;
                		        $grand           = $price*$quantity;
                		        $extras          = $this->Common->get_details('sub_cart',array('cart_id'=>$c->cart_id))->result();
                		        $sub_total       = 0;
                		        foreach($extras as $extra)
                		        {
                		            $choice          = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
                		            $choice_cat      = $this->Common->get_details('product_choice_categories',array('pcat_id'=>$extra->cat_id))->row();
                		            $extra->cat_name = $choice_cat->cat_name;
                		            $extra->cat_value= $choice->name;
                		            $extra->price    = $choice->price;
                		            $extra->total    = $choice->price*$extra->quantity;
                		            $sub_total       = $sub_total+$extra->total;
                		        }
                                $total           = $total+$grand+$sub_total;
            		        }
            		        else
            		        {
            		            $product_id      = $c->product_id;
                		        $product         = $this->Common->get_details('extras',array('extra_id'=>$product_id))->row();
                		        $price           = $product->price;
                		        $quantity        = $c->quantity;
                		        $grand           = $price*$quantity;
                		        $total           = $total+$grand;
            		        }
            		        
            		    }
            		    
                		$order = [
                        			'user_id'        => $user_id,
                        			'r_id'           => $restaurant_id,
                        			'rest_name'      => $restaurant->rest_name,
                        			'branch_id'      => $branch_id,
                        			'cutlery'        => $cutlery_status,
                        			'total'          => $grandtotal,
                        			'payment_method' => $payment_method,
                        			'address_id'     => $address_id,
                        			'status'         => 'pending',
                        			'ordered_date'   => date('Y-m-d'),
                        			'ordered_time'   => $time,
                        			'delivery_notes' => $delivery_notes,
                        			'offer_code'     => $offer_code,
                        			'delivery_date'  => $delivery_date,
                        			'delivery_time'  => $delivery_time,
                        			'order_type'     => $order_type,
                        			'type'           => 'user',
                        			'delivery_type'  => $delivery_type,
                        			'delivery_charge'=> $delivery_charge1,
                        			'service_charge' => $service_charge,
                        			'subtotal'       => $subtotal,
                        			'offer_type'     => $offer_type,
                        			'timestamp'      => $timestamp
                        		];
            
                		if ($id = $this->Common->insert('orders',$order)) 
                		{  
                		    $cart   = $this->Common->get_details('cart',array('user_id'=>$user_id))->result();
                		    foreach($cart as $c)
                		    {
                		       if($c->type=='p')
                		       {
                		          $product    = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();  
                		          $p_price    = $this->Common->get_details('product_price',array('price_id'=>$c->price_id))->row(); 
                    		      $pr_array1  = [
                    		                        'order_id'    => $id,
                    		                        'product_id'  => $c->product_id,
                    		                        'price_id'    => $c->price_id,
                    		                        'product_name'=> $product->name,
                    		                        'price'       => $p_price->price,
                    		                        'quantity'    => $c->quantity,
                    		                        'total'       => $p_price->price*$c->quantity,
                    		                        'cart_id'     => $c->cart_id,
                    		                        'type'        => 'p',
                    		                        'timestamp'   => date('Y-m-d H:i:s')
                    		                    ];
                    		        $this->Common->insert('ordered_products',$pr_array1);
                    		        $extras          = $this->Common->get_details('sub_cart',array('cart_id'=>$c->cart_id))->result();
                    		        $sub_total       = 0;
                    		        foreach($extras as $extra)
                    		        {
                    		            $choice          = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
                    		            $choice_cat      = $this->Common->get_details('product_choice_categories',array('pcat_id'=>$extra->cat_id))->row();
                    		            $extra->cat_name = $choice_cat->cat_name;
                    		            $extra->cat_value= $choice->name;
                    		            $extra->price    = $choice->price;
                    		            $extra->total    = $choice->price*$extra->quantity;
                    		            $sub_array  = [
                    		                               'order_id'     => $id,
                    		                               'product_id'   => $extra->product_id,
                    		                               'cat_name'     => $extra->cat_name,
                    		                               'cat_value'    => $extra->cat_value,
                    		                               'price'        => $extra->price,
                    		                               'quantity'     => $extra->quantity,
                    		                               'total'        => $extra->total,
                    		                               'cart_id'      => $c->cart_id
                    		                          ];
                    		             $this->Common->insert('ordered_extras',$sub_array);                
                    		        }
                    		        
                    		        $this->Common->delete('cart',array('cart_id' => $c->cart_id));
                                    $this->Common->delete('sub_cart',array('cart_id' => $c->cart_id));
                		       } 
                               else
                               {
                                  $product    = $this->Common->get_details('extras',array('extra_id'=>$c->product_id))->row();   
                    		      $pr_array1  = [
                    		                        'order_id'    => $id,
                    		                        'product_id'  => $c->product_id,
                    		                        'product_name'=> $product->name,
                    		                        'price'       => $product->price,
                    		                        'quantity'    => $c->quantity,
                    		                        'total'       => $product->price*$c->quantity,
                    		                        'cart_id'     => $c->cart_id,
                    		                        'type'        => 'e',
                    		                        'timestamp'   => date('Y-m-d H:i:s')
                    		                    ];
                    		      $this->Common->insert('ordered_products',$pr_array1); 
                    		      
                    		      $this->Common->delete('cart',array('cart_id' => $c->cart_id));
                              }
                		        
                		    }
                		    
                		    if($offer_code!='')
                        	{
                        	    $voucher_array     = [
                            	                        'user_id'     => $user_id,
                            	                        'user_type'   => 'user',
                            	                        'offer_code'  => $offer_code,
                            	                        'timestamp'   => date('Y-m-d H:i:s')
                            	                    ];
                        	    $this->Common->insert('used_voucher',$voucher_array);              
                        	}
                        
                		    $address       = $this->Common->get_details('address',array('address_id'=>$address_id))->row();
                		    $address_array = [       
                		                             'order_id'   => $id,
                		                             'user_id'    => $user_id,
                                    			     'area'       => $address->area,
                                    			     'flat'       => $address->flat,
                                    			     'building_no'=> $address->building_no,
                                    			     'road_no'    => $address->road_no,
                                    			     'landmark'   => $address->landmark,
                                    			     'block'      => $address->block,
                                    			     'mobile'     => $address->mobile,
                                    			     'latitude'   => $address->latitude,
                                    			     'longitude'  => $address->longitude,
                                    			     'type'       => 'user',
                                    			     'timestamp'  => date('Y-m-d H:i:s')
                		                     ];
                		    $this->Common->insert('ordered_address',$address_array);
                		    
                		    $title = 'Order Placed!...';
                            $body   ='Your order placed succesfully!....';
                            if($this->sendNotification($title,$body,$fcm))
                            {
                                $not_array = [
                                             'user_id'  => $user_id,
                                             'order_id' => $id,
                                             'title'    => $title,
                                             'message'  => $body,
                                             'date'     => date('Y-m-d'),
                                             'time'     => date('h:i A'),
                                             'timestamp'=> date('Y-m-d H:i:s')
                                         ];
                		        $this->Common->insert('notifications',$not_array);
                            }
                            
                            $title1     = 'New Orders!...';
                            $body1      ='Your have a new order!....';
                            $restaurant = $this->Common->get_details('restaurants',array('r_id'=>$restaurant_id))->row();
                            $rest_fcm   = $restaurant->fcm;
                            if($this->sendRestaurantNotification($title1,$body1,$rest_fcm))
                            {
                                $not_rest_array = [
                                                     'r_id'     => $restaurant_id,
                                                     'order_id' => $id,
                                                     'title'    => $title1,
                                                     'message'  => $body1,
                                                     'date'     => date('Y-m-d'),
                                                     'time'     => date('h:i A'),
                                                     'timestamp'=> date('Y-m-d H:i:s')
                                                 ];
                		        $this->Common->insert('notifications',$not_rest_array);
                            }
                            
                    	    $this->response(array(
                            		              "status"  => true,
                            		              "message" => "Success",
                            		              'order_id'=> $id
                            		            ), REST_Controller::HTTP_OK);
                		}
                		else 
                		{
                			$this->response(array(
                            		               "status"  => false,
                            		               "message" => "Failed",
                            		               'order_id'=> ''
                            		              ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
                		}
            		}
                    else
                    {
                        $this->response(array(
                            		              "status" => false,
                            		              "message" => "Failed"
                            		            ), REST_Controller::HTTP_NOT_FOUND);
                    }
        		}
        		else
        		{
        			$this->response(array(
                            			    "status"  => false,
                            			    "message" => "Your session has expired, please login again"
                            		     ), REST_Controller::HTTP_UNAUTHORIZED);
        		}    
    	    }
    	    else
    	    {
    	         $guest_check  = $this->Common->get_details('guest',array('token'=>$token));
    	         if($guest_check->num_rows()>0)
    	         {
    	            $details        = $this->order->getGuestCartData($guest_check->row()->guest_id);
            		if(count($details) != 0)
            		{
            		    $cart   = $this->Common->get_details('guest_cart',array('guest_id'=>$guest_check->row()->guest_id))->result();
            		    $total  = 0;
            		    foreach($cart as $c)
            		    {
            		        if($c->type=='p')
            		        {
            		            $product_id      = $c->product_id;
            		            $price_id        = $c->price_id;
                		        $product         = $this->Common->get_details('products',array('p_id'=>$product_id))->row();
                		        $p_price         = $this->Common->get_details('product_price',array('price_id'=>$price_id))->row();
                		        $price           = $p_price->price;
                		        $quantity        = $c->quantity;
                		        $grand           = $price*$quantity;
                		        $extras          = $this->Common->get_details('guest_sub_cart',array('gcart_id'=>$c->gcart_id))->result();
                		        $sub_total       = 0;
                		        foreach($extras as $extra)
                		        {
                		            $choice          = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
                		            $choice_cat      = $this->Common->get_details('product_choice_categories',array('pcat_id'=>$extra->cat_id))->row();
                		            $extra->cat_name = $choice_cat->cat_name;
                		            $extra->cat_value= $choice->name;
                		            $extra->price    = $choice->price;
                		            $extra->total    = $choice->price*$extra->quantity;
                		            $sub_total  = $sub_total+$extra->total;
                		        }
                                $total           = $total+$grand+$sub_total;
            		        }
            		        else
            		        {
            		            $product_id      = $c->product_id;
                		        $product         = $this->Common->get_details('extras',array('extra_id'=>$product_id))->row();
                		        $price           = $product->price;
                		        $quantity        = $c->quantity;
                		        $grand           = $price*$quantity;
                		        $total           = $total+$grand;
            		        }
            		        
            		    }
            		    
                		$order = [
                        			'user_id'        => $guest_check->row()->guest_id,
                        			'r_id'           => $restaurant_id,
                        			'rest_name'      => $restaurant->rest_name,
                        			'branch_id'      => $branch_id,
                        			'cutlery'        => $cutlery_status,
                        			'total'          => $grandtotal,
                        			'payment_method' => $payment_method,
                        			'address_id'     => $address_id,
                        			'status'         => 'pending',
                        			'ordered_date'   => date('Y-m-d'),
                        			'ordered_time'   => $time,
                        			'delivery_notes' => $delivery_notes,
                        			'offer_code'     => $offer_code,
                        			'delivery_date'  => $delivery_date,
                        			'delivery_time'  => $delivery_time,
                        			'order_type'     => $order_type,
                        			'type'           => 'guest',
                        			'delivery_type'  => $delivery_type,
                        			'delivery_charge'=> $delivery_charge1,
                        			'service_charge' => $service_charge,
                        			'subtotal'       => $subtotal,
                        			'offer_type'     => $offer_type,
                        			'timestamp'      => $timestamp
                        		];
            
                		if ($id = $this->Common->insert('orders',$order)) 
                		{  
                		    $cart   = $this->Common->get_details('guest_cart',array('guest_id'=>$guest_check->row()->guest_id))->result();
                		    foreach($cart as $c)
                		    {
                		       if($c->type=='p')
                		       {
                		          $product    = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();  
                		          $p_price    = $this->Common->get_details('product_price',array('price_id'=>$c->price_id))->row(); 
                    		      $pr_array1  = [
                    		                        'order_id'    => $id,
                    		                        'product_id'  => $c->product_id,
                    		                        'price_id'    => $c->price_id,
                    		                        'product_name'=> $product->name,
                    		                        'price'       => $p_price->price,
                    		                        'quantity'    => $c->quantity,
                    		                        'total'       => $p_price->price*$c->quantity,
                    		                        'cart_id'     => $c->gcart_id,
                    		                        'type'        => 'p',
                    		                        'timestamp'   => date('Y-m-d H:i:s')
                    		                    ];
                    		        $this->Common->insert('ordered_products',$pr_array1);
                    		        $extras          = $this->Common->get_details('guest_sub_cart',array('gcart_id'=>$c->gcart_id))->result();
                    		        $sub_total       = 0;
                    		        foreach($extras as $extra)
                    		        {
                    		            $choice          = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
                    		            $choice_cat      = $this->Common->get_details('product_choice_categories',array('pcat_id'=>$extra->cat_id))->row();
                    		            $extra->cat_name = $choice_cat->cat_name;
                    		            $extra->cat_value= $choice->name;
                    		            $extra->price    = $choice->price;
                    		            $extra->total    = $choice->price*$extra->quantity;
                    		            $sub_array       = [
                        		                               'order_id'     => $id,
                        		                               'product_id'   => $extra->product_id,
                        		                               'cat_name'     => $extra->cat_name,
                        		                               'cat_value'    => $extra->cat_value,
                        		                               'price'        => $extra->price,
                        		                               'quantity'     => $extra->quantity,
                        		                               'total'        => $extra->total,
                        		                               'cart_id'      => $c->gcart_id
                        		                          ];
                    		             $this->Common->insert('ordered_extras',$sub_array);                
                    		        }
                    		        
                    		        $this->Common->delete('guest_cart',array('gcart_id' => $c->gcart_id));
                                    $this->Common->delete('guest_sub_cart',array('gcart_id' => $c->gcart_id));
                		       } 
                               else
                               {
                                  $product    = $this->Common->get_details('extras',array('extra_id'=>$c->product_id))->row();   
                    		      $pr_array1  = [
                    		                        'order_id'    => $id,
                    		                        'product_id'  => $c->product_id,
                    		                        'product_name'=> $product->name,
                    		                        'price'       => $product->price,
                    		                        'quantity'    => $c->quantity,
                    		                        'total'       => $product->price*$c->quantity,
                    		                        'cart_id'     => $c->gcart_id,
                    		                        'type'        => 'e',
                    		                        'timestamp'   => date('Y-m-d H:i:s')
                    		                    ];
                    		      $this->Common->insert('ordered_products',$pr_array1); 
                    		      
                    		      $this->Common->delete('guest_cart',array('gcart_id' => $c->gcart_id));
                              }
                		        
                		    }
                		    
                		    $address       = $this->Common->get_details('guest_address',array('ga_id'=>$address_id))->row();
                		    $address_array = [       
                		                             'order_id'   => $id,
                		                             'user_id'    => $guest_check->row()->guest_id,
                		                             'name'       => $address->name,
                                    			     'area'       => $address->area,
                                    			     'flat'       => $address->flat,
                                    			     'building_no'=> $address->building_no,
                                    			     'road_no'    => $address->road_no,
                                    			     'landmark'   => $address->landmark,
                                    			     'block'      => $address->block,
                                    			     'mobile'     => $address->mobile,
                                    			     'latitude'   => $address->latitude,
                                    			     'longitude'  => $address->longitude,
                                    			     'type'       => 'guest',
                                    			     'timestamp'  => date('Y-m-d H:i:s')
                		                     ];
                		    $this->Common->insert('ordered_address',$address_array);
                		    
                    	    $this->response(array(
                            		              "status"  => true,
                            		              "message" => "Success",
                            		              'order_id'=> $id
                            		            ), REST_Controller::HTTP_OK);
                		}
                		else 
                		{
                			$this->response(array(
                            		               "status"  => false,
                            		               "message" => "Failed",
                            		               'order_id'=> ''
                            		              ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
                		}
            		}
                    else
                    {
                        $this->response(array(
                            		              "status" => false,
                            		              "message" => "Failed"
                            		            ), REST_Controller::HTTP_NOT_FOUND);
                    }
    	         }
    	         else
    	         {
    	             $this->response(array(
                            			 "status"  => false,
                            			 "message" => "Your session has expired, please login again"
                            		   ), REST_Controller::HTTP_UNAUTHORIZED);
    	         }
    	    }
    	}
        else
        {
            $this->response(array(
                	              "status" => false,
                	              "message" => "Sorry! We don't deliver here.",
                	              'data'    => array(),
                	              'cuisines'=> array()
                	            ), REST_Controller::HTTP_OK); 
        }
	}

//************************************************** CHECK COUPON *************************************************************************************************//	
	public function checkCoupon_post()
	{   
	    $date       = date('Y-m-d');
	    $time       = date('H:i:s');
	    $current    = date('Y-m-d H:i:s');
	    
	    $offer_code = $this->security->xss_clean($this->input->post('offer_code'));
        $total      = $this->security->xss_clean($this->input->post('total'));
        $token      = $this->security->xss_clean($this->input->post('device_token'));
        
	    $header     = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
        	    $check      = $this->Common->get_details('coupons',array('offer_code'=>$offer_code,'status'=>'1'));
        	    if($check->num_rows()>0)
        	    {
        	        $coupon      = $check->row();
        	        $percentage  = $coupon->percentage;
        	        
        	        if($coupon->start_time!='00:00:00')
        	        {   
        	            $c_start  = $coupon->start_date.' '.$coupon->start_time;
        	            if($current>=$c_start)
            	        {
            	            $start_date = true;
            	        }
            	        else
            	        {
            	            $start_date = false;
            	        }
        	        }
        	        else
        	        {
        	            if($date>=$coupon->start_date)
            	        {
            	            $start_date  = true;
            	        }
            	        else
            	        {
            	            $start_date  = false;
            	        }
        	        }
        	        
        	        
        	        if($coupon->end_time!='00:00:00')
        	        {  
        	            $c_end  = $coupon->end_date.' '.$coupon->end_time;
            	        if($current<=$c_end)
            	        {
            	            $end_date  = true;
            	        }
            	        else
            	        {
            	            $end_date  = false;
            	        }
        	        }
        	        else
        	        {
        	            if($date<=$coupon->end_date)
            	        {
            	            $end_date  = true;
            	        }
            	        else
            	        {
            	            $end_date  = false;
            	        }
        	        }
        	        
        	        if($start_date && $end_date)
        	        {
        	            $voucher_check = $this->Common->get_details('used_voucher',array('user_id'=>$user_id,'offer_code'=>$offer_code,'user_type'=>'user'));
        	            if($voucher_check->num_rows()>0)
        	            {
        	                $this->response(array(
                                		              "status"   => false,
                                		              "message"  => 'Voucher is already used.',
                                		              'total'    => $total
                                		            ), REST_Controller::HTTP_OK);
        	            }
        	            else
        	            {
            	            if($coupon->max_value>$total)
            	            {
            	                $this->response(array(
                                    		              "status"   => false,
                                    		              "message"  => 'Minimum total must be BHD '.number_format($coupon->max_value,'3').' to use this voucher. Your total is BHD '.number_format($total,'3'),
                                    		              'total'    => $total
                                    		            ), REST_Controller::HTTP_OK); 
            	            }
            	            else
            	            {
            	                $grand    = $total-$total*$percentage/100;
                	            $this->response(array(
                                    		              "status"   => true,
                                    		              "message"  => $percentage.'% of coupon applied.',
                                    		              'total'    => number_format($grand,'2')
                                    		            ), REST_Controller::HTTP_OK); 
            	            }
        	            }           
        	        }
        	        else
        	        {
        	            $message    = 'Invalid coupon';
        	            
        	            $this->response(array(
                        		              "status"   => false,
                        		              "message"  => $message,
                        		              'total'    => $total
                        		            ), REST_Controller::HTTP_OK);                
        	        }
        	    }
        	    else
        	    {
        	       $this->response(array(
                            			   "status"  => false,
                            			   "message" => 'Invalid coupon',
                            			   'total'    => $total
                            			  ), REST_Controller::HTTP_NOT_FOUND);           
        	    }
			}
    		else
    		{
    			$this->response(array(
                        			    "status"  => false,
                        			    "message" => "Your session has expired, please login again"
                        		     ), REST_Controller::HTTP_UNAUTHORIZED);
    		}    
	    }
	    else
	    {
	         $guest_check   = $this->Common->get_details('guest',array('token'=>$token));
	         if($guest_check->num_rows()>0)
	         {
	            $check      = $this->Common->get_details('coupons',array('offer_code'=>$offer_code,'status'=>'1'));
        	    if($check->num_rows()>0)
        	    {
        	        $coupon      = $check->row();
        	        $percentage  = $coupon->percentage;
        	        
        	        if($coupon->start_time!='00:00:00')
        	        {   
        	            $c_start  = $coupon->start_date.' '.$coupon->start_time;
        	            if($current>=$c_start)
            	        {
            	            $start_date = true;
            	        }
            	        else
            	        {
            	            $start_date = false;
            	        }
        	        }
        	        else
        	        {
        	            if($date>=$coupon->start_date)
            	        {
            	            $start_date  = true;
            	        }
            	        else
            	        {
            	            $start_date  = false;
            	        }
        	        }
        	        
        	        
        	        if($coupon->end_time!='00:00:00')
        	        {  
        	            $c_end  = $coupon->end_date.' '.$coupon->end_time;
            	        if($current<=$c_end)
            	        {
            	            $end_date  = true;
            	        }
            	        else
            	        {
            	            $end_date  = false;
            	        }
        	        }
        	        else
        	        {
        	            if($date<=$coupon->end_date)
            	        {
            	            $end_date  = true;
            	        }
            	        else
            	        {
            	            $end_date  = false;
            	        }
        	        }
        	        
        	        if($start_date && $end_date)
        	        {
        	            $voucher_check = $this->Common->get_details('used_voucher',array('user_id'=>$guest_check->row()->guest_id,'offer_code'=>$offer_code,'user_type'=>'guest'));
        	            if($voucher_check->num_rows()>0)
        	            {
        	                $this->response(array(
                                		              "status"   => false,
                                		              "message"  => 'Voucher is already used.',
                                		              'total'    => $total
                                		            ), REST_Controller::HTTP_OK);
        	            }
        	            else
        	            {
        	                if($coupon->max_value>$total)
            	            {
            	                $this->response(array(
                                    		              "status"   => false,
                                    		              "message"  => 'Minimum total must be BHD '.number_format($coupon->max_value,'3').' to use this voucher. Your total is BHD '.number_format($total,'3'),
                                    		              'total'    => $total
                                    		            ), REST_Controller::HTTP_OK); 
            	            }
            	            else
            	            {
            	                $grand    = $total-$total*$percentage/100;
                	            $this->response(array(
                                    		              "status"   => true,
                                    		              "message"  => $percentage.'% of coupon applied.',
                                    		              'total'    => number_format($grand,'2')
                                    		            ), REST_Controller::HTTP_OK); 
            	            }
        	            }
        	        }
        	        else
        	        {
        	            $message    = 'Invalid coupon';
        	            
        	            $this->response(array(
                        		              "status"   => false,
                        		              "message"  => $message,
                        		              'total'    => $total
                        		            ), REST_Controller::HTTP_OK);                
        	        }
        	    }
        	    else
        	    {
        	       $this->response(array(
                            			   "status"  => false,
                            			   "message" => 'Invalid coupon',
                            			   'total'    => $total
                            			  ), REST_Controller::HTTP_NOT_FOUND);           
        	    }
	         }
	         else
	         {
	             $this->response(array(
                        			 "status"  => false,
                        			 "message" => "Your session has expired, please login again"
                        		   ), REST_Controller::HTTP_UNAUTHORIZED);
	         }
	    }    		    
	}
	
	
	public function sendNotification($title,$body,$fcm)
	{
	    $SERVER_API_KEY = "AAAAKjNFP5M:APA91bG4yMG9c0Y6NGPh2gMQT77gTT9cy-ZenigVrh5RZJfBUxZZZYgynM06KTTFrtxyBoFfjqef2VIfVVFPL-cnhgAgJwbzHWsQvmzShzg9lAXFK8emE6EjVILc99TzYA0f3rrXPgkU";
    	$header = [
    		'Authorization: key='. $SERVER_API_KEY,
    		'Content-Type: Application/json'
    	];
    	$msg = [
    		'title' => $title,
    		'body'  => $body
    	];
    	
    	$notification = [
    		'title'             => $title,
    		'body'              => $body,
    		'content_available' => true
    	];
    	
    	$payload = [
    		'data'         => $msg,
    		'notification' => $notification,
    		'to'           => $fcm,
    		'priority'     => 10
    	];
    	$url = 'https://fcm.googleapis.com/fcm/send';
    
    	$curl = curl_init();
    
    	curl_setopt_array($curl, array(
    		 CURLOPT_URL            => "https://fcm.googleapis.com/fcm/send",
    		 CURLOPT_RETURNTRANSFER => true,
    		 CURLOPT_CUSTOMREQUEST  => "POST",
    		 CURLOPT_POSTFIELDS     => json_encode($payload),
    		 CURLOPT_HTTPHEADER     => $header,
    	));
    
    	$response = curl_exec($curl);
    	$err = curl_error($curl);
    
    	curl_close($curl);
        
        return true;
	}
	
	public function sendRestaurantNotification($title,$body,$fcm)
	{
	    $SERVER_API_KEY = "AAAAKjNFP5M:APA91bG4yMG9c0Y6NGPh2gMQT77gTT9cy-ZenigVrh5RZJfBUxZZZYgynM06KTTFrtxyBoFfjqef2VIfVVFPL-cnhgAgJwbzHWsQvmzShzg9lAXFK8emE6EjVILc99TzYA0f3rrXPgkU";
    	$header = [
    		'Authorization: key='. $SERVER_API_KEY,
    		'Content-Type: Application/json'
    	];
    	$msg = [
    		'title' => $title,
    		'body'  => $body
    	];
    	
    	$notification = [
    		'title'             => $title,
    		'body'              => $body,
    		'content_available' => true
    	];
    	
    	$payload = [
    		'data'         => $msg,
    		'notification' => $notification,
    		'to'           => $fcm,
    		'priority'     => 10
    	];
    	$url = 'https://fcm.googleapis.com/fcm/send';
    
    	$curl = curl_init();
    
    	curl_setopt_array($curl, array(
    		 CURLOPT_URL            => "https://fcm.googleapis.com/fcm/send",
    		 CURLOPT_RETURNTRANSFER => true,
    		 CURLOPT_CUSTOMREQUEST  => "POST",
    		 CURLOPT_POSTFIELDS     => json_encode($payload),
    		 CURLOPT_HTTPHEADER     => $header,
    	));
    
    	$response = curl_exec($curl);
    	$err = curl_error($curl);
    
    	curl_close($curl);
        
        return true;
	}
	
	public function decodeToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h7';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}
	
	public function getExtras_post()
	{   
	    $token      = $this->security->xss_clean($this->input->post('device_token'));
	    $rest_id    = $this->security->xss_clean($this->input->post('restaurant_id'));

	    $header     = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
        	    $extras    = $this->order->getExtras($rest_id);
        	    foreach($extras as $extra)
        	    {
        	        $cart_check = $this->Common->get_details('cart',array('user_id'=>$user_id,'product_id'=>$extra->extra_id,'type'=>'e'));
        	        if($cart_check->num_rows()>0)
        	        {
        	            $extra->quantity  = $cart_check->row()->quantity;
        	        }
        	        else
        	        {
        	            $extra->quantity  = '0';
        	        }
        	    }
        	    $this->response(array(
                		              "status"   => true,
                		              "message"  => 'Success',
                		              'data'     => $extras
                		            ), REST_Controller::HTTP_OK); 
			}
    		else
    		{
    			$this->response(array(
                        			    "status"  => false,
                        			    "message" => "Your session has expired, please login again"
                        		     ), REST_Controller::HTTP_UNAUTHORIZED);
    		}    
	    }
	    else
	    {
	        $check_guest  = $this->Common->get_details('guest',array('token'=>$token));
            if($check_guest->num_rows()>0)
            {
                $extras    = $this->order->getExtras($rest_id);
        	    foreach($extras as $extra)
        	    {
        	        $cart_check = $this->Common->get_details('guest_cart',array('guest_id'=>$check_guest->row()->guest_id,'product_id'=>$extra->extra_id,'type'=>'e'));
        	        if($cart_check->num_rows()>0)
        	        {
        	            $extra->quantity  = $cart_check->row()->quantity;
        	        }
        	        else
        	        {
        	            $extra->quantity  = '0';
        	        }
        	    }
        	    $this->response(array(
                		              "status"   => true,
                		              "message"  => 'Success',
                		              'data'     => $extras
                		            ), REST_Controller::HTTP_OK); 
            }
            else
            {
                 $this->response(array(
                        			 "status"  => false,
                        			 "message" => "Your session has expired, please login again"
                        		   ), REST_Controller::HTTP_UNAUTHORIZED);
            }
	       
	    }    		            
	}
	
}
