<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Cart extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_products','products');
		$this->load->model('android/M_guest','guest');
	}
//*********************************** GET CART *************************************************************************************************************************************//	
	public function getData_get()
	{
	    date_default_timezone_set('Asia/Bahrain');
		$date       = date('Y-m-d');
	    $time       = date('H:i:s');
	    $current    = date('Y-m-d H:i:s');
	    
	    $uid        = $this->security->xss_clean($this->input->get('uid'));
	    $token      = $this->security->xss_clean($this->input->get('device_token'));
	    $header     = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
			        $cart_products   = $this->products->getCartProducts($user_id);
			        $cart_extras     = $this->products->getCartExtras($user_id);
        		    $cart            = array_merge($cart_products, $cart_extras);
        		    $total  = 0;
        		    foreach($cart as $c)
        		    {   
        		        if($c->type=='p')
        		        {
        		            $product         = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();
        		            $price_check     = $this->Common->get_details('product_price',array('price_id'=>$c->price_id));
        		            if($price_check->num_rows()>0)
        		            {
        		                $product_price   = $price_check->row();
        		                $c->price        = $product_price->price;
        		            }
        		            else
        		            {
        		                $c->price        = '0';
        		            }
            		        $restaurant        = $this->Common->get_details('restaurants',array('r_id'=>$product->r_id))->row();
            		        $c->restaurant     = $restaurant->rest_name;
            		        $c->product_name   = $product->name;
            		        $c->r_id           = $product->r_id;
            		        $c->image          = $product->cover_image;
            		        $c->min_order      = $restaurant->min_order;
            		        $c->service_charge = $restaurant->service_charge;
            		        $c->delivery_charge= $restaurant->delivery_charge;
            		        
            		        $offerCheck      = $this->products->checkProductOffer($product->p_id,$date);
            		        if($offerCheck->num_rows()>0)
            		        {
            		          $offer                     = $offerCheck->row();
            		          $percentage                = $offer->percentage;
            		          $price                     = $c->price*$percentage/100;
            		          $c->offer_price            = number_format($c->price-$price,'2');
            		          $c->offer_percentage       = $percentage;
            		          $c->price                  = $c->offer_price;
            		        }
            		        else
            		        {
            		           $c->offer_price            = '';
            		           $c->offer_percentage       = '';
            		           $c->price                  = $c->price;
            		        }
            		        $cart_total      = $c->price*$c->quantity;
            		        $grand           = $cart_total;
            		        $extras          = $this->Common->get_details('sub_cart',array('cart_id'=>$c->cart_id))->result();
            		        $sub_total       = 0;
            		        $single          = 0;
            		        foreach($extras as $extra)
            		        {
            		            $choice          = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
            		            $choice_cat      = $this->Common->get_details('product_choice_categories',array('pcat_id'=>$extra->cat_id))->row();
            		            if($choice_cat){
            		                $extra->cat_name = $choice_cat->cat_name;
            		            } else {
            		                $extra->cat_name = '';
            		            }
            		            if($choice) {
            		                $extra->cat_value= $choice->name;
                		            $extra->price    = $choice->price;
                		            $extra->total    = $choice->price*$extra->quantity;
                		            $sub_total       = $sub_total+$extra->total;
                		            $single          = $single+$choice->price;
            		            } else {
            		                $extra->cat_value= '';
                		            $extra->price    = '';
                		            $extra->total    = $extra->quantity;
                		            $sub_total       = $sub_total+$extra->total;
                		            $single          = $single;
            		            }
            		            
            		        }
            		        $c->extras       = $extras;
            		        $c->extra_total  = number_format($sub_total,'2');
            		        $total           = $total+$grand+$sub_total;
            		        $total2          = $grand+$sub_total;
            		        $c->total        =  number_format($total2,'2');
            		        $c->singl_price  =  number_format($c->price+$single,'2');
        		        }
        		        else
        		        {
        		            $extras          = $this->Common->get_details('extras',array('extra_id'=>$c->product_id))->row();
            		        $restaurant      = $this->Common->get_details('restaurants',array('r_id'=>$extras->r_id))->row();
            		        $c->restaurant   = $restaurant->rest_name;
            		        $c->product_name = $extras->name;
            		        $c->r_id         = $extras->r_id;
            		        $c->image        = $extras->image;
            		        $c->price        = $extras->price;
            		        $cart_total      = $extras->price*$c->quantity;
            		        $grand           = $cart_total;
            		        
            		        $c->min_order      = $restaurant->min_order;
            		        $c->service_charge = $restaurant->service_charge;
            		        $c->delivery_charge= $restaurant->delivery_charge;
    
            		        $total         = $total+$grand;
            		        $c->singl_price= number_format($c->price,'2');
            		        $c->total      = number_format($cart_total,'2');
            		        $c->extras     = array();
            		        $c->extra_total= '';
        		        }
        		    }
    
                    $this->response(array(
                        		              "status"  => true,
                        		              "message" => "Success",
                        					  "data"    => $cart,
                        					  'total'   => number_format($total,'2')
                        		            ), REST_Controller::HTTP_OK);		
			    }
			    else
			    {
			        $this->response(array(
                                			  "status"  => false,
                                			  "message" => "Your session has expired, please login again"
                                			), REST_Controller::HTTP_UNAUTHORIZED);
			    }
    		}
    		
    		else
    		{
    			$this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	        $check_guest= $this->Common->get_details('guest',array('token'=>$token));
            if($check_guest->num_rows()>0)
            {
                $cart_guest_products = $this->products->getGuestCartProducts($check_guest->row()->guest_id);
                $cart_guest_extras   = $this->products->getGuestCartExtras($check_guest->row()->guest_id);
                $cart                = array_merge($cart_guest_products, $cart_guest_extras);
    		    $total  = 0;
    		    foreach($cart as $c)
    		    {   
    		        if($c->type=='p')
    		        {
    		            $product         = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();
    		            $price_check     = $this->Common->get_details('product_price',array('price_id'=>$c->price_id));
    		            if($price_check->num_rows()>0)
    		            {
    		                $product_price   = $price_check->row();
    		                $c->price        = $product_price->price;
    		            }
    		            else
    		            {
    		                $c->price        = '0';
    		            }
        		        $restaurant      = $this->Common->get_details('restaurants',array('r_id'=>$product->r_id))->row();
        		        $c->restaurant   = $restaurant->rest_name;
        		        $c->product_name = $product->name;
        		        $c->r_id         = $product->r_id;
        		        $c->image        = $product->cover_image;
        		        $c->min_order    = $restaurant->min_order;
        		        $c->service_charge = $restaurant->service_charge;
        		        $c->delivery_charge= $restaurant->delivery_charge;
        		        
        		        $offerCheck      = $this->products->checkProductOffer($product->p_id,$date);
        		        if($offerCheck->num_rows()>0)
        		        {
        		          $offer                     = $offerCheck->row();
        		          $percentage                = $offer->percentage;
        		          $price                     = $c->price*$percentage/100;
        		          $c->offer_price            = number_format($c->price-$price,'2');
        		          $c->offer_percentage       = $percentage;
        		          $c->price                  = $c->offer_price;
        		        }
        		        else
        		        {
        		           $c->offer_price            = '';
        		           $c->offer_percentage       = '';
        		           $c->price                  = $c->price;
        		        }
        		        $cart_total      = $c->price*$c->quantity;
        		        $grand           = $cart_total;
        		        $extras          = $this->Common->get_details('guest_sub_cart',array('gcart_id'=>$c->gcart_id))->result();
        		        $sub_total       = 0;
        		        $single          = 0;
        		        foreach($extras as $extra)
        		        {
        		            $choice          = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
        		            $choice_cat      = $this->Common->get_details('product_choice_categories',array('pcat_id'=>$extra->cat_id))->row();
        		            $extra->cat_name = $choice_cat->cat_name;
        		            $extra->cat_value= $choice->name;
        		            $extra->price    = $choice->price;
        		            $extra->total    = $choice->price*$extra->quantity;
        		            $sub_total       = $sub_total+$extra->total;
        		            $single          = $single+$choice->price;
        		        }
        		        $c->extras       = $extras;
        		        $c->extra_total  = number_format($sub_total,'2');
        		        $total           = $total+$grand+$sub_total;
        		        $total2          = $grand+$sub_total;
        		        $c->total        =  number_format($total2,'2');
        		        $c->singl_price  =  number_format($c->price+$single,'2');
    		        }
    		        else
    		        {
    		            $extras          = $this->Common->get_details('extras',array('extra_id'=>$c->product_id))->row();
        		        $restaurant      = $this->Common->get_details('restaurants',array('r_id'=>$extras->r_id))->row();
        		        $c->restaurant   = $restaurant->rest_name;
        		        $c->product_name = $extras->name;
        		        $c->r_id         = $extras->r_id;
        		        $c->image        = $extras->image;
        		        $c->price        = $extras->price;
        		        $cart_total      = $extras->price*$c->quantity;
        		        $grand           = $cart_total;
        		        
        		      //  $c->min_order      = $restaurant->min_order;
        		      //  $c->service_charge = $restaurant->service_charge;
        		      //  $c->delivery_charge= $restaurant->delivery_charge;
    
        		        $total = $total+$grand;
        		        $c->singl_price=  number_format($c->price,'2');
        		        $c->total      =  number_format($cart_total,'2');
        		        $c->extras     = array();
        		        $c->extra_total= '';
    		        }
    		    }
    
                $this->response(array(
                    		              "status"  => true,
                    		              "message" => "Success",
                    					  "data"    => $cart,
                    					  'total'   => number_format($total,'2')
                    		            ), REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
            }
	    }
	    
	}

//************************************** ADD **************************************************************************************************************************************//	
	public function add_post()
	{
	    $uid         = $this->security->xss_clean($this->input->post('uid'));
	    $token       = $this->security->xss_clean($this->input->post('device_token'));
	    
	    $product_id  = $this->security->xss_clean($this->input->post('product_id'));
		$price_id    = $this->security->xss_clean($this->input->post('price_id'));
		$quantity    = $this->security->xss_clean($this->input->post('quantity'));
		$notes       = $this->security->xss_clean($this->input->post('special_request'));
		$branch_id   = $this->security->xss_clean($this->input->post('branch_id'));
		$choices     = $this->security->xss_clean($this->input->post('choices'));
        $json        = json_decode($choices, true);
                    
	    $header     = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
                    $product = $this->Common->get_details('products',array('p_id'=>$product_id))->row();
                    $product_price   = $this->Common->get_details('product_price',array('price_id'=>$price_id))->row();
            	    $price   = $product_price->price;
            	    $total   = $price*$quantity;
        
            		$item        = [
                    			     'user_id'     => $user_id,
                    			     'product_id'  => $product_id,
                    			     'price_id'    => $price_id
                    		       ];
            	    $restaurant_id = $this->Common->get_details('products',array('p_id'=>$product_id))->row()->r_id;
            	    $cart_check    = $this->products->cartCheck($restaurant_id,$user_id);
            	    if($cart_check==0)
            	    {      
            		    $check   = $this->Common->get_details('cart',$item);
                		if ($check->num_rows() > 0) 
                		{
                			$cart_id = $check->row()->cart_id;
                			if($this->Common->update('cart_id',$cart_id,'cart',array('quantity' => $quantity)))
                			{
                			    $this->Common->delete('sub_cart',array('cart_id' => $cart_id));
                			    
                			    $elementCount  = count($json);
                                for ($i=0;$i < $elementCount; $i++) 
                                {
                                    $cat_name      =  $json[$i]['pcat_id'];
                                    $cat_values    =  $json[$i]['choice_values'];
                                    $elementCount1 = count($cat_values);
                                    for ($j=0;$j < $elementCount1; $j++)
                                    {
                                        $value_array   = [    
                                                             'cart_id'      => $cart_id,
                                                             'product_id'   => $product_id,
                                                             'price_id'     => $price_id,
                                                             'cat_id'       => $cat_name,
                                                             'val_id'       => $cat_values[$j]['pchoice_id'],
                                                             'quantity'     => $quantity,
                                                         ];
                                        $this->Common->insert('sub_cart',$value_array);                
                                    }
                                }
                			}
                		}
                		else 
                		{
                			$item['quantity']   = $quantity;
                			$item['notes']      = $notes;
                			$item['date']       = date('Y-m-d');
                    		$item['time']       = date('h:i A');
                    		$item['branch_id']  = $branch_id;
                    		$item['r_id']       = $restaurant_id; 
                    		
                			if($id=$this->Common->insert('cart',$item))
                			{
                			    $elementCount  = count($json);
                                for ($i=0;$i < $elementCount; $i++) 
                                {
                                    $cat_name      =  $json[$i]['pcat_id'];
                                    $cat_values    =  $json[$i]['choice_values'];
                                    $elementCount1 = count($cat_values);
                                    for ($j=0;$j < $elementCount1; $j++)
                                    {
                                        $value_array   = [    
                                                             'cart_id'      => $id,
                                                             'product_id'   => $product_id,
                                                             'price_id'     => $price_id,
                                                             'cat_id'       => $cat_name,
                                                             'val_id'       => $cat_values[$j]['pchoice_id'],
                                                             'quantity'     => $quantity
                                                         ];
                                        $this->Common->insert('sub_cart',$value_array);                
                                    }
                                    // print_r($elementCount1);
                                }
                			}
                		} 
                		
                	   $this->response(array(
                        		              "status"  => true,
                        		              "message" => "Success"
                        		            ), REST_Controller::HTTP_OK);	
            	     }
            	     else
            	     {
            	        $this->response(array(
                            		              "status"  => false,
                            		              "message" => "Failed to add product to cart"
                            		            ), REST_Controller::HTTP_OK);	
            	     }
			    }
        	    else
			    {
			        $this->response(array(
                                			  "status"  => false,
                                			  "message" => "Your session has expired, please login again"
                                			), REST_Controller::HTTP_UNAUTHORIZED);
			    }
    		}
    		else
    		{
    			$this->response(array(
                        			    "status"  => false,
                        			    "message" => "Your session has expired, please login again"
                        			  ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	         $guest_check    = $this->Common->get_details('guest',array('token'=>$token));
	         if($guest_check->num_rows()>0)
	         {      
	                $guest_id    = $guest_check->row()->guest_id;
	               
                    $product = $this->Common->get_details('products',array('p_id'=>$product_id))->row();
            	    $price   = $product->price;
            	    $total   = $price*$quantity;
        
            		$item        = [
                    			     'guest_id'     => $guest_id,
                    			     'product_id'   => $product_id,
                    			     'price_id'     => $price_id
                    		       ];
            	    $restaurant_id = $this->Common->get_details('products',array('p_id'=>$product_id))->row()->r_id;
            	    $cart_check    = $this->guest->cartCheck($restaurant_id,$guest_id);
            	    if($cart_check==0)
            	    {      
            		    $check   = $this->Common->get_details('guest_cart',$item);
                		if ($check->num_rows() > 0) 
                		{
                			$cart_id = $check->row()->gcart_id;
                			if($this->Common->update('gcart_id',$cart_id,'guest_cart',array('quantity' => $quantity)))
                			{
                			    $this->Common->delete('guest_sub_cart',array('gcart_id' => $cart_id));
                			    
                			    $elementCount  = count($json);
                                for ($i=0;$i < $elementCount; $i++) 
                                {
                                    $cat_name      =  $json[$i]['pcat_id'];
                                    $cat_values    =  $json[$i]['choice_values'];
                                    $elementCount1 = count($cat_values);
                                    for ($j=0;$j < $elementCount1; $j++)
                                    {
                                        $value_array   = [    
                                                             'gcart_id'      => $cart_id,
                                                             'product_id'   => $product_id,
                                                             'cat_id'        => $cat_name,
                                                             'val_id'       => $cat_values[$j]['pchoice_id'],
                                                             'quantity'     => $quantity,
                                                         ];
                                        $this->Common->insert('guest_sub_cart',$value_array);                
                                    }
                                }
                			}
                		}
                		else 
                		{
                			$item['quantity']   = $quantity;
                			$item['notes']      = $notes;
                			$item['date']       = date('Y-m-d');
                    		$item['time']       = date('h:i A');
                    		$item['branch_id']  = $branch_id;
                    		$item['r_id']       = $restaurant_id; 
                    		
                			if($id=$this->Common->insert('guest_cart',$item))
                			{
                			    $elementCount  = count($json);
                                for ($i=0;$i < $elementCount; $i++) 
                                {
                                    $cat_name      =  $json[$i]['pcat_id'];
                                    $cat_values    =  $json[$i]['choice_values'];
                                    $elementCount1 = count($cat_values);
                                    for ($j=0;$j < $elementCount1; $j++)
                                    {
                                        $value_array   = [    
                                                             'gcart_id'      => $id,
                                                             'product_id'   => $product_id,
                                                             'cat_id'        => $cat_name,
                                                             'val_id'       => $cat_values[$j]['pchoice_id'],
                                                             'quantity'     => $quantity,
                                                         ];
                                        $this->Common->insert('guest_sub_cart',$value_array);                
                                    }
                                }
                			}
                		} 
                		
                	   $this->response(array(
                        		              "status"  => true,
                        		              "message" => "Success"
                        		            ), REST_Controller::HTTP_OK);	
            	     }
            	     else
            	     {
            	        $this->response(array(
                            		              "status"  => false,
                            		              "message" => "Failed to add product to cart"
                            		            ), REST_Controller::HTTP_OK);	
            	     }
	         }
	         else
	         {
	             $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
	         }
	    }
	}

//********************************************** DELETE ****************************************************************************************************************************//	
	public function deleteCartData_post()
	{   
	    $date     = date('Y-m-d'); 
	    $uid      = $this->security->xss_clean($this->input->post('uid'));
	    $token    = $this->security->xss_clean($this->input->post('device_token'));
	    $type     = $this->security->xss_clean($this->input->post('type'));
        $cart_id  = $this->security->xss_clean($this->input->post('cart_id'));
        
	    $header   = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{  
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
            	    if($type=='product')
            	    {
                	    if($this->Common->delete('cart',array('cart_id' => $cart_id)))
                	    {
                	        $this->Common->delete('sub_cart',array('cart_id' => $cart_id));
                	        
                	        $cart_products   = $this->products->getCartProducts($user_id);
        			        $cart_extras     = $this->products->getCartExtras($user_id);
                		    $cart            = array_merge($cart_products, $cart_extras);
                		    $total  = 0;
                		    foreach($cart as $c)
                		    {   
                		        if($c->type=='p')
                		        {
                		            $product         = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();
                		            $product_price   = $this->Common->get_details('product_price',array('price_id'=>$c->price_id))->row();
                    		        $c->product_name = $product->name;
                    		        $c->image        = $product->cover_image;
                    		        
                    		        $offerCheck      = $this->products->checkProductOffer($product->p_id,$date);
                    		        if($offerCheck->num_rows()>0)
                    		        {
                    		          $offer                     = $offerCheck->row();
                    		          $percentage                = $offer->percentage;
                    		          $price                     = $product_price->price*$percentage/100;
                    		          $c->offer_price            = number_format($product_price->price-$price,'2');
                    		          $c->offer_percentage       = $percentage;
                    		          $c->price                  = $c->offer_price;
                    		        }
                    		        else
                    		        {
                    		           $c->offer_price            = '';
                    		           $c->offer_percentage       = '';
                    		           $c->price                  = $product_price->price;
                    		        }
                    		        $cart_total      = $c->price*$c->quantity;
                    		        $grand           = $cart_total;
                    		        $extras          = $this->Common->get_details('sub_cart',array('cart_id'=>$c->cart_id))->result();
                    		        $sub_total       = 0;
                    		        $single          = 0;
                    		        foreach($extras as $extra)
                    		        {
                    		            $choice          = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
                    		            $choice_cat      = $this->Common->get_details('product_choice_categories',array('pcat_id'=>$extra->cat_id))->row();
                    		            $extra->cat_name = $choice_cat->cat_name;
                    		            $extra->cat_value= $choice->name;
                    		            $extra->price    = $choice->price;
                    		            $extra->total    = $choice->price*$extra->quantity;
                    		            $sub_total       = $sub_total+$extra->total;
                    		            $single          = $single+$choice->price;
                    		        }
                    		        $c->extras       = $extras;
                    		        $c->extra_total  = number_format($sub_total,'2');
                    		        $total           = $total+$grand+$sub_total;
                    		        $total2          = $grand+$sub_total;
                    		        $c->total        =  number_format($total2,'2');
                    		        
                    		      //  $c->price        = $product_price->price;
                    		      //  $c->total        = number_format($c->price*$c->quantity,'2');
                    		      //  $grand           = $c->total;
                    		      //  $extras          = $this->Common->get_details('sub_cart',array('cart_id'=>$c->cart_id))->result();
                    		      //  $sub_total       = 0;
                    		      //  foreach($extras as $extra)
                    		      //  {
                    		      //      $choice       = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
                		          //      $extra->total = $choice->price*$extra->quantity;
                    		      //      $sub_total  = $sub_total+$extra->total;
                    		      //  }
                    		      //  $total           = $total+$grand+$sub_total;
                		        }
                		        else
                		        {
                		            $product         = $this->Common->get_details('extras',array('extra_id'=>$c->product_id))->row();
                    		        $c->product_name = $product->name;
                    		        $c->image        = $product->image;
                    		        $c->price        = $product->price;
                    		        $c->total        = number_format($c->price*$c->quantity,'2');
                    		        $grand           = $c->total;
                    		        $total           = $total+$grand;
                		        }
                		    }
                	        
                	        $this->response(array(
                                		              "status"  => true,
                                		              "message" => "success",
                                		              'total'   => number_format($total,'2'),
                                		            ), REST_Controller::HTTP_OK);
                	    }
                	    else
                	    {
                	       $this->response(array(
                                		              "status" => false,
                                		              "message" => "Failed"
                                		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
                	    }
            	    }
            	    else
            	    {
            	        if($this->Common->delete('cart',array('cart_id' => $cart_id)))
                	    {
                	        $cart_products   = $this->products->getCartProducts($user_id);
        			        $cart_extras     = $this->products->getCartExtras($user_id);
                		    $cart            = array_merge($cart_products, $cart_extras);
                		    $total  = 0;
                		    foreach($cart as $c)
                		    {   
                		        if($c->type=='p')
                		        {
                		            $product         = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();
                		            $product_price   = $this->Common->get_details('product_price',array('price_id'=>$c->price_id))->row();
                    		        $c->product_name = $product->name;
                    		        $c->image        = $product->cover_image;
                    		        
                    		        $offerCheck      = $this->products->checkProductOffer($product->p_id,$date);
                    		        if($offerCheck->num_rows()>0)
                    		        {
                    		          $offer                     = $offerCheck->row();
                    		          $percentage                = $offer->percentage;
                    		          $price                     = $product_price->price*$percentage/100;
                    		          $c->offer_price            = number_format($product_price->price-$price,'2');
                    		          $c->offer_percentage       = $percentage;
                    		          $c->price                  = $c->offer_price;
                    		        }
                    		        else
                    		        {
                    		           $c->offer_price            = '';
                    		           $c->offer_percentage       = '';
                    		           $c->price                  = $product_price->price;
                    		        }
                    		        $cart_total      = $c->price*$c->quantity;
                    		        $grand           = $cart_total;
                    		        $extras          = $this->Common->get_details('sub_cart',array('cart_id'=>$c->cart_id))->result();
                    		        $sub_total       = 0;
                    		        $single          = 0;
                    		        foreach($extras as $extra)
                    		        {
                    		            $choice          = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
                    		            $choice_cat      = $this->Common->get_details('product_choice_categories',array('pcat_id'=>$extra->cat_id))->row();
                    		            $extra->cat_name = $choice_cat->cat_name;
                    		            $extra->cat_value= $choice->name;
                    		            $extra->price    = $choice->price;
                    		            $extra->total    = $choice->price*$extra->quantity;
                    		            $sub_total       = $sub_total+$extra->total;
                    		            $single          = $single+$choice->price;
                    		        }
                    		        $c->extras       = $extras;
                    		        $c->extra_total  = number_format($sub_total,'2');
                    		        $total           = $total+$grand+$sub_total;
                    		        $total2          = $grand+$sub_total;
                    		        $c->total        =  number_format($total2,'2');
                    		        
                    		      //  $c->price        = $product_price->price;
                    		      //  $c->total        = number_format($c->price*$c->quantity,'2');
                    		      //  $grand           = $c->total;
                    		      //  $extras          = $this->Common->get_details('sub_cart',array('cart_id'=>$c->cart_id))->result();
                    		      //  $sub_total       = 0;
                    		      //  foreach($extras as $extra)
                    		      //  {
                    		      //      $choice       = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
                		          //      $extra->total = $choice->price*$extra->quantity;
                    		      //      $sub_total  = $sub_total+$extra->total;
                    		      //  }
                    		      //  $total           = $total+$grand+$sub_total;
                		        }
                		        else
                		        {
                		            $product         = $this->Common->get_details('extras',array('extra_id'=>$c->product_id))->row();
                    		        $c->product_name = $product->name;
                    		        $c->image        = $product->image;
                    		        $c->price        = $product->price;
                    		        $c->total        = number_format($c->price*$c->quantity,'2');
                    		        $grand           = $c->total;
                    		        $total           = $total+$grand;
                		        }
                		    }
                	        
                	        $this->response(array(
                                		              "status"  => true,
                                		              "message" => "success",
                                		              'total'   => number_format($total,'2'),
                                		            ), REST_Controller::HTTP_OK);
                	    }
                	    else
                	    {
                	       $this->response(array(
                                		              "status" => false,
                                		              "message" => "Failed"
                                		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
                	    }
            	    }
			    }
        	    else
			    {
			        $this->response(array(
                                			  "status"  => false,
                                			  "message" => "Your session has expired, please login again"
                                			), REST_Controller::HTTP_UNAUTHORIZED);
			    }
    		}
    		else
    		{
    			$this->response(array(
                        			   "status"  => false,
                        			   "message" => "Your session has expired, please login again"
                        			 ), REST_Controller::HTTP_UNAUTHORIZED);
    		}  
	    }
	    else
	    {
	        $guest_check    = $this->Common->get_details('guest',array('token'=>$token));
	        if($guest_check->num_rows()>0)
	        {
        	    if($type=='product')
        	    {
        	        if($this->Common->delete('guest_cart',array('gcart_id' => $cart_id)))
            	    {
            	        $this->Common->delete('guest_sub_cart',array('gcart_id' => $cart_id));
            	        
            	        $cart_guest_products = $this->products->getGuestCartProducts($guest_check->row()->guest_id);
                        $cart_guest_extras   = $this->products->getGuestCartExtras($guest_check->row()->guest_id);
                        $cart                = array_merge($cart_guest_products, $cart_guest_extras);
            		    $total  = 0;
            		    foreach($cart as $c)
            		    {   
            		        if($c->type=='p')
            		        {
                		        $product         = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();
                		        $product_price   = $this->Common->get_details('product_price',array('price_id'=>$c->price_id))->row();
                		        $c->product_name = $product->name;
                		        $c->r_id         = $product->r_id;
                		        $c->image        = $product->cover_image;
                		        
                		        $offerCheck      = $this->products->checkProductOffer($product->p_id,$date);
                		        if($offerCheck->num_rows()>0)
                		        {
                		          $offer                     = $offerCheck->row();
                		          $percentage                = $offer->percentage;
                		          $price                     = $product_price->price*$percentage/100;
                		          $c->offer_price            = number_format($product_price->price-$price,'2');
                		          $c->offer_percentage       = $percentage;
                		          $c->price                  = $c->offer_price;
                		        }
                		        else
                		        {
                		           $c->offer_price            = '';
                		           $c->offer_percentage       = '';
                		           $c->price                  = $product_price->price;
                		        }
                		        $cart_total      = $c->price*$c->quantity;
                		        $grand           = $cart_total;
                		        $extras          = $this->Common->get_details('guest_sub_cart',array('gcart_id'=>$c->gcart_id))->result();
                		        $sub_total       = 0;
                		        $single          = 0;
                		        foreach($extras as $extra)
                		        {
                		            $choice          = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
                		            $choice_cat      = $this->Common->get_details('product_choice_categories',array('pcat_id'=>$extra->cat_id))->row();
                		            $extra->cat_name = $choice_cat->cat_name;
                		            $extra->cat_value= $choice->name;
                		            $extra->price    = $choice->price;
                		            $extra->total    = $choice->price*$extra->quantity;
                		            $sub_total       = $sub_total+$extra->total;
                		            $single          = $single+$choice->price;
                		        }
                		        $c->extras       = $extras;
                		        $c->extra_total  = number_format($sub_total,'2');
                		        $total           = $total+$grand+$sub_total;
                		        $total2          = $grand+$sub_total;
                		        $c->total        =  number_format($total2,'2');
                		        $c->singl_price  =  number_format($c->price+$single,'2');
                		        
                		      //  $c->price        = $product_price->price;
                		      //  $cart_total      = number_format($c->price*$c->quantity,'2');
                		      //  $grand           = $cart_total;
                		      //  $c->total        =  number_format($cart_total,'2');
                		        
                		      //  $extras          = $this->Common->get_details('guest_sub_cart',array('gcart_id'=>$c->gcart_id))->result();
                		      //  $sub_total       = 0;
                		      //  $single          = 0;
                		      //  foreach($extras as $extra)
                		      //  {   
                		      //      $choice       = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
                		      //      $extra->total = $choice->price*$extra->quantity;
                		      //      $sub_total    = $sub_total+$extra->total;
                		      //      $single       = $single+$choice->price;
                		      //  }
                		      //  $total           = $total+$grand+$sub_total;
                		      //  $c->singl_price  = number_format($c->price+$single,'2');
            		        }
            		        else
            		        {
            		            $extras          = $this->Common->get_details('extras',array('extra_id'=>$c->product_id))->row();
                		        $restaurant      = $this->Common->get_details('restaurants',array('r_id'=>$extras->r_id))->row();
                		        $c->restaurant   = $restaurant->rest_name;
                		        $c->product_name = $extras->name;
                		        $c->r_id         = $extras->r_id;
                		        $c->image        = $extras->image;
                		        $c->price        = $extras->price;
                		        $cart_total      = $extras->price*$c->quantity;
                		        $grand           = $cart_total;
        
                		        $total = $total+$grand;
                		        $c->singl_price=  number_format($c->price,'2');
                		        $c->total      =  number_format($cart_total,'2');
            		        }
            		    }
            	        
            	        $this->response(array(
                            		              "status"  => true,
                            		              "message" => "success",
                            		              'total'   => number_format($total,'2'),
                            		            ), REST_Controller::HTTP_OK);
            	    }
            	    else
            	    {
            	       $this->response(array(
                            		              "status" => false,
                            		              "message" => "Failed"
                            		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
            	    }
        	    }
        	    else
        	    {
        	        if($this->Common->delete('guest_cart',array('gcart_id' => $cart_id)))
            	    {
            	        $cart   = $this->products->getGuestCartProducts($guest_check->row()->guest_id);
            		    $total  = 0;
            		    foreach($cart as $c)
            		    {   
            		        if($c->type=='p')
            		        {
                		        $product         = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();
                		        $product_price   = $this->Common->get_details('product_price',array('price_id'=>$c->price_id))->row();
                		        $c->product_name = $product->name;
                		        $c->r_id         = $product->r_id;
                		        $c->image        = $product->cover_image;
                		        
                		        $offerCheck      = $this->products->checkProductOffer($product->p_id,$date);
                		        if($offerCheck->num_rows()>0)
                		        {
                		          $offer                     = $offerCheck->row();
                		          $percentage                = $offer->percentage;
                		          $price                     = $product_price->price*$percentage/100;
                		          $c->offer_price            = number_format($product_price->price-$price,'2');
                		          $c->offer_percentage       = $percentage;
                		          $c->price                  = $c->offer_price;
                		        }
                		        else
                		        {
                		           $c->offer_price            = '';
                		           $c->offer_percentage       = '';
                		           $c->price                  = $product_price->price;
                		        }
                		        $cart_total      = $c->price*$c->quantity;
                		        $grand           = $cart_total;
                		        $extras          = $this->Common->get_details('guest_sub_cart',array('gcart_id'=>$c->gcart_id))->result();
                		        $sub_total       = 0;
                		        $single          = 0;
                		        foreach($extras as $extra)
                		        {
                		            $choice          = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
                		            $choice_cat      = $this->Common->get_details('product_choice_categories',array('pcat_id'=>$extra->cat_id))->row();
                		            $extra->cat_name = $choice_cat->cat_name;
                		            $extra->cat_value= $choice->name;
                		            $extra->price    = $choice->price;
                		            $extra->total    = $choice->price*$extra->quantity;
                		            $sub_total       = $sub_total+$extra->total;
                		            $single          = $single+$choice->price;
                		        }
                		        $c->extras       = $extras;
                		        $c->extra_total  = number_format($sub_total,'2');
                		        $total           = $total+$grand+$sub_total;
                		        $total2          = $grand+$sub_total;
                		        $c->total        =  number_format($total2,'2');
                		        $c->singl_price  =  number_format($c->price+$single,'2');
                		        
                		      //  $c->price        = $product_price->price;
                		      //  $cart_total      = number_format($c->price*$c->quantity,'2');
                		      //  $grand           = $cart_total;
                		      //  $c->total        =  number_format($cart_total,'2');
                		        
                		      //  $extras          = $this->Common->get_details('guest_sub_cart',array('gcart_id'=>$c->gcart_id))->result();
                		      //  $sub_total       = 0;
                		      //  $single          = 0;
                		      //  foreach($extras as $extra)
                		      //  {   
                		      //      $choice       = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
                		      //      $extra->total = $choice->price*$extra->quantity;
                		      //      $sub_total    = $sub_total+$extra->total;
                		      //      $single       = $single+$choice->price;
                		      //  }
                		      //  $total           = $total+$grand+$sub_total;
                		      //  $c->singl_price  =  number_format($c->price+$single,'2');
            		        }
            		        else
            		        {
            		            $extras          = $this->Common->get_details('extras',array('extra_id'=>$c->product_id))->row();
                		        $restaurant      = $this->Common->get_details('restaurants',array('r_id'=>$extras->r_id))->row();
                		        $c->restaurant   = $restaurant->rest_name;
                		        $c->product_name = $extras->name;
                		        $c->r_id         = $extras->r_id;
                		        $c->image        = $extras->image;
                		        $c->price        = $extras->price;
                		        $cart_total      = $extras->price*$c->quantity;
                		        $grand           = $cart_total;
        
                		        $total = $total+$grand;
                		        $c->singl_price=  number_format($c->price,'2');
                		        $c->total      =  number_format($cart_total,'2');
            		        }
            		    }
            	        
            	        $this->response(array(
                            		              "status"  => true,
                            		              "message" => "success",
                            		              'total'   => number_format($total,'2'),
                            		            ), REST_Controller::HTTP_OK);
            	    }
            	    else
            	    {
            	       $this->response(array(
                            		              "status" => false,
                            		              "message" => "Failed"
                            		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
            	    }
        	    } 
	        }
	        else
	        {
	             $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
	        }
	    }
	}

//************************************** UPDATE ***********************************************************************************************************************************//	
	public function updateCart_post()
	{
	    $date     = date('Y-m-d'); 
	    $uid      = $this->security->xss_clean($this->input->post('uid'));
	    $token    = $this->security->xss_clean($this->input->post('device_token'));
	    
	    $header   = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{ 
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
			        $type        = $this->security->xss_clean($this->input->post('type'));
            		$cart_id     = $this->security->xss_clean($this->input->post('cart_id'));
            		$quantity    = $this->security->xss_clean($this->input->post('quantity'));
            		
                    $cart_data   = $this->Common->get_details('cart',array('cart_id'=>$cart_id))->row();
                    $product_id  = $cart_data->product_id;
                    
                    if($type=='product')
                    {
                        $price_id    = $cart_data->price_id;
                        $product     = $this->Common->get_details('products',array('p_id'=>$product_id))->row();
                        $product_price= $this->Common->get_details('product_price',array('price_id'=>$price_id))->row();
                	    $price       = $product_price->price;
                	    $total       = $price*$quantity; 
                	    
                		$array = [
                        			'quantity' => $quantity
                        	 	 ];
                
                		if ($this->Common->update('cart_id',$cart_id,'cart',$array)) 
                		{   
                		    
                		    $subcart  = $this->Common->get_details('sub_cart',array('cart_id'=>$cart_id))->result(); 
                		    foreach($subcart as $sub)
                		    {
                		        $sub_id   = $sub->sb_id;
                		        $choice   = $this->Common->get_details('product_choices',array('pchoice_id'=>$sub->val_id))->row(); 
                		      
                		        $s_total  = $choice->price*$quantity;
                		        $s_array  =  [
                		                          'quantity'  => $quantity
                		                     ];
                		        $this->Common->update('sb_id',$sub_id,'sub_cart',$s_array);             
                		    }
        
                		    $cart_products   = $this->products->getCartProducts($user_id);
        			        $cart_extras     = $this->products->getCartExtras($user_id);
                		    $cart            = array_merge($cart_products, $cart_extras);
                		    $total  = 0;
                		    foreach($cart as $c)
                		    {
                		        if($c->type=='p')
                		        {
                		            $product         = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();
                		            $product_price   = $this->Common->get_details('product_price',array('price_id'=>$c->price_id))->row();
                    		        $c->product_name = $product->name;
                    		        $c->r_id         = $product->r_id;
                    		        $c->image        = $product->cover_image;
                    		        
                    		        $offerCheck      = $this->products->checkProductOffer($product->p_id,$date);
                    		        if($offerCheck->num_rows()>0)
                    		        {
                    		          $offer                     = $offerCheck->row();
                    		          $percentage                = $offer->percentage;
                    		          $price                     = $product_price->price*$percentage/100;
                    		          $c->offer_price            = number_format($product_price->price-$price,'2');
                    		          $c->offer_percentage       = $percentage;
                    		          $c->price                  = $c->offer_price;
                    		        }
                    		        else
                    		        {
                    		           $c->offer_price            = '';
                    		           $c->offer_percentage       = '';
                    		           $c->price                  = $product_price->price;
                    		        }
                    		        $cart_total      = $c->price*$c->quantity;
                    		        $grand           = $cart_total;
                    		        $extras          = $this->Common->get_details('sub_cart',array('cart_id'=>$c->cart_id))->result();
                    		        $sub_total       = 0;
                    		        $single          = 0;
                    		        foreach($extras as $extra)
                    		        {
                    		            $choice          = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
                    		            $choice_cat      = $this->Common->get_details('product_choice_categories',array('pcat_id'=>$extra->cat_id))->row();
                    		            $extra->cat_name = $choice_cat->cat_name;
                    		            $extra->cat_value= $choice->name;
                    		            $extra->price    = $choice->price;
                    		            $extra->total    = $choice->price*$extra->quantity;
                    		            $sub_total       = $sub_total+$extra->total;
                    		            $single          = $single+$choice->price;
                    		        }
                    		        $c->extras       = $extras;
                    		        $c->extra_total  = number_format($sub_total,'2');
                    		        $total           = $total+$grand+$sub_total;
                    		        $total2          = $grand+$sub_total;
                    		        $c->total        =  number_format($total2,'2');
                    		        $c->singl_price  =  number_format($c->price+$single,'2');
                    		        
                    		      //  $c->price        = $product_price->price;
                    		      //  $cart_total      = number_format($c->price*$c->quantity,'2');
                    		      //  $grand           = $cart_total;
                    		      //  $c->total        =  number_format($cart_total,'2');
                    		        
                    		      //  $extras          = $this->Common->get_details('sub_cart',array('cart_id'=>$c->cart_id))->result();
                    		      //  $sub_total       = 0;
                    		      //  $single          = 0;
                    		      //  foreach($extras as $extra)
                    		      //  {
                    		      //      $choice       = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
                		          //      $extra->total = $choice->price*$extra->quantity;
                    		      //      $sub_total    = $sub_total+$extra->total;
                    		      //      $single       = $single+$choice->price;
                    		      //  }
                    		      //  $total           = $total+$grand+$sub_total;
                    		      //  $c->singl_price  =  number_format($c->price+$single,'2');
                		        }
                		        else
                		        {
                		            $product         = $this->Common->get_details('extras',array('extra_id'=>$c->product_id))->row();
                    		        $c->product_name = $product->name;
                    		        $c->r_id         = $product->r_id;
                    		        $c->image        = $product->image;
                    		        $c->price        = $product->price;
                    		        $cart_total      = number_format($c->price*$c->quantity,'2');
                    		        $grand           = $cart_total;
                    		        $total           = $total+$grand;
                    		        $c->total        =  number_format($cart_total,'2');
                    		        $c->singl_price  =  number_format($c->price,'2');
                		        }
                		        
                		    }
                		    
        		         	 $this->response(array(
                        		              "status"  => true,
                        		              "message" => "Success",
                        		              'total'   => number_format($total,'2'),
                        		            ), REST_Controller::HTTP_OK);
                		}
                		else 
                		{
                			$this->response(array(
                                		              "status"  => false,
                                		              "message" => "Failed to update cart"
                                		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
                		}
                    }
                    else
                    {
                		$array = [
                        			'quantity' => $quantity
                        	 	 ];
                
                		if ($this->Common->update('cart_id',$cart_id,'cart',$array)) 
                		{   
                		    $cart_products   = $this->products->getCartProducts($user_id);
        			        $cart_extras     = $this->products->getCartExtras($user_id);
                		    $cart            = array_merge($cart_products, $cart_extras);
                		    $total  = 0;
                		    foreach($cart as $c)
                		    {
                		        if($c->type=='p')
                		        {
                		            $product         = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();
                		            $product_price   = $this->Common->get_details('product_price',array('price_id'=>$c->price_id))->row();
                    		        $c->product_name = $product->name;
                    		        $c->r_id         = $product->r_id;
                    		        $c->image        = $product->cover_image;
                    		        
                    		                            		        $offerCheck      = $this->products->checkProductOffer($product->p_id,$date);
                    		        if($offerCheck->num_rows()>0)
                    		        {
                    		          $offer                     = $offerCheck->row();
                    		          $percentage                = $offer->percentage;
                    		          $price                     = $product_price->price*$percentage/100;
                    		          $c->offer_price            = number_format($product_price->price-$price,'2');
                    		          $c->offer_percentage       = $percentage;
                    		          $c->price                  = $c->offer_price;
                    		        }
                    		        else
                    		        {
                    		           $c->offer_price            = '';
                    		           $c->offer_percentage       = '';
                    		           $c->price                  = $product_price->price;
                    		        }
                    		        $cart_total      = $c->price*$c->quantity;
                    		        $grand           = $cart_total;
                    		        $extras          = $this->Common->get_details('sub_cart',array('cart_id'=>$c->cart_id))->result();
                    		        $sub_total       = 0;
                    		        $single          = 0;
                    		        foreach($extras as $extra)
                    		        {
                    		            $choice          = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
                    		            $choice_cat      = $this->Common->get_details('product_choice_categories',array('pcat_id'=>$extra->cat_id))->row();
                    		            $extra->cat_name = $choice_cat->cat_name;
                    		            $extra->cat_value= $choice->name;
                    		            $extra->price    = $choice->price;
                    		            $extra->total    = $choice->price*$extra->quantity;
                    		            $sub_total       = $sub_total+$extra->total;
                    		            $single          = $single+$choice->price;
                    		        }
                    		        $c->extras       = $extras;
                    		        $c->extra_total  = number_format($sub_total,'2');
                    		        $total           = $total+$grand+$sub_total;
                    		        $total2          = $grand+$sub_total;
                    		        $c->total        =  number_format($total2,'2');
                    		        $c->singl_price  =  number_format($c->price+$single,'2');
                    		        
                    		      //  $c->price        = $product_price->price;
                    		      //  $cart_total      = number_format($c->price*$c->quantity,'2');
                    		      //  $grand           = $cart_total;
                    		      //  $c->total        =  number_format($cart_total,'2');
                    		        
                    		      //  $extras          = $this->Common->get_details('sub_cart',array('cart_id'=>$c->cart_id))->result();
                    		      //  $sub_total       = 0;
                    		      //  $single          = 0;
                    		      //  foreach($extras as $extra)
                    		      //  {
                    		      //      $choice       = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
                		          //      $extra->total = $choice->price*$extra->quantity;
                    		      //      $sub_total    = $sub_total+$extra->total;
                    		      //      $single       = $single+$choice->price;
                    		      //  }
                    		      //  $total           = $total+$grand+$sub_total;
                    		      //  $c->singl_price  =  number_format($c->price+$single,'2');
                		        }
                		        else
                		        {
                		            $product         = $this->Common->get_details('extras',array('extra_id'=>$c->product_id))->row();
                    		        $c->product_name = $product->name;
                    		        $c->r_id         = $product->r_id;
                    		        $c->image        = $product->image;
                    		        $c->price        = $product->price;
                    		        $cart_total      = number_format($c->price*$c->quantity,'2');
                    		        $grand           = $cart_total;
                    		        $total           = $total+$grand;
                    		        $c->total        =  number_format($cart_total,'2');
                    		        $c->singl_price  =  number_format($c->price,'2');
                		        }
                		        
                		    }
                		    
        		         	 $this->response(array(
                        		              "status"  => true,
                        		              "message" => "Success",
                        		              'total'   => number_format($total,'2'),
                        		            ), REST_Controller::HTTP_OK);
                		}
                		else 
                		{
                			$this->response(array(
                                		              "status"  => false,
                                		              "message" => "Failed to update cart"
                                		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
                		}
                    }
			    }
			    else
			    {
			        $this->response(array(
                            			    "status"  => false,
                            			    "message" => "Your session has expired, please login again"
                            			  ), REST_Controller::HTTP_UNAUTHORIZED);
			    }
    		}
    		else
    		{
    			$this->response(array(
                        			    "status"  => false,
                        			    "message" => "Your session has expired, please login again"
                        			  ), REST_Controller::HTTP_UNAUTHORIZED);
    		}  
	    }
	    else
	    {
	        $guest_check    = $this->Common->get_details('guest',array('token'=>$token));
	        if($guest_check->num_rows()>0)
	        {
	            $type        = $this->security->xss_clean($this->input->post('type'));
        		$cart_id     = $this->security->xss_clean($this->input->post('cart_id'));
        		$quantity    = $this->security->xss_clean($this->input->post('quantity'));
        		
                $cart_data   = $this->Common->get_details('guest_cart',array('gcart_id'=>$cart_id))->row();
                if($type=='product')
                {
                    $product_id  = $cart_data->product_id;
                    $price_id    = $cart_data->price_id;
                    $product_price= $this->Common->get_details('product_price',array('price_id'=>$price_id))->row();
            	    $price       = $product_price->price;
            	    $total       = $price*$quantity; 
            	    
            		$array = [
                    			'quantity' => $quantity
                    	 	 ];
            
            		if ($this->Common->update('gcart_id',$cart_id,'guest_cart',$array)) 
            		{   
            		    $subcart  = $this->Common->get_details('guest_sub_cart',array('gcart_id'=>$cart_id))->result(); 
            		    foreach($subcart as $sub)
            		    {   
            		        $choice   = $this->Common->get_details('product_choices',array('pchoice_id'=>$sub->val_id))->row(); 
            		        $sub_id   = $sub->gsub_id;
            		        $s_total  = $choice->price*$quantity;
            		        $s_array  =  [
            		                          'quantity'  => $quantity
            		                     ];
            		        $this->Common->update('gsub_id',$sub_id,'guest_sub_cart',$s_array);             
            		    }
    
            		    $cart_guest_products = $this->products->getGuestCartProducts($guest_check->row()->guest_id);
                        $cart_guest_extras   = $this->products->getGuestCartExtras($guest_check->row()->guest_id);
                        $cart                = array_merge($cart_guest_products, $cart_guest_extras);
            		    $total  = 0;
            		    foreach($cart as $c)
            		    {
            		        if($c->type=='p')
            		        {
            		            $product         = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();
            		            $product_price   = $this->Common->get_details('product_price',array('price_id'=>$c->price_id))->row();
                		        $restaurant      = $this->Common->get_details('restaurants',array('r_id'=>$product->r_id))->row();
                		        $c->cart_id      = $c->gcart_id;
                		        $c->restaurant   = $restaurant->rest_name;
                		        $c->product_name = $product->name;
                		        $c->r_id         = $product->r_id;
                		        $c->image        = $product->cover_image;
                		        
                		        $offerCheck      = $this->products->checkProductOffer($product->p_id,$date);
                		        if($offerCheck->num_rows()>0)
                		        {
                		          $offer                     = $offerCheck->row();
                		          $percentage                = $offer->percentage;
                		          $price                     = $product_price->price*$percentage/100;
                		          $c->offer_price            = number_format($product_price->price-$price,'2');
                		          $c->offer_percentage       = $percentage;
                		          $c->price                  = $c->offer_price;
                		        }
                		        else
                		        {
                		           $c->offer_price            = '';
                		           $c->offer_percentage       = '';
                		           $c->price                  = $product_price->price;
                		        }
                		        $cart_total      = $c->price*$c->quantity;
                		        $grand           = $cart_total;
                		        $extras          = $this->Common->get_details('guest_sub_cart',array('gcart_id'=>$c->gcart_id))->result();
                		        $sub_total       = 0;
                		        $single          = 0;
                		        foreach($extras as $extra)
                		        {
                		            $choice          = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
                		            $choice_cat      = $this->Common->get_details('product_choice_categories',array('pcat_id'=>$extra->cat_id))->row();
                		            $extra->cat_name = $choice_cat->cat_name;
                		            $extra->cat_value= $choice->name;
                		            $extra->price    = $choice->price;
                		            $extra->total    = $choice->price*$extra->quantity;
                		            $sub_total       = $sub_total+$extra->total;
                		            $single          = $single+$choice->price;
                		        }
                		        $c->extras       = $extras;
                		        $c->extra_total  = number_format($sub_total,'2');
                		        $total           = $total+$grand+$sub_total;
                		        $total2          = $grand+$sub_total;
                		        $c->total        =  number_format($total2,'2');
                		        $c->singl_price  =  number_format($c->price+$single,'2');
                		        
                		      
            		        }
            		        else
                		    {
            		            $extras          = $this->Common->get_details('extras',array('extra_id'=>$c->product_id))->row();
                		        $restaurant      = $this->Common->get_details('restaurants',array('r_id'=>$extras->r_id))->row();
                		        $c->restaurant   = $restaurant->rest_name;
                		        $c->product_name = $extras->name;
                		        $c->r_id         = $extras->r_id;
                		        $c->image        = $extras->image;
                		        $c->price        = $extras->price;
                		        $cart_total      = $extras->price*$c->quantity;
                		        $grand           = $cart_total;
        
                		        $total = $total+$grand;
                		        $c->singl_price=  number_format($c->price,'2');
                		        $c->total      =  number_format($cart_total,'2');
                		   }
        		            
            		    }
            		    
    		         	 $this->response(array(
                    		              "status"  => true,
                    		              "message" => "Success",
                    		              'total'   => number_format($total,'2'),
                    		            ), REST_Controller::HTTP_OK);
            		}
            		else 
            		{
            			$this->response(array(
                            		              "status"  => false,
                            		              "message" => "Failed to update cart"
                            		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
            		}
                }
                else
                {
                    $product_id  = $cart_data->product_id;
                   
            		$array = [
                    			'quantity' => $quantity
                    	 	 ];
            
            		if ($this->Common->update('gcart_id',$cart_id,'guest_cart',$array)) 
            		{   
            		    $cart_guest_products = $this->products->getGuestCartProducts($guest_check->row()->guest_id);
                        $cart_guest_extras   = $this->products->getGuestCartExtras($guest_check->row()->guest_id);
                        $cart                = array_merge($cart_guest_products, $cart_guest_extras);
            		    $total  = 0;
            		    foreach($cart as $c)
            		    {
            		        if($c->type=='p')
            		        {
            		            $product         = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();
            		            $product_price   = $this->Common->get_details('product_price',array('price_id'=>$c->price_id))->row();
            		            
                		        $restaurant      = $this->Common->get_details('restaurants',array('r_id'=>$product->r_id))->row();
                		        $c->cart_id      = $c->gcart_id;
                		        $c->restaurant   = $restaurant->rest_name;
                		        $c->product_name = $product->name;
                		        $c->r_id         = $product->r_id;
                		        $c->image        = $product->cover_image;
                		        
                		        $offerCheck      = $this->products->checkProductOffer($product->p_id,$date);
                		        if($offerCheck->num_rows()>0)
                		        {
                		          $offer                     = $offerCheck->row();
                		          $percentage                = $offer->percentage;
                		          $price                     = $product_price->price*$percentage/100;
                		          $c->offer_price            = number_format($product_price->price-$price,'2');
                		          $c->offer_percentage       = $percentage;
                		          $c->price                  = $c->offer_price;
                		        }
                		        else
                		        {
                		           $c->offer_price            = '';
                		           $c->offer_percentage       = '';
                		           $c->price                  = $product_price->price;
                		        }
                		        $cart_total      = $c->price*$c->quantity;
                		        $grand           = $cart_total;
                		        $extras          = $this->Common->get_details('guest_sub_cart',array('gcart_id'=>$c->gcart_id))->result();
                		        $sub_total       = 0;
                		        $single          = 0;
                		        foreach($extras as $extra)
                		        {
                		            $choice          = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
                		            $choice_cat      = $this->Common->get_details('product_choice_categories',array('pcat_id'=>$extra->cat_id))->row();
                		            $extra->cat_name = $choice_cat->cat_name;
                		            $extra->cat_value= $choice->name;
                		            $extra->price    = $choice->price;
                		            $extra->total    = $choice->price*$extra->quantity;
                		            $sub_total       = $sub_total+$extra->total;
                		            $single          = $single+$choice->price;
                		        }
                		        $c->extras       = $extras;
                		        $c->extra_total  = number_format($sub_total,'2');
                		        $total           = $total+$grand+$sub_total;
                		        $total2          = $grand+$sub_total;
                		        $c->total        =  number_format($total2,'2');
                		        $c->singl_price  =  number_format($c->price+$single,'2');
                		        
                		      
            		        }
            		        else
                		    {
            		            $extras          = $this->Common->get_details('extras',array('extra_id'=>$c->product_id))->row();
                		        $restaurant      = $this->Common->get_details('restaurants',array('r_id'=>$extras->r_id))->row();
                		        $c->restaurant   = $restaurant->rest_name;
                		        $c->product_name = $extras->name;
                		        $c->r_id         = $extras->r_id;
                		        $c->image        = $extras->image;
                		        $c->price        = $extras->price;
                		        $cart_total      = $extras->price*$c->quantity;
                		        $grand           = $cart_total;
        
                		        $total = $total+$grand;
                		        $c->singl_price=  number_format($c->price,'2');
                		        $c->total      =  number_format($cart_total,'2');
                		   }
        		            
            		    }
            		    
    		         	 $this->response(array(
                    		              "status"  => true,
                    		              "message" => "Success",
                    		              'total'   => number_format($total,'2'),
                    		            ), REST_Controller::HTTP_OK);
            		}
            		else 
            		{
            			$this->response(array(
                            		              "status"  => false,
                            		              "message" => "Failed to update cart"
                            		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
            		}
                }	
	        }
	        else
	        {
	            $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
	        }
	    }
	}

//*************************************** CHECK CART ******************************************************************************************************************************//	
    public function checkCart_post()
	{
	    $date          = date('Y-m-d'); 
	    $uid           = $this->security->xss_clean($this->input->post('uid'));
	    $token         = $this->security->xss_clean($this->input->post('device_token'));
	    $restaurant_id = $this->input->post('restuarant_id');
        $branch_id     = $this->input->post('branch_id');
       
	    $header     = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{    
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
        		     $cart_check    = $this->products->restaurantCartCheck($restaurant_id,$user_id,$branch_id);
            	     if($cart_check==0)
            	     {
            	         $this->response(array(
                            		              "status" => true,
                            		              "message" => "Failed"
                            		            ), REST_Controller::HTTP_NOT_FOUND);
            	     }
            	     else
            	     {   
            	        $cart_products   = $this->products->getCartProducts($user_id);
    			        $cart_extras     = $this->products->getCartExtras($user_id);
            		    $cart            = array_merge($cart_products, $cart_extras);
            		    $total  = 0;
            		    foreach($cart as $c)
            		    {
            		        if($c->type=='p')
            		        {
            		            $product         = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();
            		            $product_price   = $this->Common->get_details('product_price',array('price_id'=>$c->price_id))->row();
            		            
            		            $offerCheck      = $this->products->checkProductOffer($product->p_id,$date);
                		        if($offerCheck->num_rows()>0)
                		        {
                		          $offer                     = $offerCheck->row();
                		          $percentage                = $offer->percentage;
                		          $price                     = $product_price->price*$percentage/100;
                		          $c->offer_price            = number_format($product_price->price-$price,'2');
                		          $c->offer_percentage       = $percentage;
                		          $c->price                  = $c->offer_price;
                		        }
                		        else
                		        {
                		           $c->offer_price            = '';
                		           $c->offer_percentage       = '';
                		           $c->price                  = $product_price->price;
                		        }
                		        $cart_total      = $c->price*$c->quantity;
                		        $grand           = $cart_total;
                		        $extras          = $this->Common->get_details('sub_cart',array('cart_id'=>$c->cart_id))->result();
                		        $sub_total       = 0;
                		        $single          = 0;
                		        foreach($extras as $extra)
                		        {
                		            $choice          = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
                		            $choice_cat      = $this->Common->get_details('product_choice_categories',array('pcat_id'=>$extra->cat_id))->row();
                		            $extra->cat_name = $choice_cat->cat_name;
                		            $extra->cat_value= $choice->name;
                		            $extra->price    = $choice->price;
                		            $extra->total    = $choice->price*$extra->quantity;
                		            $sub_total       = $sub_total+$extra->total;
                		            $single          = $single+$choice->price;
                		        }
                		        $c->extras       = $extras;
                		        $c->extra_total  = number_format($sub_total,'2');
                		        $total           = $total+$grand+$sub_total;
                		        $total2          = $grand+$sub_total;
                		        $c->total        =  number_format($total2,'2');
                		        $c->singl_price  =  number_format($c->price+$single,'2');
            		            
                		     
            		        }
            		        else
            		        {
            		            $product         = $this->Common->get_details('extras',array('extra_id'=>$c->product_id))->row();
                		        $c->price        = $product->price;
                		        $c->total        = $c->price*$c->quantity;
                		        $grand           = $c->total;
                		        $total           = $total+$grand;
            		        }
            		    }
            	        
            	        $this->response(array(
                            		              "status"  => true,
                            		              "message" => "Success",
                            		              'count'   => $cart_check,
            	                                  'total'   => number_format($total,'2'),
                            		            ), REST_Controller::HTTP_OK);             
            	     }
			    }
    		    else
    		    {
    		        $this->response(array(
                            			     "status"  => false,
                            			     "message" => "Your session has expired, please login again"
                            			 ), REST_Controller::HTTP_UNAUTHORIZED);
    		    }
    		}
    		else
    		{
    		    $this->response(array(
                        			     "status"  => false,
                        			     "message" => "Your session has expired, please login again"
                        			 ), REST_Controller::HTTP_UNAUTHORIZED);
    		}  
	    }
	    else
	    {
	         $guest_check   = $this->Common->get_details('guest',array('token'=>$token));
	         if($guest_check->num_rows()>0)
	         {
    		     $cart_check    = $this->guest->restaurantCartCheck($restaurant_id,$guest_check->row()->guest_id,$branch_id);
        	     if($cart_check==0)
        	     {
        	         $this->response(array(
                        		              "status" => false,
                        		              "message" => "Failed"
                        		            ), REST_Controller::HTTP_NOT_FOUND);
        	     }
        	     else
        	     {   
        	        $cart_guest_products = $this->products->getGuestCartProducts($guest_check->row()->guest_id);
                    $cart_guest_extras   = $this->products->getGuestCartExtras($guest_check->row()->guest_id);
                    $cart                = array_merge($cart_guest_products, $cart_guest_extras);
        		    $total  = 0;
        		    foreach($cart as $c)
        		    {
        		        if($c->type=='p')
        		        {
        		            $product         = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();
        		            $product_price   = $this->Common->get_details('product_price',array('price_id'=>$c->price_id))->row();
        		            
        		            $offerCheck      = $this->products->checkProductOffer($product->p_id,$date);
            		        if($offerCheck->num_rows()>0)
            		        {
            		          $offer                     = $offerCheck->row();
            		          $percentage                = $offer->percentage;
            		          $price                     = $product_price->price*$percentage/100;
            		          $c->offer_price            = number_format($product_price->price-$price,'2');
            		          $c->offer_percentage       = $percentage;
            		          $c->price                  = $c->offer_price;
            		        }
            		        else
            		        {
            		           $c->offer_price            = '';
            		           $c->offer_percentage       = '';
            		           $c->price                  = $product_price->price;
            		        }
            		        $cart_total      = $c->price*$c->quantity;
            		        $grand           = $cart_total;
            		        $extras          = $this->Common->get_details('guest_sub_cart',array('gcart_id'=>$c->gcart_id))->result();
            		        $sub_total       = 0;
            		        $single          = 0;
            		        foreach($extras as $extra)
            		        {
            		            $choice          = $this->Common->get_details('product_choices',array('pchoice_id'=>$extra->val_id))->row(); 
            		            $choice_cat      = $this->Common->get_details('product_choice_categories',array('pcat_id'=>$extra->cat_id))->row();
            		            $extra->cat_name = $choice_cat->cat_name;
            		            $extra->cat_value= $choice->name;
            		            $extra->price    = $choice->price;
            		            $extra->total    = $choice->price*$extra->quantity;
            		            $sub_total       = $sub_total+$extra->total;
            		            $single          = $single+$choice->price;
            		        }
            		        $c->extras       = $extras;
            		        $c->extra_total  = number_format($sub_total,'2');
            		        $total           = $total+$grand+$sub_total;
            		        $total2          = $grand+$sub_total;
            		        $c->total        =  number_format($total2,'2');
            		        $c->singl_price  =  number_format($c->price+$single,'2');
        		            
            		      
        		        }
        		        else
        		        {
        		            $extras          = $this->Common->get_details('extras',array('extra_id'=>$c->product_id))->row();
            		        $restaurant      = $this->Common->get_details('restaurants',array('r_id'=>$extras->r_id))->row();
            		        $c->restaurant   = $restaurant->rest_name;
            		        $c->product_name = $extras->name;
            		        $c->r_id         = $extras->r_id;
            		        $c->image        = $extras->image;
            		        $c->price        = $extras->price;
            		        $cart_total      = $extras->price*$c->quantity;
            		        $grand           = $cart_total;
    
            		        $total = $total+$grand;
            		        $c->singl_price=  number_format($c->price,'2');
            		        $c->total      =  number_format($cart_total,'2');
        		        }
        		    }
        	        
        	        $this->response(array(
                        		              "status"  => true,
                        		              "message" => "Success",
                        		              'count'   => $cart_check,
        	                                  'total'   => number_format($total,'2'),
                        		            ), REST_Controller::HTTP_OK);             
        	     }
	         }
	         else
	         {
	             $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
	         }
	    }
	}

//*********************************** DELETE **************************************************************************************************************************************//	
	public function delete_get()
	{   
	    $uid      = $this->security->xss_clean($this->input->get('uid'));
	    $token    = $this->security->xss_clean($this->input->get('device_token'));
	    
	    $header   = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{  
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
			        $cart = $this->Common->get_details('cart',array('user_id'=>$user_id))->result();
        		    foreach($cart as $c)
        		    {   
        		        $cart_id = $c->cart_id;
        		        if($this->Common->delete('cart',array('cart_id' => $cart_id)))
                	    {
                	        $this->Common->delete('sub_cart',array('cart_id' => $cart_id));
                	    }
        		    }
        		     $this->response(array(
                            		              "status"  => true,
                            		              "message" => "Success"
                            		            ), REST_Controller::HTTP_OK);
			    }
			    else
			    {
			        $this->response(array(
                            			   "status"  => false,
                            			   "message" => "Your session has expired, please login again"
                            			  ), REST_Controller::HTTP_UNAUTHORIZED);
			    }
    		}
    		else
    		{
    			$this->response(array(
                        			   "status"  => false,
                        			   "message" => "Your session has expired, please login again"
                        			  ), REST_Controller::HTTP_UNAUTHORIZED);
    		}  
	    }
	    else
	    {
	         $guest_check = $this->Common->get_details('guest',array('token'=>$token));
	         if($guest_check->num_rows()>0)
	         {
	              $cart = $this->Common->get_details('guest_cart',array('guest_id'=>$guest_check->row()->guest_id))->result();
    		      foreach($cart as $c)
    		      {   
        		        $cart_id = $c->gcart_id;
        		        if($this->Common->delete('guest_cart',array('gcart_id' => $cart_id)))
                	    {
                	        $this->Common->delete('guest_sub_cart',array('gcart_id' => $cart_id));
                	    }
    		      }
    		      $this->response(array(
                        		              "status"  => true,
                        		              "message" => "Success"
                        		            ), REST_Controller::HTTP_OK);
	         }
	         else
	         {
	             $this->response(array(
                        			 "status"  => false,
                        			 "message" => "Your session has expired, please login again"
                        		   ), REST_Controller::HTTP_UNAUTHORIZED);
	         }
	    }
	}

//**************************************** CART COUNT ******************************************************************************************************************************//	
	public function getCount_get()
	{
	    $uid        = $this->security->xss_clean($this->input->get('uid'));
	    $token      = $this->security->xss_clean($this->input->get('device_token'));
	    
	    $header     = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
			        $cart_products   = $this->products->getCartProducts($user_id);
			        $cart_extras     = $this->products->getCartExtras($user_id);
        		    $cart            = array_merge($cart_products, $cart_extras);
    		        $count           = count($cart);
    		       
                	$this->response(array(
                        		              "status"  => true,
                        		              "message" => "Success",
                        		              "data"    => $count,
                        		            ), REST_Controller::HTTP_OK);	
			    }
    		    else
    		    {
    		        $this->response(array(
                        			   "status"  => false,
                        			   "message" => "Your session has expired, please login again"
                        			  ), REST_Controller::HTTP_UNAUTHORIZED);
    		    }
    		}
    		else
    		{
    			$this->response(array(
                        			   "status"  => false,
                        			   "message" => "Your session has expired, please login again"
                        			  ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	        $guest_check = $this->Common->get_details('guest',array('token'=>$token));
	        if($guest_check->num_rows()>0)
	        {
	            $cart_guest_products = $this->products->getGuestCartProducts($guest_check->row()->guest_id);
                $cart_guest_extras   = $this->products->getGuestCartExtras($guest_check->row()->guest_id);
                $cart                = array_merge($cart_guest_products, $cart_guest_extras);
    		    $count               = count($cart);
    		       
                	$this->response(array(
                        		              "status"  => true,
                        		              "message" => "Success",
                        		              "data"    => $count,
                        		            ), REST_Controller::HTTP_OK);	
	        }
	        else
	        {
	            $this->response(array(
                        			 "status"  => false,
                        			 "message" => "Your session has expired, please login again"
                        		   ), REST_Controller::HTTP_UNAUTHORIZED);
	        }
	    }
	}

//******************************************* DECODE TOKEN ************************************************************************************************************************//	
	public function decodeToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h7';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}
	
	
}
?>
