<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH.'libraries/REST_Controller.php';
require APPPATH.'/libraries/JWT.php';
class Address extends REST_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_address','address');
	}
//*************************************** GET ADDRESS *******************************************************************************************************************************//	
	public function index_get()
	{
	    $uid      = $this->security->xss_clean($this->input->get('uid'));
	    $token    = $this->security->xss_clean($this->input->get('device_token'));
	    $header   = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
    				$address = $this->address->getAddress($user_id);
    				$this->response(array(
                        		              "status"  => true,
                        					  "data"    => $address,
                        		              "message" => "Success"
                        		            ), REST_Controller::HTTP_OK);
			    }
			    else
			    {
			        $this->response(array(
                    				    "status" => false,
                    				    "message" => "Your session has expired, please login again"
                    				 ), REST_Controller::HTTP_UNAUTHORIZED);
			    }
			}
			else 
			{
				$this->response(array(
                    				    "status" => false,
                    				    "message" => "Your session has expired, please login again"
                    				 ), REST_Controller::HTTP_UNAUTHORIZED);
			}
		}
		else 
		{
		    $check_guest= $this->Common->get_details('guest',array('token'=>$token));
            if($check_guest->num_rows()>0)
            {
                $address = $this->address->getGuestAddress($check_guest->row()->guest_id);
				$this->response(array(
                    		              "status"  => true,
                    					  "data"    => $address,
                    		              "message" => "Success"
                    		            ), REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
            }
			
		}
	}

//************************************ ADD ADDRESS *********************************************************************************************************************************//	
	public function add_post()
	{   
	    $uid       = $this->security->xss_clean($this->input->post('uid'));
	    $token     = $this->security->xss_clean($this->input->post('device_token'));
	    $name      = $this->security->xss_clean($this->input->post('name'));
	    $area      = $this->security->xss_clean($this->input->post('area'));
		$flat      = $this->security->xss_clean($this->input->post('flat'));
		$road_no   = $this->security->xss_clean($this->input->post('road_no'));
		$building  = $this->security->xss_clean($this->input->post('building'));
		$block     = $this->security->xss_clean($this->input->post('block'));
		$mobile    = $this->security->xss_clean($this->input->post('mobile'));
		$landmark  = $this->security->xss_clean($this->input->post('landmark'));
		$latitude  = $this->security->xss_clean($this->input->post('latitude'));
		$longiude  = $this->security->xss_clean($this->input->post('longitude'));
	    
	    $header   = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
            		$array     = [
                    			     'user_id'    => $user_id,
                    			     'area'       => $area,
                    			     'flat'       => $flat,
                    			     'road_no'    => $road_no,
                    			     'building_no'=> $building,
                    			     'block'      => $block,
                    			     'mobile'     => $mobile,
                    			     'landmark'   => $landmark,
                    			     'latitude'   => $latitude,
                    			     'longitude'  => $longiude,
                    			     'date'       => date('Y-m-d'),
                    			     'timestamp'  => date('Y-m-d H:i:s')
                    		       ];
            	    
                     if($id=$this->Common->insert('address',$array))
                     {
                    	    $this->response(array(
                            		              "status"  => true,
                            					  "data"    => [
                            					                  'address_id' => $id
                            					               ],
                            		              "message" => "Success"
                            		            ), REST_Controller::HTTP_OK);	
            	     }
            	     else
            	     {
            	         $this->response(array(
                            		              "status" => false,
                            		              "message" => "Failed to add address"
                            		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);	
            	     }
			    }
			    else
			    {
			        $this->response(array(
                    				    "status" => false,
                    				    "message" => "Your session has expired, please login again"
                    				 ), REST_Controller::HTTP_UNAUTHORIZED);
			    }
			}
			else 
			{
				$this->response(array(
                    				    "status" => false,
                    				    "message" => "Your session has expired, please login again"
                    				 ), REST_Controller::HTTP_UNAUTHORIZED);
			}
		}
		else 
		{
		    $check_guest= $this->Common->get_details('guest',array('token'=>$token));
            if($check_guest->num_rows()>0)
            {   
                $guestaddress = $this->Common->get_details('guest_address',array('guest_id'=>$check_guest->row()->guest_id));
                if($guestaddress->num_rows()>0)
                {
                    $array     = [
                    			     'guest_id'   => $check_guest->row()->guest_id,
                    			     'name'       => $name,
                    			     'area'       => $area,
                    			     'flat'       => $flat,
                    			     'road_no'    => $road_no,
                    			     'building_no'=> $building,
                    			     'block'      => $block,
                    			     'mobile'     => $mobile,
                    			     'landmark'   => $landmark,
                    			     'latitude'   => $latitude,
                    			     'longitude'  => $longiude,
                    			     'date'       => date('Y-m-d'),
                        			 'timestamp'  => date('Y-m-d H:i:s')
                    		       ];
            	    
                     if($this->Common->update('ga_id',$guestaddress->row()->ga_id,'guest_address',$array))
                     {
                    	    $this->response(array(
                            		              "status"  => true,
                            					  "data"    => [
                            					                  'address_id' => $guestaddress->row()->ga_id
                            					               ],
                            		              "message" => "Success"
                            		            ), REST_Controller::HTTP_OK);	
            	     }
            	     else
            	     {
            	         $this->response(array(
                            		              "status" => false,
                            		              "message" => "Failed to add address"
                            		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);	
            	     }
                }
                else
                {
                    $array     = [
                    			     'guest_id'   => $check_guest->row()->guest_id,
                    			     'name'       => $name,
                    			     'area'       => $area,
                    			     'flat'       => $flat,
                    			     'road_no'    => $road_no,
                    			     'building_no'=> $building,
                    			     'block'      => $block,
                    			     'mobile'     => $mobile,
                    			     'landmark'   => $landmark,
                    			     'latitude'   => $latitude,
                    			     'longitude'  => $longiude,
                    			     'date'       => date('Y-m-d'),
                        			 'timestamp'  => date('Y-m-d H:i:s')
                    		      ];
            	    
                     if($id=$this->Common->insert('guest_address',$array))
                     {
                    	    $this->response(array(
                            		              "status"  => true,
                            					  "data"    => [
                            					                  'address_id' => $id
                            					               ],
                            		              "message" => "Success"
                            		            ), REST_Controller::HTTP_OK);	
            	     }
            	     else
            	     {
            	         $this->response(array(
                            		              "status" => false,
                            		              "message" => "Failed to add address"
                            		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);	
            	     }
                }
            }
            else
            {
                $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
            }
		}
	}

//********************************************* DELETE ADDRESS *********************************************************************************************************************//	
	public function deleteAddress_post()
	{  
	    $uid      = $this->security->xss_clean($this->input->post('uid'));
	    $header   = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
            	    $address_id = $this->security->xss_clean($this->input->post('address_id'));
            	    if($this->Common->update('address_id',$address_id,'address',array('status' => '0')))
            	    {
            	        $this->response(array(
                            		              "status"  => true,
                            		              "message" => "Success"
                            		            ), REST_Controller::HTTP_OK);
            	    }
            	    else
            	    {
            	        $this->response(array(
                            		              "status" => false,
                            		              "message" => "Failed to delete address"
                            		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
            	    }
			    }
			    else
			    {
			        $this->response(array(
                        				    "status" => false,
                        				    "message" => "Your session has expired, please login again"
                        				 ), REST_Controller::HTTP_UNAUTHORIZED);
			    }
    		}
    		else
    		{
    			$this->response(array(
                    				    "status" => false,
                    				    "message" => "Your session has expired, please login again"
                    				 ), REST_Controller::HTTP_UNAUTHORIZED);
    		}  
	    }
	    else
	    {
	        $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
	    }
	}

//********************************************* UPDATE ADDRESS ********************************************************************************************************************//	
	public function updateAddress_post()
	{
	    $uid       = $this->security->xss_clean($this->input->post('uid'));
	    $address_id= $this->security->xss_clean($this->input->post('address_id'));
	    $name      = $this->security->xss_clean($this->input->post('name'));
	    $area      = $this->security->xss_clean($this->input->post('area'));
		$flat      = $this->security->xss_clean($this->input->post('flat'));
		$road_no   = $this->security->xss_clean($this->input->post('road_no'));
		$building  = $this->security->xss_clean($this->input->post('building'));
		$block     = $this->security->xss_clean($this->input->post('block'));
		$mobile    = $this->security->xss_clean($this->input->post('mobile'));
		$landmark  = $this->security->xss_clean($this->input->post('landmark'));
		$latitude  = $this->security->xss_clean($this->input->post('latitude'));
		$longiude  = $this->security->xss_clean($this->input->post('longitude'));
		
	    $header   = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1)
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{  
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
            		$array     = [
                    			     'user_id'    => $user_id,
                    			     'area'       => $area,
                    			     'flat'       => $flat,
                    			     'road_no'    => $road_no,
                    			     'building_no'=> $building,
                    			     'block'      => $block,
                    			     'mobile'     => $mobile,
                    			     'landmark'   => $landmark,
                    			     'latitude'   => $latitude,
                    			     'longitude'  => $longiude,
                    			     'date'       => date('Y-m-d'),
                    			     'timestamp'  => date('Y-m-d H:i:s')
                    		       ];
            	    
                     if($id=$this->Common->update('address_id',$address_id,'address',$array))
                     {
                    	    $this->response(array(
                            		              "status"  => true,
                            		              "message" => "Success"
                            		            ), REST_Controller::HTTP_OK);	
            	     }
            	     else
            	     {
            	          $this->response(array(
                            		              "status" => false,
                            		              "message" => "Failed to update address"
                            		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
            	     }
			    }
			    else
			    {
			        $this->response(array(
                            			  "status"  => false,
                            			  "message" => "Your session has expired, please login again"
                            			), REST_Controller::HTTP_UNAUTHORIZED);
			    }
    		}
    		else
    		{
    			 $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	        $check_guest= $this->Common->get_details('guest',array('token'=>$token));
            if($check_guest->num_rows()>0)
            {
                     $array     = [
                    			     'guest_id'   => $check_guest->row()->guest_id,
                    			     'name'       => $name,
                    			     'area'       => $area,
                    			     'flat'       => $flat,
                    			     'road_no'    => $road_no,
                    			     'building_no'=> $building,
                    			     'block'      => $block,
                    			     'mobile'     => $mobile,
                    			     'landmark'   => $landmark,
                    			     'latitude'   => $latitude,
                    			     'longitude'  => $longiude,
                    			     'date'       => date('Y-m-d'),
                    			     'timestamp'  => date('Y-m-d H:i:s')
                    		       ];
            	    
                     if($id=$this->Common->update('ga_id',$address_id,'guest_address',$array))
                     {
                    	    $this->response(array(
                            		              "status"  => true,
                            		              "message" => "Success"
                            		            ), REST_Controller::HTTP_OK);	
            	     }
            	     else
            	     {
            	          $this->response(array(
                            		              "status" => false,
                            		              "message" => "Failed to update address"
                            		            ), REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
            	     }
            }
            else
            {
                $this->response(array(
                        			  "status"  => false,
                        			  "message" => "Your session has expired, please login again"
                        			), REST_Controller::HTTP_UNAUTHORIZED);
            }
	    }
 	}

//*************************************************** CHECK DELIVERY ADDRESS *******************************************************************************************************//	
	public function checkDeliveryAddress_post()
	{
	    $uid           = $this->security->xss_clean($this->input->post('uid'));
	    $token         = $this->security->xss_clean($this->input->post('device_token'));
	    $restaurant_id = $this->security->xss_clean($this->input->post('restaurant_id'));
        $branch_id     = $this->security->xss_clean($this->input->post('branch_id'));
	    
	    $header     = $this->input->get_request_header('Authorization');
	    if (count(explode(' ', $header)) > 1) 
	    {
			$user_id = $this->decodeToken($header);
			if ($user_id) 
			{  
			    $uid_check = $this->Common->get_details('users',array('uid'=>$uid,'user_id'=>$user_id));
			    if($uid_check->num_rows()>0)
			    {
        		    $address_check = $this->Common->get_details('address',array('user_id'=>$user_id));
        		    $radius        = $this->Common->get_details('delivery_area',array())->row()->area_distance;

        		    if($address_check->num_rows()>0)
        		    {
        		       $address       = $this->address->getAddress($user_id);
        		       $count         = '0';
        		       foreach($address as $addr)
        		       {
        		           $latitude  = $addr->latitude;
        		           $longitude = $addr->longitude;
        		           
        		           if($branch_id==0)
        		           {
        		               $addr->shops     = $this->address->getShopsDelivery($latitude,$longitude,$radius,$restaurant_id);
        		               
        		           }
        		           else
        		           {
        		               $addr->shops     = $this->address->getShopsBranchDelivery($latitude,$longitude,$radius,$branch_id);
        		           }
        		           $count     = $count+$addr->shops;
        		       }
        		       if($count>0)
        		       {
        		           if($branch_id==0)
        		           {
        		               $restaurant  = $this->Common->get_details('restaurants',array('r_id'=>$restaurant_id))->row();
        		               $r_latitude  = $restaurant->latitude;
        		               $r_longitude = $restaurant->longitude;
        		           }
        		           else
        		           {
        		               $branch      = $this->Common->get_details('branches',array('b_id'=>$branch_id))->row();
        		               $r_latitude  = $branch->latitude;
        		               $r_longitude = $branch->longitude;
        		           }
        		           
        		           $d_address   = $this->address->getDeliveryAddress($r_latitude,$r_longitude,$radius,$user_id);
        		           
        		           $this->response(array(
                            		              "status"  => true,
                            		              "message" => "Success",
                            		              "data"    => $d_address,
                            		            ), REST_Controller::HTTP_OK);	
        		       }
        		       else
        		       {
        		           $this->response(array(
                            		              "status" => false,
                            		              "message" => "Failed"
                            		            ), REST_Controller::HTTP_OK);
        		       }
        		    }
                    else
                    {
                        	$this->response(array(
                                		              "status" => false,
                                		              "message" => "Failed"
                                		            ), REST_Controller::HTTP_NOT_FOUND);
                    }
			    }
			    else
			    {
			        $this->response(array(
                            			   "status"  => false,
                            			   "message" => "Your session has expired, please login again"
                            			  ), REST_Controller::HTTP_UNAUTHORIZED);
			    }
    		}
    		else
    		{
    			$this->response(array(
                        			   "status"  => false,
                        			   "message" => "Your session has expired, please login again"
                        			  ), REST_Controller::HTTP_UNAUTHORIZED);
    		}
	    }
	    else
	    {
	        $check_guest= $this->Common->get_details('guest',array('token'=>$token));
            if($check_guest->num_rows()>0)
	        {
        		    $address_check = $this->Common->get_details('guest_address',array('guest_id'=>$check_guest->row()->guest_id));
        		    $radius        = $this->Common->get_details('delivery_area',array())->row()->area_distance;

        		    if($address_check->num_rows()>0)
        		    {
        		       $address       = $this->address->getGuestAddress($check_guest->row()->guest_id);
        		       $count         = '0';
        		       foreach($address as $addr)
        		       {
        		           $latitude  = $addr->latitude;
        		           $longitude = $addr->longitude;
        		           
        		           if($branch_id==0)
        		           {
        		               $addr->shops     = $this->address->getShopsDelivery($latitude,$longitude,$radius,$restaurant_id);
        		               
        		           }
        		           else
        		           {
        		               $addr->shops     = $this->address->getShopsBranchDelivery($latitude,$longitude,$radius,$branch_id);
        		           }
        		           $count     = $count+$addr->shops;
        		       }
        		       if($count>0)
        		       {
        		           if($branch_id==0)
        		           {
        		               $restaurant  = $this->Common->get_details('restaurants',array('r_id'=>$restaurant_id))->row();
        		               $r_latitude  = $restaurant->latitude;
        		               $r_longitude = $restaurant->longitude;
        		           }
        		           else
        		           {
        		               $branch      = $this->Common->get_details('branches',array('b_id'=>$branch_id))->row();
        		               $r_latitude  = $branch->latitude;
        		               $r_longitude = $branch->longitude;
        		           }
        		           
        		           $d_address   = $this->address->getGuestDeliveryAddress($r_latitude,$r_longitude,$radius,$check_guest->row()->guest_id);
        		           
        		           $this->response(array(
                            		              "status"  => true,
                            		              "message" => "Success",
                            		              "data"    => $d_address,
                            		            ), REST_Controller::HTTP_OK);	
        		       }
        		       else
        		       {
        		           $this->response(array(
                            		              "status"  => false,
                            		              "message" => "Failed"
                            		            ), REST_Controller::HTTP_OK);
        		       }
        		    }
                    else
                    {
                        	$this->response(array(
                                		              "status"  => false,
                                		              "message" => "Failed"
                                		            ), REST_Controller::HTTP_NOT_FOUND);
                    }
	        } 
	        else
	        {
	            $this->response(array(
                        			 "status"  => false,
                        			 "message" => "Your session has expired, please login again"
                        		   ), REST_Controller::HTTP_UNAUTHORIZED);
	        }
	         
	    }
	}

//******************************************** DECODE TOKEN ***********************************************************************************************************************//	
	public function decodeToken($token)
	{
    	$token   = substr($token, 7);
    	$key     = 'vnN6RFYYUWhMyKFlVZ2DUdxl3Qxn9ym5R5h7';
    	$decoded = JWT::decode($token, $key, array('HS256'));
    	if ($decoded) 
    	{
    		return $decoded->id;
    	}
    	else 
    	{
    		return false;
    	}
    	return $decoded;
	}
	
}
?>
