<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Terms extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('admin/M_terms','terms');
			$this->load->model('Common');
			if (!admin()) {
				redirect('users/admin');
			}
	}
	public function index()
	{   
		$data['term']  = $this->Common->get_details('terms',array())->row();
		$this->load->view('admin/terms/edit',$data);
	}
	
	public function editData()
	{
		$term_id     = $this->input->post('term_id');
		$description = $this->security->xss_clean($this->input->post('description'));
	
		$array = [
					'description' => $description
			    ];			
		if ($this->Common->update('term_id',$term_id,'terms',$array)) 
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Changes made successfully..!');
			redirect('admin/terms');
		}
		else
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to update data..!');
			redirect('admin/terms');
		}
	}

}
?>
