<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Settings extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			// $this->load->model('admin/M_blocks','blocks');
			$this->load->model('Common');
			if (!admin()) {
				redirect('users/admin');
			}
	}
	
/*Get Blocks*/
	public function index()
	{   
		$data['settings']  = $this->Common->get_details('settings',array('id' => '1'))->result();
		$this->load->view('admin/settings/view',$data);
	}

/*Get Block details*/	
	public function getDetails()
	{  
		$check = $this->Common->get_details('settings',array('id' => '1'));
		if ($check->num_rows() > 0) 
		{
			$data['setting']= $check->row();
		}
		else 
		{
		    $data['setting']= '';
		}
		
		print_r(json_encode($data));
	}



/*Edit posted data*/	
	public function editData()
	{
		$android_version_driver      = $this->security->xss_clean($this->input->post('android_version_driver'));
		$maintenance_driver= $this->security->xss_clean($this->input->post('maintenance_driver'));
		$play_store_update_driver= $this->security->xss_clean($this->input->post('play_store_update_driver'));
		$android_version_customer= $this->security->xss_clean($this->input->post('android_version_customer'));
		$maintenance_android_customer= $this->security->xss_clean($this->input->post('maintenance_android_customer'));
		$maintenance_ios_customer= $this->security->xss_clean($this->input->post('maintenance_ios_customer'));
		$ios_version_customer= $this->security->xss_clean($this->input->post('ios_version_customer'));
		$play_store_update_customer= $this->security->xss_clean($this->input->post('play_store_update_customer'));
		$app_store_update_customer= $this->security->xss_clean($this->input->post('app_store_update_customer'));
		
		
				$array = [
							'android_version_driver' => $android_version_driver,
							'maintenance_driver' => $maintenance_driver,
							'play_store_update_driver' => $play_store_update_driver,
							'android_version_customer' => $android_version_customer,
							'maintenance_android_customer' => $maintenance_android_customer,
							'maintenance_ios_customer' => $maintenance_ios_customer,
							'ios_version_customer' => $ios_version_customer,
							'play_store_update_customer' => $play_store_update_customer,
							'app_store_update_customer' => $app_store_update_customer,
					    ];			
			if ($this->Common->update('id','1','settings',$array)) 
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Settings updated successfully..!');
				redirect('admin/settings');
			}
			else
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to update settings..!');
				redirect('admin/settings');
			}
	}


/*Deactivate block*/
	public function disable()
	{
	    $id    = $this->input->post('block_id');
		$array = [
			       'block_status' => '2'
		         ];
	
		if ($this->Common->update('block_id',$id,'blocks',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Block deactivated successfully..!');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to deactivate block..!');
		}
		redirect('admin/blocks');
	}


}
?>
