<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Restaurants extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('admin/M_restaurants','rest');
			$this->load->model('Common');
			if (!admin()) {
				redirect('users/admin');
			}
	}
//****************************************** VIEW ************************************************************************************************************************************//	
	public function index()
	{
		$this->load->view('admin/restaurants/view');
	}
	public function get()
	{
		$result = $this->rest->make_datatables();
		$data = array();
		foreach ($result as $res) 
		{
			if ($res->status) 
			{
				$status = "Active";
				$action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="disable('.$res->r_id.')" >Disable</a>';
			}
			else 
			{
				$status = "Blocked";
				$action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="enable('.$res->r_id.')" >Enable</a>';
			}
			$sub_array = array();
			$sub_array[] = '<img src="' . base_url() . $res->thumbnail . '" height="60px">';
			$sub_array[] = $res->rest_name;
			$sub_array[] = $res->rest_code;
			$sub_array[] = date('h:i A',strtotime($res->open_time)).' TO <br>'.date('h:i A',strtotime($res->close_time));
			// $sub_array[] = '';
			$sub_array[] = $res->rest_email;
			$sub_array[] = $res->rest_phone;
			// $sub_array[] = $res->address1.'<br>'.$res->address2.'<br>'.$res->address3.'<br>'.$res->pincode.'<br>'.$res->country.'<br>'.$res->state.'<br>'.$res->landmark.'<br>'.$res->pincode;
			// $sub_array[] = $res->url;
			$sub_array[] = $status.'<br>'.$action;
			$sub_array[] = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="change_password('.$res->r_id.')"  >Password</a>';
			$sub_array[] = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" href="' . site_url('admin/restaurants/edit/'.$res->r_id) . '">Edit</a>';
            $sub_array[] = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" href="' . site_url('admin/restaurants/details/'.$res->r_id) . '">View</a>';
			$data[] = $sub_array;
		}

		$output = array(
			"draw"   => intval($_POST['draw']),
			"recordsTotal" => $this->rest->get_all_data(),
			"recordsFiltered" => $this->rest->get_filtered_data(),
			"data" => $data
		);
		echo json_encode($output);
	}
	
//************************************************* ADD *****************************************************************************************************************************//	
	public function add()
	{   
	    $data['places']  = $this->Common->get_details('places',array('status'=>'1'))->result();
		$this->load->view('admin/restaurants/add',$data);
	}
	
	public function addData()
	{
		$name      = $this->security->xss_clean($this->input->post('name'));
		$email     = $this->security->xss_clean($this->input->post('email'));
		$phone     = $this->security->xss_clean($this->input->post('phone'));
		$open_time = $this->security->xss_clean($this->input->post('open_time'));
		$close_time= $this->security->xss_clean($this->input->post('close_time'));
		$address_1 = $this->security->xss_clean($this->input->post('address_1'));
		$code      = $this->security->xss_clean($this->input->post('code'));
// 		$address_2 = $this->security->xss_clean($this->input->post('address_2'));
// 		$address_3 = $this->security->xss_clean($this->input->post('address_3'));
// 		$pincode   = $this->security->xss_clean($this->input->post('pincode'));
// 		$state     = $this->security->xss_clean($this->input->post('state'));
		$country   = $this->security->xss_clean($this->input->post('country'));
		$city      = $this->security->xss_clean($this->input->post('city'));
		$landmark  = $this->security->xss_clean($this->input->post('landmark'));
		$latitude  = $this->security->xss_clean($this->input->post('latitude'));
		$longitude = $this->security->xss_clean($this->input->post('longitude'));
		$password  = $this->security->xss_clean($this->input->post('password'));
		$delivery_vat   = $this->security->xss_clean($this->input->post('delivery_vat'));
		$delivery  = $this->security->xss_clean($this->input->post('delivery'));
		$min_order = $this->security->xss_clean($this->input->post('min_order'));
		$city_check= $this->Common->get_details('places',array('name' =>$city));
		if($city_check->num_rows()>0)
		{
		    $city_id = $city_check->row()->place_id;
		}
		else
		{
		    $city_id= '';
		}
		
		$check     = $this->Common->get_details('restaurants',array('rest_email' => $email,'rest_phone'=>$phone))->num_rows();
		if ($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Restaurant already exists..!');
			redirect('admin/restaurants/addRestaturent');
		}
		else 
		{
            $image     = $this->input->post('image');
			$img       = substr($image, strpos($image, ",") + 1);
			$url       = FCPATH.'uploads/admin/restaurants/';
			$rand      = date('Ymd').mt_rand(1001,9999);
			$userpath  = $url.$rand.'.png';
			$path      = "uploads/admin/restaurants/".$rand.'.png';
			file_put_contents($userpath,base64_decode($img));
// 			if(file_put_contents($userpath,base64_decode($img)))
// 			{
// 			    $filename = 'uploads/admin/restaurants/thumbnail/'.$rand.'thumb.png'; // output file name
//                 $fileData = base64_decode($img);
//                 $im = imagecreatefromstring($fileData);
//                 $source_width = imagesx($im);
//                 $source_height = imagesy($im);
//                 $ratio =  $source_height / $source_width;
                
//                 $new_width  = 300; // assign new width to new resized image
//                 $new_height = 350*$ratio;
                
//                 $thumb = imagecreatetruecolor($new_width, $new_height);
                
//                 $transparency = imagecolorallocatealpha($thumb, 255, 255, 255, 127);
//                 imagefilledrectangle($thumb, 0, 0, $new_width, $new_height, $transparency);
                
//                 imagecopyresampled($thumb, $im, 0, 0, 0, 0, $new_width, $new_height, $source_width, $source_height);
//                 imagepng($thumb, $filename, 9);
//                 imagedestroy($im);
// 			}
// 			else
// 			{
// 			    $filename = '';
// 			}
			
			$image2     = $this->input->post('c_image');
			$img2       = substr($image2, strpos($image2, ",") + 1);
			$url2       = FCPATH.'uploads/admin/restaurants/cover/';
			$rand2      = date('Ymd').mt_rand(1001,9999);
			$userpath2  = $url2.$rand2.'.png';
			$path2      = "uploads/admin/restaurants/cover/".$rand2.'.png';
			if(file_put_contents($userpath2,base64_decode($img2)))
			{
			    $filename = 'uploads/admin/restaurants/thumbnail/'.$rand2.'thumb.png'; // output file name
                $fileData = base64_decode($img2);
                $im = imagecreatefromstring($fileData);
                $source_width = imagesx($im);
                $source_height = imagesy($im);
                $ratio =  $source_height / $source_width;
                
                $new_width  = 300; // assign new width to new resized image
                $new_height = 350*$ratio;
                
                $thumb = imagecreatetruecolor($new_width, $new_height);
                
                $transparency = imagecolorallocatealpha($thumb, 255, 255, 255, 127);
                imagefilledrectangle($thumb, 0, 0, $new_width, $new_height, $transparency);
                
                imagecopyresampled($thumb, $im, 0, 0, 0, 0, $new_width, $new_height, $source_width, $source_height);
                imagepng($thumb, $filename, 9);
                imagedestroy($im);
			}
			else
			{
			    $filename = '';
			}
			$array = [
						'rest_name'  => $name,
						'rest_phone' => $phone,
						'rest_email' => $email,
						'rest_image' => $path,
						'cover_image'=> $path2,
						'open_time'  => $open_time,
						'close_time' => $close_time,
						'address1'   => $address_1,
				// 		'service_charge' => $service,
						'min_order'  => $min_order,
						'del_charge_without_vat' => $delivery,
						'delivery_charge'=>$delivery_vat,
						'rest_code'  => $code,
						'thumbnail'  => $filename,
				        'city_id'    => $city_id,
						'city'       => $city,
						'landmark'   => $landmark,
						'latitude'   => $latitude,
						'longitude'  => $longitude,
						'country'    => $country,
						'rest_password' => md5($password),
						'password'   => $password,
						'status'     => '1',
                        'date'       => date('Y-m-d'),
						'timestamp'  => date('Y-m-d H:i:s')
					 ];
			if ($id=$this->Common->insert('restaurants',$array))
			{
			//Start Commented Code 
			   $branch_array = [  
            				        'r_id'       => $id,
            				        'branch_code'=> $code,
            						'phone'      => $phone,
            						'email'      => $email,
            						'city_id'    => $city_id,
            						'city'       => $city,
            						'address'    => $address_1,
            						'location'   => $landmark,
            						'latitude'   => $latitude,
            						'longitude'  => $longitude,
            						'country'    => $country,
            						'password'   => md5($password),
            						'pass'       => $password,
            						'open_time'  => $open_time,
						            'close_time' => $close_time,
            						'status'     => '1',
            						'branch_type'=> '2',
                                    'date'       => date('Y-m-d'),
            						'timestamp'  => date('Y-m-d H:i:s')
            					 ];
				$this->Common->insert('branches',$branch_array);
			//End Commented Code
					 
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'New restaurant added..!');
				redirect('admin/restaurants');
			}
			else
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to add restaurant...!');
				redirect('admin/restaurants/addRestaturent');
			}
		}
	}

//*************************************** EDIT *************************************************************************************************************************************//	
	public function edit($id)
	{
		$check = $this->Common->get_details('restaurants',array('r_id' => $id));
		if ($check->num_rows() > 0) 
		{
			$data['rest']    = $check->row();
			$data['places']  = $this->Common->get_details('places',array('status'=>'1'))->result();
			$this->load->view('admin/restaurants/edit',$data);
		}
		else 
		{
			redirect('restaurants');
		}
	}
	
	public function editData()
	{
		$rest_id   = $this->input->post('rest_id');
		$name      = $this->security->xss_clean($this->input->post('name'));
		$email     = $this->security->xss_clean($this->input->post('email'));
		$phone     = $this->security->xss_clean($this->input->post('phone'));
		$open_time = $this->security->xss_clean($this->input->post('open_time'));
		$close_time= $this->security->xss_clean($this->input->post('close_time'));
		$address_1 = $this->security->xss_clean($this->input->post('address_1'));
		$code      = $this->security->xss_clean($this->input->post('code'));
// 		$address_2 = $this->security->xss_clean($this->input->post('address_2'));
// 		$address_3 = $this->security->xss_clean($this->input->post('address_3'));
// 		$pincode   = $this->security->xss_clean($this->input->post('pincode'));
// 		$state     = $this->security->xss_clean($this->input->post('state'));
		$country   = $this->security->xss_clean($this->input->post('country'));
		$city      = $this->security->xss_clean($this->input->post('city'));
		$landmark  = $this->security->xss_clean($this->input->post('landmark'));
		$latitude  = $this->security->xss_clean($this->input->post('latitude'));
		$longitude = $this->security->xss_clean($this->input->post('longitude'));
// 		$service   = $this->security->xss_clean($this->input->post('service'));
		$delivery  = $this->security->xss_clean($this->input->post('delivery'));
		$min_order = $this->security->xss_clean($this->input->post('min_order'));
		$delivery_vat   = $this->security->xss_clean($this->input->post('delivery_vat'));
		
		$city_check= $this->Common->get_details('places',array('name' =>$city));
		if($city_check->num_rows()>0)
		{
		    $city_id = $city_check->row()->place_id;
		}
		else
		{
		    $city_id= '';
		}
// 		print_r($city_id);
		$check       = $this->Common->get_details('restaurants',array('rest_email' => $email,'rest_phone'=>$phone, 'r_id!=' => $rest_id))->num_rows();
		$check_phone = $this->Common->get_details('restaurants',array('rest_phone'=>$phone, 'r_id!=' => $rest_id))->num_rows();
		$check_mail  = $this->Common->get_details('restaurants',array('rest_email'=>$email, 'r_id!=' => $rest_id))->num_rows();
		$check_email  = $this->Common->get_details('branches',array('email'=>$email,'branch_type' => 1 ))->num_rows();
		$check_code  = $this->Common->get_details('restaurants',array('rest_code'=>$code, 'r_id!=' => $rest_id))->num_rows();
		$check_bcode  = $this->Common->get_details('branches',array('branch_code'=>$code,'branch_type' => 1 ))->num_rows();
		if($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Mobile number and email already exists..!');
			redirect('admin/restaurants/edit/'.$rest_id);
		}
		elseif($check_phone > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Mobile number already exists..!');
			redirect('admin/restaurants/edit/'.$rest_id);
		}
		elseif($check_mail > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Email already exists..!');
			redirect('admin/restaurants/edit/'.$rest_id);
		}
		elseif($check_email > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Email address already registered for a branch..!');
			redirect('admin/restaurants/edit/'.$rest_id);
		}
		elseif($check_code > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Code already exists..!');
			redirect('admin/restaurants/edit/'.$rest_id);
		}
		elseif($check_bcode > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Code already exists..!');
			redirect('admin/restaurants/edit/'.$rest_id);
		}
		else 
		{
            $image  = $this->input->post('image');
            if ($image != '') 
			{
				$img = substr($image, strpos($image, ",") + 1);

				$url      = FCPATH.'uploads/admin/restaurants/';
				$rand     = date('Ymd').mt_rand(1001,9999);
				$userpath = $url.$rand.'.png';
				$path     = "uploads/admin/restaurants/".$rand.'.png';
				file_put_contents($userpath,base64_decode($img));
				// if(file_put_contents($userpath,base64_decode($img)))
    // 			{
    // 			    $filename = 'uploads/admin/restaurants/thumbnail/'.$rand.'thumb.png'; // output file name
    //                 $fileData = base64_decode($img);
    //                 $im = imagecreatefromstring($fileData);
    //                 $source_width = imagesx($im);
    //                 $source_height = imagesy($im);
    //                 $ratio =  $source_height / $source_width;
                    
    //                 $new_width  = 300; // assign new width to new resized image
    //                 $new_height = 350*$ratio;
                    
    //                 $thumb = imagecreatetruecolor($new_width, $new_height);
                    
    //                 $transparency = imagecolorallocatealpha($thumb, 255, 255, 255, 127);
    //                 imagefilledrectangle($thumb, 0, 0, $new_width, $new_height, $transparency);
                    
    //                 imagecopyresampled($thumb, $im, 0, 0, 0, 0, $new_width, $new_height, $source_width, $source_height);
    //                 imagepng($thumb, $filename, 9);
    //                 imagedestroy($im);
                    
    //                 // Remove old image from the server
    // 				$old1 = $this->Common->get_details('restaurants',array('r_id' => $rest_id))->row()->thumbnail;
    // 				$remove_path1 = FCPATH . $old1;
    // 				unlink($remove_path1);
    // 			}
    // 			else
    // 			{
    // 			    $filename = '';
    // 			}

				// Remove old image from the server
				$old = $this->Common->get_details('restaurants',array('r_id' => $rest_id))->row()->rest_image;
				$remove_path = FCPATH . $old;
				unlink($remove_path);

				$array = [
						'rest_name'  => $name,
						'rest_phone' => $phone,
						'rest_email' => $email,
						'rest_image' => $path,
				// 		'thumbnail'  => $filename,
						'open_time'  => $open_time,
						'close_time' => $close_time,
						'address1'   => $address_1,
				        'city_id'    => $city_id,
						'city'       => $city,
						'landmark'   => $landmark,
						'country'    => $country,
						'latitude'   => $latitude,
						'longitude'  => $longitude,
				// 		'service_charge' => $service,
						'min_order'  => $min_order,
						'rest_code'  => $code,
						'del_charge_without_vat' => $delivery,
						'delivery_charge'=>$delivery_vat,
					 ];
			}
			else
			{
				$array = [
						'rest_name'  => $name,
						'rest_phone' => $phone,
						'rest_email' => $email,
						'open_time'  => $open_time,
						'close_time' => $close_time,
						'address1'   => $address_1,
						'city_id'    => $city_id,
						'city'       => $city,
						'landmark'   => $landmark,
						'country'    => $country,
						'latitude'   => $latitude,
						'longitude'  => $longitude,
				// 		'service_charge' => $service,
						'min_order'  => $min_order,
						'rest_code'  => $code,
						'del_charge_without_vat' => $delivery,
						'delivery_charge'=>$delivery_vat,
					 ];
			}
		
			$image2     = $this->input->post('c_image');
			if($image2!='')
			{
			    $img2       = substr($image2, strpos($image2, ",") + 1);
    			$url2       = FCPATH.'uploads/admin/restaurants/cover/';
    			$rand2      = date('Ymd').mt_rand(1001,9999);
    			$userpath2  = $url2.$rand2.'.png';
    			$path2      = "uploads/admin/restaurants/cover/".$rand2.'.png';
    			if(file_put_contents($userpath2,base64_decode($img2)))
    			{
    		    	$filename = 'uploads/admin/restaurants/thumbnail/'.$rand2.'thumb.png'; // output file name
                    $fileData = base64_decode($img2);
                    $im = imagecreatefromstring($fileData);
                    $source_width = imagesx($im);
                    $source_height = imagesy($im);
                    $ratio =  $source_height / $source_width;
                    
                    $new_width  = 300; // assign new width to new resized image
                    $new_height = 350*$ratio;
                    
                    $thumb = imagecreatetruecolor($new_width, $new_height);
                    
                    $transparency = imagecolorallocatealpha($thumb, 255, 255, 255, 127);
                    imagefilledrectangle($thumb, 0, 0, $new_width, $new_height, $transparency);
                    
                    imagecopyresampled($thumb, $im, 0, 0, 0, 0, $new_width, $new_height, $source_width, $source_height);
                    imagepng($thumb, $filename, 9);
                    imagedestroy($im);
                    
                    // Remove old image from the server
    				$old1 = $this->Common->get_details('restaurants',array('r_id' => $rest_id))->row()->thumbnail;
    				$remove_path1 = FCPATH . $old1;
    				unlink($remove_path1);
    			}
    			else
    			{
    			    $filename = '';
    			}
    			$array['cover_image'] = $path2;
    			$array['thumbnail']   = $filename;
    			// Remove old image from the server
				$old2         = $this->Common->get_details('restaurants',array('r_id' => $rest_id))->row()->cover_image;
				$remove_path2 = FCPATH . $old2;
				unlink($remove_path2);
			}
			
			if ($this->Common->update('r_id',$rest_id,'restaurants',$array)) 
			{
			   $branch_check = $this->Common->get_details('branches',array('r_id'=>$rest_id,'branch_type'=>'2'));
			   if($branch_check->num_rows()>0)
			   {
			       $branch_id    = $branch_check->row()->b_id;
			       $branch_array = [  
                						'phone'      => $phone,
                						'email'      => $email,
                						'city_id'    => $city_id,
                						'city'       => $city,
                						'address'    => $address_1,
                						'location'   => $landmark,
                						'latitude'   => $latitude,
                						'longitude'  => $longitude,
                						'country'    => $country,
                						'branch_code'=> $code,
                						'open_time'  => $open_time,
						                'close_time' => $close_time,
                					 ];
			       $this->Common->update('b_id',$branch_id,'branches',$branch_array);
			   }
			   else
			   {
			       $rest_details = $this->Common->get_details('restaurants',array('r_id' => $rest_id))->row();
			       $branch_array = [  
                				        'r_id'       => $rest_id,
                				        'branch_code'=> $code,
                						'phone'      => $phone,
                						'email'      => $email,
                						'city_id'    => $city_id,
                						'city'       => $city,
                						'address'    => $address_1,
                						'location'   => $landmark,
                						'latitude'   => $latitude,
                						'longitude'  => $longitude,
                						'country'    => $country,
                						'password'   => $rest_details->rest_password,
                						'pass'       => $rest_details->password,
                						'status'     => '1',
                						'branch_type'=> '2',
                                        'date'       => date('Y-m-d'),
                						'timestamp'  => date('Y-m-d H:i:s')
            					 ];
                    $this->Common->insert('branches',$branch_array);        					 
			   }
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Changes made successfully..!');
				redirect('admin/restaurants');
			}
			else
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to update restaurant..!');
				redirect('admin/restaurants/edit/'.$rest_id);
			}
		}
	}

//************************************************ DETAILS *************************************************************************************************************************//
	public function details($id)
	{
		$check = $this->Common->get_details('restaurants',array('r_id' => $id));
		if ($check->num_rows() > 0) 
		{
			$data['rest'] = $check->row();
		    $types         = $this->Common->get_details('restaurant_cuisines',array('r_id'=>$id))->result();
			foreach($types as $type)
			{
				$type->name = $this->Common->get_details('cuisines',array('c_id'=>$type->c_id))->row()->name;
			}
			$data['types'] = $types;
			$this->load->view('admin/restaurants/details',$data);
		}
		else 
		{
			redirect('admin/restaurants');
		}
	}

//******************************************** DISABLE ******************************************************************************************************************************//
	public function disable()
	{
	    $id    = $this->input->post('r_id');
		$array = [
			       'status' => '0'
		         ];
	
		if ($this->Common->update('r_id',$id,'restaurants',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Restaurant blocked successfully..!');
			redirect('admin/restaurants');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block restaurant..!');
			redirect('admin/restaurants');
		}
	}

//***************************** ENABLE ********************************************************************************************************************************************//
	public function enable()
	{
	    $id    = $this->input->post('r_id');
		$array = [
			       'status' => '1'
		         ];
	
		if ($this->Common->update('r_id',$id,'restaurants',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Restaurant activated successfully..');
			redirect('admin/restaurants');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate restaurant..!');
			redirect('admin/restaurants');
	    }		
	}

//************************************* CHANGE PASSWORD ************************************************************************************************************//	
	public function changePassword()
    {
        $rest_id   = $this->security->xss_clean($this->input->post('rest_id'));
        $password  = $this->security->xss_clean($this->input->post('password'));

        $array = [
		            'rest_password' => md5($password),
		            'password'      => $password
		        ];

        $this->Common->update('r_id',$rest_id,'restaurants',$array);
        
        $branch_check = $this->Common->get_details('branches',array('r_id'=>$rest_id,'branch_type'=>'2'));
	    if($branch_check->num_rows()>0)
	    {
	        $branch_id    = $branch_check->row()->b_id;
	        $array        = [
            		            'password' => md5($password),
            		            'pass'     => $password
            		        ];
            $this->Common->update('b_id',$branch_id,'branches',$array);
	    }       
        $this->session->set_flashdata('alert_type', 'success');
		$this->session->set_flashdata('alert_title', 'Success');
		$this->session->set_flashdata('alert_message', 'Password changed successfully...!');
        redirect('admin/restaurants');
    }

//*********************************************** CHECK RESTAURANT *****************************************************************************************************************//
	public function checkRestaurant() 
	{
        $phone       = $this->input->post('phone');
        $email       = $this->input->post('email');
        $code        = $this->input->post('code');
        $check_phone = $this->Common->get_details('restaurants', array('rest_phone' => $phone));
        $check_mail  = $this->Common->get_details('restaurants', array('rest_email' => $email));
        $check_code  = $this->Common->get_details('restaurants', array('rest_code'  => $code));
        if($check_phone->num_rows() > 0) 
        {
            $data = '1';
        } 
        elseif($check_mail->num_rows() > 0) 
        {
            $data = '2';
        }
        elseif($check_code->num_rows() > 0) 
        {
            $data = '3';
        }
        else
        {
        	$data = '0';
        }
        print_r($data);
    }
}
?>
