<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Restaurant_styles extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('admin/M_styles','styles');
			$this->load->model('Common');
			if (!admin()) {
				redirect('users/admin');
			}
	}
	public function index()
	{   
		$data['styles']  = $this->styles->getRestStyles();
		$this->load->view('admin/restaurant_styles/view',$data);
	}
	public function get()
	{
		$result = $this->styles->make_datatables();
		$data = array();
		foreach ($result as $res) 
		{
			if ($res->status) 
			{
				$status = "Active";
				$action = '<a class="btn btn-danger" style="font-size:12px;" href="' . site_url('admin/restaurant_styles/disable/'.$res->rs_id) . '" >Disable</a>';
			}
			else 
			{
				$status = "Blocked";
				$action = '<a class="btn btn-success" style="font-size:12px;" href="' . site_url('admin/restaurant_styles/enable/'.$res->rs_id) . '" >Enable</a>';
			}
			$sub_array = array();
			$sub_array[] = $res->name;
			$sub_array[] = $status.'<br>'.$action;
			$sub_array[] = '<a class="btn btn-primary" style="font-size:12px;" href="' . site_url('admin/restaurant_styles/edit/'.$res->rs_id) . '">Edit</a>';
		}

		$output = array(
						"draw"            => intval($_POST['draw']),
						"recordsTotal"    => $this->styles->get_all_data(),
						"recordsFiltered" => $this->styles->get_filtered_data(),
						"data"            => $data
					);
		echo json_encode($output);
	}
	public function getDetails()
	{  
		$id= $this->input->post('id');
		$check = $this->Common->get_details('restaurant_styles',array('rs_id' => $id));
		if ($check->num_rows() > 0) 
		{
			$data= $check->row();
		}
		else 
		{
		    $data= '';
		}
		print_r(json_encode($data));
	}
	public function addData()
	{
		$name      = $this->security->xss_clean($this->input->post('name'));
		$check     = $this->Common->get_details('restaurant_styles',array('name' => $name))->num_rows();
		if ($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Restaurant style already exists..!');
			redirect('admin/restaurant_styles');
		}
		else
		{
			$array = [
						'name'       => $name,
						'status'     => '1',
                        'date'       => date('Y-m-d'),
						'timestamp'  => date('Y-m-d H:i:s')
					 ];
			if ($this->Common->insert('restaurant_styles',$array))
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'New restaurant style added..!');
				redirect('admin/restaurant_styles');
			}
			else
			 {
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to add restaurant style...!');
				redirect('admin/restaurant_styles');
			}
		}
	}
	public function editData()
	{
		$style_id  = $this->input->post('style_id');
		$name      = $this->security->xss_clean($this->input->post('name'));
		$check     = $this->Common->get_details('restaurant_styles',array('name' => $name, 'rs_id!=' => $style_id))->num_rows();
		if ($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Reataurant style already exists..!');
			redirect('admin/restaurant_styles');
		}
		else {
				$array = [
							'name'  => $name,
					    ];			
			if ($this->Common->update('rs_id',$style_id,'restaurant_styles',$array)) 
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Changes made successfully..!');
				redirect('admin/restaurant_styles');
			}
			else
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to update restaurant style..!');
				redirect('admin/restaurant_styles');
			}
		}
	}

	public function disable($id)
	{
		$array = [
			       'status' => '0'
		         ];
	
		if ($this->Common->update('rs_id',$id,'restaurant_styles',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Restaurant style blocked successfully..!');
			redirect('admin/restaurant_styles');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block restaurant style..!');
			redirect('admin/restaurant_styles');
		}
	}

	public function enable($id)
	{
		$array = [
			       'status' => '1'
		         ];
	
		if ($this->Common->update('rs_id',$id,'restaurant_styles',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Restaurant style activated successfully..');
			redirect('admin/restaurant_styles');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate restaurant style..!');
			redirect('admin/restaurants');
	    }		
	}
}
?>
