<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Reports extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->library('session');
			$this->load->helper('url');
			$this->load->model('Common');
			$this->load->model('admin/M_reports','reports');
			if (!admin()) {
				redirect('users/admin');
			}
	}

//************************************ PERFORMANCE REPORT **********************************************************************************************************//    
    public function select()
    {   
       $restaurants         = $this->Common->get_details('restaurants',array('status'=>'1'))->result();
       $data['restaurants'] = $restaurants;
       $this->load->view('admin/reports/select',$data);
    }
    
    public function report()
    {   
        $start              = $this->input->post('start_date');
		$end                = $this->input->post('end_date');
		$rest_id            = $this->input->post('rest_id');
		$start_date         = date('Y-m-d',strtotime($start));
		$end_date           = date('Y-m-d',strtotime($end));
		$orders             = $this->reports->getReports($start_date,$end_date,$rest_id);
		$total              = 0;
        foreach($orders as $order)
		{
			$order->rest      = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id))->row()->rest_name;
			$address_check    = $this->Common->get_details('ordered_address',array('order_id'=>$order->order_id));
    	    if($order->type=='guest')
    	    {
    	        if($address_check->num_rows()>0)
    		    {
    		       $address           = $address_check->row();
    	           $order->username   = $address->name;
                   $order->userphone  = $address->mobile;
                   $order->useremail  = '';
    		    }
    		    else
    		    {
    		        $order->username  = '';
                    $order->userphone = '';
                    $order->useremail = '';
    		    }
    	    }
    	    else
    	    {
    	        $user             = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
    	        $order->username  = $user->firstname.' '.$user->lastname;
                $order->userphone = $user->mobile;
                $order->useremail = $user->email;
    	    }
    	    if($address_check->num_rows()>0)
    		{
		        $address           = $address_check->row();
    		    $order->flat       = $address->flat;
    			$order->road_no    = $address->road_no;
    			$order->building   = $address->building_no;
                $order->block      = $address->block;
                $order->landmark   = $address->landmark;
                $order->area       = $address->area;
                $order->mobile     = $address->mobile;
    		}
    		else
    		{
    		    $order->flat       = '';
    			$order->road_no    = '';
    			$order->building   = '';
                $order->block      = '';
                $order->landmark   = ''; 
                $order->area       = '';
                $order->mobile     = '';
    		}
    		$driver_check     = $this->Common->get_details('driver_orders',array('order_id'=>$order->order_id));
            if($driver_check->num_rows()>0)
            {  
                $d_order          = $driver_check->row();
                $driver_detail    = $this->Common->get_details('drivers',array('dr_id'=>$d_order->driver_id))->row();
                $order->driver    = $driver_detail->name;
                $order->vehicle   = $driver_detail->vehicle_number;
            }
            else
            {
                 $order->driver    = '';
                 $order->vehicle   = ''; 
            }
    		$order->completed      = date('d M Y',strtotime($order->completed_date)).'<br>'.$order->completed_time;
    		$total                 = $total+$order->subtotal;
		}
		$data['orders']  = $orders;
		$data['total']   = $total;
		$data['date']    = 'FROM '.date('d M Y',strtotime($start)).' TO '.date('d M Y',strtotime($end));
        $this->load->view('admin/reports/view',$data);
    }
    
//************************************ DAILY PERFORMANCE REPORT **********************************************************************************************************//    
    public function select_day()
    {   
       $restaurants         = $this->Common->get_details('restaurants',array('status'=>'1'))->result();
       $data['restaurants'] = $restaurants;
       $this->load->view('admin/reports/select_day',$data);
    }
    
    public function daily_report()
    {   
        $start              = $this->input->post('start_date');
		$rest_id            = $this->input->post('rest_id');
		$start_date         = date('Y-m-d',strtotime($start));
		$orders             = $this->reports->getDailyReports($start_date,$rest_id);
		$total              = 0;
        foreach($orders as $order)
		{
			$order->rest      = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id))->row()->rest_name;
			$address_check    = $this->Common->get_details('ordered_address',array('order_id'=>$order->order_id));
    	    if($order->type=='guest')
    	    {
    	        if($address_check->num_rows()>0)
    		    {
    		       $address           = $address_check->row();
    	           $order->username   = $address->name;
                   $order->userphone  = $address->mobile;
                   $order->useremail  = '';
    		    }
    		    else
    		    {
    		        $order->username  = '';
                    $order->userphone = '';
                    $order->useremail = '';
    		    }
    	    }
    	    else
    	    {
    	        $user             = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
    	        $order->username  = $user->firstname.' '.$user->lastname;
                $order->userphone = $user->mobile;
                $order->useremail = $user->email;
    	    }
    	    if($address_check->num_rows()>0)
    		{
		        $address           = $address_check->row();
    		    $order->flat       = $address->flat;
    			$order->road_no    = $address->road_no;
    			$order->building   = $address->building_no;
                $order->block      = $address->block;
                $order->landmark   = $address->landmark;
                $order->area       = $address->area;
                $order->mobile     = $address->mobile;
    		}
    		else
    		{
    		    $order->flat       = '';
    			$order->road_no    = '';
    			$order->building   = '';
                $order->block      = '';
                $order->landmark   = ''; 
                $order->area       = '';
                $order->mobile     = '';
    		}
    		$driver_check     = $this->Common->get_details('driver_orders',array('order_id'=>$order->order_id));
            if($driver_check->num_rows()>0)
            {  
                $d_order          = $driver_check->row();
                $driver_detail    = $this->Common->get_details('drivers',array('dr_id'=>$d_order->driver_id))->row();
                $order->driver    = $driver_detail->name;
                $order->vehicle   = $driver_detail->vehicle_number;
            }
            else
            {
                 $order->driver    = '';
                 $order->vehicle   = ''; 
            }
    		$order->completed      = date('d M Y',strtotime($order->completed_date)).'<br>'.$order->completed_time;
    		$total                 = $total+$order->subtotal;
		}
		$data['orders']  = $orders;
		$data['total']   = $total;
		$data['date']    = date('d M Y',strtotime($start));
        $this->load->view('admin/reports/daily_reports',$data);
    }

//************************************ DAILY PERFORMANCE REPORT **********************************************************************************************************//    
    public function select_date()
    {   
       $restaurants         = $this->Common->get_details('restaurants',array('status'=>'1'))->result();
       $data['restaurants'] = $restaurants;
       $this->load->view('admin/reports/select_date',$data);
    }
    
    public function menu_performance()
    {   
        $start              = $this->input->post('start_date');
		$end                = $this->input->post('end_date');
		$rest_id            = $this->input->post('rest_id');
		$start_date         = date('Y-m-d',strtotime($start));
		$end_date           = date('Y-m-d',strtotime($end));
		$orders             = $this->reports->getMenuReports($start_date,$end_date,$rest_id);
        foreach($orders as $order)
		{
			$order->rest         = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id))->row()->rest_name;
			$product_check       = $this->Common->get_details('products',array('p_id'=>$order->product_id));
			if($product_check->num_rows()>0)
			{
			    $product   = $product_check->row();
			    $order->product_name = $product->name;
			}
			else
			{
			    $order->product_name = '';
			}
			
			
		}
		$data['orders']  = $orders;
		$data['date']    = 'FROM '.date('d M Y',strtotime($start)).' TO '.date('d M Y',strtotime($end));
        $this->load->view('admin/reports/menu_performance',$data);
    }
	
}
