<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Privacy extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('admin/M_privacy','privacy');
			$this->load->model('Common');
			if (!admin()) {
				redirect('users/admin');
			}
	}
	public function index()
	{   
		$data['privacy']  = $this->Common->get_details('privacy',array())->row();
		$this->load->view('admin/privacy/edit',$data);
	}

	public function editData()
	{
		$privacy_id  = $this->input->post('privacy_id');
		$description = $this->security->xss_clean($this->input->post('description'));
		
		$array = [
					'description' => $description
			    ];			
		if ($this->Common->update('privacy_id',$privacy_id,'privacy',$array)) 
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Changes made successfully..!');
			redirect('admin/privacy');
		}
		else
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to update data..!');
			redirect('admin/privacy');
		}
	}
}
?>
