<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Places extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('admin/M_places','places');
			$this->load->model('Common');
			if (!admin()) {
				redirect('users/admin');
			}
	}
	public function index()
	{   
		$data['places']  = $this->places->getPlaces();
		$this->load->view('admin/places/view',$data);
	}
	
	public function getDetails()
	{  
		$id= $this->input->post('id');
		$check = $this->Common->get_details('places',array('place_id' => $id));
		if ($check->num_rows() > 0) 
		{
			$data= $check->row();
		}
		else 
		{
		    $data= '';
		}
		print_r(json_encode($data));
	}
	public function addData()
	{
		$name      = $this->security->xss_clean($this->input->post('name'));
		$check     = $this->Common->get_details('places',array('name' => $name))->num_rows();
		if ($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'City already exists..!');
			redirect('admin/places');
		}
		else
		{
			$array = [
						'name'       => $name,
						'status'     => '1',
						'timestamp'  => date('Y-m-d H:i:s')
					 ];
			if ($this->Common->insert('places',$array))
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'New city added..!');
				redirect('admin/places');
			}
			else
			 {
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to add city ...!');
				redirect('admin/places');
			}
		}
	}
	public function editData()
	{
		$place_id= $this->input->post('place_id');
		$name      = $this->security->xss_clean($this->input->post('name'));
		$check     = $this->Common->get_details('places',array('name' => $name, 'place_id!=' => $place_id))->num_rows();
		if ($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'City already exists..!');
			redirect('admin/places');
		}
		else {
				$array = [
							'name'  => $name,
					    ];			
			if ($this->Common->update('place_id',$place_id,'places',$array)) 
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'City updated successfully..!');
				redirect('admin/places');
			}
			else
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to update city..!');
				redirect('admin/places');
			}
		}
	}

	public function disable()
	{
	    $id    = $this->input->post('place_id');
		$array = [
			       'status' => '0'
		         ];
	
		if ($this->Common->update('place_id',$id,'places',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'City blocked successfully..!');
			redirect('admin/places');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block city..!');
			redirect('admin/places');
		}
	}

	public function enable()
	{
	    $id    = $this->input->post('place_id');
		$array = [
			       'status' => '1'
		         ];
	
		if ($this->Common->update('place_id',$id,'places',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'City activated successfully..');
			redirect('admin/places');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate city..!');
			redirect('admin/places');
	    }		
	}
}
?>
