<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Orders extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('Common');
			$this->load->model('admin/M_orders','orders');
			if (!admin()) {
				redirect('app');
			}
	}
//new orders//
    public function new()
	{   
		$orders  = $this->orders->getNewOrders();
		foreach($orders as $order)
		{
			$order->rest = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id))->row()->rest_name;
			$user        = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
			$order->username  = $user->firstname.' '.$user->lastname;
			$order->userphone = $user->mobile;
			$order->useremail = $user->email;
			$address          = $this->Common->get_details('address',array('address_id'=>$order->address_id))->row();
			$order->area       = $address->area;
			$order->floor      = $address->floor;
			$order->apartment  = $address->apartment;
			$order->building   = $address->building;
            $order->street      = $address->street;
            
		}
		$data['orders']  = $orders;
		$this->load->view('admin/orders/new',$data);
	}
//active orders//	
	public function active()
	{   
		$orders  = $this->orders->getActiveOrders();
		foreach($orders as $order)
		{
			$order->rest = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id))->row()->rest_name;
			$user        = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
			$order->username  = $user->firstname.' '.$user->lastname;
			$order->userphone = $user->mobile;
			$order->useremail = $user->email;
			$address          = $this->Common->get_details('address',array('address_id'=>$order->address_id))->row();
			$order->area       = $address->area;
			$order->floor      = $address->floor;
			$order->apartment  = $address->apartment;
			$order->building   = $address->building;
            $order->street      = $address->street;
            
		}
		$data['orders']  = $orders;
		$this->load->view('admin/orders/active',$data);
	}
	
	//Block member//
	public function disable($id)
	{
		$array = [
			       'status' => '0'
		         ];
	
		if ($this->Common->update('user_id',$id,'users',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Member blocked successfully..!');
			redirect('admin/customers');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block member..!');
			redirect('admin/customers');
		}
	}

  //Activate user//	
	public function enable($id)
	{
		$array = [
			       'status' => '1'
		         ];
	
		if ($this->Common->update('user_id',$id,'users',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Member activated successfully..');
			redirect('admin/customers');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate member..!');
			redirect('admin/customers');
	    }		
	}

//completed orders//
   public function completed()
	{  
		$orders  = $this->orders->getCompletedOrders();
		foreach($orders as $order)
		{
			$order->rest = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id))->row()->rest_name;
			$user        = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
			$order->username  = $user->firstname.' '.$user->lastname;
			$order->userphone = $user->mobile;
			$order->useremail = $user->email;
			$address          = $this->Common->get_details('address',array('address_id'=>$order->address_id))->row();
			$order->area       = $address->area;
			$order->floor      = $address->floor;
			$order->apartment  = $address->apartment;
			$order->building   = $address->building;
            $order->street      = $address->street;
            
		}
		$data['orders']  = $orders;
	   $this->load->view('admin/orders/completed',$data);
	}	

//cancelled orders//
 public function cancelled()
	{  
	    $orders  = $this->orders->getCancelledOrders();
		foreach($orders as $order)
		{
			$order->rest = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id))->row()->rest_name;
			$user        = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
			$order->username  = $user->firstname.' '.$user->lastname;
			$order->userphone = $user->mobile;
			$order->useremail = $user->email;
			$address          = $this->Common->get_details('address',array('address_id'=>$order->address_id))->row();
			$order->area       = $address->area;
			$order->floor      = $address->floor;
			$order->apartment  = $address->apartment;
			$order->building   = $address->building;
            $order->street      = $address->street;
            
		}
		$data['orders']  = $orders;
	   $this->load->view('admin/orders/cancelled',$data);
	}	

//order details//
    public function details($id)
    {
	 	$order        = $this->Common->get_details('orders',array('order_id'=>$id))->row();
 	    $order->rest = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id))->row()->rest_name;
		$user        = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
		$order->username  = $user->firstname.' '.$user->lastname;
		$order->userphone = $user->mobile;
		$order->useremail = $user->email;
		$address          = $this->Common->get_details('address',array('address_id'=>$order->address_id))->row();
	 	$order->products   = $this->Common->get_details('ordered_products',array('order_id'=>$id))->result();
	 	foreach($order->products as $pro)
	 	{
	 		$pro->name   = $this->Common->get_details('products',array('p_id'=>$pro->product_id))->row()->name;
	 		$extra_check = $this->Common->get_details('ordered_extras',array('product_id'=>$pro->product_id,'order_id'=>$id,'cart_id'=>$pro->cart_id));
	 		$pro->extras = $extra_check->result();
	 		foreach($pro->extras as $extra)
	 		{
	 			$extra->name   = $this->Common->get_details('extras',array('extra_id'=>$extra->extra_id))->row()->name;
	 		}
	 	}
	 	$data['order']      = $order;
	 	$data['address']    = $address;
	 	$data['extra_check']= $extra_check;
	 	$this->load->view('admin/orders/details',$data);
    }	

}
?>
