<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Orders extends CI_Controller {
  public function __construct()
  {
      parent::__construct();
      $this->load->helper('url');
      $this->load->model('Common');
      $this->load->model('admin/M_orders','orders');
      if (!admin()) {
        redirect('users/admin');
      }
  }
//*************************************** NEW ***************************************************************************************************************************************//  
    public function new()
    {
        $this->load->view('admin/orders/new');
    }
    public function get_new()
	{
        $result = $this->orders->make_new_datatables();
		$data   = array();
		foreach ($result as $res) 
		{   
		    $address_check    = $this->Common->get_details('ordered_address',array('order_id'=>$res->order_id));
		    if($res->type=='guest')
		    {
		        if($address_check->num_rows()>0)
			    {
			       $address           = $address_check->row();
		           $user_details      = $address->name.'<br>'.$address->mobile;
			    }
			    else
			    {
			        $user_details = '';
			    }
		    }
		    else
		    {
		        $user             = $this->Common->get_details('users',array('user_id'=>$res->user_id))->row();
		        $user_details     = $user->firstname.' '.$user->lastname.'<br>'.$user->mobile.'<br>'.$user->email;
		    }
            $restaurant       = $this->Common->get_details('restaurants',array('r_id'=>$res->r_id))->row();
            
			$sub_array        = array();
			$sub_array[]      = 'ORD'.$res->order_id;
			$sub_array[]      = $restaurant->rest_name.', <br>'.$restaurant->address1;
			$sub_array[]      = $user_details;
			$sub_array[]      = date('d M Y',strtotime($res->ordered_date)).', <br>'.$res->ordered_time;
			if($address_check->num_rows()>0)
			{
			    $address           = $address_check->row();
                // $sub_array[]       = $address->flat.',<br>'.$address->area.',<br>'.$address->building_no.',<br>'.$address->block.',<br>'.$address->landmark.',<br>'.$address->mobile;
			    $sub_array[]       = $address->area.'<br>'.$address->block.', '.$address->road_no.', '.$address->building_no.', '.$address->landmark.', '.$address->flat.'<br> Mobile no: +973 '.$address->mobile;
			}
            else
            {
                $sub_array[]       = '';
            }
            $sub_array[]      = 'BHD '.number_format($res->total,'3');
            // $sub_array[]      = 'Order Placed';
			$sub_array[]      = '<a href="'.site_url('admin/orders/details/'.$res->order_id).'"><button type="button" class="btn btn-primary" style="font-size:12px;">View</button></a>';
			
			$data[]           = $sub_array;
		}

		$output       = array(
							    "draw"            => intval($_POST['draw']),
							    "recordsTotal"    => $this->orders->get_new_all_data(),
							    "recordsFiltered" => $this->orders->get_new_filtered_data(),
							    "data"            => $data
						     );
		echo json_encode($output);
	}  
  
//****************************************** SCHEDULED ******************************************************************************************************************************//
    public function scheduled()
    {
        $this->load->view('admin/orders/scheduled');
    }
    public function get_scheduled()
	{
        $result = $this->orders->make_scheduled_datatables();
		$data   = array();
		foreach ($result as $res) 
		{
		    $address_check    = $this->Common->get_details('ordered_address',array('order_id'=>$res->order_id));
		    if($res->type=='guest')
		    {
		        if($address_check->num_rows()>0)
			    {
			       $address           = $address_check->row();
		           $user_details      = $address->name.'<br>'.$address->mobile;
			    }
			    else
			    {
			        $user_details = '';
			    }
		    }
		    else
		    {
		        $user             = $this->Common->get_details('users',array('user_id'=>$res->user_id))->row();
		        $user_details     = $user->firstname.' '.$user->lastname.'<br>'.$user->mobile.'<br>'.$user->email;
		    }
            $restaurant       = $this->Common->get_details('restaurants',array('r_id'=>$res->r_id))->row();
            
			$sub_array        = array();
			$sub_array[]      = 'ORD'.$res->order_id;
			$sub_array[]      = $restaurant->rest_name.', <br>'.$restaurant->address1;
			$sub_array[]      = $user_details;
			$sub_array[]      = date('d M Y',strtotime($res->ordered_date)).', <br>'.$res->ordered_time;
            $sub_array[]      = date('d M Y',strtotime($res->delivery_date)).', <br>'.$res->delivery_time;
            if($address_check->num_rows()>0)
			{
			    $address           = $address_check->row();
			    $sub_array[]       = $address->area.'<br>'.$address->block.', '.$address->road_no.', '.$address->building_no.', '.$address->landmark.', '.$address->flat.'<br> Mobile no: +973 '.$address->mobile;
			}
            else
            {
                $sub_array[]       = '';
            }
            $sub_array[]      = 'BHD '.number_format($res->total,'3');
            // $sub_array[]      = 'Order Placed';
			$sub_array[]      = '<a href="'.site_url('admin/orders/details/'.$res->order_id).'"><button type="button" class="btn btn-primary" style="font-size:12px;">View</button></a>';
			
			$data[]           = $sub_array;
		}

		$output       = array(
							    "draw"            => intval($_POST['draw']),
							    "recordsTotal"    => $this->orders->get_scheduled_all_data(),
							    "recordsFiltered" => $this->orders->get_scheduled_filtered_data(),
							    "data"            => $data
						     );
		echo json_encode($output);
	}  
	
//*************************************** APPROVED *********************************************************************************************************************************// 
    public function approved()
    {
        $this->load->view('admin/orders/approved');
    }
    public function get_approved()
	{
        $result = $this->orders->make_approved_datatables();
		$data   = array();
		foreach ($result as $res) 
		{
		    $address_check    = $this->Common->get_details('ordered_address',array('order_id'=>$res->order_id));
		    if($res->type=='guest')
		    {
		        if($address_check->num_rows()>0)
			    {
			       $address           = $address_check->row();
		           $user_details      = $address->name.'<br>'.$address->mobile;
			    }
			    else
			    {
			        $user_details = '';
			    }
		    }
		    else
		    {
		        $user             = $this->Common->get_details('users',array('user_id'=>$res->user_id))->row();
		        $user_details     = $user->firstname.' '.$user->lastname.'<br>'.$user->mobile.'<br>'.$user->email;
		    }
            $restaurant       = $this->Common->get_details('restaurants',array('r_id'=>$res->r_id))->row();
            
			$sub_array        = array();
			$sub_array[]      = 'ORD'.$res->order_id;
			$sub_array[]      = $restaurant->rest_name.', <br>'.$restaurant->address1;
			$sub_array[]      = $user_details;
			$sub_array[]      = date('d M Y',strtotime($res->ordered_date)).', <br>'.$res->ordered_time;
			if($address_check->num_rows()>0)
			{
			    $address           = $address_check->row();
			    $sub_array[]       = $address->area.'<br>'.$address->block.', '.$address->road_no.', '.$address->building_no.', '.$address->landmark.', '.$address->flat.'<br> Mobile no: +973 '.$address->mobile;
			}
            else
            {
                $sub_array[]       = '';
            }
            $sub_array[]      = 'BHD '.number_format($res->total,'3');
            // $sub_array[]      = 'Approved';
			$sub_array[]      = '<a href="'.site_url('admin/orders/details/'.$res->order_id).'"><button type="button" class="btn btn-primary" style="font-size:12px;">View</button></a>';
			
			$data[]           = $sub_array;
		}

		$output       = array(
							    "draw"            => intval($_POST['draw']),
							    "recordsTotal"    => $this->orders->get_approved_all_data(),
							    "recordsFiltered" => $this->orders->get_approved_filtered_data(),
							    "data"            => $data
						     );
		echo json_encode($output);
	} 
	
//**************************************************** CANCELLED ************************************************************************************************************************//  
    public function cancelled()
    {  
        $orders  = $this->orders->getCancelledOrders();
        foreach($orders as $order)
        {
          $order->rest = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id))->row()->rest_name;
          if($order->branch_id=='0')
          {
              $rest           = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id))->row();
              $order->address = $rest->address1;
          }
          else
          {
               $branch_check   = $this->Common->get_details('branches',array('b_id'=>$order->branch_id));
               if($branch_check->num_rows()>0)
               {
                  $order->address = $branch_check->row()->address;
               }
               else{
                   $order->address = '';
               }
          }
            
            $address_check    = $this->Common->get_details('ordered_address',array('order_id'=>$order->order_id));
		    if($order->type=='guest')
		    {
		        if($address_check->num_rows()>0)
			    {
			       $address           = $address_check->row();
		           $order->username   = $address->name;
                   $order->userphone  = $address->mobile;
                   $order->useremail  = '';
			    }
			    else
			    {
			        $order->username  = '';
                    $order->userphone = '';
                    $order->useremail = '';
			    }
		    }
		    else
		    {
		        $user             = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
		        $order->username  = $user->firstname.' '.$user->lastname;
                $order->userphone = $user->mobile;
                $order->useremail = $user->email;
		    }
         
    		if($address_check->num_rows()>0)
    		{
    		    $address           = $address_check->row();
    		    $order->flat       = $address->flat;
    			$order->road_no    = $address->road_no;
    			$order->building   = $address->building_no;
                $order->block      = $address->block;
                $order->landmark   = $address->landmark;
                $order->area       = $address->area;
                $order->mobile     = $address->mobile;
    		}
    		else
    		{
    		    $order->flat       = '';
    			$order->road_no    = '';
    			$order->building   = '';
                $order->block      = '';
                $order->landmark   = ''; 
                $order->area       = '';
                $order->mobile     = '';
    		}
            $cancel_check       = $this->Common->get_details('cancelled_orders',array('order_id'=>$order->order_id));
            if($cancel_check->num_rows()>0)
            {  
                $c_order             = $cancel_check->row();
                $order->cancelled_by = $c_order->cancelled_by;
            }
            else
            {
               $order->cancelled_by  = '';
            }
        }
        $data['orders']  = $orders;
        $this->load->view('admin/orders/cancelled',$data);
    } 
  
//************************************************* ACTIVE *****************************************************************************************************************************// 
    public function active()
    {
        $this->load->view('admin/orders/active');
    }
    public function get_active()
	{
        $result = $this->orders->make_active_datatables();
		$data   = array();
		foreach ($result as $res) 
		{
		    $address_check    = $this->Common->get_details('ordered_address',array('order_id'=>$res->order_id));
		    if($res->type=='guest')
		    {
		        if($address_check->num_rows()>0)
			    {
			       $address           = $address_check->row();
		           $user_details      = $address->name.'<br>'.$address->mobile;
			    }
			    else
			    {
			        $user_details = '';
			    }
		    }
		    else
		    {
		        $user             = $this->Common->get_details('users',array('user_id'=>$res->user_id))->row();
		        $user_details     = $user->firstname.' '.$user->lastname.'<br>'.$user->mobile.'<br>'.$user->email;
		    }
		    
            $restaurant       = $this->Common->get_details('restaurants',array('r_id'=>$res->r_id))->row();
            $driver_check       = $this->Common->get_details('driver_orders',array('order_id'=>$res->order_id));
            if($driver_check->num_rows()>0)
            {  
                $d_order       = $driver_check->row();
                $driver_detail = $this->Common->get_details('drivers',array('dr_id'=>$d_order->driver_id))->row();
                $driver        = $driver_detail->name;
                $vehicle       = $driver_detail->vehicle_number;
            }
            else
            {
                $driver       = '';
                $vehicle      = ''; 
            }
            
			$sub_array        = array();
			$sub_array[]      = 'ORD'.$res->order_id;
			$sub_array[]      = $restaurant->rest_name.', <br>'.$restaurant->address1;
			$sub_array[]      = $user_details;
			$sub_array[]      = date('d M Y',strtotime($res->ordered_date)).', <br>'.$res->ordered_time;
			if($address_check->num_rows()>0)
			{
			    $address           = $address_check->row();
			    $sub_array[]       = $address->area.'<br>'.$address->block.', '.$address->road_no.', '.$address->building_no.', '.$address->landmark.', '.$address->flat.'<br> Mobile no: +973 '.$address->mobile;
			}
            else
            {
                $sub_array[]       = '';
            }
            $sub_array[]      = 'BHD '.number_format($res->total,'3');
            // $sub_array[]      = 'Active';
            $sub_array[]      = $driver.'<br>'.$vehicle;
			$sub_array[]      = '<a href="'.site_url('admin/orders/details/'.$res->order_id).'"><button type="button" class="btn btn-primary" style="font-size:12px;">View</button></a>';
			
			$data[]           = $sub_array;
		}

		$output       = array(
							    "draw"            => intval($_POST['draw']),
							    "recordsTotal"    => $this->orders->get_active_all_data(),
							    "recordsFiltered" => $this->orders->get_active_filtered_data(),
							    "data"            => $data
						     );
		echo json_encode($output);
	} 
	
//************************************************ DISPATCHED ***********************************************************************************************************************// 
    public function dispatched()
    {
        $this->load->view('admin/orders/dispatched');
    }
    public function get_dispatched()
	{
        $result = $this->orders->make_dispatched_datatables();
		$data   = array();
		foreach ($result as $res) 
		{
		    $address_check    = $this->Common->get_details('ordered_address',array('order_id'=>$res->order_id));
		    if($res->type=='guest')
		    {
		        if($address_check->num_rows()>0)
			    {
			       $address           = $address_check->row();
		           $user_details      = $address->name.'<br>'.$address->mobile;
			    }
			    else
			    {
			        $user_details = '';
			    }
		    }
		    else
		    {
		        $user             = $this->Common->get_details('users',array('user_id'=>$res->user_id))->row();
		        $user_details     = $user->firstname.' '.$user->lastname.'<br>'.$user->mobile.'<br>'.$user->email;
		    }
		    
            $restaurant       = $this->Common->get_details('restaurants',array('r_id'=>$res->r_id))->row();
            
			$sub_array        = array();
			$sub_array[]      = 'ORD'.$res->order_id;
			$sub_array[]      = $restaurant->rest_name.', <br>'.$restaurant->address1;
			$sub_array[]      = $user_details;
			$sub_array[]      = date('d M Y',strtotime($res->ordered_date)).', <br>'.$res->ordered_time;
			if($address_check->num_rows()>0)
			{
			    $address           = $address_check->row();
			    $sub_array[]       = $address->area.'<br>'.$address->block.', '.$address->road_no.', '.$address->building_no.', '.$address->landmark.', '.$address->flat.'<br> Mobile no: +973 '.$address->mobile;
			}
            else
            {
                $sub_array[]       = '';
            }
            $sub_array[]      = 'BHD '.number_format($res->total,'3');
            // $sub_array[]      = 'Dispatched';
			$sub_array[]      = '<a href="'.site_url('admin/orders/details/'.$res->order_id).'"><button type="button" class="btn btn-primary" style="font-size:12px;">View</button></a>';
			
			$data[]           = $sub_array;
		}

		$output       = array(
							    "draw"            => intval($_POST['draw']),
							    "recordsTotal"    => $this->orders->get_dispatched_all_data(),
							    "recordsFiltered" => $this->orders->get_dispatched_filtered_data(),
							    "data"            => $data
						     );
		echo json_encode($output);
	}  
	
//******************************************** COMPLETED *******************************************************************************************************************************//  
    public function completed()
    {
        $this->load->view('admin/orders/completed');
    }
    public function get_completed()
	{
        $result = $this->orders->make_completed_datatables();
		$data   = array();
		foreach ($result as $res) 
		{
		    $address_check    = $this->Common->get_details('ordered_address',array('order_id'=>$res->order_id));
		    if($res->type=='guest')
		    {
		        if($address_check->num_rows()>0)
			    {
			       $address           = $address_check->row();
		           $user_details      = $address->name.'<br>'.$address->mobile;
			    }
			    else
			    {
			        $user_details = '';
			    }
		    }
		    else
		    {
		        $user             = $this->Common->get_details('users',array('user_id'=>$res->user_id))->row();
		        $user_details     = $user->firstname.' '.$user->lastname.'<br>'.$user->mobile.'<br>'.$user->email;
		    }
		    
		    if($res->branch_id=='0')
              {
                  $rest           = $this->Common->get_details('restaurants',array('r_id'=>$res->r_id))->row();
                  $rest_address   = $rest->address1;
              }
              else
              {
                   $branch         = $this->Common->get_details('branches',array('b_id'=>$res->branch_id))->row();
                   $rest_address   = $branch->address;
              }
            $restaurant       = $this->Common->get_details('restaurants',array('r_id'=>$res->r_id))->row();
            $driver_check     = $this->Common->get_details('driver_orders',array('order_id'=>$res->order_id));
            if($driver_check->num_rows()>0)
            {  
                $d_order       = $driver_check->row();
                $driver_detail = $this->Common->get_details('drivers',array('dr_id'=>$d_order->driver_id))->row();
                $driver        = $driver_detail->name;
                $vehicle       = $driver_detail->vehicle_number;
            }
            else
            {
                $driver       = '';
                $vehicle      = ''; 
            }
            
			$sub_array        = array();
			$sub_array[]      = 'ORD'.$res->order_id;
			$sub_array[]      = $restaurant->rest_name.', <br>'.$rest_address;
			$sub_array[]      = $user_details;
			$sub_array[]      = date('d M Y',strtotime($res->ordered_date)).', <br>'.$res->ordered_time;
			if($address_check->num_rows()>0)
			{
			    $address           = $address_check->row();
			    $sub_array[]       = $address->area.'<br>'.$address->block.', '.$address->road_no.', '.$address->building_no.', '.$address->landmark.', '.$address->flat.'<br> Mobile no: +973 '.$address->mobile;
			}
            else
            {
                $sub_array[]       = '';
            }
            $sub_array[]      = 'BHD '.number_format($res->total,'3');
            // $sub_array[]      = 'Active';
            $sub_array[]      = $driver.'<br>'.$vehicle;
            $sub_array[]      = date('d M Y',strtotime($res->completed_date)).'<br>'.$res->completed_time;
			$sub_array[]      = '<a href="'.site_url('admin/orders/details/'.$res->order_id).'"><button type="button" class="btn btn-primary" style="font-size:12px;">View</button></a>';
			
			$data[]           = $sub_array;
		}

		$output       = array(
							    "draw"            => intval($_POST['draw']),
							    "recordsTotal"    => $this->orders->get_completed_all_data(),
							    "recordsFiltered" => $this->orders->get_completed_filtered_data(),
							    "data"            => $data
						     );
		echo json_encode($output);
  } 
  
//******************************************* DETAILS *******************************************************************************************************************************//
    public function details($id)
    {
        $order            = $this->Common->get_details('orders',array('order_id'=>$id))->row();
        $order->rest      = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id))->row()->rest_name;
        $address_check    = $this->Common->get_details('ordered_address',array('order_id'=>$order->order_id));
	    if($order->type=='guest')
	    {
	        if($address_check->num_rows()>0)
		    {
		       $address           = $address_check->row();
	           $order->username   = $address->name;
               $order->userphone  = $address->mobile;
               $order->useremail  = '';
		    }
		    else
		    {
		        $order->username  = '';
                $order->userphone = '';
                $order->useremail = '';
		    }
	    }
	    else
	    {
	        $user             = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
	        $order->username  = $user->firstname.' '.$user->lastname;
            $order->userphone = $user->mobile;
            $order->useremail = $user->email;
	    }
		if($address_check->num_rows()>0)
		{
		    $address           = $address_check->row();
		    $order->flat       = $address->flat;
			$order->road_no    = $address->road_no;
			$order->building   = $address->building_no;
            $order->block      = $address->block;
            $order->landmark   = $address->landmark;
            $order->area       = $address->area;
            $order->mobile     = $address->mobile;
		}
		else
		{
		    $order->flat       = '';
			$order->road_no    = '';
			$order->building   = '';
            $order->block      = '';
            $order->landmark   = ''; 
            $order->area       = '';
            $order->mobile     = '';
		}
        $order->products   = $this->Common->get_details('ordered_products',array('order_id'=>$id))->result();
        foreach($order->products as $product)
        {
          $extra_check     = $this->Common->get_details('ordered_extras',array('product_id'=>$product->product_id,'order_id'=>$id,'cart_id'=>$product->cart_id));
          $product->extras = $extra_check->result();    
          if($product->type=='p')
             {
                 $p_details             = $this->Common->get_details('products',array('p_id'=>$product->product_id))->row();
                //  $product->image        = $p_details->cover_image;
                 $extras                = $this->Common->get_details('ordered_extras',array('order_id'=>$order->order_id,'product_id'=>$product->product_id))->result();
    	         $product->extras       =  $extras;
    	         $sub_total       = 0;
    	         foreach($extras as $extra)
    	         {
    	             $sub_total  = $sub_total+$extra->total;
    	         }
                 $product->total_price  = $product->total+$sub_total;
             }
             else
             {
                 $p_details             = $this->Common->get_details('extras',array('extra_id'=>$product->product_id))->row();
                //  $product->image        = $p_details->image;
                 $product->prep_time    = '0';
                 $product->extras       = array();
                 $product->total_price  = $product->total;
             }
        }
        $data['order']      = $order;
        $data['extra_check']= $extra_check;
        $this->load->view('admin/orders/details',$data);
    }

//*************************************************** STATUS **************************************************************************************************************************//

  public function status($param,$id)
  {
    if($param=='1')
    {
        $array = [
                   'status' => 'approved'
                 ];
        if ($this->Common->update('order_id',$id,'orders',$array))
        {   
          $order         = $this->Common->get_details('orders',array('order_id'=>$id))->row();
          $user          = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
          $customer_name = $user->firstname.' '.$user->lastname;
          $customer_phone= $user->mobile;
          $address       = $this->Common->get_details('address',array('address_id'=>$order->address_id))->row();
          $area          = $address->area;
          $building      = $address->building;
          $house         = $address->apartment.', '.$address->floor;
          $date          = date('d-M-Y');
          $time          = date('h:i A');
          $body          = 'Your Order has been approved on '.$date.' at '.$time; 
          $this->sendApproveNotification($user->fcm,$body);
          
          $date1   = date('Y-m-d');
        //   $drivers = $this->orders->getDrivers($address->latitude,$address->longitude,$date1,$time);
        //         foreach($drivers as $driver)
        //         {
        //             $driver_check_check = $this->Common->get_details('drivers',array('dr_id'=>$driver->driver_id));
        //             if($driver_check_check->num_rows()>0)
        //             {
        //               $device_token  = $driver_check_check->row()->fcm;  
        //             }
        //             else
        //             {
        //               $device_token = ''; 
        //             }
        //             $content       = $customer_name.'('.$customer_phone.') ,'.$building.','.$house.','.$area;
        //             $this->sendDrivernotification($device_token,$content);
        //         }
        //   print_r($content);
          $this->session->set_flashdata('alert_type', 'success');
          $this->session->set_flashdata('alert_title', 'Success');
          $this->session->set_flashdata('alert_message', 'Order approved..');
          redirect('admin/orders/approved');
       }
       else 
       {
          $this->session->set_flashdata('alert_type', 'error');
          $this->session->set_flashdata('alert_title', 'Failed');
          $this->session->set_flashdata('alert_message', 'Failed to approve the order..!');
          redirect('admin/orders/new');
        }          
    }
    else if($param=='2')
    {
        $array = [
                   'status' => 'dispatched'
                 ];
        if ($this->Common->update('order_id',$id,'orders',$array))
        {   
            $status   = [
                         'dispatched_time'  => date('Y-m-d H:i:s')
                      ];
            $this->Common->update('order_id',$id,'driver_orders',$status);
          
             $this->session->set_flashdata('alert_type', 'success');
             $this->session->set_flashdata('alert_title', 'Success');
             $this->session->set_flashdata('alert_message', 'Order dispatched..');
             redirect('admin/orders/dispatched');
          }
          else 
          {
             $this->session->set_flashdata('alert_type', 'error');
             $this->session->set_flashdata('alert_title', 'Failed');
             $this->session->set_flashdata('alert_message', 'Failed to approve the order..!');
             redirect('admin/orders/new');
          }          
    }
    else
    {
        $array = [
                   'status' => 'cancelled',
                   'cancelled_by' => 'admin'
                 ];
          if ($this->Common->update('order_id',$id,'orders',$array))
          {   
            // $cancel  = [
            //           'canc'
            //            ]
    
            $this->session->set_flashdata('alert_type', 'success');
            $this->session->set_flashdata('alert_title', 'Success');
            $this->session->set_flashdata('alert_message', 'Order cancelled..');
            redirect('admin/orders/cancelled');
          }
          else 
          {
                $this->session->set_flashdata('alert_type', 'error');
                $this->session->set_flashdata('alert_title', 'Failed');
                $this->session->set_flashdata('alert_message', 'Failed to cancel the order..!');
                redirect('admin/orders/new');
            }           
    }     
  }

//*********************************************************** SEND DRIVER NOTIFICATION *****************************************************************************************************//
   public function sendDrivernotification($id,$content)
   {
          $SERVER_API_KEY = "AAAAKjNFP5M:APA91bG4yMG9c0Y6NGPh2gMQT77gTT9cy-ZenigVrh5RZJfBUxZZZYgynM06KTTFrtxyBoFfjqef2VIfVVFPL-cnhgAgJwbzHWsQvmzShzg9lAXFK8emE6EjVILc99TzYA0f3rrXPgkU";
          $header = [
            'Authorization: key='. $SERVER_API_KEY,
            'Content-Type: Application/json'
          ];
          $msg = [
            'title' => 'New Order',
            'body'  => $content
          ];
          
          $notification = [
            'title'             => 'New Order',
            'body'              => $content,
            'content_available' => true
          ];
          
          $payload = [
            'data'         => $msg,
            'notification' => $notification,
            'to'           => $id,
            'priority'     => 10
          ];
          $url = 'https://fcm.googleapis.com/fcm/send';
        
          $curl = curl_init();
        
          curl_setopt_array($curl, array(
             CURLOPT_URL            => "https://fcm.googleapis.com/fcm/send",
             CURLOPT_RETURNTRANSFER => true,
             CURLOPT_CUSTOMREQUEST  => "POST",
             CURLOPT_POSTFIELDS     => json_encode($payload),
             CURLOPT_HTTPHEADER     => $header,
          ));
        
          $response = curl_exec($curl);
          $err = curl_error($curl);
        
          curl_close($curl);
            
            return true;
    }

//************************************************************* SEND APPROVE NOTIFICATION ******************************************************************************************//  
   public function sendApproveNotification($id,$content)
   {
          $SERVER_API_KEY = "AAAAKjNFP5M:APA91bG4yMG9c0Y6NGPh2gMQT77gTT9cy-ZenigVrh5RZJfBUxZZZYgynM06KTTFrtxyBoFfjqef2VIfVVFPL-cnhgAgJwbzHWsQvmzShzg9lAXFK8emE6EjVILc99TzYA0f3rrXPgkU";
          $header = [
            'Authorization: key='. $SERVER_API_KEY,
            'Content-Type: Application/json'
          ];
          $msg = [
            'title' => 'New Order',
            'body'  => $content
          ];
          
          $notification = [
            'title'             => 'New Order',
            'body'              => $content,
            'content_available' => true
          ];
          
          $payload = [
            'data'         => $msg,
            'notification' => $notification,
            'to'           => $id,
            'priority'     => 10
          ];
          $url = 'https://fcm.googleapis.com/fcm/send';
        
          $curl = curl_init();
        
          curl_setopt_array($curl, array(
             CURLOPT_URL            => "https://fcm.googleapis.com/fcm/send",
             CURLOPT_RETURNTRANSFER => true,
             CURLOPT_CUSTOMREQUEST  => "POST",
             CURLOPT_POSTFIELDS     => json_encode($payload),
             CURLOPT_HTTPHEADER     => $header,
          ));
        
          $response = curl_exec($curl);
          $err = curl_error($curl);
        
          curl_close($curl);
            
            return true;
    }
  
}
?>
