<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Offers extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('Common');
			$this->load->model('admin/M_offers','offer');
			if (!admin()) {
				redirect('users/admin');
			}
	}
//coupons//	
	public function coupons()
	{   
		$coupons  = $this->offer->getCoupons();
		foreach($coupons as $coup)
		{
			$coup->restaurant = $this->Common->get_details('restaurants',array('r_id'=>$coup->r_id))->row()->rest_name;
		}
		$data['coupons'] = $coupons;
		$data['restaurants'] = $this->Common->get_details('restaurants',array('status'=>'1'))->result();
		$this->load->view('admin/offers/view_coupon',$data);
	}

	public function addCoupon()
	{   
		$rest_id      = $this->security->xss_clean($this->input->post('rest_id'));
		$title        = $this->security->xss_clean($this->input->post('title'));
		$description  = $this->security->xss_clean($this->input->post('description'));
		$code         = $this->security->xss_clean($this->input->post('code'));
		$percentage   = $this->security->xss_clean($this->input->post('percentage'));
		$cart         = $this->security->xss_clean($this->input->post('cart'));
		$start_date   = $this->security->xss_clean($this->input->post('start_date'));
		$end_date     = $this->security->xss_clean($this->input->post('end_date'));
		$start_time   = $this->security->xss_clean($this->input->post('start_time'));
		$end_time     = $this->security->xss_clean($this->input->post('end_time'));

		$data         = [
			              'r_id'            => $rest_id,
			              'offer_code'      => $code,
			              'description'     => $description,
			              'title'           => $title,
			              'percentage'      => $percentage,
			              'max_value'       => $cart,
			              'start_date'      => $start_date,
			              'end_date'        => $end_date,
			              'start_time'      => $start_time,
			              'end_time'        => $end_time,
			              'added_date'      => date('Y-m-d'),
			              'offer_starts'    => $start_date.' '.$start_time,
			              'offer_ends'      => $end_date.' '.$end_time,
			              'timestamp'       => date('Y-m-d H:i:s')
		                ];
		
		if ($this->Common->insert('coupons',$data)) 
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Coupon added successfully..!');
		}
		else
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to add coupon..!');
		}
		redirect('admin/offers/coupons');
	}

	public function editCoupon()
	{   
		$coupon_id    = $this->security->xss_clean($this->input->post('coupon_id'));
		$rest_id      = $this->security->xss_clean($this->input->post('rest_id'));
		$title        = $this->security->xss_clean($this->input->post('title'));
		$description  = $this->security->xss_clean($this->input->post('description'));
		$code         = $this->security->xss_clean($this->input->post('code'));
		$percentage   = $this->security->xss_clean($this->input->post('percentage'));
		$cart         = $this->security->xss_clean($this->input->post('cart'));
		$start_date   = $this->security->xss_clean($this->input->post('start_date'));
		$end_date     = $this->security->xss_clean($this->input->post('end_date'));
		$start_time   = $this->security->xss_clean($this->input->post('start_time'));
		$end_time     = $this->security->xss_clean($this->input->post('end_time'));

		$data         = [
			              'r_id'            => $rest_id,
			              'offer_code'      => $code,
			              'description'     => $description,
			              'title'           => $title,
			              'percentage'      => $percentage,
			              'max_value'       => $cart,
			              'start_date'      => $start_date,
			              'end_date'        => $end_date,
			              'start_time'      => $start_time,
			              'end_time'        => $end_time,
			              'offer_starts'    => $start_date.' '.$start_time,
			              'offer_ends'      => $end_date.' '.$end_time,
		                ];
		
		if ($this->Common->update('c_id',$coupon_id,'coupons',$data)) 
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Coupon updated successfully..!');
		}
		else
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to edit coupon..!');
		}
		redirect('admin/offers/coupons');
	}

	public function disable_coupon()
	{
	    $id    = $this->input->post('coupon_id');
		$array = [
			       'status' => '0'
		         ];
	
		if ($this->Common->update('c_id',$id,'coupons',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Coupon blocked successfully..!');
			redirect('admin/offers/coupons');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block coupon..!');
			redirect('admin/offers/coupons');
		}
	}
	public function enable_coupon()
	{
	    $id    = $this->input->post('coupon_id');
		$array = [
			       'status' => '1'
		         ];
	
		if ($this->Common->update('c_id',$id,'coupons',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Coupon activated successfully..');
			redirect('admin/offers/coupons');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate coupon..!');
			redirect('admin/offers/coupons');
	    }		
	}

	public function getCouponDetails()
	{
		$coupon_id       = $_POST['id'];
		$coupon          = $this->Common->get_details('coupons',array('c_id'=>$coupon_id))->row();
		$data['coupons']  = $coupon;
		$restaurants     = $this->Common->get_details('restaurants',array('status' =>'1'))->result();
		$options = '<option value="">-- Choose Restaurant ---</option>';
         foreach ($restaurants as $rest) 
         {
            if ($rest->r_id == $coupon->r_id) 
            {
                $options = $options . '<option value="' . $rest->r_id . '" selected>' . $rest->rest_name . '</option>';
            }
            else 
            {
                $options = $options . '<option value="' . $rest->r_id . '">' . $rest->rest_name . '</option>';
            }
        }
        $data['restaurants'] = $options;
		print_r(json_encode($data));
	}
    
    public function checkCoupon()
    {
    	$code = $this->input->post('code');
    	$check= $this->Common->get_details('coupons',array('offer_code'=>$code));
    	if($check->num_rows()>0)
    	{
    		$data = '1';
    	}
        else
        {
        	$data = '0';
        }
        print_r($data);
    }

    public function checkCouponById()
    {
    	$code = $this->input->post('code');
    	$id   = $this->input->post('id');
    	$check= $this->Common->get_details('coupons',array('offer_code'=>$code,'c_id!='=>$id));
    	if($check->num_rows()>0)
    	{
    		$data = '1';
    	}
        else
        {
        	$data = '0';
        }
        print_r($data);
    }

//promotions//
    public function promotions()
	{   
		$promotions  = $this->offer->getPromotions();
		foreach($promotions as $pro)
		{
			$pro->restaurant = $this->Common->get_details('restaurants',array('r_id'=>$pro->r_id))->row()->rest_name;
		}
		$data['promotions'] = $promotions;
		$data['restaurants'] = $this->Common->get_details('restaurants',array('status'=>'1'))->result();
		$this->load->view('admin/offers/view_promotion',$data);
	}

	public function disable_promotion()
	{
	    $id    = $this->input->post('promotion_id');
		$array = [
			       'status' => 'blocked'
		         ];
	
		if ($this->Common->update('pr_id',$id,'promotions',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Promotion blocked successfully..!');
			redirect('admin/offers/promotions');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block coupon..!');
			redirect('admin/offers/promotions');
		}
	}
	public function enable_promotion()
	{
	    $id    = $this->input->post('promotion_id');
		$array = [
			       'status' => 'active'
		         ];
	
		if ($this->Common->update('pr_id',$id,'promotions',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Promotion activated successfully..');
			redirect('admin/offers/promotions');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate promotion..!');
			redirect('admin/offers/promotions');
	    }		
	}
	public function accept_promotion()
	{
	    $id    = $this->input->post('promotion_id');
		$array = [
			       'status' => 'active'
		         ];
	
		if ($this->Common->update('pr_id',$id,'promotions',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Promotion accepted successfully..');
			redirect('admin/offers/promotions');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to accept promotion..!');
			redirect('admin/offers/promotions');
	    }		
	}

}
?>
