<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Media extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('Common');
			if (!admin()) {
				redirect('users/admin');
			}
	}
	public function index()
	{   
		$data['medias']  = $this->Common->get_details('social_media',array())->result();
		$this->load->view('admin/media/view',$data);
	}
	
	public function getDetails()
	{  
		$id= $this->input->post('id');
		$check = $this->Common->get_details('social_media',array('sm_id' => $id));
		if ($check->num_rows() > 0) 
		{
			$data= $check->row();
		}
		else 
		{
		    $data= '';
		}
		print_r(json_encode($data));
	}
	public function addData()
	{
		$title       = $this->security->xss_clean($this->input->post('title'));
		$description = $this->security->xss_clean($this->input->post('description'));
		$check       = $this->Common->get_details('terms',array('title' => $title))->num_rows();
		if ($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Data already exists..!');
			redirect('admin/terms');
		}
		else
		{
			$array = [
						'title'       => $title,
						'description' => $description,
						'status'      => '1',
						'timestamp'   => date('Y-m-d H:i:s')
					 ];
			if ($this->Common->insert('terms',$array))
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'New data added..!');
				redirect('admin/terms');
			}
			else
			 {
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to add cuisine type...!');
				redirect('admin/terms');
			}
		}
	}
	public function editData()
	{
		$media_id    = $this->input->post('sm_id');
        $link        = $this->security->xss_clean($this->input->post('link'));
		
		$array       = [
        					'link' => $link
        			    ];			
		if ($this->Common->update('sm_id',$media_id,'social_media',$array)) 
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Changes made successfully..!');
			redirect('admin/media');
		}
		else
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to update data..!');
			redirect('admin/media');
		}
	}



}
?>
