<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Home_section extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('admin/M_section','section');
			$this->load->model('Common');
			if (!admin()) {
				redirect('users/admin');
			}
	}
	public function index()
	{   
		  $sections = $this->section->getHomeSection();
		  foreach($sections as $sec)
		  {
		  	if($sec->type!='0')
		  	{
				$sec->cuisines   = $this->Common->get_details('section_cuisines',array('hs_id'=>$sec->hs_id))->result();
				foreach($sec->cuisines as $cu)
				{
					$cu->name = $this->Common->get_details('cuisines',array('c_id'=>$cu->c_id))->row()->name;
				}
		  	}    
		  }
		  $data['sections'] =  $sections;
		$this->load->view('admin/home_section/view',$data);
	}

	public function add()
	{   
		$data['restaurants']  = $this->Common->get_details('restaurants',array('status'=>'1'))->result();
		$data['cuisines']     = $this->Common->get_details('cuisines',array('status'=>'1'))->result();
		$data['category']     = $this->Common->get_details('section_category',array('status'=>'1'))->result();
		$this->load->view('admin/home_section/add',$data);
	}

	public function addData()
	{   
		$title         = $this->security->xss_clean($this->input->post('title'));
		$type          = $this->security->xss_clean($this->input->post('type'));
		if($type=='1')
		{
			$cuisines   = $this->input->post('cuisines');
		}
		else
		{
			$cuisines   = '';
		}
        
        $data          = [
        	               'title'    => $title,
        	               'type'     => $type,
        	               'status'   => '1',
        	               'date'     => date('Y-m-d'),
        	               'timestamp'=> date('Y-m-d H:i:s')
                         ];
        if($id=$this->Common->insert('home_section',$data))
        {
            if($cuisines!='')
            {
                foreach($cuisines as $cu)
    			{ 
    		    	$array  = [
    				             'c_id'      => $cu,
    				             'hs_id'     => $id,
    				             'timestamp' => date('Y-m-d H:i:s')
    			              ];
    		        $this->Common->insert('section_cuisines',$array);
    			}
            }
	        
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Home section added successfully..!');
			redirect('admin/home_section');
        }
        else
        {
        	$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to add home section..!');
			redirect('admin/home_section/add');
        }	
          // print_r($type);               
	}
	
	public function edit($id)
	{   
		$section  = $this->Common->get_details('home_section',array('hs_id'=>$id))->row();
		$cuisines = $this->Common->get_details('cuisines',array('status'=>'1'))->result();
		foreach($cuisines as $cu)
		{
			$stat_check      = $this->Common->get_details('section_cuisines',array('hs_id'=>$id,'c_id'=>$cu->c_id))->num_rows();
			if($stat_check>0)
			{
				$cu->stat  = '1';
			}
			else
			{
				$cu->stat  = '0';
			}
		}
		$data['cuisines']    = $cuisines;
		$data['section']     = $section;
		$this->load->view('admin/home_section/edit',$data);
	}

	public function getDetails()
	{  
		$id= $this->input->post('id');
		$check = $this->Common->get_details('home_section',array('hs_id' => $id));
		if ($check->num_rows() > 0) 
		{
			$data= $check->row();
		}
		else 
		{
		    $data= '';
		}
		print_r(json_encode($data));
	}

	public function editData()
	{
		$section_id    = $this->input->post('section_id');
		$title         = $this->security->xss_clean($this->input->post('title'));
		$type          = $this->security->xss_clean($this->input->post('type'));
		if($type=='1')
		{
			$cuisines   = $this->input->post('cuisines');
		}
		else
		{
			$cuisines   = '';
		}
        
        $data          = [
        	               'title'    => $title,
        	               'type'     => $type
                         ];
        if($this->Common->update('hs_id',$section_id,'home_section',$data))
        {   
        	$this->Common->delete('section_cuisines',array('hs_id'=>$section_id));
        // 	$cuisines = $this->input->post('cuisines');	
            if($cuisines!='')
            {
                if(count($cuisines)>0)
            	{
        	        foreach($cuisines as $cu)
        			{ 
        		    	$array  = [
        				             'c_id'      => $cu,
        				             'hs_id'     => $section_id,
        				             'timestamp' => date('Y-m-d H:i:s')
        			              ];
        		        $this->Common->insert('section_cuisines',$array);
        			}
            	}
            }
        	
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Home section updated successfully..!');
			redirect('admin/home_section');
        }
        else
        {
        	$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to update data..!');
			redirect('admin/home_section/add');
        }	
	}

	public function getRestaurants()
	{
		$cuisine   = $_POST['cu_id'];
		$array     = $this->Common->get_details('restaurant_cuisines',array('c_id'=>$cuisine))->result();
		$string = '';
		foreach ($array as $sub) {
			$name = $this->Common->get_details('restaurants',array('r_id'=>$sub->r_id))->row()->rest_name;
			$string  = $string . "<option value='".$sub->r_id."'>".$name."</option>";
		}
		print_r(json_encode($string));
	}

	public function disable()
	{
	    $id    = $this->input->post('section_id');
		$array = [
			       'status' => '0'
		         ];
	
		if ($this->Common->update('hs_id',$id,'home_section',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Home section blocked successfully..!');
			redirect('admin/home_section');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block section..!');
			redirect('admin/home_section');
		}
	}

	public function enable()
	{
	    $id    = $this->input->post('section_id');
		$array = [
			       'status' => '1'
		         ];
	
		if ($this->Common->update('hs_id',$id,'home_section',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Home section activated successfully..');
			redirect('admin/home_section');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate section..!');
			redirect('admin/home_section');
	    }		
	}

//section category//
    public function category()
	{   
		$data['category']  = $this->section->getCatgeory();
		$this->load->view('admin/home_section/category',$data);
	}	
	
	public function addCategory()
	{
		$name      = $this->security->xss_clean($this->input->post('name'));
		$check     = $this->Common->get_details('section_category',array('name' => $name))->num_rows();
		if ($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Section category already exists..!');
			redirect('admin/home_section/category');
		}
		else
		{
			$array = [
						'name'       => $name,
						'status'     => '1',
						'timestamp'  => date('Y-m-d H:i:s')
					 ];
			if ($this->Common->insert('section_category',$array))
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'New section category added..!');
				redirect('admin/home_section/category');
			}
			else
			 {
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to add section category...!');
				redirect('admin/home_section/category');
			}
		}
	}

	public function editCategory()
	{
		$cat_id    = $this->input->post('cat_id');
		$name      = $this->security->xss_clean($this->input->post('name'));
		$check     = $this->Common->get_details('section_category',array('name' => $name, 'sc_id!=' => $cat_id))->num_rows();
		if ($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Reataurant style already exists..!');
			redirect('admin/home_section/category');
		}
		else {
				$array = [
							'name'  => $name,
					    ];			
			if ($this->Common->update('sc_id',$cat_id,'section_category',$array)) 
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Changes made successfully..!');
				redirect('admin/home_section/category');
			}
			else
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to update section category..!');
				redirect('admin/home_section/category');
			}
		}
	}

	public function getCategoryDetails()
	{  
		$id= $this->input->post('id');
		$check = $this->Common->get_details('section_category',array('sc_id' => $id));
		if ($check->num_rows() > 0) 
		{
			$data= $check->row();
		}
		else 
		{
		    $data= '';
		}
		print_r(json_encode($data));
	}

	public function disable_category()
	{
	    $id    = $this->input->post('section_id');
		$array = [
			       'status' => '0'
		         ];
	
		if ($this->Common->update('sc_id',$id,'section_category',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Section blocked successfully..!');
			redirect('admin/home_section/category');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block section..!');
			redirect('admin/home_section/category');
		}
	}

	public function enable_category()
	{
	    $id    = $this->input->post('section_id');
		$array = [
			       'status' => '1'
		         ];
	
		if ($this->Common->update('sc_id',$id,'section_category',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Section activated successfully..');
			redirect('admin/home_section/category');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate section..!');
			redirect('admin/home_section/category');
	    }		
	}
}
?>
