<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Help extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('Common');
			if (!admin()) {
				redirect('users/admin');
			}
	}
	public function index()
	{   
		$data['help']  = $this->Common->get_details('help',array())->row();
		$this->load->view('admin/help/edit',$data);
	}
	
	public function editData()
	{
		$help_id      = $this->input->post('help_id');
		$description  = $this->security->xss_clean($this->input->post('description'));
		
		$array        = [
					       'content' => $description
			            ];			
		if ($this->Common->update('help_id',$help_id,'help',$array)) 
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Changes made successfully..!');
			redirect('admin/help');
		}
		else
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to update data..!');
			redirect('admin/help');
		}
	}

}
?>
