<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Fare_card extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('admin/M_fare','fare');
			$this->load->model('Common');
			if (!admin()) {
				redirect('users/admin');
			}
	}
	public function index()
	{   
		$data['cards']  = $this->fare->getDriverFareCard();
		$this->load->view('admin/fare_card/view',$data);
	}
	
	public function getDetails()
	{  
		$id= $this->input->post('id');
		$check = $this->Common->get_details('fare_card',array('fc_id' => $id));
		if ($check->num_rows() > 0) 
		{
			$data= $check->row();
		}
		else 
		{
		    $data= '';
		}
		print_r(json_encode($data));
	}

	public function editData()
	{
		$card_id         = $this->input->post('card_id');
		$base_fare       = $this->security->xss_clean($this->input->post('base_fare'));
		$free_distance   = $this->security->xss_clean($this->input->post('free_distance'));
		$free_time       = $this->security->xss_clean($this->input->post('free_time'));
		$distance_charges= $this->security->xss_clean($this->input->post('distance_charges'));
		$time_charges    = $this->security->xss_clean($this->input->post('time_charges'));
		$free_waiting_time= $this->security->xss_clean($this->input->post('free_waiting_time'));
		$waiting_charges = $this->security->xss_clean($this->input->post('waiting_charges'));
		$fixed_charge    = $this->security->xss_clean($this->input->post('fixed_charge'));
		$delivery_fees   = $this->security->xss_clean($this->input->post('delivery_fees'));
		
		$array     = [
						'base_fare'         => $base_fare,
						'free_distance'     => $free_distance,
						'free_time'         => $free_time,
						'distance_charges'  => $distance_charges,
						'time_charges'      => $time_charges,
						'free_waiting_time' => $free_waiting_time,
						'waiting_charges'   => $waiting_charges,
						'fixed_charge'      => $fixed_charge,
						'delivery_fees'     => $delivery_fees
				    ];			
		if ($this->Common->update('fc_id',$card_id,'fare_card',$array)) 
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Changes made successfully..!');
			redirect('admin/fare_card');
		}
		else
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to update fare card..!');
			redirect('admin/fare_card');
		}
	}

	
	
}
?>
