<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Drivers extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('admin/M_drivers','drivers');
			$this->load->model('Common');
			if (!admin()) {
				redirect('users/admin');
			}
	}
	public function index()
	{
	    $drivers  = $this->drivers->getDrivers();
	    foreach($drivers as $driver)
	    {
	        $city_check = $this->Common->get_details('places',array('place_id'=>$driver->city));
			if($city_check->num_rows()>0)
			{
			    $city   = $city_check->row()->name;
			}
			else
			{
			    $city  = '';
			}
			$driver->city = $city;
	    }
	    $data['drivers'] = $drivers;
		$this->load->view('admin/drivers/view',$data);
	}
	public function get()
	{
		$result = $this->drivers->make_datatables();
		$data = array();
		foreach ($result as $res) 
		{
			if ($res->status=='1') 
			{
				$status = "Active";
				$action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="disable('.$res->dr_id.')" >Disable</a>';
			}
			else 
			{
				$status = "Blocked";
				$action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="enable('.$res->dr_id.')" >Enable</a>';
			}
			$city_check = $this->Common->get_details('places',array('place_id'=>$res->city));
			if($city_check->num_rows()>0)
			{
			    $city   = $city_check->row()->name;
			}
			else
			{
			    $city  = '';
			}
			$sub_array   = array();
			$sub_array[] = $res->name;
			$sub_array[] = $res->phone;
			$sub_array[] = $res->email;
			$sub_array[] = $res->vehicle_number;
			$sub_array[] = $res->jrms_code;
			$sub_array[] = $city;
			$sub_array[] = $status.'<br>'.$action;
			$sub_array[] = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" href="' . site_url('admin/drivers/edit/'.$res->dr_id) . '">Edit</a>';
			$sub_array[] = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="del('.$res->dr_id.')" >Delete</a>';
			$data[] = $sub_array;
		}

		$output = array(
			"draw"   => intval($_POST['draw']),
			"recordsTotal" => $this->drivers->get_all_data(),
			"recordsFiltered" => $this->drivers->get_filtered_data(),
			"data" => $data
		);
		echo json_encode($output);
	}
	public function add()
	{   
	    $data['places'] = $this->Common->get_details('places',array('status'=>'1'))->result();
		$this->load->view('admin/drivers/add',$data);
	}
	public function edit($id)
	{
		$check = $this->Common->get_details('drivers',array('dr_id' => $id));
		if ($check->num_rows() > 0) 
		{
			$data['driver'] = $check->row();
			$data['places'] = $this->Common->get_details('places',array('status'=>'1'))->result();
			$this->load->view('admin/drivers/edit',$data);
		}
		else 
		{
			redirect('admin/drivers');
		}
	}
	public function addData()
	{
		$name      = $this->security->xss_clean($this->input->post('name'));
		$email     = $this->security->xss_clean($this->input->post('email'));
		$phone     = $this->security->xss_clean($this->input->post('phone'));
		$code      = $this->security->xss_clean($this->input->post('code'));
// 		$pincode   = $this->security->xss_clean($this->input->post('pincode'));
// 		$state     = $this->security->xss_clean($this->input->post('state'));
        $vehicle_no= $this->security->xss_clean($this->input->post('vehicle_no'));
		$country   = $this->security->xss_clean($this->input->post('country'));
		$city      = $this->security->xss_clean($this->input->post('city'));
		$password  = $this->security->xss_clean($this->input->post('password'));
	    
	    $image   = $this->input->post('image');
		$img     = substr($image, strpos($image, ",") + 1);
	    if($image!='')
	    {
	        $url      = FCPATH.'uploads/admin/drivers/';
    		$rand     = date('Ymd').mt_rand(1001,9999);
    		$userpath = $url.$rand.'.png';
    		$path     = "uploads/admin/drivers/".$rand.'.png';
    		file_put_contents($userpath,base64_decode($img));
	    }
		else
		{
		    $path     = '';
		}
	
		$licence   = $this->input->post('c_image');
		$lic     = substr($licence, strpos($licence, ",") + 1);
	    if($licence!='')
	    {
	        $url      = FCPATH.'uploads/admin/driver-licences/';
    		$rand2     = date('Ymd').mt_rand(1001,9999);
    		$userpath2 = $url.$rand2.'.png';
    		$path1     = "uploads/admin/driver-licences/".$rand2.'.png';
    		file_put_contents($userpath2,base64_decode($lic));
	    }else
		{
		    $path1     = '';
		}
		$array = [
					'name'       => $name,
					'phone'      => $phone,
					'email'      => $email,
					'jrms_code'  => $code,
					'image'      => $path,
					'licence'	 => $path1,
				// 	'state'      => $state,
					'city'       => $city,
					'vehicle_number' => $vehicle_no,
					'country'    => $country,
					'password'   => md5($password),
					'pass'       => $password,
					'status'     => '1',
                    'date'       => date('Y-m-d'),
					'timestamp'  => date('Y-m-d H:i:s')
				 ];
			if ($this->Common->insert('drivers',$array))
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Driver added..!');
				redirect('admin/drivers');
			}
			else
			 {
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to add driver...!');
				redirect('admin/drivers/add');
			}
	}
	public function editData()
	{
		$driver_id = $this->input->post('driver_id');
		$name      = $this->security->xss_clean($this->input->post('name'));
		$email     = $this->security->xss_clean($this->input->post('email'));
		$phone     = $this->security->xss_clean($this->input->post('phone'));
		$code      = $this->security->xss_clean($this->input->post('code'));
// 		$pincode   = $this->security->xss_clean($this->input->post('pincode'));
		$vehicle_no= $this->security->xss_clean($this->input->post('vehicle_no'));
		$country   = $this->security->xss_clean($this->input->post('country'));
		$city      = $this->security->xss_clean($this->input->post('city'));
		$check     = $this->Common->get_details('drivers',array('phone' => $phone,'email'=>$email, 'dr_id!=' => $driver_id))->num_rows();
		$check_phone = $this->Common->get_details('drivers',array('phone' => $phone,'dr_id!=' => $driver_id))->num_rows(); 
		$check_mail  = $this->Common->get_details('drivers',array('email' => $email,'dr_id!=' => $driver_id))->num_rows();
		$check_code  = $this->Common->get_details('drivers',array('jrms_code' => $code,'dr_id!=' => $driver_id))->num_rows();
		if ($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Mobile number and email already exists..!');
			redirect('admin/drivers/edit/'.$driver_id);
		}
		elseif($check_phone>0)
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Mobile number already exists..!');
			redirect('admin/drivers/edit/'.$driver_id);
		}
		elseif($check_mail>0)
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Email already exists..!');
			redirect('admin/drivers/edit/'.$driver_id);
		}
		elseif($check_code>0)
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Code already exists..!');
			redirect('admin/drivers/edit/'.$driver_id);
		}
		else 
		{
		    $image   = $this->input->post('image');
    	    if($image!='')
    	    {
    	        $img      = substr($image, strpos($image, ",") + 1);
    	        $url      = FCPATH.'uploads/admin/drivers/';
        		$rand     = date('Ymd').mt_rand(1001,9999);
        		$userpath = $url.$rand.'.png';
        		$path     = "uploads/admin/drivers/".$rand.'.png';
        		file_put_contents($userpath,base64_decode($img));
    	   
				$array = [
						'name'       => $name,
						'phone'      => $phone,
						'email'      => $email,
						'jrms_code'  => $code,
						'vehicle_number' => $vehicle_no,
						'city'       => $city,
				// 		'pincode'    => $pincode,
						'country'    => $country,
						'image'      => $path
					 ];
			}
			else
			{
				$array = [
						'name'       => $name,
						'phone'      => $phone,
						'email'      => $email,
						'jrms_code'  => $code,
						'vehicle_number' => $vehicle_no,
						'city'       => $city,
				// 		'pincode'    => $pincode,
						'country'    => $country
					 ];
			}
			$licence   = $this->input->post('c_image');
			$lic     = substr($licence, strpos($licence, ",") + 1);
			if($licence!='')
			{
				$url      = FCPATH.'uploads/admin/driver-licences/';
				$rand2     = date('Ymd').mt_rand(1001,9999);
				$userpath2 = $url.$rand2.'.png';
				$path1     = "uploads/admin/driver-licences/".$rand2.'.png';
				file_put_contents($userpath2,base64_decode($lic));
			}else
			{
				$path1     = '';
			}
			$array['licence'] = $path1;
			
			if ($this->Common->update('dr_id',$driver_id,'drivers',$array)) 
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Changes made successfully..!');
				redirect('admin/drivers');
			}
			else
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to update driver..!');
				redirect('admin/drivers/edit/'.$driver_id);
			}
		}
	}

	public function disable()
	{
	    $id    = $this->input->post('driver_id');
		$array = [
			       'status' => '0'
		         ];
	
		if ($this->Common->update('dr_id',$id,'drivers',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Driver blocked successfully..!');
			redirect('admin/drivers');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block driver..!');
			redirect('admin/drivers');
		}
	}

	public function enable()
	{
	    $id    = $this->input->post('driver_id');
		$array = [
			       'status' => '1'
		         ];
	
		if ($this->Common->update('dr_id',$id,'drivers',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Driver activated successfully..');
			redirect('admin/drivers');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate driver..!');
			redirect('admin/drivers');
	    }		
	}
    
    public function delete()
	{
	    $id    = $this->input->post('driver_id');
		$array = [
			       'status' => '3'
		         ];
	
		if ($this->Common->update('dr_id',$id,'drivers',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Driver deleted successfully..');
			redirect('admin/drivers');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate driver..!');
			redirect('admin/drivers');
	    }		
	}
    
	public function checkDriver() 
	{
        $phone = $this->input->post('phone');
        $email = $this->input->post('email');
        $code  = $this->input->post('code');
        $check_phone = $this->Common->get_details('drivers', array('phone' => $phone));
        $check_mail  = $this->Common->get_details('drivers', array('email' => $email));
        $check_code  = $this->Common->get_details('drivers', array('jrms_code' => $code));
        if($check_phone->num_rows() > 0) 
        {
            $data = '1';
        } 
        elseif($check_mail->num_rows() > 0) 
        {
            $data = '2';
        }
        elseif($check_code->num_rows() > 0) 
        {
            $data = '3';
        }
        else
        {
        	$data = '0';
        }
        print_r($data);
    }
}
?>
