<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Delivery_area extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('Common');
			if (!admin()) {
				redirect('users/admin');
			}
	}
	public function index()
	{   
		$data['area']  = $this->Common->get_details('delivery_area',array())->row();
		$this->load->view('admin/delivery_area/view',$data);
	}
	
	public function getDetails()
	{  
		$id= $this->input->post('id');
		$check = $this->Common->get_details('delivery_area',array('da_id' => $id));
		if ($check->num_rows() > 0) 
		{
			$data= $check->row();
		}
		else 
		{
		    $data= '';
		}
		print_r(json_encode($data));
	}

	public function edit()
	{
		$area_id   = $this->input->post('area_id');
		$limit     = $this->security->xss_clean($this->input->post('limit'));
		
		if ($this->Common->update('da_id',$area_id,'delivery_area',array('area_distance'=>$limit))) 
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Changes made successfully..!');
			redirect('admin/delivery_area');
		}
		else
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to update limit..!');
			redirect('admin/delivery_area');
		}
	}

}
?>
