<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('admin/M_dashboard','dash');
			$this->load->model('Common');
			if (!admin()) {
				redirect('users/admin');
			}
	}
	public function index()
	{  
	    date_default_timezone_set('Asia/Bahrain');
	    $date   = date('Y-m-d');
	    
		$data['users']       = $this->dash->getUsers();
        $data['restaurants'] = $this->dash->getRestaurants();
        $data['cuisines']    = $this->dash->getCuisines();
        $data['orders']      = $this->dash->getOrders();

        $data['restaurant']  = $this->Common->get_details('restaurants',array('status'=>'1'))->num_rows();
        $data['user']        = $this->Common->get_details('users',array())->num_rows();
        $data['cuisine']     = $this->Common->get_details('cuisines',array('status'=>'1'))->num_rows();
        $data['order']       = $this->dash->getOrderCount();
        $data['order_today'] = $this->dash->getTodaysOrderCount($date);
        $data['cancelled_today'] = $this->dash->getTodaysCancelledOrderCount($date);
        
		$this->load->view('admin/dashboard/dashboard',$data);
	}
	
	
}
?>
