<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Customers extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('Common');
			$this->load->model('admin/M_customers','customer');
			if (!admin()) {
				redirect('app');
			}
	}
	public function index()
	{
		$this->load->view('admin/customers/view');
	}
	public function get()
	{
		$result = $this->customer->make_datatables();
		$data = array();
		foreach ($result as $res) 
		{
			if ($res->status) 
			{
				$status = "Active";
				$action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="disable('.$res->user_id.')"  >Disable</a>';
			}
			else 
			{
				$status = "Blocked";
				$action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="enable('.$res->user_id.')"  >Enable</a>';
			}
			$sub_array   = array();
			$sub_array[] = $res->firstname.' '.$res->lastname;;
			$sub_array[] = $res->mobile;
			$sub_array[] = $res->email;
			$sub_array[] = $status.'<br>'.$action;
			$data[]      = $sub_array;
		}

		$output = array(
			"draw"   => intval($_POST['draw']),
			"recordsTotal" => $this->customer->get_all_data(),
			"recordsFiltered" => $this->customer->get_filtered_data(),
			"data" => $data
		);
		echo json_encode($output);
	}

	//Block member//
	public function disable()
	{
	    $id    = $this->input->post('cust_id');
		$array = [
			       'status' => '0'
		         ];
	
		if ($this->Common->update('user_id',$id,'users',$array))  
		{
		    $user  = $this->Common->get_details('users',array('user_id'=>$id))->row();
		    
		    $this->sendCustomerNotification($user->fcm);
		    
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Member blocked successfully..!');
			redirect('admin/customers');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block member..!');
			redirect('admin/customers');
		}
	}

  //Activate user//	
	public function enable()
	{
	    $id    = $this->input->post('cust_id');
		$array = [
			       'status' => '1'
		         ];
	
		if ($this->Common->update('user_id',$id,'users',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Member activated successfully..');
			redirect('admin/customers');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate member..!');
			redirect('admin/customers');
	    }		
	}
	
//************************************************************* SEND  NOTIFICATION ******************************************************************************************//  
   public function sendCustomerNotification($id)
   {
          $SERVER_API_KEY = "AAAAKjNFP5M:APA91bG4yMG9c0Y6NGPh2gMQT77gTT9cy-ZenigVrh5RZJfBUxZZZYgynM06KTTFrtxyBoFfjqef2VIfVVFPL-cnhgAgJwbzHWsQvmzShzg9lAXFK8emE6EjVILc99TzYA0f3rrXPgkU";
          $header = [
            'Authorization: key='. $SERVER_API_KEY,
            'Content-Type: Application/json'
          ];
          $msg = [
                     'title'           => 'Your account has been blocked by admin',
                     'type'            => 'logout'
                  ];
          
          $notification = [
                            'title'             => 'Your account has been blocked by admin',
                            'type'              => 'logout',
                            'content_available' => true
                          ];
          
          $payload = [
                        'data'         => $msg,
                        'notification' => $notification,
                        'to'           => $id,
                        'priority'     => 10
                      ];
          $url = 'https://fcm.googleapis.com/fcm/send';
        
          $curl = curl_init();
        
          curl_setopt_array($curl, array(
             CURLOPT_URL            => "https://fcm.googleapis.com/fcm/send",
             CURLOPT_RETURNTRANSFER => true,
             CURLOPT_CUSTOMREQUEST  => "POST",
             CURLOPT_POSTFIELDS     => json_encode($payload),
             CURLOPT_HTTPHEADER     => $header,
          ));
        
          $response = curl_exec($curl);
          $err = curl_error($curl);
        
          curl_close($curl);
            
            return true;
    }

}
?>
