<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cuisines extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('admin/M_cuisines','cuisines');
			$this->load->model('Common');
			if (!admin()) {
				redirect('users/admin');
			}
	}
//********************************************* GET ***************************************************************************************************************//	
	public function index()
	{   
		$data['cuisines']  = $this->cuisines->getCuisines();
		$this->load->view('admin/cuisines/view',$data);
	}
	
	public function getDetails()
	{  
		$id= $this->input->post('id');
		$check = $this->Common->get_details('cuisines',array('c_id' => $id));
		if ($check->num_rows() > 0) 
		{
			$data= $check->row();
		}
		else 
		{
		    $data= '';
		}
		print_r(json_encode($data));
	}

//******************************************* ADD *****************************************************************************************************************//	
	public function addData()
	{
		$name      = $this->security->xss_clean($this->input->post('name'));
		$check     = $this->Common->get_details('cuisines',array('name' => $name))->num_rows();
		if ($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Cuisine type already exists..!');
			redirect('admin/cuisines');
		}
		else
		{
		    $file = $_FILES['image'];
    		$tar = "uploads/admin/cuisines/";
    		$rand=date('Ymd').mt_rand(1001,9999);
    		$tar_file = $tar . $rand .'.png';
    		move_uploaded_file($file["tmp_name"], $tar_file);
    		
			$array = [
						'name'       => $name,
						'status'     => '1',
						'image'      => $tar_file,
                        'date'       => date('Y-m-d'),
						'timestamp'  => date('Y-m-d H:i:s')
					 ];
			if ($this->Common->insert('cuisines',$array))
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'New cuisine type added..!');
				redirect('admin/cuisines');
			}
			else
			 {
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to add cuisine type...!');
				redirect('admin/cuisines');
			}
		}
	}
	
//*********************************************** EDIT ************************************************************************************************************//	
	public function editData()
	{
		$cuisine_id= $this->input->post('cuisine_id');
		$name      = $this->security->xss_clean($this->input->post('name'));
		$check     = $this->Common->get_details('cuisines',array('name' => $name, 'c_id!=' => $cuisine_id))->num_rows();
		if ($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Cuisine type already exists..!');
			redirect('admin/cuisines');
		}
		else {
		        $file     = $_FILES['image'];
    		    if($file['name']!='')
    		    {
    		        $tar      = "uploads/admin/cuisines/";
            		$rand     = date('Ymd').mt_rand(1001,9999);
            		$tar_file = $tar . $rand .'.png';
            		move_uploaded_file($file["tmp_name"], $tar_file);
            		
            		$array = [
							'name'  => $name,
							'image' => $tar_file
					    ];	
    		    }
    		    else
    		    {
    		       $array = [
							'name'  => $name,
					    ];	
    		    }
    		    
						
			if ($this->Common->update('c_id',$cuisine_id,'cuisines',$array)) 
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Changes made successfully..!');
				redirect('admin/cuisines');
			}
			else
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to update cuisine type..!');
				redirect('admin/cuisines');
			}
		}
	}

//************************************************** DISABLE *****************************************************************************************************//
	public function disable()
	{
	    $id    = $this->input->post('c_id');
		$array = [
			       'status' => '0'
		         ];
	
		if ($this->Common->update('c_id',$id,'cuisines',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Cuisine blocked successfully..!');
			redirect('admin/cuisines');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block cuisine..!');
			redirect('admin/cuisines');
		}
	}

//******************************************* ENABLE ************************************************************************************************************//
	public function enable()
	{   
	    $id    = $this->input->post('c_id');
		$array = [
			       'status' => '1'
		         ];
	
		if ($this->Common->update('c_id',$id,'cuisines',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Cuisine activated successfully..');
			redirect('admin/cuisines');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate cusine..!');
			redirect('admin/cuisines');
	    }		
	}
}
?>
