<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Contact extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('Common');
			if (!admin()) {
				redirect('users/admin');
			}
	}
	public function index()
	{   
		$data['cont']  = $this->Common->get_details('contact',array())->row();
		$this->load->view('admin/contact/view',$data);
	}
	
	public function editData()
	{
		$contact_id     = $this->input->post('contact_id');
		$description    = $this->security->xss_clean($this->input->post('description'));
	
		$array = [
					'content' => $description
			    ];			
		if ($this->Common->update('contact_id',$contact_id,'contact',$array)) 
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Contact details updated successfully..!');
			redirect('admin/contact');
		}
		else
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to update details..!');
			redirect('admin/contact');
		}
	}

}
?>
