<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cancel_reasons extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('admin/M_reasons','reason');
			$this->load->model('Common');
			if (!admin()) {
				redirect('users/admin');
			}
	}
	public function index()
	{   
		$data['reasons']  = $this->reason->getCancelReasons();
		$this->load->view('admin/cancel_reasons/view',$data);
	}
	public function get()
	{
		$result = $this->reason->make_datatables();
		$data = array();
		foreach ($result as $res) 
		{
			if ($res->status) 
			{
				$status = "Active";
				$action = '<a class="btn btn-danger" style="font-size:12px;" onclick="disable('.$res->cr_id.')" >Disable</a>';
			}
			else 
			{
				$status = "Blocked";
				$action = '<a class="btn btn-success" style="font-size:12px;" onclick="disable('.$res->cr_id.')"  >Enable</a>';
			}
			$sub_array = array();
			$sub_array[] = $res->reason_for;
			$sub_array[] = $res->reason;
			$sub_array[] = $status.'<br>'.$action;
			$sub_array[] = '<a class="btn btn-primary" style="font-size:12px;" href="' . site_url('admin/cancel_reasons/edit/'.$res->cr_id) . '">Edit</a>';
		}

		$output = array(
						"draw"            => intval($_POST['draw']),
						"recordsTotal"    => $this->reason->get_all_data(),
						"recordsFiltered" => $this->reason->get_filtered_data(),
						"data"            => $data
					);
		echo json_encode($output);
	}
	public function getDetails()
	{  
		$id= $this->input->post('id');
		$check = $this->Common->get_details('cancel_reasons',array('cr_id' => $id));
		if ($check->num_rows() > 0) 
		{
			$data= $check->row();
		}
		else 
		{
		    $data= '';
		}
		print_r(json_encode($data));
	}
	public function addData()
	{
		$reason_for= $this->security->xss_clean($this->input->post('reason_for'));
		$reason    = $this->security->xss_clean($this->input->post('reason'));
		$check     = $this->Common->get_details('cancel_reasons',array('reason' => $reason,'reason_for'=>$reason_for))->num_rows();
		if ($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Reason already exists..!');
			redirect('admin/cancel_reasons');
		}
		else
		{
			$array = [
						'reason_for' => $reason_for,
						'reason'     => $reason,
						'status'     => '1',
						'timestamp'  => date('Y-m-d H:i:s')
					 ];
			if ($this->Common->insert('cancel_reasons',$array))
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'New restaurant style added..!');
				redirect('admin/cancel_reasons');
			}
			else
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to add restaurant style...!');
				redirect('admin/cancel_reasons');
			}
		}
	}
	public function editData()
	{
		$reason_id = $this->input->post('reason_id');
        $reason_for= $this->security->xss_clean($this->input->post('reason_for'));
		$reason    = $this->security->xss_clean($this->input->post('reason'));		
		$check     = $this->Common->get_details('cancel_reasons',array('reason' => $reason,'reason_for'=>$reason_for, 'cr_id!=' => $reason_id))->num_rows();
		if ($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Reason already exists..!');
			redirect('admin/cancel_reasons');
		}
		else {
				$array = [  
					        'reason_for' => $reason_for,
 							'reason'     => $reason
					     ];			
			if ($this->Common->update('cr_id',$reason_id,'cancel_reasons',$array)) 
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Changes made successfully..!');
				redirect('admin/cancel_reasons');
			}
			else
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to update reason.!');
				redirect('admin/cancel_reasons');
			}
		}
	}

	public function disable()
	{
	    $id    = $this->input->post('reason_id');
		$array = [
			       'status' => '0'
		         ];
	
		if ($this->Common->update('cr_id',$id,'cancel_reasons',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Reason  blocked successfully..!');
			redirect('admin/cancel_reasons');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block reason ..!');
			redirect('admin/cancel_reasons');
		}
	}

	public function enable()
	{
	    $id    = $this->input->post('reason_id');
		$array = [
			       'status' => '1'
		         ];
	
		if ($this->Common->update('cr_id',$id,'cancel_reasons',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Reason activated successfully..');
			redirect('admin/cancel_reasons');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate reason..!');
			redirect('admin/cancel_reasons');
	    }		
	}
}
?>
