<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Blocks extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('admin/M_blocks','blocks');
			$this->load->model('Common');
			if (!admin()) {
				redirect('users/admin');
			}
	}
	
/*Get Blocks*/
	public function index()
	{   
		$data['blocks']  = $this->blocks->getBlocks();
		$data['cities']  = $this->Common->get_details('places',array('status',1))->result();
		$this->load->view('admin/blocks/view',$data);
	}

/*Get Block details*/	
	public function getDetails()
	{  
		$id= $this->input->post('id');
		$check = $this->Common->get_details('blocks',array('block_id' => $id));
		if ($check->num_rows() > 0) 
		{
			$data['block']= $check->row();
		}
		else 
		{
		    $data['block']= '';
		}
		$cities  = $this->Common->get_details('places',array('status'=>1))->result();
		$options = '<option value="">-- Choose City ---</option>';
        foreach ($cities as $city) 
        {
            if ($city->place_id == $check->row()->city_id) 
            {
                $options = $options . '<option value="' . $city->place_id . '" selected>' . $city->name . '</option>';
            }
            else 
            {
                $options = $options . '<option value="' . $city->place_id . '" >' . $city->name . '</option>';
            }
        }
        $data['cities'] = $options;
		print_r(json_encode($data));
	}

/*Save posted data*/	
	public function addData()
	{
		$name      = $this->security->xss_clean($this->input->post('name'));
		$place_name= $this->security->xss_clean($this->input->post('place_name'));
		$city_id   = $this->security->xss_clean($this->input->post('city_id'));
		$check     = $this->Common->get_details('blocks',array('city_id'=>$city_id,'block_name' => $name))->num_rows();
		if ($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Block already exists..!');
			redirect('admin/blocks');
		}
		else
		{
			$array = [
						'block_name'     => $name,
						'place_name'     => $place_name,
						'block_status'   => '1',
						'city_id'        => $city_id,
						'created_at'     => date('Y-m-d H:i:s')
					 ];
			if ($this->Common->insert('blocks',$array))
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'New block added..!');
				redirect('admin/blocks');
			}
			else
			 {
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to add block ...!');
				redirect('admin/blocks');
			}
		}
	}

/*Edit posted data*/	
	public function editData()
	{
		$block_id  = $this->input->post('block_id');
		$name      = $this->security->xss_clean($this->input->post('name'));
		$place_name= $this->security->xss_clean($this->input->post('place_name'));
		$city_id   = $this->security->xss_clean($this->input->post('city_id'));
		$check     = $this->Common->get_details('blocks',array('city_id'=>$city_id,'block_name' => $name, 'block_id!=' => $block_id))->num_rows();
		if ($check > 0) 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Block already exists..!');
			redirect('admin/blocks');
		}
		else {
				$array = [
							'block_name' => $name,
							'place_name' => $place_name,
							'city_id'    => $city_id
					    ];			
			if ($this->Common->update('block_id',$block_id,'blocks',$array)) 
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Block updated successfully..!');
				redirect('admin/blocks');
			}
			else
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to update block..!');
				redirect('admin/blocks');
			}
		}
	}

/*Deactivate block*/
	public function disable()
	{
	    $id    = $this->input->post('block_id');
		$array = [
			       'block_status' => '2'
		         ];
	
		if ($this->Common->update('block_id',$id,'blocks',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Block deactivated successfully..!');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to deactivate block..!');
		}
		redirect('admin/blocks');
	}

/*Activate block*/
	public function enable()
	{
	    $id    = $this->input->post('block_id');
		$array = [
			       'block_status' => '1'
		         ];
	
		if ($this->Common->update('block_id',$id,'blocks',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Block activated successfully..');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate block..!');
	    }
	    redirect('admin/blocks');
	}
}
?>
