<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Banners extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('admin/M_banners','banner');
			$this->load->model('Common');
			if (!admin()) {
				redirect('users/admin');
			}
	}
	public function index()
	{
		$this->load->view('admin/banners/view');
	}
	public function get()
	{
		$result = $this->banner->make_datatables();
		$data = array();
		foreach ($result as $res) 
		{   
			if ($res->status) 
			{
				$status = "Active";
				$action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="disable('.$res->bn_id.')" >Disable</a>';
			}
			else 
			{
				$status = "Disabled";
				$action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="enable('.$res->bn_id.')" >Enable</a>';
			}
			$sub_array = array();
			$sub_array[] = '<img src="' . base_url() . $res->thumbnail . '" height="50px">';
			$sub_array[] = $res->name;
			$sub_array[] = $res->long_description;
			$sub_array[] = $res->short_description;
			$sub_array[] = $status.'<br>'.$action;
			$sub_array[] = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" href="' . site_url('admin/banners/edit/'.$res->bn_id) . '" >Edit</a>';
			$sub_array[] = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="del('.$res->bn_id.')" >Delete</a>';

			$data[] = $sub_array;
		}

		$output = array(
			"draw"   => intval($_POST['draw']),
			"recordsTotal" => $this->banner->get_all_data(),
			"recordsFiltered" => $this->banner->get_filtered_data(),
			"data" => $data
		);
		echo json_encode($output);
	}
	public function add()
	{   
	    $data['restaurants'] = $this->Common->get_details('restaurants',array('status'=>'1'))->result();
		$this->load->view('admin/banners/add',$data);
	}
	public function edit($id)
	{
		$check = $this->Common->get_details('banners',array('bn_id' => $id));
		if ($check->num_rows() > 0) 
		{
			$data['banner']      = $check->row();
			$data['restaurants'] = $this->Common->get_details('restaurants',array('status'=>'1'))->result();
			$this->load->view('admin/banners/edit',$data);
		}
		else 
		{
			redirect('banner');
		}
	}
	public function addData()
	{
		$banner   = $this->security->xss_clean($this->input->post('name'));
		$short    = $this->security->xss_clean($this->input->post('short'));
		$long     = $this->security->xss_clean($this->input->post('long'));
// 		$sequence = $this->security->xss_clean($this->input->post('sequence'));
		$restaurant = $this->security->xss_clean($this->input->post('r_id'));
	    $image   = $this->input->post('image');
		$img     = substr($image, strpos($image, ",") + 1);
	    
		$url      = FCPATH.'uploads/admin/banners/';
		$rand     = date('Ymd').mt_rand(1001,9999);
		$userpath = $url.$rand.'.png';
		$path     = "uploads/admin/banners/".$rand.'.png';
		if(file_put_contents($userpath,base64_decode($img)))
		{
            $filename = 'uploads/admin/banners/thumbnail/'.$rand.'thumb.png'; // output file name
            $fileData = base64_decode($img);
            $im = imagecreatefromstring($fileData);
            $source_width = imagesx($im);
            $source_height = imagesy($im);
            $ratio =  $source_height / $source_width;
            
            $new_width  = 300; // assign new width to new resized image
            $new_height = 500*$ratio;
            
            $thumb = imagecreatetruecolor($new_width, $new_height);
            
            $transparency = imagecolorallocatealpha($thumb, 255, 255, 255, 127);
            imagefilledrectangle($thumb, 0, 0, $new_width, $new_height, $transparency);
            
            imagecopyresampled($thumb, $im, 0, 0, 0, 0, $new_width, $new_height, $source_width, $source_height);
            imagepng($thumb, $filename, 9);
            imagedestroy($im);
		}
		else
		{
		    $filename = '';
		}
		$array     = [
						'name'               => $banner,
						'long_description'  => $short,
						'short_description'   => $long,
				// 		'sequence'           => $sequence,
						'image'              => $path,
						'thumbnail'          => $filename,
						'status'             => '1',
					    'r_id'               => $restaurant,
						'date'               => date('Y-m-d'),
						'timestamp'          => date('Y-m-d H:i:s')
					];
		if ($this->Common->insert('banners',$array)) 
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'New banner added..!');
			redirect('admin/banners');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to add banner..!');
			redirect('admin/banners/add');
		}
	}
	public function editData()
	{
		$banner_id = $this->input->post('banner_id');
		$banner     = $this->security->xss_clean($this->input->post('name'));
		$short      = $this->security->xss_clean($this->input->post('short'));
		$long       = $this->security->xss_clean($this->input->post('long'));
// 		$sequence   = $this->security->xss_clean($this->input->post('sequence'));
		$restaurant = $this->security->xss_clean($this->input->post('r_id'));

		$image      = $this->input->post('image');	
        if ($image != '') 
        {
			$img = substr($image, strpos($image, ",") + 1);

			$url      = FCPATH.'uploads/admin/banners/';
			$rand     = date('Ymd').mt_rand(1001,9999);
			$userpath = $url.$rand.'.png';
			$path     = "uploads/admin/banners/".$rand.'.png';
			if(file_put_contents($userpath,base64_decode($img)))
            {
                $filename = 'uploads/admin/banners/thumbnail/'.$rand.'thumb.png'; // output file name
                $fileData = base64_decode($img);
                $im = imagecreatefromstring($fileData);
                $source_width = imagesx($im);
                $source_height = imagesy($im);
                $ratio =  $source_height / $source_width;
                
                $new_width  = 300; // assign new width to new resized image
                $new_height = $ratio * 300;;
                
                $thumb = imagecreatetruecolor($new_width, $new_height);
                
                $transparency = imagecolorallocatealpha($thumb, 255, 255, 255, 127);
                imagefilledrectangle($thumb, 0, 0, $new_width, $new_height, $transparency);
                
                imagecopyresampled($thumb, $im, 0, 0, 0, 0, $new_width, $new_height, $source_width, $source_height);
                imagepng($thumb, $filename, 9);
                imagedestroy($im);
                
                	// Remove old image from the server
        			$old = $this->Common->get_details('banners',array('bn_id' => $banner_id))->row()->image;
        			$remove_path = FCPATH . $old;
        			unlink($remove_path);
        			
        			// Remove old image from the server
        			$old1 = $this->Common->get_details('banners',array('bn_id' => $banner_id))->row()->thumbnail;
        			$remove_path1 = FCPATH . $old1;
        			unlink($remove_path1);
            }
		    else
		    {
		        $filename  = '';
		    }

			$array     = [
							'name'                => $banner,
							'long_description'    => $short,
							'short_description'   => $long,
				// 			'sequence'            => $sequence,
							'image'               => $path,
							'thumbnail'           => $filename,
							'r_id'                => $restaurant,
						];
			}
			else 
			{
					$array     = [
        							'name'                => $banner,
        							'long_description'    => $short,
        							'short_description'   => $long,
        				// 			'sequence'            => $sequence,
        							'r_id'                => $restaurant,
        						];
			}

		if ($this->Common->update('bn_id',$banner_id,'banners',$array)) 
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Changes made successfully..!');
			redirect('admin/banners');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to update banner..!');
			redirect('admin/banners/edit/'.$banner_id);
		}
	}

	public function delete()
	{
	    $id    = $this->input->post('banner_id');
		$check = $this->Common->get_details('banners',array('bn_id' => $id));
		if ($check->num_rows() > 0) {
			$banner = $check->row();
			if ($this->Common->delete('banners',array('bn_id' => $id))) {
				$remove_path = FCPATH . $banner->image;
				unlink($remove_path);

				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Banner deleted successfully..!');
			}
			else {
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to remove banner..!');
			}
		}
		else {
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to remove banner..!');
		}
		redirect('admin/banners');
	}

	public function disable()
	{   
	    $id    = $this->input->post('banner_id');
		$array = [
			       'status' => '0'
		         ];
	
		if ($this->Common->update('bn_id',$id,'banners',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Banner blocked successfully..!');
			redirect('admin/banners');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block banner..!');
			redirect('admin/banners');
		}
	}

	public function enable()
	{
	    $id    = $this->input->post('banner_id');
		$array = [
			       'status' => '1'
		         ];
	
		if ($this->Common->update('bn_id',$id,'banners',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Banner activated successfully..');
			redirect('admin/banners');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate banner..!');
			redirect('admin/banners');
	    }		
	}
}
?>
