<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Advertisements extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('admin/M_advertisement','adv');
			$this->load->model('Common');
			if (!admin()) {
				redirect('users/admin');
			}
	}
	public function index()
	{   
		$this->load->view('admin/advertisements/view');
	}
	public function get()
	{
		$result = $this->adv->make_datatables();
		$data = array();
		foreach ($result as $res) 
		{   
			if ($res->status) 
			{
				$status = "Active";
				$action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="disable('.$res->pop_id.')">Disable</a>';
			}
			else 
			{
				$status = "Blocked";
				$action = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="enable('.$res->pop_id.')" >Enable</a>';
			}
			$sub_array = array();
			$sub_array[] = '<img src="' . base_url() . $res->image . '" height="100px">';
			$sub_array[] = $res->title;
			$sub_array[] = date('d M Y',strtotime($res->start_date));
			$sub_array[] = date('d M Y',strtotime($res->end_date));
			$sub_array[] = $status.'<br>'.$action;
			$sub_array[] = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" href="' . site_url('admin/advertisements/edit/'.$res->pop_id) . '">Edit</a>';
			$sub_array[] = '<a class="btn btn-success btn-sm btn-rounded waves-light waves-effect" style="font-size:12px;" onclick="del('.$res->pop_id.')" >Delete</a>';

			$data[] = $sub_array;
		}

		   $output  = array(
							"draw"   => intval($_POST['draw']),
							"recordsTotal" => $this->adv->get_all_data(),
							"recordsFiltered" => $this->adv->get_filtered_data(),
							"data" => $data
						);
		echo json_encode($output);
	}
	public function add()
	{   
		$data['places']  = $this->Common->get_details('places',array('status'=>'1'))->result();
		$this->load->view('admin/advertisements/add',$data);
	}
	public function edit($id)
	{
		$check = $this->Common->get_details('popup',array('pop_id' => $id));
		if ($check->num_rows() > 0) 
		{
			$data['popup']  = $check->row();
			$data['places'] = $this->Common->get_details('places',array('status'=>'1'))->result();
			$this->load->view('admin/advertisements/edit',$data);
		}
		else 
		{
			redirect('advertisements');
		}
	}
	public function addData()
	{
		$title    = $this->security->xss_clean($this->input->post('title'));
		$place_id = $this->security->xss_clean($this->input->post('city'));
		$start_date = $this->security->xss_clean($this->input->post('start_date'));
		$end_date = $this->security->xss_clean($this->input->post('end_date'));
        
        $image   = $this->input->post('image');
		$img     = substr($image, strpos($image, ",") + 1);
	    
		$url      = FCPATH.'uploads/admin/advertisement/';
		$rand     = date('Ymd').mt_rand(1001,9999);
		$userpath = $url.$rand.'.png';
		$path     = "uploads/admin/advertisement/".$rand.'.png';
		file_put_contents($userpath,base64_decode($img));
        
        $place_check = $this->Common->get_details('places',array('place_id'=>$place_id));
        if($place_check->num_rows()>0)
        {
        	$city   = $place_check->row()->name;
        }
        else
        {
        	$city   = '';
        }

		$array     = [
						'title'       => $title,
						'city'        => $city,
						'place_id'    => $place_id,
						'start_date'  => $start_date,
						'end_date'    => $end_date,
						'image'       => $path,
						'status'      => '1',
						'date'        => date('Y-m-d'),
						'timestamp'   => date('Y-m-d H:i:s')
					];
		if ($this->Common->insert('popup',$array)) 
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'New advertisement added..!');
			redirect('admin/advertisements');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to add advertisement..!');
			redirect('admin/advertisements/add');
		}
	}

	public function editData()
	{
		$adv_id   = $this->input->post('adv_id');
		$title    = $this->security->xss_clean($this->input->post('title'));
		$place_id = $this->security->xss_clean($this->input->post('city'));
		$start_date = $this->security->xss_clean($this->input->post('start_date'));
		$end_date = $this->security->xss_clean($this->input->post('end_date'));
		
        $place_check = $this->Common->get_details('places',array('place_id'=>$place_id));
        if($place_check->num_rows()>0)
        {
        	$city   = $place_check->row()->name;
        }
        else
        {
        	$city   = '';
        }

		$image   = $this->input->post('image');
		if ($image!= '') 
		{
			$img     = substr($image, strpos($image, ",") + 1);
	    
    		$url      = FCPATH.'uploads/admin/advertisement/';
    		$rand     = date('Ymd').mt_rand(1001,9999);
    		$userpath = $url.$rand.'.png';
    		$path     = "uploads/admin/advertisement/".$rand.'.png';
    		file_put_contents($userpath,base64_decode($img));
        
			// Remove old image from the server
			$old = $this->Common->get_details('popup',array('pop_id' => $adv_id))->row()->image;
			$remove_path = FCPATH . $old;
			unlink($remove_path);

			$array     = [
							'title'       => $title,
							'place_id'    => $place_id,
							'city'        => $city,
							'start_date'  => $start_date,
							'end_date'    => $end_date,
							'image'       => $path
						];
		}
		else 
		{
			$array     = [
							'title'       => $title,
							'place_id'    => $place_id,
							'city'        => $city,
							'start_date'  => $start_date,
							'end_date'    => $end_date,
						];
		}

		$offer_check  = $this->adv->checkById($place_id,$adv_id,$start_date);
        if($offer_check->num_rows()>0)
        {
            $this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Advertisement already exists..!');
			redirect('admin/advertisements/edit/'.$adv_id);
        }
        else
        {
           if ($this->Common->update('pop_id',$adv_id,'popup',$array)) 
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Advertisement updated successfully..!');
				redirect('admin/advertisements');
			}
			else 
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to update advertisement..!');
				redirect('admin/advertisements/edit/'.$adv_id);
			}
        }
	}

	public function delete()
	{
	    $id    = $this->input->post('banner_id');
		$check = $this->Common->get_details('popup',array('pop_id' => $id));
		if ($check->num_rows() > 0) 
		{
			$popup       = $check->row();
			$remove_path = FCPATH . $popup->image;
			unlink($remove_path);
			if ($this->Common->delete('popup',array('pop_id' => $id))) 
			{
				$this->session->set_flashdata('alert_type', 'success');
				$this->session->set_flashdata('alert_title', 'Success');
				$this->session->set_flashdata('alert_message', 'Advertisement deleted successfully..!');
			}
			else 
			{
				$this->session->set_flashdata('alert_type', 'error');
				$this->session->set_flashdata('alert_title', 'Failed');
				$this->session->set_flashdata('alert_message', 'Failed to remove advertisement..!');
			}
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to remove advertisement..!');
		}
		redirect('admin/advertisements');
	}

	public function disable()
	{
	    $id    = $this->input->post('banner_id');
		$array = [
			       'status' => '0'
		         ];
	
		if ($this->Common->update('pop_id',$id,'popup',$array))  
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Advertisement blocked successfully..!');
			redirect('admin/advertisements');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to block advertisement..!');
			redirect('admin/advertisements');
		}
	}

	public function enable()
	{
	    $id    = $this->input->post('banner_id');
		$array = [
			       'status' => '1'
		         ];
	
		if ($this->Common->update('pop_id',$id,'popup',$array))
		{
			$this->session->set_flashdata('alert_type', 'success');
			$this->session->set_flashdata('alert_title', 'Success');
			$this->session->set_flashdata('alert_message', 'Advertisement activated successfully..');
			redirect('admin/advertisements');
		}
		else 
		{
			$this->session->set_flashdata('alert_type', 'error');
			$this->session->set_flashdata('alert_title', 'Failed');
			$this->session->set_flashdata('alert_message', 'Failed to activate advertisement..!');
			redirect('admin/advertisements');
	    }		
	}

	public function checkAdvertisement()
    {
        $date       = date('Y-m-d');
	    $time       = date('H:i:s');
	    $current    = date('Y-m-d H:i:s');

	    $place_id   = $this->input->post('place_id');
	    $start_date = $this->security->xss_clean($this->input->post('start_date'));
        $end_date   = $this->security->xss_clean($this->input->post('end_date'));
        
        $start_check = $this->adv->checkStart($place_id,$start_date);
        if($start_check->num_rows()>0)
        {   
        	$data  = '1';
        }
        else
        {
        	$data  = '0';
        }

        print_r($data);
       
    }
}
?>
