<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Users extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->model('Common');
	}
    public function index()
    {
        $this->admin();
    }
//********************************************** ADMIN LOGIN ***********************************************************************************************************************//
    public function admin()
	{
		if(isset($_COOKIE['admin_id']))
		{
			$session = [
            				'admin_id' => $_COOKIE['admin_id'],
            				'name'     => $_COOKIE['admin_name']
            			];
			$this->session->set_userdata('admin',$session);
			redirect('admin/dashboard');
		}
		$this->load->view('login/admin/login');
	}
	public function adminLogin()
	{
		$username = $this->security->xss_clean($this->input->post('username'));
		$pass = $this->security->xss_clean($this->input->post('password'));
		$password = md5($pass);
        
        $email_check = $this->Common->get_details('admin',array('username'=>$username));
        if($email_check->num_rows()>0)
        {
    		$details = [
                			'username' => $username,
                			'password' => $password
                		];
    
    		$check = $this->Common->get_details('admin',$details);
    		if ( $check->num_rows() > 0 ) {
    			$user = $check->row();
    			$session = [
                				'admin_id'  => $user->id,
                				'name'      => $user->username
                			];
    			$this->session->set_userdata('admin',$session);
    
    			$hour = time() + 3600 * 24 * 30;
    		    setcookie('admin_id', $user->id, $hour);
    			setcookie('admin_name', $user->username, $hour);
    			redirect('admin/dashboard');
    		}
    		else {
    			$this->session->set_flashdata('message','The password you entered is incorrect..!');
    			redirect('users/admin');
    		}
        }
        else
        {
            $this->session->set_flashdata('message','There is no account associated with this email id..!');
    		redirect('users/admin');
        }
	}
	public function adminLogout()
	{
		setcookie('admin_id');
		setcookie('admin_name');

		$this->session->unset_userdata('admin');

		redirect('users/admin');
	}

//******************************************************* RESTAURANT LOGIN ************************************************************************************************************//
    public function restaurant()
	{
		if(isset($_COOKIE['restaurant_id'])){
			$session = [
            				'restaurant_id' => $_COOKIE['restaurant_id'],
            				'name'          => $_COOKIE['restaurant_name']
            			];
			$this->session->set_userdata('restaurant',$session);
			redirect('restaurant/dashboard');
		}
		$this->load->view('login/restaurant/login');
	}
	public function restaurantLogin()
	{
		$username = $this->security->xss_clean($this->input->post('username'));
		$pass     = $this->security->xss_clean($this->input->post('password'));
		$password = md5($pass);
		$fcm      = $this->security->xss_clean($this->input->post('token'));
        
        $email_check = $this->Common->get_details('restaurants',array('rest_email'=>$username));
        if($email_check->num_rows()>0)
        {
    		$details =  [
    						'rest_email'    => $username,
    						'rest_password' => $password,
    						'status'        => '1'
    					];
    					
            $details1 =  [
    						'rest_email'    => $username,
    						'rest_password' => $password,
    					];
    					
    		$check = $this->Common->get_details('restaurants',$details);
    		$check1 = $this->Common->get_details('restaurants',$details1);
    		if ( $check1->num_rows() == 0 ) 
    		{
    		    $this->session->set_flashdata('message','The password you entered is incorrect..!');
    			redirect('users/restaurant');
    		}
    		elseif($check->num_rows() > 0 )
    		{
    			$user    = $check->row();
    			$this->Common->update('r_id',$user->r_id,'restaurants',array('fcm'=>$fcm));	
    			$session = [
    							'restaurant_id' => $user->r_id,
    							'name'          => $user->rest_name
    						];
    			$this->session->set_userdata('restaurant',$session);
    
    			$hour = time() + 3600 * 24 * 30;
    		    setcookie('restaurant_id', $user->r_id, $hour);
    			setcookie('restaurant_name', $user->rest_name, $hour);
    			redirect('restaurant/dashboard');
    		}
    		else 
    		{
    			$this->session->set_flashdata('message','Your account has been blocked by admin. Please contact the admin..!');
    			redirect('users/restaurant');
    		}
        }
        else
        {
            	$this->session->set_flashdata('message','There is no account associated with this email id..!');
    			redirect('users/restaurant');
        }
	}
	public function restaurantLogout()
	{
		setcookie('restaurant_id');
		setcookie('restaurant_name');
		$this->session->unset_userdata('restaurant');
		redirect('users/restaurant');
	}	

//************************************************* BRANCH LOGIN *******************************************************************************************************************//
    public function branch()
	{
		if(isset($_COOKIE['branch_id'])){
			$session = [
            				'branch_id' => $_COOKIE['branch_id'],
            				'name'      => $_COOKIE['branch_name']
            			];
			$this->session->set_userdata('branch',$session);
			redirect('branch/dashboard');
		}
		$this->load->view('login/branch/login');
	}

	public function branchLogin()
	{
		$username = $this->security->xss_clean($this->input->post('username'));
		$pass     = $this->security->xss_clean($this->input->post('password'));
		$password = md5($pass);
        
        $email_check = $this->Common->get_details('branches',array('email'=>$username));
        // $email_check = $this->Common->get_details('branches',array('email'=>$username,'branch_type'=>'1'));
        if($email_check->num_rows()>0)
        {
    		$details =  [
    						'email'    => $username,
    						'password' => $password,
							// 'branch_type'=>'1',
    						'status'   => '1'
    					];
    					
    	    $details1 =  [
        						'email'    => $username,
        						'password' => $password,
								// 'branch_type'=>'1'
        					];				
    
    		$check = $this->Common->get_details('branches',$details);
    		$check1 = $this->Common->get_details('branches',$details1);
    		if ( $check1->num_rows() == 0 ) 
    		{
    		    $this->session->set_flashdata('message','The password you entered is incorrect..!');
    			redirect('users/branch');
    		}
    		elseif($check->num_rows() > 0 )
    		{
    			$user    = $check->row();
    			$session = [
    							'branch_id' => $user->b_id,
    							'name'      => $user->email
    						];
    			$this->session->set_userdata('branch',$session);
    
    			$hour = time() + 3600 * 24 * 30;
    		    setcookie('branch_id', $user->b_id, $hour);
    			setcookie('branch_name', $user->email, $hour);
    			redirect('branch/dashboard');
    		}
    		else 
    		{
    			$this->session->set_flashdata('message','Your account has been blocked by admin. Please contact the admin..!');
    			redirect('users/branch');
    		}
        }
        else
        {
            $this->session->set_flashdata('message','There is no account associated with this email id..!');
    		redirect('users/branch');
        }
	}

	public function branchLogout()
	{
		setcookie('branch_id');
		setcookie('branch_name');
		$this->session->unset_userdata('branch');
		redirect('users/branch');
	}	

}
