<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Status extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->helper('url');
			$this->load->model('android/driver/M_status','status');
			$this->load->model('android/driver/M_order','orders');
			$this->load->model('Common');
	}

	public function index()
	{   
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getDriverId($key)) 
		{
    	    $status    = $this->security->xss_clean($this->input->post('status'));
    	    if($status=='today')
    	    {
    		   $total_sale    = $this->status->getTodaysTotalSale($user_id);
    		   $payment_list  = $this->status->getTodaysTotalPaymentList($user_id);
    		   foreach($payment_list as $list)
    		   {
    		       $list->products = $this->orders->getOrderedProducts($list->order_id);
        	       foreach($list->products as $product)
        	       {
        	            $product->extras = $this->orders->getOrderedExtras($list->order_id,$product->product_id);
        	       }
        	       $list->address  = $this->Common->get_details('address',array('address_id'=>$list->address_id))->row();
    		   }
    	    }
    	    elseif($status=='week')
    	    {
    	        $total_sale    = $this->status->getWeeksTotalSale($user_id);
    	        $payment_list  = $this->status->getWeeksTotalPaymentList($user_id);
    	        foreach($payment_list as $list)
    		    {
    		       $list->products = $this->orders->getOrderedProducts($list->order_id);
        	       foreach($list->products as $product)
        	       {
        	            $product->extras = $this->orders->getOrderedExtras($list->order_id,$product->product_id);
        	       }
        	       $list->address  = $this->Common->get_details('address',array('address_id'=>$list->address_id))->row();
    		    }
    	    }
    	    elseif($status=='month')
    	    {
    	        $total_sale    = $this->status->getMonthTotalSale($user_id);
    	        $payment_list  = $this->status->getMonthTotalPaymentList($user_id);
    	        foreach($payment_list as $list)
    		    {
    		       $list->products = $this->orders->getOrderedProducts($list->order_id);
        	       foreach($list->products as $product)
        	       {
        	            $product->extras = $this->orders->getOrderedExtras($list->order_id,$product->product_id);
        	       }
        	       $list->address  = $this->Common->get_details('address',array('address_id'=>$list->address_id))->row();
    		    }
    	    }
    	    elseif($status=='lifetime')
    	    {
    	        $total_sale    = $this->status->getTotalSale($user_id);
    	        $payment_list  = $this->status->getTotalPaymentList($user_id);
    	        foreach($payment_list as $list)
    		    {
    		       $list->products = $this->orders->getOrderedProducts($list->order_id);
        	       foreach($list->products as $product)
        	       {
        	            $product->extras = $this->orders->getOrderedExtras($list->order_id,$product->product_id);
        	       }
        	       $list->address  = $this->Common->get_details('address',array('address_id'=>$list->address_id))->row();
    		    }
    	    }
    	    
    	    $return   = [  
    	                   'status'     => true,
    	                   'message'    => 'success',
    	                   'data'       => [
    	                                      'payments'  => $total_sale,
    	                                      'orders'    => $payment_list
    	                                    ]  
    	                ];
		}	
        else 
		{
			   $return = [
            				'status'  => false,
            				'message' => 'Session expired, Login again',
            				'data'    => array()
            			];
		}              
		print_r(json_encode($return));
	}
	
	
}
?>
