<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Orders extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->model('Common');
			$this->load->model('android/driver/M_order','orders');
	}
	
	public function accept()
	{   
	    $key = $this->security->xss_clean($this->input->post('auth'));
	    if ($user_id = getDriverId($key)) 
	    {
    		$order_id  = $this->security->xss_clean($this->input->post('order_id'));
            $r_id      = $this->Common->get_details('orders',array('order_id'=>$order_id))->row()->r_id;
    		$status    = [
    			             'status'          => 'processing'
    		              ];
    		if ($this->Common->update('order_id',$order_id,'orders',$status)) 
    		{   
    		    $orders = [
    		                'order_id'      => $order_id,
    		                'driver_id'     => $user_id,
    		                'r_id'          => $r_id,
    		                'status'        => 'assigned',
    		                'assigned_time' => date('Y-m-d H:i:s'),
    		                'timestamp'     => date('Y-m-d H:i:s')
    		              ];
    		    $this->Common->insert('driver_orders',$orders);
    		    
    			$return = [
    			            'status'  => true,
    				        'message' => 'success'
    			          ];
    		}
    		else 
    		{
    			$return = [
    			            'status' => false,
    			        	'message' => 'failed'
    			          ];
    		}
	    }
	    else 
		{
			   $return = [
            				'status' => false,
            				'message' => 'Session expired, Login again'
            			];
		}
		print_r(json_encode($return));
	}
	
	public function newRequests()
	{   
	    $date      = date('Y-m-d');
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getDriverId($key)) 
		{
    	    $locations = $this->orders->getLatestLocation($user_id);
    	    if($locations!='')
    	    {
        	    $latitude  = $locations->latitude;
        	    $longitude = $locations->longitude;
        	    
        	    $orders     = $this->orders->getNewRequests($latitude,$longitude,$date);
        	    foreach($orders as $order)
        	    {   
        	        $user                  = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
        	        $order->user_firstname = $user->firstname;
        	        $order->lastname       = $user->lastname;
        	        $order->user_mobile    = $user->mobile;
        	        $order->user_email     = $user->email;
        	        
        	        $status_check    = $this->Common->get_details('driver_rejected_orders',array('order_id'=>$order->order_id,'driver_id'=>$user_id));
        	        if($status_check->num_rows()>0)
        	        {
        	            $order->reject_status = true;
        	        }
        	        else
        	        {
        	            $order->reject_status = false;
        	        }
  
        	        $order->products = $this->orders->getOrderedProducts($order->order_id);
        	        foreach($order->products as $product)
        	        {
        	            $product->extras = $this->orders->getOrderedExtras($order->order_id,$product->product_id);
        	        }
        	        $order->address  = $this->Common->get_details('address',array('address_id'=>$order->address_id))->row();
        	               	   // print_r($orders);
        	    }
    	    }
    	    else
    	    {
    	        $orders = '';
    	    }
    	    
    	    
    	    $return    = [
    	                   'status'   => true,
    	                   'message'  => 'success',
    	                   'orders'   => $orders
    	                 ];
		}
	    else 
		{
			   $return = [
            				'status' => false,
            				'message' => 'Session expired, Login again',
            				'orders'  => array()
            			];
		}
	    print_r(json_encode($return));               
	}
	
	public function approvedRequests()
	{
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getDriverId($key)) 
		{
    	    $orders    = $this->orders->getApprovedRequests($user_id);
    	    foreach($orders as $order)
    	    {   
    	        $user            = $this->Common->get_details('users',array('user_id'=>$order->user_id))->row();
    	        $order->user_firstname = $user->firstname;
    	        $order->lastname       = $user->lastname;
    	        $order->user_mobile    = $user->mobile;
    	        $order->user_email     = $user->email;
    	        $order->products = $this->orders->getOrderedProducts($order->order_id);
    	        foreach($order->products as $product)
    	        {
    	            $product->extras = $this->orders->getOrderedExtras($order->order_id,$product->product_id);
    	        }
    	        $order->address  = $this->Common->get_details('address',array('address_id'=>$order->address_id))->row();
    	    }
    	    
    	    $return    = [
    	                   'status'   => true,
    	                   'message'  => 'success',
    	                   'orders'   => $orders
    	                 ];
		}
		else 
		{
			   $return = [
            				'status'  => false,
            				'message' => 'Session expired, Login again',
            				'orders'  => array()
            			];
		}
	    print_r(json_encode($return));   
	}
	
	public function completedRequests()
	{
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getDriverId($key)) 
		{
    	    $orders    = $this->orders->getCompletedRequests($user_id);
    	    foreach($orders as $order)
    	    {   
    	        $order->products = $this->orders->getOrderedProducts($order->order_id);
    	        foreach($order->products as $product)
    	        {
    	            $product->extras = $this->orders->getOrderedExtras($order->order_id,$product->product_id);
    	        }
    	        $order->address  = $this->Common->get_details('address',array('address_id'=>$order->address_id))->row();
    	    }
    	    
    	    $return    = [ 
    	                   'status'   => true,
    	                   'message'  => 'success',
    	                   'orders'   => $orders
    	                 ];
		}
		else 
		{
			   $return = [
            				'status'  => false,
            				'message' => 'Session expired, Login again',
            				'orders'  => array()
            			];
		}                
	    print_r(json_encode($return));               
	}
	
	public function getOrderDetails()
	{
	   $key = $this->security->xss_clean($this->input->post('auth'));
	   if ($user_id = getDriverId($key)) 
	   {  
    	    $order_id        = $this->security->xss_clean($this->input->post('order_id'));
    	    $order           = $this->orders->getOrderDetails($order_id);
    	    $order->products = $this->orders->getOrderedProducts($order->order_id);
            foreach($order->products as $product)
            {
                $product->extras = $this->orders->getOrderedExtras($order->order_id,$product->product_id);
            }
            $order->address  = $this->Common->get_details('address',array('address_id'=>$order->address_id))->row();
    	    
    	    $return          = [
    	                         'status'     => true,
    	                         'message'    => 'success',
    	                         'order'      => $order
    	                       ];
	   }
	   else 
	   {
			   $return      = [
                				'status'  => false,
                				'message' => 'Session expired, Login again',
                				'orders'  => array()
                    		  ];
		}                       
	   print_r(json_encode($return));                       
	}
	
	public function rejectOrder()
	{
	   date_default_timezone_set('Asia/Kolkata');
	   $key = $this->security->xss_clean($this->input->post('auth'));
	   if ($user_id = getDriverId($key)) 
	   {  	
    	   $order_id        = $this->security->xss_clean($this->input->post('order_id'));

    	   $array           = [
    	                         'driver_id'  => $user_id,
    	                         'order_id'   => $order_id,
    	                         'timestamp'  => date('Y-m-d H:i:s')
    	                      ];
    	   if($this->Common->insert('driver_rejected_orders',$array))
    	   {
    	      $return      = [  
    	                        'status'     => true,
    	                        'message'    => 'success'
    	                     ];
    	   }
    	   else
    	   {
    	      $return      = [  
    	                        'status'     => false,
    	                        'message'    => 'failed'
    	                     ];
    	   }
	   }
	   else 
	   {
			   $return      = [
                				'status'  => false,
                				'message' => 'Session expired, Login again',
                    		  ];
		}    
	   print_r(json_encode($return));
	}
	
	public function completeOrder()
	{
	   date_default_timezone_set('Asia/Kolkata');
	   $time   = date('h:i A');
	   
	   $key = $this->security->xss_clean($this->input->post('auth'));
	   if ($user_id = getDriverId($key)) 
	   { 	
    	   $order_id        = $this->security->xss_clean($this->input->post('order_id'));

    	   $order           = $this->Common->get_details('orders',array('order_id'=>$order_id))->row();
    	   $driver_order    = $this->Common->get_details('driver_orders',array('order_id'=>$order_id,'driver_id'=>$user_id))->row()->do_id;
    	   $customer_id     = $order->user_id;
    	   $restaurant      = $order->r_id;
    	   $total           = $order->total;
    	   
    	   $order_status    = [
    	                         'status'          => 'delivered',
    	                         'payment'         => '1',
    	                         'completed_date'  => date('Y-m-d'),
    	                         'completed_time'  => $time
    	                      ];
    	                      
    	   $driver_status   = [
    	                         'status'          => 'completed',
    	                         'completed_time'  => date('Y-m-d H:i:s')        
    	                      ];     
    	                      
    	   if($this->Common->update('order_id',$order_id,'orders',$order_status))
    	   {  
    	       $this->Common->update('do_id',$driver_order,'driver_orders',$driver_status);

               $payment  = [
	                         'user_id'      => $customer_id,
	                         'amount'       => $total,
	                         'driver_id'    => $user_id,
	                         'r_id'         => $restaurant,
	                         'date'         => date('Y-m-d'),
	                         'time'         => date('h:i A'),
	                         'timestamp'    => date('Y-m-d H:i:s')
	                       ];
               $this->Common->insert('user_payments',$payment); 
   
                $return  = [  
                             'status'    => true,
                             'message'   => 'success'
                           ];
    	   }
    	   else
    	   {
    	       $return  = [  
    	                     'status'     => false,
    	                     'message'    => 'failed'
    	                  ];
    	   }
	   }
	   else 
	   {
			   $return      = [
                				'status'  => false,
                				'message' => 'Session expired, Login again',
                    		  ];
		}   
	   print_r(json_encode($return));                   
	}
	

	public function addPayment()
	{
		date_default_timezone_set('Asia/Kolkata');
        $timestamp   = date('Y-m-d H:i:s');
        
        $customer_id     = $this->security->xss_clean($this->input->post('customer_id'));
        $agency_id       = $this->security->xss_clean($this->input->post('agency_id'));
// 		$payment_id      = $this->security->xss_clean($this->input->post('payment_id'));
        $amount_received = $this->security->xss_clean($this->input->post('amount_received'));
        $current_amount  = $this->security->xss_clean($this->input->post('current_amount'));
        $customer        = $this->Common->get_details('customers',array('customer_id'=>$customer_id))->row();
        $customer_name   = $customer->name_english;
        $customer_phone  = $customer->customer_phone;
        $balance         = $current_amount-$amount_received;
        $pending         = $this->Common->get_details('customer_pending_payments',array('customer_id'=>$customer_id,'type'=>'agency','payment_type'=>'credit','agency_id'=>$agency_id))->row();
	    $payment_id      = $pending->cpp_id;
	    $array           = [
							'amount'        => $balance,
							'updated_on'    => $timestamp
				           ];
	    			           
		if ($this->Common->update('cpp_id',$payment_id,'customer_pending_payments',$array)) 
		{   
			$payment    = [
                            'customer_id'    => $customer_id,
                            'customer_name'  => $customer_name,
                            'customer_phone' => $customer_phone,
                            'amount_paid'    => $amount_received,
                            'balance_amount' => $balance,
                            'type'           => 'agency',
                            'agency_id'      => $agency_id,
                            'date'           => date('Y-m-d'),
                            'timestamp'      => $timestamp
			              ];
			if($id=$this->Common->insert('payment_history',$payment))
			{
	            $wallet_check = $this->Common->get_details('customer_wallet',array('customer_id'=>$customer_id,'type'=>'credit'));
	        	if($wallet_check->num_rows()>0)
	        	{
	        		$amount     = $wallet_check->row()->amount;
	        		$new_amount = $amount-$amount_received;
	        		$wallet_id  = $wallet_check->row()->wallet_id;
	        		$wallet_array = [
	        			               'amount' => $new_amount 
	        		                ];
	        		$this->Common->update('wallet_id',$wallet_id,'customer_wallet',$wallet_array);   
	        	}
			    $return  = [
			                  'message' => 'success'
			               ];    
            }
            else
            {
                $return  = [
                              'message' => 'failed'
                           ];
            }
            
            $return = [
                          'message' => 'success'
                      ];
		}
		else 
		{
			$return = [
			              'message'  => 'failed'
			          ];
		}
		print_r(json_encode($return));
	}
	
	public function resendNewRequest()
	{   
	    date_default_timezone_set('Asia/Kolkata');
		$timestamp     = date('Y-m-d H:i:s');
		$date          = date('Y-m-d');
		$time          = date('h:i A');
		
	    $order_id = $this->input->post('order_id');
	    $order   = $this->Common->get_details('customer_orders',array('order_id'=>$order_id))->row();
        $address = $this->Common->get_details('ordered_address',array('order_id'=>$order->order_id))->row();
        if($order->sale_type=='call')
        {
            $drivers = $this->Common->get_details('agencies',array('agency_status'=>'1'))->result();
            foreach($drivers as $driver)
            {
                $content       = $order->customer_name.'('.$order->customer_phone.') ,'.$address->building.','.$address->house.','.$address->location;
                $this->send_notification($driver->device_token,$content);
            }
        }
        else
        {
           $drivers = $this->orders->getDrivers($order->latitude,$order->longitude,$date,$time);
           foreach($drivers as $driver)
            {
                $agency_check = $this->Common->get_details('agencies',array('agency_id'=>$driver->agency_id));
                if($agency_check->num_rows()>0)
                {
                   $device_token  = $agency_check->row()->fcm_token;  
                }
                else
                {
                   $device_token = ''; 
                }
                $content       = $order->customer_name.'('.$order->customer_phone.') ,'.$address->building.','.$address->house.','.$address->location;
                $this->send_notification($device_token,$content);
            }
        }

	    $return  = [
	                  'message' => 'Success'
	               ];  
	    print_r(json_encode($return));            
	        
	}
	
	public function resendPendingRequest()
	{   
	    date_default_timezone_set('Asia/Kolkata');
		$timestamp     = date('Y-m-d H:i:s');
		$date          = date('Y-m-d');
		$time          = date('h:i A');
		
	    $order_id = $this->input->post('order_id');
	    $agency_id= $this->input->post('agency_id');
	    
	    $order   = $this->Common->get_details('customer_orders',array('order_id'=>$order_id))->row();
        $address = $this->Common->get_details('ordered_address',array('order_id'=>$order->order_id))->row();
        $array   = [
                      'agency_assigned' =>'0',
                      'status'          =>'pending'
                   ];
        if($this->Common->update('order_id',$order_id,'customer_orders',$array))
        {   
            $this->Common->delete('agency_orders',array('agency_id'=>$agency_id,'order_id'=>$order_id));
            $rejected      = [
                                'agency_id'  => $agency_id,
                                'order_id'   => $order_id,
                                'timestamp'  => date('Y-m-d H:i:s')
                             ];
            $this->Common->insert('agency_rejected_orders',$rejected);
            
            if($order->sale_type=='call')
            {
                $drivers = $this->Common->get_details('agencies',array('agency_status'=>'1','agency_id!='=>$agency_id))->result();
                foreach($drivers as $driver)
                {
                    $content       = $order->customer_name.'('.$order->customer_phone.') ,'.$address->building.','.$address->house.','.$address->location;
                    $this->send_notification($driver->device_token,$content);
                }
            }
            else
            {
               $drivers = $this->orders->getPendingDrivers($order->latitude,$order->longitude,$date,$time,$agency_id);
               foreach($drivers as $driver)
                {
                    $agency_check = $this->Common->get_details('agencies',array('agency_id'=>$driver->agency_id));
                    if($agency_check->num_rows()>0)
                    {
                       $device_token  = $agency_check->row()->fcm_token;  
                    }
                    else
                    {
                       $device_token = ''; 
                    }
                    $content       = $order->customer_name.'('.$order->customer_phone.') ,'.$address->building.','.$address->house.','.$address->location;
                    $this->send_notification($device_token,$content);
                }
            }
             $return  = [
	                  'message' => 'Success'
	               ];  
        }
	    else
	    {
	         $return  = [
	                  'message' => 'Failed'
	               ];  
	    }
	    print_r(json_encode($return));            
	        
	}
	
	public function send_notification($id,$content)
	{
	    $SERVER_API_KEY = "AAAADKiRWxs:APA91bFm8ulvZBQZX7VNnbBsk9f2QCKJIpzuPXKnE3qZYHuZIeE_YnM3TzhtUxdY_p4XeZzKGez9VNEhxWkdGpdLSrYO_ZN4QtVCG4vp8_S2vxuMWVHRVOCJnv0P1iB9nXvOvuqD6OzH";
    	$header = [
    		'Authorization: key='. $SERVER_API_KEY,
    		'Content-Type: Application/json'
    	];
    	$msg = [
    		'title' => 'New Order',
    		'body'  => $content
    	];
    	
    	$notification = [
    		'title'             => 'New Order',
    		'body'              => $content,
    		'content_available' => true
    	];
    	
    	$payload = [
    		'data'         => $msg,
    		'notification' => $notification,
    		'to'           => $id,
    		'priority'     => 10
    	];
    	$url = 'https://fcm.googleapis.com/fcm/send';
    
    	$curl = curl_init();
    
    	curl_setopt_array($curl, array(
    		 CURLOPT_URL            => "https://fcm.googleapis.com/fcm/send",
    		 CURLOPT_RETURNTRANSFER => true,
    		 CURLOPT_CUSTOMREQUEST  => "POST",
    		 CURLOPT_POSTFIELDS     => json_encode($payload),
    		 CURLOPT_HTTPHEADER     => $header,
    	));
    
    	$response = curl_exec($curl);
    	$err = curl_error($curl);
    
    	curl_close($curl);
        
        return true;
	}
	
	
}
