<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Location extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->model('Common');
	}
	
    public function add()
	{
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getDriverId($key)) 
		{
    		$lat        = $this->security->xss_clean($this->input->post('lat'));
    		$lon        = $this->security->xss_clean($this->input->post('long'));
    		
    		date_default_timezone_set("Asia/Calcutta"); 
    		$date       = date('Y-m-d');
    		$time       = date('h:i A');
    
    		$array = [
            			'driver_id' => $user_id,
            			'latitude'  => $lat,
            			'longitude' => $lon,
            			'date'      => $date,
            			'time'      => $time,
            			'timestamp' => date('Y-m-d H:i:s')
            		 ];
    
    		if ($this->Common->insert('locations',$array)) 
    		{
    			$return = [
    			            'status'  => true,
    				        'message' => 'success'
    			          ];
    		}
    		else 
    		{
    			$return = [
    			            'status'  => false,
    				        'message' => 'failed'
    			          ];
    		}
		}	
        else 
		{
			   $return = [
            				'status' => false,
            				'message' => 'Session expired, Login again'
            			];
		}
		print_r(json_encode($return));
	}

}
